* STK10
* A program to display 10 lines on the stack
* Created 01/02/94
* By: John B. Call
* Modified 01/19/94 fixed display of numbers
* for >8 digits behind decimal place

ASSEMBLE

SYSSTOF  EQU  #1C731          ( location of routine to store system flags )

     NIBASC  /HPHP48-E/
RPL

::
     CK1NOLASTWD              ( *check that the stack has at least one object* )
     GARBAGE                  ( *collect any garbage* )

     GBUFF
     TOTEMPOB                 ( recall PICT for saving )
     { NULLLAM }
     BIND                     ( store PICT in temporary variable )     

     SIXTYFOUR
     BINT_131d
     MAKEGROB
      
     GROB>GDISP               ( resize and clear graph grob )

* Find the minimum of DEPTH or 11  (counting the NEW STACK DATA )
     ELEVEN                   ( for later use in loop )
     DEPTH                    ( find out how many items are on the stack )
     
     DUP                      ( make copy for later use )
     TWELVE

     #<                       ( check if there are more than ten )
                              ( items on the stack to display )
                              ( returns TRUE if DEPTH<=11 )
     IT SWAP                  ( if TRUE then drop ELEVEN and use DEPTH )
     DROP

     ONE_DO (DO)              ( start loop )

                              ( tagged obs..., tagged ob --> )
                              ( it is assumed that tagged obs will )
                              ( be on the stack, but there may be )
                              ( other types as well that need to )
                              ( be displayed )
          ::
          CK&DISPATCH0        ( check type of object to be displayed )
          THIRTEEN            ( check if an object is tagged )
               ::
* DECOMP$ was changed to DO>STR, see note below.
               DO>STR         ( convert tagged object to string )
               CDR$           ( remove leading ":" for display  )
               ;
* If there is a problem with display of certain objects
* then extra type checking should be performed.
          THREE               ( do nothing if it is already a string )
               :: ;
          ZERO                ( for any other object        )  
* DO>STR is used here instead of DECOMP$ so there are not
* any unprintable characters sent to the display.
               DO>STR         ( convert tagged ob to string )
          ;

          RCLSYSF             ( recall system flags )
                              ( tagged obs..., $, sysflags --> )
          INDEX@              ( recall index )
          UNCOERCE            ( convert index to real number )
          DOSTD               ( select standard display mode )
          a%>$                ( convert index to string using current )
                              ( display mode                          )
          SWAP
          SYSSTOF             ( restore system flags )
                              ( tagged obs..., $, "i#" --> )
          ": "
          &$
          SWAP                ( tagged obs..., "i#:", $ --> )                        
          
          &$                  ( concatenate index number with $ )
                              ( tagged obs..., "i#: $" --> )
          $>grob              ( make 3x5 font grob from string )
                              ( tagged obs..., text_grob --> )
          GBUFF               ( tagged obs..., text_grob, GBUFF --> )
          SWAP                ( tagged obs..., GBUFF, text_grob --> )
          ONE                 ( column number )
          SIXTYFOUR
          INDEX@                          
          #6*                 ( recall index and calculate row position )
          #-                  ( row number = 64 - 6*index )
                              ( tagged obs..., GBUFF, text_grob, #col, #row --> )
          CKGROBFITS          ( if text_grob is too long truncate it )
          2SWAP
          SWAP
          2SWAP               ( reposition grobs for next operation )

          GROB!               ( store text in GBUFF )
     LOOP

     GBUFF
     ClrDA1IsStat             ( *clear clock display* )
     RECLAIMDISP              ( *select text grob and clear* )
     TURNMENUOFF              ( *resize text grob to 131x64* )

     ABUFF
     ZEROZERO
     GROB!                    ( copy graph grob into text grob )

     1GETLAM                  ( recall saved PICT to stack )
     ABND                     ( abandon temp environment )
     DUPGROBDIM               ( get size of PICT )
     #+
     #0=                      ( if it was originally purged then purge )
     ITE
          ::
          DROP
          KILLGDISP
          ;
          GROB>GDISP          ( else restore old PICT with saved image )
SetDAsTemp                    ( freeze the display area )
;                             ( end of program )
