%%HP: T(3)A(R)F(.);
DIR
  @ Action Integral
  AI 2
  @ Action Itegral Equation
  AIEQ 'AI=.5*C*V^2/R'
  @ Alpha equation
  ALPHA
    \<<
       'R/(2*L)'
    \>>
  @ Beta equation
  BETA
    \<<
       '\v/(R^2/(4*L^2)-1/(L*C))'
    \>>
  @ Capacitance
  C .000005
  @ Critical Damping equation
  CDEQ '1/(L*C)=R/(2*L)'
  @ Custom Menu for RLC
  CST { { AINT {\<< AIEQ SOLVIT \>> } }
        { CIRQ {\<< QEQ SOLVIT \>> } }
        { CRITDAMP {\<< CDEQ SOLVIT \>> } }
        { JOULES {\<< JEQ SOLVIT \>> } }
        { PK {\<< 'PKEQ' SOLVIT \>> } }
        { RESONANCE {\<< RESEQ SOLVIT \>> } }
        { TPK {\<< 'TPKEQ' SOLVIT \>> } }
        { \GDI {\<< '\GDIEQ' SOLVIT \>> } }
        \GDIPLOT
        { }
        LIST
        { QUIT {\<< UPDIR 1 MENU \>> } }
        @             >...^...<
        @ If you don't want to terminate with
        @ CST enables change the 1 to a 2 for
        @ VAR or to a 0 for the LAST MENU
      }
  @ Damping Type equation
  DAMPCALC
    \<<
        'ALPHA^2-1/(L*C)'
    \>>
  @ HP48 equation solver variable
  EQ \GDIEQ
  @ Frequency
  F 15915.4943092
  @ Current
  I -441.830515838
  @ Joules
  J 2.5
  @ Joules equation
  JEQ 'J=.5*C*V^2'
  @ Inductance
  L .00002
  @ Calculate and display all parameters
  LIST
    \<<
       PREPLOT \-> a2
      \<<
         V "  V" \->TAG
         R "  R" \->TAG
         L "  L" \->TAG
         C "  C" \->TAG
         AIEQ EQ\-> SWAP DROP EVAL
         " A\.S" \->TAG
         JEQ EQ\-> SWAP DROP EVAL
         "  J" \->TAG
         QEQ EQ\-> SWAP DROP EVAL
         "  Q" \->TAG
         IF a2 .0001 >
         THEN
           PKO EVAL " PK" \->TAG
           TPKO EVAL "TPK" \->TAG
           "Over Damped"
         ELSE
           IF a2 ABS .0001 <
           THEN
             PKC EVAL " PK" \->TAG
             TPKC EVAL "TPK" \->TAG
             "Critically Damped"
           ELSE
             PKU EVAL " PK" \->TAG
             TPKU EVAL "TPK" \->TAG
             "Under Damped"
           END
         END
         10 ROLLD
         STK10
         @ If you are using the SysRPL version of STK10
         @ delete the following line.
         10 DROPN
      \>>
    \>>
  @ Omega equation
  OMEGA '\v/(1/(L*C)-R^2/(4*L^2))'
  @ Peak Current equation selector
  PKEQ
    \<<
       PRECALC \-> a2 a b o
      \<<
        IF a2 .0001 >
        THEN
          a b PK\|^
        ELSE
          IF a2 ABS .0001 <
          THEN
            PK\162
          ELSE
             a o PK\|v
          END
        END
      \>>
    \>>
  @ LIST Under Damped Peak Current
  PKU 'V/(L*o)*EXP(-(a*ATAN(o/a)/o))*
       SIN(o*ATAN(o/a)/o)'
  @ LIST Over Damped Peak Current
  PKO 'V*\v/(C/L)*((a+b)/(a-b))^(-a/(2*b))'
  @ LIST Critically Damped Peak Current
  PKC '2*V/(2.718281828*R)'
  @ Solver Under Damped Peak Current
  PK\|v
    \<<
        \-> a o 'I=V/(L*o)*
         EXP(-(a*ATAN(o/a)/o))*
         SIN(o*ATAN(o/a)/o)'
    \>>
  @ Solver Over Damped Peak Current
  PK\|^
    \<<
        \-> a b 'I=V*\v/(C/L)*
        ((a+b)/(a-b))^(-a/(2*b))'
    \>>
  @ Solver Critically Damped Peak Current
  PK\162
    \<<
        'I=2*V/(2.718281828*R)'
    \>>
  @ HP48 Plot variable
  PPAR {
         (0,-49.356206279)
         (.0001,329.041375193)
         T1 0 (0,0)
         FUNCTION I
       }
  @ Pre solver calculation of a b and o
  PRECALC
    \<< DAMPCALC \->NUM
        ALPHA \->NUM
        BETA \->NUM
        OMEGA \->NUM
    \>>
  @ Pre plot calculation of a b and o
  PREPLOT
    \<<
        DAMPCALC \->NUM
        ALPHA \->NUM 'a' STO
        BETA \->NUM 'b' STO
        OMEGA \->NUM 'o' STO
    \>>
  @ Circuit Q
  Q 4
  @ Circuit Q equation
  QEQ 'Q=\v/(L/C)/R'
  @ Resistance
  R 4
  @ Circuit Resonance equation
  RESEQ 'F=1/(2*\pi*\v/(L*C))'
  @ Set up and execute solver
  SOLVIT
    \<<
        STEQ RAD
        @ GX Solve equation Form
        # 737281d LIBEVAL
        @ SX/GX Users can delete the LIBEVAL and use
        @ 30 MENU
    \>>
  @ The 10 level stack display
  @ Note: A SysRPL version of this routine is included
  @ with the program distribution. If you use it make
  @ sure you edit LIST as indicated by the comments at
  @ the end of the LIST program. See STK10.TXT.
  STK10
    \<<
       IF DEPTH
       THEN
         PICT RCL PPAR \-> p pp
        \<<
           PICT PURGE 1 32 XRNG 1 64 YRNG
           1 DEPTH 1 - 10 MIN
           FOR i PICT 1 i
             6 * R\->C RCLF STD i ": "
             + SWAP STOF i 3 + PICK \->STR +
             1 \->GROB GOR
           NEXT
           { } PVIEW 'PPAR' PURGE pp
           IF 'PPAR' SAME NOT
           THEN
             pp 'PPAR' STO
           END
           p PICT STO
        \>>
       END
    \>>
  @ Time variable
  T1 .000205
  @ Time to Peak equation selector
  TPKEQ
    \<<
       PRECALC \-> a2 a b o
      \<<
        IF a2 .0001 >
        THEN
          a b TPK\|^
        ELSE
          IF a2 ABS .0001 <
          THEN
            a TPK\162
          ELSE
            a o TPK\|v
          END
        END
      \>>
    \>>
  @ LIST Under Damped Time to Peak
  TPKU 'ATAN(o/a)/o'
  @ LIST Over Damped Time to Peak
  TPKO '1/(2*b)*LN((a+b)/(a-b))'
  @ LIST Critically Damped Time to Peak
  TPKC '1/a'
  @ Solver Under Damped Time to Peak
  TPK\|v
    \<<
       \-> a o 'T1=ATAN(o/a)/o'
    \>>
  @ Solver Over Damped Time to Peak
  TPK\|^
    \<<
       \-> a b 'T1=1/(2*b)*LN((a+b)/(a-b))'
    \>>
  @ Solver Critically Damped Time to Peak
  TPK\162
    \<<
       \-> a 'T1=1/a'
    \>>
  @ Voltage
  V 1788.854382
  @ Calculated alpha for plotter
  a 100000
  @ Calculated beta for plotter
  b 0
  @ Calculated omega for plotter
  o 0
  @ Idt equation selector
  \GDIEQ
    \<<
       PRECALC \-> a2 a b o
      \<<
        IF a2 .0001 >
        THEN
          a b \GDI\|^
        ELSE
          IF a2 ABS .0001 <
          THEN
            a \GDI\162
          ELSE
            a o \GDI\|v
          END
        END
      \>>
    \>>
  @ Idt Plotter equation selector/plotter
  \GDIPLOT
    \<<
      \<<
         PREPLOT \-> a2
        \<<
          IF a2 .0001 >
          THEN
            '\GDI\|^p'
          ELSE
            IF a2 ABS .0001 <
            THEN
              '\GDI\162p'
            ELSE
              '\GDI\|vp'
            END
          END
        \>>
      \>> EVAL STEQ RAD
          @ GX Plot Input Form
          # 737349d LIBEVAL
          @ SX Users can delete the LIBEVAL and use
          @ 33 MENU
          @ GX Users can use the fast Plot Menu
          @ 81 MENU
    \>>
  @ Solver Under Damped Idt
  \GDI\|v
    \<<
       \-> a o 'I=V/(o*L)*
       EXP(-(a*T1))*SIN(o*T1)'
    \>>
  @ Plotter Under Damped Idt
  \GDI\|vp 'V/(o*L)*EXP(-(a*T1))*SIN(o*T1)'
  @ Solver Over Damped Idt
  \GDI\|^
    \<<
        \-> a b 'I=V/(b*L)*
        (EXP(b*T1-a*T1)-EXP(-b*T1-a*T1))/2'
    \>>
  @ Plotter Over Damped Idt
  \GDI\|^p 'V/(b*L)*(EXP(b*T1-a*T1)-
           EXP(-b*T1-a*T1))/2'
  @ Solver Critcally Damped Idt
  \GDI\162
    \<<
       \-> a 'I=V/L*T1*EXP(-(a*T1))'
    \>>
  @ Plotter Critcally Damped Idt
  \GDI\162p 'V/L*T1*EXP(-(a*T1))'
END
