/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*                  This module was written by Bob Hartman                  */
/*                                                                          */
/*                BinkleyTerm Modem7 Receiver State Machine                 */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

int MRInit (XMARGSP);
int MREnd (XMARGSP);
int MRSendNak (XMARGSP);
int MRWaitAck (XMARGSP);
int MRWaitChar (XMARGSP);
int MRWaitOkCk (XMARGSP);

typedef struct
{
	char *state_name;
	int (*state_func) (XMARGSP);
} MSTATES, *MSTATEP;

MSTATES Modem7_Receiver[] =
{
	{"MRInit", MRInit},
	{"MREnd", MREnd},
	{"MR0", MRSendNak},
	{"MR1", MRWaitAck},
	{"MR2", MRWaitChar},
	{"MR3", MRWaitOkCk}
};

int 
MRInit (XMARGSP args)
{
	args->tries = 0;
	return ((int) args->control);
}

int 
MREnd (XMARGSP args)
{
	args->result = (int) args->control;
	return (args->result);
}

int 
MRSendNak (XMARGSP args)
{
	if (args->tries >= 10)
		return (FNAME_ERR);

	args->fptr = args->filename;

	SENDBYTE (NAK);
	++(args->tries);
	return (MR1);
}

int 
MRWaitAck (XMARGSP args)
{
	long MR1Timer;
	int in_char;

	MR1Timer = timerset (1000);
	while (!timeup (MR1Timer))
	{
		if ((in_char = PEEKBYTE ()) >= 0)
		{
			(void) TIMED_READ (0);
			switch (in_char)
			{
			case ACK:
				return (MR2);

			case EOT:
				args->result = SUCCESS_EOT;
				return (SUCCESS_EOT);
			}
		}
		else
		{
			if (!CARRIER)
				return (CARRIER_ERR);
			else
				time_release ();
		}
	}

	return (MR0);
}

int 
MRWaitChar (XMARGSP args)
{
	int in_char;
	unsigned char check;
	char *p;

	in_char = TIMED_READ (10);
	switch (in_char)
	{
	case -1:
		return (MR0);

	case EOT:
		return (SUCCESS);

	case SUB:
		for (p = args->filename, check = SUB; p != args->fptr; p++)
			check += (unsigned char) *p;
		SENDBYTE (check);
		return (MR3);

	case 'u':
		return (MR0);

	default:
		break;
	}

	*args->fptr++ = (char) (in_char & 0xff);
	SENDBYTE (ACK);
	return (MR2);
}

int 
MRWaitOkCk (XMARGSP args)
{
	int in_char;

	in_char = TIMED_READ (10);
	if (in_char == ACK)
	{
		args->result = SUCCESS;
		return (SUCCESS);
	}

	return (MR0);
}

int 
Modem7_Receive_File (char *filename)
{
	XMARGS batch;
	int res;

	batch.result = 0;
	batch.filename = filename;
	res = state_machine ((STATEP) Modem7_Receiver, &batch, 2);
	return (res);
}
