/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*              (C) Copyright 1987-96, Bit Bucket Software Co.              */
/*                                                                          */
/*            This module was originally written by Bob Hartman             */
/*                                                                          */
/*                  BinkleyTerm Initial Fullscreen Setup                    */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.260.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:42/1491                        */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

extern VIOMODEINFO vfos_mode;

void 
b_sbinit ()
{
	register int r;
	char *savep;

	savep = calloc (1, 4096);
	for (r = 0; r < 132; r++)
	{
		blanks[r * 2] = ' ';
		blanks[r * 2 + 1] = 7;
	}

	vfossil_init ();
	if (vfos_mode.col < 80)
		vfos_mode.col = 80;
	if (vfos_mode.row < 23)
		vfos_mode.row = 23;

	SB_ROWS = vfos_mode.row - 1;
	SB_COLS = vfos_mode.col;

	SB_COLS_M_1 = SB_COLS - 1;
	SB_ROWS_M_1 = SB_ROWS - 1;
	SB_ROWS_M_2 = SB_ROWS - 2;
	SB_ROW_STATUS = SB_ROWS - 15;

	screen_clear ();
	sb_init ();
	free (savep);

	wholewin = (REGIONP) sb_new (0, 0, SB_ROWS, SB_COLS);
	settingswin = (REGIONP) sb_new (1, 1, 7, 22);
	historywin = (REGIONP) sb_new (1, 23, 7, 23);
	holdwin = (REGIONP) sb_new (1, 46, 7, (short) (SB_COLS - 47));
	callwin = (REGIONP) sb_new (8, 1, (short) (SB_ROWS - 13), (short) (SB_COLS - 2));
	filewin = (REGIONP) sb_new ((short) (SB_ROWS - 5), 1, 4, (short) (SB_COLS - 2));

	sb_fill (wholewin, ' ', colors.background);
	sb_fill (settingswin, ' ', colors.settings);
	sb_fill (historywin, ' ', colors.history);
	sb_fill (holdwin, ' ', colors.hold);
	sb_fill (callwin, ' ', colors.call);
	sb_fill (filewin, ' ', colors.file);

	sb_box (settingswin, boxtype, colors.settings);
	sb_box (historywin, boxtype, colors.history);
	sb_box (holdwin, boxtype, colors.hold);
	sb_box (callwin, boxtype, colors.call);
	sb_box (filewin, boxtype, colors.file);

	sb_caption (settingswin, MSG_TXT (M_CURRENT_SETTINGS));
	sb_caption (historywin, MSG_TXT (M_TODAY_GLANCE));
	sb_caption (holdwin, MSG_TXT (M_PENDING_OUTBOUND));
	sb_caption (callwin, MSG_TXT (M_RECENT_ACTIVITY));
	sb_caption (filewin, MSG_TXT (M_TRANSFER_STATUS));

	sb_move (holdwin, 3, 7);
	sb_puts (holdwin, MSG_TXT (M_INITIALIZING_SYSTEM));

	sb_move (wholewin, 0, 1);
	(void) sprintf (junk, MSG_TXT (M_NODE_COLON), Full_Addr_Str (&my_addr));
	sb_puts (wholewin, junk);
	sb_move (wholewin, 0, (short) (SB_COLS - 1 - (short) strlen (system_name)));
	sb_puts (wholewin, system_name);

	bottom_line ();

	sb_move (settingswin, SET_EVNT_ROW, 2);
	sb_puts (settingswin, MSG_TXT (M_EVENT_COLON));
	sb_move (settingswin, SET_PORT_ROW, 2);
	sb_puts (settingswin, MSG_TXT (M_PORT_COLON));
	sb_move (settingswin, SET_STAT_ROW, 2);
	sb_puts (settingswin, MSG_TXT (M_STATUS_INIT));

	do_today ();

	settingswin->sr0 = settingswin->r0 + 1;
	settingswin->sr1 = settingswin->r1 - 1;
	settingswin->sc0 = settingswin->c0 + 1;
	settingswin->sc1 = settingswin->c1 - 1;

	historywin->sr0 = historywin->r0 + 1;
	historywin->sr1 = historywin->r1 - 1;
	historywin->sc0 = historywin->c0 + 1;
	historywin->sc1 = historywin->c1 - 1;

	holdwin->sr0 = holdwin->r0 + 1;
	holdwin->sr1 = holdwin->r1 - 1;
	holdwin->sc0 = holdwin->c0 + 1;
	holdwin->sc1 = holdwin->c1 - 1;

	callwin->sr0 = callwin->r0 + 1;
	callwin->sr1 = callwin->r1 - 1;
	callwin->sc0 = callwin->c0 + 1;
	callwin->sc1 = callwin->c1 - 1;

	callwin->lines = callwin->sr1 - callwin->sr0 + 1;

	if (scrllines < callwin->lines) 
		scrllines = callwin->lines;

	callwin->linesize  = callwin->sc1 - callwin->sc0 + 1;
	callwin->buffer    = calloc (scrllines, callwin->linesize);
	callwin->endbuff   = callwin->buffer + ((scrllines - 1) * callwin->linesize) ;
	callwin->lastline  = callwin->buffer ;
	callwin->lastshown = callwin->lastline ;

	filewin->sr0 = filewin->r0 + 1;
	filewin->sr1 = filewin->r1 - 1;
	filewin->sc0 = filewin->c0 + 1;
	filewin->sc1 = filewin->c1 - 1;
}

