;*****************************************
;*                                       *
;*  CapaPlay II Constants and Variables  *
;*                                       *
;*****************************************


;**************************** Channel Information *****************************


ChanSize	equ 248

ChannelStructure	struc

CH_InstrumentDataCache		db 0
CH_CurrentInstrument		dw 0
CH_OldInstrument		dw 0
CH_CurrentSample		dw 0
CH_OldSample			dw 0

CH_GUSOffsetBegin		dd 0
CH_GUSOffsetEnd			dd 0
CH_GUSOffsetLoopBegin		dd 0
CH_SampleLength			dd 0
CH_LoopType			db 0
CH_C4SpdPrecalc 		dd 0
CH_OldC4SpdPrecalc		dd 0
CH_SampleVolume 		dw 0
CH_OldSampleVolume		dw 0
CH_SamplePanning		db 0

CH_VolumeEnvelopeType		db 0
CH_VolumeEnvelopeLoopBegin	db 0
CH_VolumeEnvelopeLoopEnd	db 0
CH_VolumeEnvelopeNumOfPoints	db 0
CH_VolumeEnvelopePointer	dw 0
CH_VolumeEnvelopeCurrentPoint	db 0
CH_VolumeEnvelopeVolume		db 0
CH_VolumeEnvelopePoints 	dw 12 dup (0)
CH_VolumeEnvelopePointValues	db 12 dup (0)
CH_VolumeEnvelopeSustainPoint	db 0

CH_PanningEnvelopeType		db 0
CH_PanningEnvelopeLoopBegin	db 0
CH_PanningEnvelopeLoopEnd	db 0
CH_PanningEnvelopeNumOfPoints	db 0
CH_PanningEnvelopePointer	dw 0
CH_PanningEnvelopeCurrentPoint	db 0
CH_PanningEnvelopePanning	db 0
CH_PanningEnvelopePoints	dw 12 dup (0)
CH_PanningEnvelopePointValues	db 12 dup (0)
CH_PanningEnvelopeSustainPoint	db 0

CH_Panning			db 0
CH_FinalPanning			db 0
CH_OldFinalPanning		db 0

CH_InstrumentType		db 0
CH_RelativeNote 		db 0
CH_RelativeOctave		db 0

CH_AutoVibratoType		db 0
CH_AutoVibratoTableAddress	dw 0
CH_AutoVibratoSweep		db 0
CH_AutoVibratoSweepCounter	db 0
CH_AutoVibratoDepth		db 0
CH_AutoVibratoRate		db 0
CH_AutoVibratoPointer		db 0
CH_AutoVibratoValue		dd 0

CH_VolumeFadeout		dw 0
CH_VolumeFadeoutCounter 	dw 0
CH_16Bit			db 0

CH_NoteDataCache		db 0
CH_Note 			db 0
CH_RealNote			db 0
CH_Octave			db 0
CH_RealOctave			db 0
CH_RealNoteFragment		db 0

CH_Period			dd 0
CH_PeriodChange 		dd 0
CH_NoteFrequency		dw 0
CH_OldNoteFrequency		dw 0
CH_RealFrequency		dw 0

CH_Volume			dw 0
CH_RealVolume			dw 0
CH_OldVolume			dw 0
CH_FinalVolume			dw 0
CH_OldFinalVolume		dw 0
CH_VolumeColumn 		db 0

CH_KeyOff			db 0

CH_Effect			dw 0
CH_OldEffect			dw 0
CH_EffectTime			db 0
CH_RetrigTime			db 0

CH_VibratoPointer		db 0
CH_VibratoDepth 		db 0
CH_VibratoSpeed 		db 0
CH_OldVibratoOn 		db 0
CH_VibratoOn			db 0	;1=normal vibrato, 2=vol column vibrato
CH_VibratoFrequency		dw 0

CH_OldTremoloVolume		dw 0
CH_TremoloPointer		db 0
CH_TremoloDepth 		db 0
CH_TremoloSpeed 		db 0

CH_PortamentoPeriod		dd 0
CH_PortamentoSpeed		dw 0
CH_PortamentoOn 		db 0

CH_TremorCounter		db 0
CH_TremorOn			db 0
CH_TremorOnCount		db 0
CH_TremorOffCount		db 0
CH_TremorVolume 		dw 0

CH_JumpToLoopOn 		db 0
CH_JumpToLoopCounter		db 0
CH_JumpToLoopRow		dw 0

CH_ArpeggioVals 		dw 0,0,0
CH_CalculatedArpeggioVals	dw 0,0,0
CH_ArpeggioCounter		dw 0
CH_ArpeggioOn			db 0
CH_OldArpeggioOn		db 0

CH_FineEffect			db 0
CH_GlissandoMode		db 0
CH_OffsetAddition		dw 0
CH_InstrumentSet		db 0
CH_Bar				db 0
CH_BarSequencer 		db 0
CH_NewNote			db 0
CH_NoteTriggered		db 0

ChannelStructure	ends

ChannelInfo	ChannelStructure 33 dup (<>)

ChannelPointers dw	ChanSize*00,ChanSize*01,ChanSize*02,ChanSize*03
		dw	ChanSize*04,ChanSize*05,ChanSize*06,ChanSize*07
		dw	ChanSize*08,ChanSize*09,ChanSize*10,ChanSize*11
		dw	ChanSize*12,ChanSize*13,ChanSize*14,ChanSize*15
		dw	ChanSize*16,ChanSize*17,ChanSize*18,ChanSize*19
		dw	ChanSize*20,ChanSize*21,ChanSize*22,ChanSize*23
		dw	ChanSize*24,ChanSize*25,ChanSize*26,ChanSize*27
		dw	ChanSize*28,ChanSize*29,ChanSize*30,ChanSize*31

ChannelAmplifications	db	64,64,64,64,64,63,63,62,62,61,61,60,60,59,59,58
			db	58,58,57,57,57,56,56,56,56,55,55,55,55,54,54,54

PanningDefaults 	db 32 dup (0)


;********************* Hardware Constants and Variables ***********************


; UltraSound Ports

StatusPort	equ 6h
TimerCtrlPort	equ 8h
TimerDataPort	equ 9h
IRQDMACtrlPort	equ 0Bh
MidiCtrlPort	equ 100h
MidiDataPort	equ 101h
ActiveVoicePort equ 102h
CommandPort	equ 103h
DataLowPort	equ 104h
DataHighPort	equ 105h
DRAMIOPort	equ 107h

; UltraSound Commands

WriteVoiceMode	equ 00h
SetVoiceFreq	equ 01h 	; Value=Freq/Divisor
LoopStartLo	equ 02h
LoopStartHi	equ 03h
SampleEndLo	equ 04h
SampleEndHi	equ 05h
VolRampRate	equ 06h
VolRampStart	equ 07h
VolRampEnd	equ 08h
SetVolume	equ 09h
SampleStartLo	equ 0Ah
SampleStartHi	equ 0Bh
VoiceBalance	equ 0Ch
VolumeCtrl	equ 0Dh
VoicesActive	equ 0Eh
DMACtrl 	equ 41h
DMAAddr		equ 42h
DRAMAddrLo	equ 43h
DRAMAddrHi	equ 44h
TimerControl	equ 45h
Timer1		equ 46h
Timer2		equ 47h
Initialize	equ 4Ch
ReadVolume	equ 89h
VoicePosLo	equ 8Ah
VoicePosHi	equ 8Bh
ReadVolCtrl	equ 8Dh

DMAAddress		db 000h,002h,004h,006h,0c0h,0c4h,0c8h,0cch
DMACount		db 001h,003h,005h,007h,0c2h,0c6h,0cah,0ceh
DMAPage			db 087h,083h,081h,082h,08fh,08bh,089h,08ah
DMAStatus		db 008h,008h,008h,008h,0d0h,0d0h,0d0h,0d0h
DMAStatusBits		db 1,2,4,8,1,2,4,8
DMAMask			db 00ah,00ah,00ah,00ah,0d4h,0d4h,0d4h,0d4h
DMAMode			db 00bh,00bh,00bh,00bh,0d6h,0d6h,0d6h,0d6h
DMAClear		db 00ch,00ch,00ch,00ch,0d8h,0d8h,0d8h,0d8h
DMAReset		db 00dh,00dh,00dh,00dh,0dah,0dah,0dah,0dah
DMAInitialized		db 0

IOStateBeforeInit	db 0
LineIn			db 001b ;disabled
MicIn			db 000b ;disabled
BasePort		dw 220h
GUSIRQ			dw 0
IRQToPort		db 0,0,1,3,0,2,0,4,0,0,0,5,6,0,0,7
GUSDMA			dw 0
DMAToPort		db 0,1,0,2,0,3,4,5
OldIRQAddr		dd 0
TimerModeToUse		db 0	; 0=system, 1=GUS IRQ
TransferModeToUse	db 0	; 0=manual, 1=GUS DMA


;********************* Tables Needed in The Player Routine ********************


FineTuneCompare dw	7894,7897,7901,7904
		dw	7908,7911,7915,7919
		dw	7922,7926,7929,7933
		dw	7936,7940,7944,7947
		dw	7951,7954,7958,7962
		dw	7965,7969,7972,7976
		dw	7980,7983,7987,7990
		dw	7994,7998,8001,8005
		dw	8008,8012,8016,8019
		dw	8023,8027,8030,8034
		dw	8037,8041,8045,8048
		dw	8052,8056,8059,8063
		dw	8066,8070,8074,8077
		dw	8081,8085,8088,8092
		dw	8096,8099,8103,8107
		dw	8110,8114,8118,8121
		dw	8125,8129,8132,8136
		dw	8140,8143,8147,8151
		dw	8154,8158,8162,8165
		dw	8169,8173,8176,8180
		dw	8184,8187,8191,8195
		dw	8199,8202,8206,8210
		dw	8213,8217,8221,8225
		dw	8228,8232,8236,8239
		dw	8243,8247,8251,8254
		dw	8258,8262,8265,8269
		dw	8273,8277,8280,8284
		dw	8288,8292,8295,8299
		dw	8303,8307,8310,8314
		dw	8318,8322,8325,8329
		dw	8333,8337,8340,8344
		dw	8348,8352,8355,8359
		dw	8363,8367,8371,8374
		dw	8378,8382,8386,8389
		dw	8393,8397,8401,8405
		dw	8408,8412,8416,8420
		dw	8424,8427,8431,8435
		dw	8439,8443,8446,8450
		dw	8454,8458,8462,8466
		dw	8469,8473,8477,8481
		dw	8485,8488,8492,8496
		dw	8500,8504,8508,8511
		dw	8515,8519,8523,8527
		dw	8531,8535,8538,8542
		dw	8546,8550,8554,8558
		dw	8562,8565,8569,8573
		dw	8577,8581,8585,8589
		dw	8593,8596,8600,8604
		dw	8608,8612,8616,8620
		dw	8624,8627,8631,8635
		dw	8639,8643,8647,8651
		dw	8655,8659,8663,8667
		dw	8670,8674,8678,8682
		dw	8686,8690,8694,8698
		dw	8702,8706,8710,8714
		dw	8718,8721,8725,8729
		dw	8733,8737,8741,8745
		dw	8749,8753,8757,8761
		dw	8765,8769,8773,8777
		dw	8781,8785,8789,8793
		dw	8797,8801,8804,8808
		dw	8812,8816,8820,8824
		dw	8828,8832,8836,8840
		dw	8844,8848,8852,8856

ReversePeriod	db (907-0) dup (11)
		db (960-907) dup (11)
		db (1016-960) dup (10)
		db (1076-1016) dup (9)
		db (1140-1076) dup (8)
		db (1208-1140) dup (7)
		db (1280-1208) dup (6)
		db (1356-1280) dup (5)
		db (1440-1356) dup (4)
		db (1524-1440) dup (3)
		db (1616-1524) dup (2)
		db (1712-1616) dup (1)
		db (1814-1712) dup (0)

Periods 	dw 1712
		dw 1710,1709,1707,1706,1704,1703,1701,1700
		dw 1698,1697,1695,1694,1692,1691,1689,1687
		dw 1686,1684,1683,1681,1680,1678,1677,1675
		dw 1674,1672,1671,1669,1668,1666,1665,1663
		dw 1662,1660,1659,1657,1656,1654,1653,1651
		dw 1650,1648,1647,1645,1644,1642,1641,1639
		dw 1638,1636,1635,1634,1632,1631,1629,1628
		dw 1626,1625,1623,1622,1620,1619,1617,1616
		dw 1614,1613,1612,1610,1609,1607,1606,1604
		dw 1603,1601,1600,1599,1597,1596,1594,1593
		dw 1591,1590,1588,1587,1586,1584,1583,1581
		dw 1580,1578,1577,1576,1574,1573,1571,1570
		dw 1568,1567,1566,1564,1563,1561,1560,1559
		dw 1557,1556,1554,1553,1552,1550,1549,1547
		dw 1546,1545,1543,1542,1540,1539,1538,1536
		dw 1535,1534,1532,1531,1529,1528,1527,1525
		dw 1524,1522,1521,1520,1518,1517,1516,1514
		dw 1513,1512,1510,1509,1507,1506,1505,1503
		dw 1502,1501,1499,1498,1497,1495,1494,1493
		dw 1491,1490,1489,1487,1486,1484,1483,1482
		dw 1480,1479,1478,1476,1475,1474,1472,1471
		dw 1470,1468,1467,1466,1465,1463,1462,1461
		dw 1459,1458,1457,1455,1454,1453,1451,1450
		dw 1449,1447,1446,1445,1444,1442,1441,1440
		dw 1438,1437,1436,1434,1433,1432,1431,1429
		dw 1428,1427,1425,1424,1423,1422,1420,1419
		dw 1418,1416,1415,1414,1413,1411,1410,1409
		dw 1407,1406,1405,1404,1402,1401,1400,1399
		dw 1397,1396,1395,1394,1392,1391,1390,1389
		dw 1387,1386,1385,1384,1382,1381,1380,1379
		dw 1377,1376,1375,1374,1372,1371,1370,1369
		dw 1367,1366,1365,1364,1362,1361,1360,1359
		dw 1358,1356,1355,1354,1353,1351,1350,1349
		dw 1348,1347,1345,1344,1343,1342,1341,1339
		dw 1338,1337,1336,1335,1333,1332,1331,1330
		dw 1328,1327,1326,1325,1324,1323,1321,1320
		dw 1319,1318,1317,1315,1314,1313,1312,1311
		dw 1309,1308,1307,1306,1305,1304,1302,1301
		dw 1300,1299,1298,1297,1295,1294,1293,1292
		dw 1291,1290,1288,1287,1286,1285,1284,1283
		dw 1281,1280,1279,1278,1277,1276,1274,1273
		dw 1272,1271,1270,1269,1268,1266,1265,1264
		dw 1263,1262,1261,1260,1258,1257,1256,1255
		dw 1254,1253,1252,1251,1249,1248,1247,1246
		dw 1245,1244,1243,1242,1240,1239,1238,1237
		dw 1236,1235,1234,1233,1232,1230,1229,1228
		dw 1227,1226,1225,1224,1223,1222,1220,1219
		dw 1218,1217,1216,1215,1214,1213,1212,1211
		dw 1209,1208,1207,1206,1205,1204,1203,1202
		dw 1201,1200,1199,1198,1196,1195,1194,1193
		dw 1192,1191,1190,1189,1188,1187,1186,1185
		dw 1184,1182,1181,1180,1179,1178,1177,1176
		dw 1175,1174,1173,1172,1171,1170,1169,1168
		dw 1167,1166,1164,1163,1162,1161,1160,1159
		dw 1158,1157,1156,1155,1154,1153,1152,1151
		dw 1150,1149,1148,1147,1146,1145,1144,1143
		dw 1142,1141,1140,1139,1137,1136,1135,1134
		dw 1133,1132,1131,1130,1129,1128,1127,1126
		dw 1125,1124,1123,1122,1121,1120,1119,1118
		dw 1117,1116,1115,1114,1113,1112,1111,1110
		dw 1109,1108,1107,1106,1105,1104,1103,1102
		dw 1101,1100,1099,1098,1097,1096,1095,1094
		dw 1093,1092,1091,1090,1089,1088,1087,1086
		dw 1085,1084,1083,1082,1081,1080,1079,1078
		dw 1078,1077,1076,1075,1074,1073,1072,1071
		dw 1070,1069,1068,1067,1066,1065,1064,1063
		dw 1062,1061,1060,1059,1058,1057,1056,1055
		dw 1054,1053,1053,1052,1051,1050,1049,1048
		dw 1047,1046,1045,1044,1043,1042,1041,1040
		dw 1039,1038,1037,1037,1036,1035,1034,1033
		dw 1032,1031,1030,1029,1028,1027,1026,1025
		dw 1024,1023,1023,1022,1021,1020,1019,1018
		dw 1017,1016,1015,1014,1013,1012,1012,1011
		dw 1010,1009,1008,1007,1006,1005,1004,1003
		dw 1002,1002,1001,1000, 999, 998, 997, 996
		dw  995, 994, 993, 993, 992, 991, 990, 989
		dw  988, 987, 986, 985, 985, 984, 983, 982
		dw  981, 980, 979, 978, 977, 977, 976, 975
		dw  974, 973, 972, 971, 970, 970, 969, 968
		dw  967, 966, 965, 964, 963, 963, 962, 961
		dw  960, 959, 958, 957, 957, 956, 955, 954
		dw  953, 952, 951, 950, 950, 949, 948, 947
		dw  946, 945, 944, 944, 943, 942, 941, 940
		dw  939, 939, 938, 937, 936, 935, 934, 933
		dw  933, 932, 931, 930, 929, 928, 928, 927
		dw  926, 925, 924, 923, 923, 922, 921, 920
		dw  919, 918, 918, 917, 916, 915, 914, 913
		dw  913, 912, 911, 910, 909, 909, 908, 907
		dw  906, 905, 904, 904, 903, 902, 901, 900
		dw  900, 899, 898, 897, 896, 896, 895, 894
		dw  893, 892, 891, 891, 890, 889, 888, 887
		dw  887, 886, 885, 884, 883, 883, 882, 881
		dw  880, 879, 879, 878, 877, 876, 876, 875
		dw  874, 873, 872, 872, 871, 870, 869, 868
		dw  868, 867, 866, 865, 865, 864, 863, 862
		dw  861, 861, 860, 859, 858, 858, 857, 856


Divisors	dd 1173161870/8/441
		dd 1173161870/8/441,1173161870/8/441,1173161870/8/441,1173161870/8/441
		dd 1173161870/8/441,1173161870/8/441,1173161870/8/441,1173161870/8/441
		dd 1173161870/8/441,1173161870/8/441,1173161870/8/441,1173161870/8/441
		dd 1173161870/8/441,1173161870/8/441,1173161870/8/412,1173161870/8/386
		dd 1173161870/8/363,1173161870/8/343,1173161870/8/325,1173161870/8/309
		dd 1173161870/8/294,1173161870/8/281,1173161870/8/268,1173161870/8/257
		dd 1173161870/8/247,1173161870/8/237,1173161870/8/229,1173161870/8/221
		dd 1173161870/8/213,1173161870/8/206,1173161870/8/199,1173161870/8/193

SiniTab 	dw 0,6,13,19,25,31,38,44
		dw 50,56,62,68,74,80,86,92
		dw 98,104,109,115,121,126,132,137
		dw 142,147,152,157,162,167,172,177
		dw 181,185,190,194,198,202,206,209
		dw 213,216,220,223,226,229,231,234
		dw 237,239,241,243,245,247,248,250
		dw 251,252,253,254,255,255,256,256
		dw 256,256,256,255,255,254,253,252
		dw 251,250,248,247,245,243,241,239
		dw 237,234,231,229,226,223,220,216
		dw 213,209,206,202,198,194,190,185
		dw 181,177,172,167,162,157,152,147
		dw 142,137,132,126,121,115,109,104
		dw 98,92,86,80,74,68,62,56
		dw 50,44,38,31,25,19,13,6
		dw 0,-6,-13,-19,-25,-31,-38,-44
		dw -50,-56,-62,-68,-74,-80,-86,-92
		dw -98,-104,-109,-115,-121,-126,-132,-137
		dw -142,-147,-152,-157,-162,-167,-172,-177
		dw -181,-185,-190,-194,-198,-202,-206,-209
		dw -213,-216,-220,-223,-226,-229,-231,-234
		dw -237,-239,-241,-243,-245,-247,-248,-250
		dw -251,-252,-253,-254,-255,-255,-256,-256
		dw -256,-256,-256,-255,-255,-254,-253,-252
		dw -251,-250,-248,-247,-245,-243,-241,-239
		dw -237,-234,-231,-229,-226,-223,-220,-216
		dw -213,-209,-206,-202,-198,-194,-190,-185
		dw -181,-177,-172,-167,-162,-157,-152,-147
		dw -142,-137,-132,-126,-121,-115,-109,-104
		dw -98,-92,-86,-80,-74,-68,-62,-56
		dw -50,-44,-38,-31,-25,-19,-13,-6

RampDownTab	dw 256,254,252,250,248,246,244,242
		dw 240,238,236,234,232,230,228,226
		dw 224,222,220,218,216,214,212,210
		dw 208,206,204,202,200,198,196,194
		dw 192,190,188,186,184,182,180,178
		dw 176,174,172,170,168,166,164,162
		dw 160,158,156,154,152,150,148,146
		dw 144,142,140,138,136,134,132,130
		dw 128,126,124,122,120,118,116,114
		dw 112,110,108,106,104,102,100,98
		dw 96,94,92,90,88,86,84,82
		dw 80,78,76,74,72,70,68,66
		dw 64,62,60,58,56,54,52,50
		dw 48,46,44,42,40,38,36,34
		dw 32,30,28,26,24,22,20,18
		dw 16,14,12,10,8,6,4,2
		dw 0,-2,-4,-6,-8,-10,-12,-14
		dw -16,-18,-20,-22,-24,-26,-28,-30
		dw -32,-34,-36,-38,-40,-42,-44,-46
		dw -48,-50,-52,-54,-56,-58,-60,-62
		dw -64,-66,-68,-70,-72,-74,-76,-78
		dw -80,-82,-84,-86,-88,-90,-92,-94
		dw -96,-98,-100,-102,-104,-106,-108,-110
		dw -112,-114,-116,-118,-120,-122,-124,-126
		dw -128,-130,-132,-134,-136,-138,-140,-142
		dw -144,-146,-148,-150,-152,-154,-156,-158
		dw -160,-162,-164,-166,-168,-170,-172,-174
		dw -176,-178,-180,-182,-184,-186,-188,-190
		dw -192,-194,-196,-198,-200,-202,-204,-206
		dw -208,-210,-212,-214,-216,-218,-220,-222
		dw -224,-226,-228,-230,-232,-234,-236,-238
		dw -240,-242,-244,-246,-248,-250,-252,-254

SquareTab	dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw 256,256,256,256,256,256,256,256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256
		dw -256,-256,-256,-256,-256,-256,-256,-256

RandomTab	dw -256,-240,184,-153,-117,87,-93,-174
		dw -66,-39,-215,-13,-220,174,-226,-106
		dw 213,-68,140,-89,101,176,111,-99
		dw -173,-88,-18,-130,166,-114,-10,-180
		dw 191,-109,139,243,-4,198,167,-246
		dw -184,-183,0,-245,47,-252,140,77
		dw 138,106,29,-151,92,47,233,73
		dw 255,-132,90,-105,-213,139,-3,195
		dw 5,37,232,94,-83,-253,105,250
		dw 140,127,-155,-183,211,145,45,186
		dw 96,-109,-209,66,-113,193,-174,-117
		dw 22,235,-167,-176,-119,-166,39,-1
		dw -110,-177,56,122,126,-215,-217,-226
		dw -202,151,156,-61,57,-33,123,-4
		dw -82,163,162,-184,-209,-222,-226,-157
		dw 88,-140,36,-126,-69,172,-95,-95
		dw 80,98,206,-93,-11,-105,136,123
		dw 26,114,-46,21,49,194,86,-199
		dw -15,-50,-198,-229,24,88,-215,215
		dw 173,92,218,-115,102,120,-1,83
		dw -175,-139,228,-70,-192,249,-100,-229
		dw -204,187,27,100,-205,86,-248,-98
		dw 207,18,-89,-30,205,-79,-75,-7
		dw -220,179,133,-164,216,-4,-191,200
		dw -50,-150,157,44,-200,63,218,20
		dw -90,-27,-140,-162,97,253,66,98
		dw 20,-207,126,-180,-137,194,109,-32
		dw 245,-177,-236,-162,-252,-63,-54,-70
		dw -214,-24,2,-21,89,162,34,-127
		dw -66,42,191,55,-125,100,29,193
		dw -72,-70,62,143,-23,-151,101,172
		dw 128,205,-161,141,-120,-105,103,-23

RampUpTab	dw -256,-254,-252,-250,-248,-246,-244,-242
		dw -240,-238,-236,-234,-232,-230,-228,-226
		dw -224,-222,-220,-218,-216,-214,-212,-210
		dw -208,-206,-204,-202,-200,-198,-196,-194
		dw -192,-190,-188,-186,-184,-182,-180,-178
		dw -176,-174,-172,-170,-168,-166,-164,-162
		dw -160,-158,-156,-154,-152,-150,-148,-146
		dw -144,-142,-140,-138,-136,-134,-132,-130
		dw -128,-126,-124,-122,-120,-118,-116,-114
		dw -112,-110,-108,-106,-104,-102,-100,-98
		dw -96,-94,-92,-90,-88,-86,-84,-82
		dw -80,-78,-76,-74,-72,-70,-68,-66
		dw -64,-62,-60,-58,-56,-54,-52,-50
		dw -48,-46,-44,-42,-40,-38,-36,-34
		dw -32,-30,-28,-26,-24,-22,-20,-18
		dw -16,-14,-12,-10,-8,-6,-4,-2
		dw 0,2,4,6,8,10,12,14
		dw 16,18,20,22,24,26,28,30
		dw 32,34,36,38,40,42,44,46
		dw 48,50,52,54,56,58,60,62
		dw 64,66,68,70,72,74,76,78
		dw 80,82,84,86,88,90,92,94
		dw 96,98,100,102,104,106,108,110
		dw 112,114,116,118,120,122,124,126
		dw 128,130,132,134,136,138,140,142
		dw 144,146,148,150,152,154,156,158
		dw 160,162,164,166,168,170,172,174
		dw 176,178,180,182,184,186,188,190
		dw 192,194,196,198,200,202,204,206
		dw 208,210,212,214,216,218,220,222
		dw 224,226,228,230,232,234,236,238
		dw 240,242,244,246,248,250,252,254

GUSVol		dw 257 dup (0)

DefaultGUSVol	dw 16384
                dw 28672,32752,36848,37888,39936,40944,41984,42496
                dw 43520,44032,45040,45312,45824,46080,46592,46848
                dw 47360,47616,48128,48384,48896,49136,49408,49536
                dw 49792,49920,50176,50304,50560,50688,50944,51072
                dw 51328,51456,51712,51840,52096,52224,52480,52608
                dw 52864,52992,53232,53312,53440,53504,53632,53696
                dw 53824,53888,54016,54080,54208,54272,54400,54464
                dw 54592,54656,54784,54848,54976,55040,55168,55232
                dw 55360,55424,55552,55616,55744,55808,55936,56000
                dw 56128,56192,56320,56384,56512,56576,56704,56768
                dw 56896,56960,57088,57152,57280,57328,57408,57440
                dw 57504,57536,57600,57632,57696,57728,57792,57824
                dw 57888,57920,57984,58016,58080,58112,58176,58208
                dw 58272,58304,58368,58400,58464,58496,58560,58592
                dw 58656,58688,58752,58784,58848,58880,58944,58976
                dw 59040,59072,59136,59168,59232,59264,59328,59360
                dw 59424,59456,59520,59552,59616,59648,59712,59744
                dw 59808,59840,59904,59936,60000,60032,60096,60128
                dw 60192,60224,60288,60320,60384,60416,60480,60512
                dw 60576,60608,60672,60704,60768,60800,60864,60896
                dw 60960,60992,61056,61088,61152,61184,61248,61280
                dw 61344,61376,61424,61456,61488,61504,61536,61552
                dw 61584,61600,61632,61648,61680,61696,61728,61744
                dw 61776,61792,61824,61840,61872,61888,61920,61936
                dw 61968,61984,62016,62032,62064,62080,62112,62128
                dw 62160,62176,62208,62224,62256,62272,62304,62320
                dw 62352,62368,62400,62416,62448,62464,62496,62512
                dw 62544,62560,62592,62608,62640,62656,62688,62704
                dw 62736,62752,62784,62800,62832,62848,62880,62896
                dw 62928,62944,62976,62992,63024,63040,63072,63088
                dw 63120,63136,63168,63184,63216,63232,63264,63280
                dw 63312,63328,63360,63376,63408,63424,63456,63472


;**************************** Module Information ******************************


FileHeader		db 1084 dup (0)

FileSize		dd 0

ModuleType		db 0 ;(1=MOD,2=S3M,3=XM,4=C2M)

ModuleName		db 28+1 dup (0)

NumOfInstruments	dw 0
InstrumentPointers	dd 128 dup (0)
InstrumentInfoSize	dd 0

NumOfOrders		dw 0
RealNumOfOrders 	dw 0
PatternOrder		db 256 dup (0)
LastRowNum		db 256 dup (0)

NumOfPatterns		dw 0
RealNumOfPatterns	dw 0
PatternPointers 	dd 256 dup (0)
RepackedSize		dd 0

GUSMemoryUsed		dd 5 dup (0)

UsedChannels		dw 0
NumOfChannels		dw 0

FrequencyTable		db 0

RestartPosition 	dw 0

InitialVolume		db 0
InitialSpeed		db 0
InitialTempo		db 0

StereoMode		db 0

FastVolumeSlides	db 0

PortamentoType		db 0

TempoCalculationType	db 0

SampleOffsetType	db 0


;***************** Variables and Constants Used by The Loader *****************


XMIDText		db 'Extended Module:'
XMEffectCompare 	db 23h,25h,7fh,7fh,7fh,26h,7fh,7fh,7fh,18h
			db 7fh,19h,7fh,20h,7fh,7fh,7fh,7fh,7fh,7fh
XMSampleHeaderSize	dw 0
XMNumOfSamples		dw 0
XMSampleSize		dd 16 dup (0)
XMSampleLength		dd 16 dup (0)
XMGUSOffset		dd 16 dup (0)
XMSample16Bit		db 16 dup (0)
XMDelta 		dw 0

S3MEffectCompare	db 0fh,0bh,7fh,7fh,7fh,7fh,03h,04h,20h,00h,06h,05h,7fh
			db 7fh,09h,7fh,19h,07h,7fh,0eh,24h,23h,7fh,7fh,7fh,7fh
S3MEffect18Compare	db 10h,13h,15h,14h,17h,7fh,7fh,7fh
			db 7fh,7fh,7fh,16h,1ch,1dh,1eh,1fH
S3MChannelCoords	dw 32 dup (0)
S3MDefaultPan		db 0

MODPanning		db 0,2,2,0,0,2,2,0,0,2,2,0,0,2,2,0
			db 0,2,2,0,0,2,2,0,0,2,2,0,0,2,2,0
MODPeriodCompare	db (56-0) dup (0+16*7)
			db (60-56) dup (11+16*6)
			db (63-60) dup (10+16*6)
			db (67-63) dup (9+16*6)
			db (71-67) dup (8+16*6)
			db (75-71) dup (7+16*6)
			db (80-75) dup (6+16*6)
			db (85-80) dup (5+16*6)
			db (90-85) dup (4+16*6)
			db (95-90) dup (3+16*6)
			db (101-95) dup (2+16*6)
			db (107-101) dup (1+16*6)
			db (113-107) dup (0+16*6)
			db (120-113) dup (11+16*5)
			db (127-120) dup (10+16*5)
			db (135-127) dup (9+16*5)
			db (143-135) dup (8+16*5)
			db (151-143) dup (7+16*5)
			db (160-151) dup (6+16*5)
			db (170-160) dup (5+16*5)
			db (180-170) dup (4+16*5)
			db (190-180) dup (3+16*5)
			db (202-190) dup (2+16*5)
			db (214-202) dup (1+16*5)
			db (226-214) dup (0+16*5)
			db (240-226) dup (11+16*4)
			db (254-240) dup (10+16*4)
			db (269-254) dup (9+16*4)
			db (285-269) dup (8+16*4)
			db (302-285) dup (7+16*4)
			db (320-302) dup (6+16*4)
			db (339-320) dup (5+16*4)
			db (360-339) dup (4+16*4)
			db (381-360) dup (3+16*4)
			db (404-381) dup (2+16*4)
			db (428-404) dup (1+16*4)
			db (453-428) dup (0+16*4)
			db (480-453) dup (11+16*3)
			db (508-480) dup (10+16*3)
			db (538-508) dup (9+16*3)
			db (570-538) dup (8+16*3)
			db (604-570) dup (7+16*3)
			db (640-604) dup (6+16*3)
			db (678-640) dup (5+16*3)
			db (720-678) dup (4+16*3)
			db (762-720) dup (3+16*3)
			db (808-762) dup (2+16*3)
			db (856-808) dup (1+16*3)
			db (907-856) dup (0+16*3)
			db (960-907) dup (11+16*2)

;*********** Variables and Constants Needed in The Player Routine *************


RowParameter		db 32 dup (0)
RowBuffer		db 5*32 dup (0)

FileHandle		dw 0
NumVoices		db 0
ChanOn			dd 0FFFFFFFFh
ErrorCode		dw 0
FileStartOffset		dd 0
OfsPattern		dw 0
SegPattern		dw 0
BufferMem		dw 0
PatternMem		dw 0

PanEffectOn		db 1
SpeedZeroOn		db 1
LoLimit 		dd 0
HiLimit 		dd 0
ReadOnlyPatterns	db 0
VBlank			db 0

PositionToUnpack	dw 0
RowToUnpack		dw 0
CurrentPosition 	dw 0
InternalRow		dw 0
CurrentRow		dw 0
GlobalVolume		dw 64
MainVolume		dw 64
CurrentSpeed		dw 0
CurrentTempo		db 0
TickCounter		dw 0
TempVol 		dw 0
BreakFlag		db 0
BreakRow		dw 0
OldBreakRow		dw 0
BreakPattern		dw 0
IgnoreBreak		db 0
Speed			dd 0
SpeedAdd		dd 0
CurrentDivisor		dd 0
Counter 		dd 0
Time			dd 0
OfficialTempo		dw 0
OfficialSpeed		dw 0
JumpOldTimer		dw 0
SpeedDivisor		dw 1250
PauseModule		db 0
LoopCounter		db 0

GlobalJumpToLoopOn 	db 0
GlobalJumpToLoopCounter	db 0
GlobalJumpToLoopRow	dw 0

PatternDelayOn		db 0
PatternDelayCounter	db 0
PatternDelayRow 	dw 0

VibratoWaveform 	dw 0
VibratoWaveNum		db 0
TremoloWaveNum		db 0
TremoloWaveform 	dw 0

HighestOctave		equ 9

;*************************** Instrument Constants *****************************


; Instrument structure

InstrumentName			equ   0 ;  28 bytes+nul byte
InstrumentType			equ  29 ;   1 byte (0=normal, 1=extended)
NumOfSamples			equ  30 ;   1 byte

InstrumentStructureSize 	equ  31

; Extended instrument info structure

KeyboardCompare 		equ   0 ;96*4 bits
VolumeType			equ  48 ;   1 byte
NumOfVolumePoints		equ  49 ;   1 byte
VolumeEnvelopePoints		equ  50 ;  12 words
VolumeEnvelopePointValues	equ  74 ;  12 bytes
VolumeSustainPoint		equ  86 ;   1 byte
VolumeLoopBegin 		equ  87 ;   1 byte
VolumeLoopEnd			equ  88 ;   1 byte
PanningType			equ  89 ;   1 byte
NumOfPanningPoints		equ  90 ;   1 byte
PanningEnvelopePoints		equ  91 ;  12 words
PanningEnvelopePointValues	equ 115 ;  12 bytes
PanningSustainPoint		equ 127 ;   1 byte
PanningLoopBegin		equ 128 ;   1 byte
PanningLoopEnd			equ 129 ;   1 byte
AutoVibratoType 		equ 130 ;   1 byte
AutoVibratoSweep		equ 131 ;   1 byte
AutoVibratoDepth		equ 132 ;   1 byte
AutoVibratoRate 		equ 133 ;   1 byte
VolumeFadeout			equ 134 ;   1 word

ExtendedInstrumentStructureSize equ 136

; Sample structure

SampleName			equ   0 ;  22 bytes+nul byte
SampleOffset			equ  23 ;   1 dword
SampleLength			equ  27 ;   1 dword
SampleSize			equ  31 ;   1 dword
SampleLoopBegin 		equ  35 ;   1 dword
SampleVolume			equ  43 ;   1 byte
SampleC4Spd			equ  44 ;   1 word
SampleC4SpdPrecalc		equ  46 ;   1 dword
SampleLoopType			equ  50 ;   1 byte (1 = 1way, 2 = 2way)
Sample16Bit			equ  51 ;   1 byte (1 = enabled, 2 = converted)
SampleMute			equ  52 ;   1 byte
SamplePanning			equ  53 ;   1 byte
SampleRelativeNote		equ  54 ;   1 byte (4 bits octave, 4 bits note)

SampleStructureSize		equ	55
