;********************************
;*			        *
;*  CapaPlay II Player Routine  *
;*			        *
;********************************


;*************************** The Player Interrupt *****************************


PlayerInterrupt	proc	far
		pushad
		push	es
		push	ds

		cli

		mov	ax,cs
		mov	ds,ax

		cmp	[TimerModeToUse],0
		jz	@@SystemTimerPrepare

		mov	dx,cs:[BasePort]
		add	dx,StatusPort
		in	al,dx
		test	al,4
		jnz	@@NoIrqPending
		jmp	@@EndPattern
@@NoIrqPending:

		mov	dx,cs:[BasePort]
		add	dx,CommandPort
		mov	al,TimerControl
		out	dx,al
		add	dx,2
		xor	al,al			;disable timer 1
		out	dx,al
		mov	al,4			;enable timer 1
		out	dx,al

@@SystemTimerPrepare:

		cmp	[PauseModule],1
		jnz	@@NoPauseModule
		jmp	@@EndPattern
@@NoPauseModule:

		inc	[Time]

		mov	di,offset [ChannelInfo]
		mov	cx,[UsedChannels]
@@BarCheckLoop:

		inc	[di.CH_BarSequencer]

		test	[di.CH_BarSequencer],15
		jnz	@@BarSet2

		cmp	[di.CH_Bar],0
		jz	@@BarSet
		dec	[di.CH_Bar]
@@BarSet:
		cmp	[di.CH_BarSequencer],96
		jb	@@BarSet2
		mov	[di.CH_BarSequencer],0
		mov	[di.CH_NoteTriggered],0
@@BarSet2:

		add	di,ChanSize
		dec	cx	
		jnz	@@BarCheckLoop

		inc	[Counter]
		mov	ax,word ptr [Speed+2]
		add	word ptr [SpeedAdd+2],ax
		mov	ax,word ptr [Speed]
		adc	word ptr [SpeedAdd],ax
		jc	@@JumpPattern

		cmp	[Counter],4
		je	@@ClearNotes
		cmp	[Counter],5
		je	@@SetNotes
		jmp	@@EndPattern

@@ClearNotes:
		mov	di,offset [ChannelInfo]
		mov	cx,[UsedChannels]
		mov	dx,[BasePort]
		add	dx,CommandPort

@@StopVoices:
		dec	dx
		mov	al,byte ptr [UsedChannels]
		sub	al,cl
		out	dx,al
		inc	dx

		cmp	[di.CH_InstrumentSet],1
		jae	@@VoiceOff1
		cmp	[di.CH_OffsetAddition],0
		jne	@@VoiceOff1
		jmp	@@NoVoiceOff

@@VoiceOff1:
		mov	bx,[di.CH_OldFinalVolume]
		mov	[di.CH_OldFinalVolume],0
		mov	[di.CH_OldVolume],0

		shl	bx,1
		mov	bp,[GUSVol+bx]

		mov	dx,[BasePort]
		add	dx,CommandPort

		mov	al,VolumeCtrl
		out	dx,al
		add	dx,2
		mov	al,3
		out	dx,al
		sub	dx,2

		mov	bx,[GUSVol]
		mov	ah,01000000b

		mov	al,VolRampStart
		out	dx,al
		xchg	ax,bx
		inc	dx
		out	dx,ax
		dec	dx

		mov	al,VolRampEnd
		out	dx,al
		mov	ax,bp
		inc	dx
		out	dx,ax
		dec	dx

		mov	al,VolumeCtrl
		out	dx,al
		mov	al,bh
		add	dx,2
		out	dx,al
		sub	dx,2
@@NoVoiceOff:

		add	di,ChanSize
		dec	cx
		jnz	@@StopVoices
		jmp	@@EndPattern

@@SetNotes:
		mov	cs:[Counter],1
		mov	di,offset [ChannelInfo]
		mov	cx,[UsedChannels]
		mov	dx,[BasePort]
		add	dx,CommandPort

@@ChangeSamps:
		dec	dx
		mov	al,byte ptr [UsedChannels]
		sub	al,cl
		out	dx,al
		inc	dx

		cmp	[di.CH_InstrumentSet],1
		jae	@@SampChange1
		cmp	[di.CH_OffsetAddition],0
		jne	@@ChangeOffset
		jmp	@@NoChangeSamp

@@ChangeOffset:
		mov	al,SampleStartLo
		out	dx,al
		inc	dx
		mov	eax,[di.CH_GUSOffsetBegin]
		xor	ebx,ebx
		mov	bx,[di.CH_OffsetAddition]
		add	eax,ebx
		shr	eax,7
		and	eax,1fffh
		out	dx,ax
		dec	dx
		mov	al,SampleStartHi
		out	dx,al
		inc	dx
		mov	ax,word ptr [di.CH_GUSOffsetBegin]
		add	ax,[di.CH_OffsetAddition]
		and	ax,7fh
		shl	ax,9
		out	dx,ax
		dec	dx
		sub	dx,CommandPort
		rept	6
		in	al,dx
		endm
		add	dx,CommandPort
		jmp	@@NoChangeSamp

@@SampChange1:
		mov	al,WriteVoiceMode
		out	dx,al
		add	dx,2
		mov	al,3
		out	dx,al
		sub	dx,DataHighPort
		rept	6
		in	al,dx
		endm
		add	dx,CommandPort

		mov	al,SampleStartLo
		out	dx,al
		inc	dx
		mov	eax,[di.CH_GUSOffsetBegin]
		xor	ebx,ebx
		mov	bx,[di.CH_OffsetAddition]
		add	eax,ebx
		shr	eax,7
		and	eax,1fffh
		out	dx,ax
		dec	dx
		mov	al,SampleStartHi
		out	dx,al
		inc	dx
		mov	ax,word ptr [di.CH_GUSOffsetBegin]
		add	ax,[di.CH_OffsetAddition]
		and	ax,7fh
		shl	ax,9
		out	dx,ax
		sub	dx,DataLowPort
		rept	6
		in	al,dx
		endm
		add	dx,CommandPort

		mov	al,SampleEndLo
		out	dx,al
		inc	dx
		mov	eax,[di.CH_GUSOffsetEnd]
		shr	eax,7
		and	eax,1fffh
		out	dx,ax
		dec	dx
		mov	al,SampleEndHi
		out	dx,al
		inc	dx
		mov	ax,word ptr [di.CH_GUSOffsetEnd]
		and	ax,7fh
		shl	ax,9
		out	dx,ax
		dec	dx

		mov	al,LoopStartLo
		out	dx,al
		inc	dx
		mov	eax,[di.CH_GUSOffsetLoopBegin]
		shr	eax,7
		and	eax,1fffh
		out	dx,ax
		dec	dx
		mov	al,LoopStartHi
		out	dx,al
		inc	dx
		mov	ax,word ptr [di.CH_GUSOffsetLoopBegin]
		and	ax,7fh
		shl	ax,9
		out	dx,ax
		dec	dx

		mov	al,WriteVoiceMode
		out	dx,al
		add	dx,2
		mov	al,3
		out	dx,al
		sub	dx,2

@@NoChangeSamp:

		mov	ax,[di.CH_Volume]
		cmp	ax,[di.CH_OldVolume]
		je	@@NoSetBar
		mov	[di.CH_Bar],al
@@NoSetBar:
		mov	ax,[di.CH_FinalVolume]
		mov	[TempVol],ax
		mov	eax,[Counter]
		test	[ChanOn],eax
		jnz	@@NoChanOff1
		jmp	@@ChanOff
@@NoChanOff1:
		mov	bx,[di.CH_CurrentInstrument]
		shl	bx,2
		les	si,InstrumentPointers[bx]

		mov	ax,[di.CH_CurrentSample]
		cmp	byte ptr es:[si+NumOfSamples],al
		jbe	@@ChanOff
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument1
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument1:
		add	si,InstrumentStructureSize
		add	si,ax
		cmp	byte ptr es:[si+SampleMute],1
		jnz	@@NoChanOff2
@@ChanOff:
		mov	[TempVol],0
		mov	[di.CH_Bar],0
@@NoChanOff2:

		mov	bx,[TempVol]

		shl	bx,1
		mov	bp,[GUSVol+bx]

		mov	bx,[di.CH_OldFinalVolume]
		shl	bx,1
		mov	bx,[GUSVol+bx]

		mov	dx,bp
		mov	dl,bh
		cmp	dl,dh
		jne	@@SetVol

		mov	dx,[BasePort]
		add	dx,CommandPort

		mov	al,VolumeCtrl
		out	dx,al
		add	dx,2
		mov	al,3
		out	dx,al
		sub	dx,2

		mov	al,SetVolume
		out	dx,al
		mov	ax,bp
		inc	dx
		out	dx,ax
		dec	dx
		jmp	@@NoSetVol

@@SetVol:
		mov	dx,[BasePort]
		add	dx,CommandPort

		mov	al,VolumeCtrl
		out	dx,al
		add	dx,2
		mov	al,3
		out	dx,al
		sub	dx,2

		xor	ah,ah
		cmp	bx,bp
		jb	@@NoFixVolDir
		mov	ah,01000000b
		xchg	bx,bp
@@NoFixVolDir:

		mov	al,VolRampStart
		out	dx,al
		xchg	ax,bx
		inc	dx
		out	dx,ax
		dec	dx

		mov	al,VolRampEnd
		out	dx,al
		mov	ax,bp
		inc	dx
		out	dx,ax
		dec	dx

		mov	al,VolumeCtrl
		out	dx,al
		mov	al,bh
		add	dx,2
		out	dx,al
		sub	dx,2
@@NoSetVol:

		cmp	[di.CH_VibratoOn],0
		jz	@@NoVibratoFrequency
		mov	bx,[di.CH_VibratoFrequency]
		jmp	@@FrequencyChange
@@NoVibratoFrequency:
		cmp	[di.CH_ArpeggioOn],0
		jz	@@NoArpeggioFrequency
		mov	bx,[di.CH_ArpeggioCounter]
		mov	bx,[di.CH_CalculatedArpeggioVals+bx]
		jmp	@@FrequencyChange
@@NoArpeggioFrequency:

		mov	bx,[di.CH_NoteFrequency]

		cmp	[di.CH_OldVibratoOn],1
		jz	@@FrequencyChange

		cmp	[di.CH_OldArpeggioOn],1
		jz	@@FrequencyChange

		cmp	bx,[di.CH_OldNoteFrequency]
		jz	@@NoFrequencyChange

@@FrequencyChange:
		mov	al,SetVoiceFreq
		out	dx,al
		inc	dx
		mov	ax,bx
		out	dx,ax
		dec	dx
		mov	[di.CH_RealFrequency],bx
@@NoFrequencyChange:

		mov	bx,[di.CH_NoteFrequency]
		mov	[di.CH_OldNoteFrequency],bx


		shl	[Counter],1
		add	di,ChanSize
		dec	cx
		jnz	@@ChangeSamps

		mov	di,offset [ChannelInfo]
		mov	cx,[UsedChannels]
@@StartVoices:
		dec	dx
		mov	al,byte ptr [UsedChannels]
		sub	al,cl
		out	dx,al
		inc	dx

		cmp	[di.CH_InstrumentSet],2
		jne	@@NoVoiceStart

		mov	al,WriteVoiceMode
		out	dx,al
		add	dx,2
		mov	al,[di.CH_LoopType]
		shl	al,3
		test	al,00010000b
		jz	@@No2WayLoop
		or	al,00001000b
@@No2WayLoop:
		cmp	[di.CH_16Bit],1
		jnz	@@No16BitSample
		or	al,00000100b
@@No16BitSample:
		out	dx,al
		sub	dx,DataHighPort
		rept	6
		in	al,dx
		endm
		add	dx,CommandPort
@@NoVoiceStart:

		mov	[di.CH_InstrumentSet],0
		mov	[di.CH_OffsetAddition],0

		add	di,ChanSize
		dec	cx
		jnz	@@StartVoices
		jmp	@@EndPattern

;--------------------------------- Row Loop -----------------------------------

@@JumpPattern:

		mov	[Counter],0

		cmp	[CurrentSpeed],0
		jnz	@@NoSpeedZero
		jmp	@@DoEffects
@@NoSpeedZero:

		dec	[TickCounter]
		jnz	@@DoEffects
		jmp	@@DoPattern
@@DoEffects:

		mov	di,offset [ChannelInfo]
		mov	cx,[UsedChannels]
@@RowLoop:

		inc	[di.CH_EffectTime]

		mov	ax,[di.CH_Volume]
		mov	[di.CH_OldVolume],ax

		add	[di.CH_ArpeggioCounter],2
		cmp	[di.CH_ArpeggioCounter],6
		jb	@@NoWrapArp
		mov	[di.CH_ArpeggioCounter],0
@@NoWrapArp:

		mov	[di.CH_PeriodChange],0
		
		cmp	[di.CH_VolumeColumn],0f0h
		jae	@@NoLoopVolumeColumnEffect
		cmp	[di.CH_VolumeColumn],040h
		jbe	@@NoLoopVolumeColumnEffect
		mov	al,[di.CH_VolumeColumn]
		mov	ah,al
		shr	al,4
		and	ah,0fh

		cmp	al,05h
		jnz	@@NoLoopVolumeSlideDown
		mov	al,0ah
		call	LoopEffects
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopVolumeSlideDown:
		cmp	al,06h
		jnz	@@NoLoopVolumeSlideUp
		shl	ah,4
		mov	al,0ah
		call	LoopEffects
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopVolumeSlideUp:
		cmp	al,07h
		jnz	@@NoLoopFineVolumeSlideDown
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopFineVolumeSlideDown:
		cmp	al,08h
		jnz	@@NoLoopFineVolumeSlideUp
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopFineVolumeSlideUp:
		cmp	al,09h
		jnz	@@NoLoopSetVibratoSpeed
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopSetVibratoSpeed:
		cmp	al,0ah
		jnz	@@NoLoopVibrato
		mov	al,04h
		call	LoopEffects
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopVibrato:
		cmp	al,0bh
		jnz	@@NoLoopSetPanning
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopSetPanning:
		cmp	al,0ch
		jnz	@@NoLoopPanningSlideLeft
		mov	al,18h
		call	LoopEffects
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopPanningSlideLeft:
		cmp	al,0dh
		jnz	@@NoLoopPanningSlideRight
		mov	al,18h
		shl	ah,4
		call	LoopEffects
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopPanningSlideRight:
		cmp	al,0eh
		jnz	@@NoLoopPortamento
		mov	al,03h
		shl	ah,4
		call	LoopEffects
		jmp	@@NoLoopVolumeColumnEffect
@@NoLoopPortamento:

@@NoLoopVolumeColumnEffect:

		mov	ax,[di.CH_Effect]
		call	LoopEffects

		call	CalculateVoiceInformation

		add	di,ChanSize
		dec	cx
		jnz	@@RowLoop
		jmp	@@EndPattern

;------------------------------ Pattern Loop ----------------------------------

@@DoPattern:
		mov	ax,[CurrentSpeed]
		mov	[TickCounter],ax

		mov	bx,[CurrentPosition]
		dec	bx
		mov	[PositionToUnpack],bx

		mov	ax,[InternalRow]
		mov	[RowToUnpack],ax

		cmp	[PatternDelayOn],1
		jnz	@@NoPatternDelay
		dec	[PatternDelayCounter]
		jnz	@@NoPatternDelayCounterZero
		mov	[PatternDelayOn],0
		inc	[PatternDelayRow]
@@NoPatternDelayCounterZero:

		mov	ax,[PatternDelayRow]
		mov	[RowToUnpack],ax
		jmp	@@PatternDelay

@@NoPatternDelay:

		xor	bh,bh
		mov	di,offset [ChannelInfo]
		mov	cx,[UsedChannels]
@@JumpToLoopCheck:
		cmp	[di.CH_JumpToLoopOn],1
		jnz	@@NoJumpToLoop
		mov	ax,[di.CH_JumpToLoopRow]
		mov	[RowToUnpack],ax
		mov	[di.CH_JumpToLoopOn],0
		mov	bh,1
@@NoJumpToLoop:
		add	di,ChanSize
		dec	cx
		jnz	@@JumpToLoopCheck

		cmp	[GlobalJumpToLoopOn],1
		jnz	@@NoGlobalJumpToLoop
		mov	ax,[GlobalJumpToLoopRow]
		mov	[RowToUnpack],ax
		mov	[GlobalJumpToLoopOn],0
		mov	bh,1
@@NoGlobalJumpToLoop:

		cmp	bh,1
		jz	@@NoPatternWrap

@@PatternDelay:

		cmp	[PatternDelayOn],1
		jz	@@NoPatternWrap
		cmp	[BreakFlag],1
		jnz	@@NoBreakFlagOn
		mov	[BreakFlag],0
		mov	bx,[BreakPattern]
		mov	[CurrentPosition],bx
		jmp	@@NoTrackWrap
@@NoBreakFlagOn:
		mov	bx,[CurrentPosition]
		dec	bx
		mov	bl,cs:[PatternOrder+bx]
		xor	bh,bh
		xor	ah,ah
		mov	al,LastRowNum[bx]
		cmp	[InternalRow],ax
		jbe	@@NoPatternWrap
		mov	ax,[CurrentPosition]
		inc	ax
		cmp	ax,[RealNumOfOrders]
		jbe	@@NoTrackWrap
		mov	ax,[RestartPosition]
		mov	[CurrentPosition],ax
		inc	[LoopCounter]
@@NoTrackWrap:

		mov	bx,[CurrentPosition]
		mov	ax,[BreakRow]
		mov	[OldBreakRow],ax

		mov	[BreakRow],0
		inc	[CurrentPosition]

		mov	[PositionToUnpack],bx
		mov	[RowToUnpack],ax

@@NoPatternWrap:

		cmp	[IgnoreBreak],0
		jz	@@NoIgnoreDec
		dec	[IgnoreBreak]
@@NoIgnoreDec:

		call	UnpackRow

		xor	bp,bp
		mov	di,offset [ChannelInfo]
		mov	cx,[UsedChannels]
@@PatternLoop:

		mov	ax,[di.CH_Volume]
		mov	[di.CH_OldVolume],ax
		
		mov	eax,[di.CH_C4SpdPrecalc]
		mov	[di.CH_OldC4SpdPrecalc],eax

		cmp	[PatternDelayOn],1
		jnz	@@NoPatternDelayOnSoPlayNote
		jmp	@@NoVolumeDefined
@@NoPatternDelayOnSoPlayNote:

		mov	ax,[di.CH_Effect]
		cmp	ah,0
		jnz	@@NoCopyOldEffect
		mov	ah,byte ptr [di.CH_OldEffect+1]
@@NoCopyOldEffect:
		mov	[di.CH_OldEffect],ax

		mov	al,RowBuffer[bp]
		mov	[di.CH_NoteDataCache],al

		mov	al,RowBuffer[bp+1]
		mov	[di.CH_InstrumentDataCache],al

		mov	ax,word ptr RowBuffer[bp+2]
		mov	[di.CH_Effect],ax

		mov	al,RowBuffer[bp+4]
		mov	[di.CH_VolumeColumn],al

; Handle note column

		mov	al,[di.CH_VibratoOn]
		mov	[di.CH_OldVibratoOn],al
		mov	[di.CH_VibratoOn],0
		mov	al,[di.CH_ArpeggioOn]
		mov	[di.CH_OldArpeggioOn],al
		mov	[di.CH_ArpeggioOn],0
		mov	[di.CH_ArpeggioCounter],0
		mov	[di.CH_NewNote],0
		mov	[di.CH_NoteTriggered],0
		mov	[di.CH_FineEffect],0

		cmp	byte ptr [di.CH_Effect],19h
		jz	@@EffectRetrig
		mov	[di.CH_RetrigTime],0
@@EffectRetrig:

		cmp	byte ptr [di.CH_Effect],04h
		jz	@@Vibrato
		cmp	byte ptr [di.CH_Effect],06h
		jz	@@Vibrato
		cmp	byte ptr [di.CH_Effect],24h
		jz	@@Vibrato

		mov	al,[di.CH_VolumeColumn]
		and	al,0f0h
		cmp	al,0a0h
		jnz	@@NoVibrato
		mov	[di.CH_VibratoOn],2
		jmp	@@NoVibrato
@@Vibrato:
		mov	[di.CH_VibratoOn],1
@@NoVibrato:

		cmp	byte ptr [di.CH_Effect],03h
		jz	@@Portamento
		cmp	byte ptr [di.CH_Effect],05h
		jz	@@Portamento
		mov	al,[di.CH_VolumeColumn]
		and	al,0f0h
		cmp	al,0e0h
		jnz	@@NoPortamento
@@Portamento:
		mov	[di.CH_PortamentoOn],1
		jmp	@@NoNewNote1
@@NoPortamento:
		mov	[di.CH_PortamentoOn],0

		cmp	byte ptr [di.CH_Effect],1dh
		jz	@@NoNewNote1

		mov	bl,[di.CH_NoteDataCache]
		mov	al,bl
		cmp	al,254
		jae	@@OldNoteValues
		mov	ah,al
		shr	al,4
		mov	[di.CH_Octave],al
		and	ah,0fh
		mov	[di.CH_Note],ah
@@OldNoteValues:
		cmp	bl,254
		jb	@@YesNewNote1
		cmp	bl,255
		jz	@@NoNewNote1
; Key off
		mov	[di.CH_KeyOff],1
		cmp	[di.CH_AutoVibratoSweepCounter],255
		jz	@@NoNewNote1
		mov	[di.CH_AutoVibratoSweepCounter],0
		jmp	@@NoNewNote1
@@YesNewNote1:
	        mov	[di.CH_NewNote],1
@@NoNewNote1:

; Handle instrument column

		cmp	[di.CH_InstrumentDataCache],255
		jnz	@@NewInstrument
		cmp	[di.CH_NewNote],1
		jz	@@OnlyNewNote
		jmp	@@NoNewInstrument
@@NewInstrument:

		mov	ax,[di.CH_CurrentInstrument]
		mov	[di.CH_OldInstrument],ax

		mov	ax,[di.CH_CurrentSample]
		mov	[di.CH_OldSample],ax

		xor	bh,bh
		mov	bl,[di.CH_InstrumentDataCache]
		mov	[di.CH_CurrentInstrument],bx

		mov	[di.CH_VolumeFadeoutCounter],32768

		mov	[di.CH_AutoVibratoSweepCounter],0
		mov	[di.CH_AutoVibratoPointer],0
		mov	[di.CH_VolumeEnvelopePointer],0
		mov	[di.CH_VolumeEnvelopeCurrentPoint],0
		mov	[di.CH_PanningEnvelopePointer],0
		mov	[di.CH_PanningEnvelopeCurrentPoint],0

		cmp	[di.CH_NoteDataCache],254
		jz	@@OnlyNewNote
		mov	[di.CH_KeyOff],0
@@OnlyNewNote:

		mov	ax,[di.CH_SampleVolume]
		mov	[di.CH_OldSampleVolume],ax

		mov	bx,[di.CH_CurrentInstrument]
		cmp	[NumOfInstruments],bx
		ja	@@NewInstrumentExists

		mov	bx,[di.CH_OldInstrument]
		mov	[di.CH_CurrentInstrument],bx

		cmp	[PortamentoType],0
		jz	@@PortamentoTypeZero1

		cmp	[di.CH_PortamentoOn],1
		jnz	@@PortamentoTypeZero1
		mov	ax,[di.CH_OldSampleVolume]
		mov	[di.CH_SampleVolume],ax
		mov	[di.CH_Volume],ax
		mov	[di.CH_RealVolume],ax
		jmp	@@NoNewInstrument
@@PortamentoTypeZero1:

		mov	[di.CH_Volume],0
		mov	[di.CH_RealVolume],0

		mov	[di.CH_InstrumentType],0
		mov	[di.CH_GUSOffsetBegin],0
		mov	[di.CH_GUSOffsetEnd],0
		mov	[di.CH_GUSOffsetLoopBegin],0
		mov	[di.CH_LoopType],0
		mov	[di.CH_C4SpdPrecalc],4096
		jmp	@@NoNewInstrument
@@NewInstrumentExists:

		shl	bx,2
		les	si,InstrumentPointers[bx]

		mov	al,es:[si+InstrumentType]
		mov	[di.CH_InstrumentType],al

		xor	ax,ax
		cmp	[di.CH_InstrumentType],0
		jz	@@NormalInstrument2

		push	cx

		mov	al,[di.CH_Octave]
		mov	bl,12
		mul	bl
		mov	bl,[di.CH_Note]
		add	bl,al
		xor	bh,bh
		mov	cl,bl
		and	cl,1
		shl	cl,2
		shr	bx,1
		mov	al,es:[si+InstrumentStructureSize+KeyboardCompare+bx]
		shr	al,cl
		and	ax,0fh

		pop	cx

@@NormalInstrument2:

		mov	[di.CH_CurrentSample],ax

		cmp	[PortamentoType],0
		jz	@@PortamentoTypeZero2

		cmp	[di.CH_PortamentoOn],1
		jnz	@@PortamentoTypeZero2
		mov	ax,[di.CH_OldSampleVolume]
		mov	[di.CH_SampleVolume],ax
		mov	[di.CH_Volume],ax
		mov	[di.CH_RealVolume],ax
		jmp	@@NoNewInstrument
@@PortamentoTypeZero2:

		cmp	es:[si+NumOfSamples],al
		ja	@@NewSampleExists

		mov	[di.CH_Volume],0
		mov	[di.CH_RealVolume],0

		mov	[di.CH_GUSOffsetBegin],0
		mov	[di.CH_GUSOffsetEnd],0
		mov	[di.CH_GUSOffsetLoopBegin],0
		mov	[di.CH_LoopType],0
		mov	[di.CH_C4SpdPrecalc],4096
		jmp	@@NoNewInstrument
@@NewSampleExists:

		mov	bl,SampleStructureSize
		mul	bl

		cmp	[di.CH_InstrumentType],0
		jz	@@NormalInstrument3

		add	si,InstrumentStructureSize
		mov	bl,es:[si+AutoVibratoType]
		mov	[di.CH_AutoVibratoType],bl
		cmp	bl,0
		jnz	@@NoAutoVibratoSiniTable
		mov	bx,offset cs:[SiniTab]
		jmp	@@NoAutoVibratoRampUpTable
@@NoAutoVibratoSiniTable:
		cmp	bl,1
		jnz	@@NoAutoVibratoSquareTable
		mov	bx,offset cs:[SquareTab]
		jmp	@@NoAutoVibratoRampUpTable
@@NoAutoVibratoSquareTable:
		cmp	bl,2
		jnz	@@NoAutoVibratoRampUpTable
		mov	bx,offset cs:[RampUpTab]
		jmp	@@NoAutoVibratoRampDownTable
@@NoAutoVibratoRampUpTable:
		cmp	bl,3
		jnz	@@NoAutoVibratoRampDownTable
		mov	bx,offset cs:[RampDownTab]
		jmp	@@NoAutoVibratoRampDownTable
@@NoAutoVibratoRampDownTable:
		mov	[di.CH_AutoVibratoTableAddress],bx
		mov	bl,es:[si+AutoVibratoSweep]
		mov	[di.CH_AutoVibratoSweep],bl
		mov	bl,es:[si+AutoVibratoDepth]
		mov	[di.CH_AutoVibratoDepth],bl
		mov	bl,es:[si+AutoVibratoRate]
		mov	[di.CH_AutoVibratoRate],bl
		mov	bx,es:[si+VolumeFadeout]
		mov	[di.CH_VolumeFadeout],bx

		mov	bl,es:[si+VolumeType]
		mov	[di.CH_VolumeEnvelopeType],bl
		mov	bl,es:[si+NumOfVolumePoints]
		mov	[di.CH_VolumeEnvelopeNumOfPoints],bl
		mov	bl,es:[si+VolumeLoopBegin]
		mov	bx,24
@@GetVolumeEnvelopePoints:
		mov	dx,es:[si+VolumeEnvelopePoints+bx-2]
		mov	[di.CH_VolumeEnvelopePoints+bx-2],dx
		sub	bx,2
		jnz	@@GetVolumeEnvelopePoints
		mov	bx,12
@@GetVolumeEnvelopePointValues:
		mov	dl,es:[si+VolumeEnvelopePointValues+bx-1]
		mov	[di.CH_VolumeEnvelopePointValues+bx-1],dl
		dec	bx
		jnz	@@GetVolumeEnvelopePointValues
		mov	bl,es:[si+VolumeSustainPoint]
		mov	[di.CH_VolumeEnvelopeSustainPoint],bl
		mov	bl,es:[si+VolumeLoopBegin]
		mov	[di.CH_VolumeEnvelopeLoopBegin],bl
		mov	bl,es:[si+VolumeLoopEnd]
		mov	[di.CH_VolumeEnvelopeLoopEnd],bl
		mov	bl,[di.CH_VolumeEnvelopePointValues]
		mov	[di.CH_VolumeEnvelopeVolume],bl

		mov	bl,es:[si+PanningType]
		mov	[di.CH_PanningEnvelopeType],bl
		mov	bl,es:[si+NumOfPanningPoints]
		mov	[di.CH_PanningEnvelopeNumOfPoints],bl
		mov	bl,es:[si+PanningLoopBegin]
		mov	bx,24
@@GetPanningEnvelopePoints:
		mov	dx,es:[si+PanningEnvelopePoints+bx-2]
		mov	[di.CH_PanningEnvelopePoints+bx-2],dx
		sub	bx,2
		jnz	@@GetPanningEnvelopePoints
		mov	bx,12
@@GetPanningEnvelopePointValues:
		mov	dl,es:[si+PanningEnvelopePointValues+bx-1]
		mov	[di.CH_PanningEnvelopePointValues+bx-1],dl
		dec	bx
		jnz	@@GetPanningEnvelopePointValues
		mov	bl,es:[si+PanningSustainPoint]
		mov	[di.CH_PanningEnvelopeSustainPoint],bl
		mov	bl,es:[si+PanningLoopBegin]
		mov	[di.CH_PanningEnvelopeLoopBegin],bl
		mov	bl,es:[si+PanningLoopEnd]
		mov	[di.CH_PanningEnvelopeLoopEnd],bl
		mov	bl,[di.CH_PanningEnvelopePointValues]
		mov	[di.CH_PanningEnvelopePanning],bl

		add	si,ExtendedInstrumentStructureSize
		sub	si,InstrumentStructureSize
@@NormalInstrument3:
		add	si,InstrumentStructureSize
		add	si,ax

		cmp	[di.CH_InstrumentDataCache],255
		jz	@@NoNewSampleVolume

		xor	ah,ah
		mov	al,es:[si+SampleVolume]
		mov	[di.CH_Volume],ax
		mov	[di.CH_RealVolume],ax
		mov	[di.CH_SampleVolume],ax
@@NoNewSampleVolume:

		mov	eax,es:[si+SampleOffset]
		mov	[di.CH_GUSOffsetBegin],eax
		mov	[di.CH_GUSOffsetEnd],eax
		mov	[di.CH_GUSOffsetLoopBegin],eax

		mov	eax,es:[si+SampleLength]
		mov	[di.CH_SampleLength],eax
		add	[di.CH_GUSOffsetEnd],eax
		mov	eax,es:[si+SampleLoopBegin]
		add	[di.CH_GUSOffsetLoopBegin],eax

		mov	eax,es:[si+SampleC4SpdPrecalc]
		mov	[di.CH_C4SpdPrecalc],eax
		mov	al,es:[si+SampleLoopType]
		mov	[di.CH_LoopType],al
		mov	al,es:[si+SampleRelativeNote]
		mov	ah,al
		and	al,0fh
		mov	[di.CH_RelativeNote],al
		sar	ah,4
		mov	[di.CH_RelativeOctave],ah
		mov	al,es:[si+Sample16Bit]
		mov	[di.CH_16Bit],al
		mov	al,es:[si+SamplePanning]
		mov	[di.CH_SamplePanning],al

		cmp	[di.CH_InstrumentType],0
		jz	@@NormalInstrument4

		mov	al,[di.CH_SamplePanning]
		mov	[di.CH_Panning],al
@@NormalInstrument4:

		cmp	[di.CH_16Bit],1
		jnz	@@NoNewInstrument

		mov	eax,[di.CH_GUSOffsetBegin]
		and	[di.CH_GUSOffsetBegin],0c0000h
		and	eax,03ffffh
		shr	eax,1
		add	[di.CH_GUSOffsetBegin],eax

		mov	eax,[di.CH_GUSOffsetEnd]
		and	[di.CH_GUSOffsetEnd],0c0000h
		and	eax,03ffffh
		shr	eax,1
		add	[di.CH_GUSOffsetEnd],eax

		mov	eax,[di.CH_GUSOffsetLoopBegin]
		and	[di.CH_GUSOffsetLoopBegin],0c0000h
		and	eax,03ffffh
		shr	eax,1
		add	[di.CH_GUSOffsetLoopBegin],eax

@@NoNewInstrument:

; Handle new note

		cmp	[di.CH_NewNote],1
		jnz	@@NoNewNote2

		push	cx

		mov	ax,[di.CH_RealVolume]
		mov	[di.CH_Volume],ax

		mov	[di.CH_VibratoPointer],0
		mov	[di.CH_TremoloPointer],0
		mov	[di.CH_NoteTriggered],1
		mov	[di.CH_BarSequencer],0

		mov	[di.CH_RealNoteFragment],0

		xor	ebx,ebx
		mov	bl,[di.CH_Note]
		mov	cl,[di.CH_Octave]
	
		add	bl,[di.CH_RelativeNote]
		cmp	bl,12
		jge	@@TooHighNote
		cmp	bl,0
		jnl	@@NoteOK
		add	bl,12
		dec	cl
		jmp	@@NoteOK
@@TooHighNote:
		sub	bl,12
		inc	cl
@@NoteOK:
		mov	[di.CH_RealNote],bl
		shl	bx,1+6
		mov	bx,[Periods+bx]
		add	cl,[di.CH_RelativeOctave]
		cmp	cl,HighestOctave
		jg	@@TooHighOctave
		cmp	cl,0
		jnl	@@OctaveOK
		mov	cl,0
		jmp	@@OctaveOK
@@TooHighOctave:
		mov	cl,HighestOctave
@@OctaveOK:
		mov	[di.CH_RealOctave],cl
		mov	eax,[di.CH_C4SpdPrecalc]
		mul	ebx
		shr	eax,8
		shr	eax,cl
		mov	[di.CH_Period],eax

		cmp	eax,[HiLimit]
		jae	@@NotTooHigh
		mov	eax,[HiLimit]
		mov	[di.CH_Period],eax
		call	SetNoteAndOctave
		mov	eax,[di.CH_Period]
@@NotTooHigh:

		cmp	eax,[LoLimit]
		jbe	@@NotTooLow
		mov	eax,[LoLimit]
		mov	[di.CH_Period],eax
		call	SetNoteAndOctave
		mov	eax,[di.CH_Period]
@@NotTooLow:
		mov	[di.CH_PortamentoPeriod],eax

		mov	ebx,eax
		xor	edx,edx
		mov	eax,[CurrentDivisor]
		div	ebx

		mov	[di.CH_NoteFrequency],ax

		mov	[di.CH_InstrumentSet],2

		pop	cx
@@NoNewNote2:

		mov	al,[di.CH_VolumeColumn]
		cmp	al,40h
		ja	@@NoVolumeDefined

		cmp	byte ptr [di.CH_Effect],1dh
		jz	@@NoVolumeDefined
		xor	ah,ah
		mov	[di.CH_Volume],ax
		mov	[di.CH_RealVolume],ax
@@NoVolumeDefined:

		mov	[di.CH_PeriodChange],0

		cmp	[di.CH_VolumeColumn],0f0h
		jae	@@NoInitialVolumeColumnEffect
		cmp	[di.CH_VolumeColumn],040h
		jbe	@@NoInitialVolumeColumnEffect
		mov	al,[di.CH_VolumeColumn]
		mov	ah,al
		shr	al,4
		and	ah,0fh

		cmp	al,05h
		jnz	@@NoInitialVolumeSlideDown
		mov	al,0ah
		call	InitialEffects
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialVolumeSlideDown:
		cmp	al,06h
		jnz	@@NoInitialVolumeSlideUp
		shl	ah,4
		mov	al,0ah
		call	InitialEffects
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialVolumeSlideUp:
		cmp	al,07h
		jnz	@@NoInitialFineVolumeSlideDown
		mov	al,1bh
		call	InitialEffects
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialFineVolumeSlideDown:
		cmp	al,08h
		jnz	@@NoInitialFineVolumeSlideUp
		mov	al,1ah
		call	InitialEffects
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialFineVolumeSlideUp:
		cmp	al,09h
		jnz	@@NoInitialSetVibratoSpeed
		shl	ah,4
		mov	al,04h
		call	InitialEffects
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialSetVibratoSpeed:
		cmp	al,0ah
		jnz	@@NoInitialVibrato
		mov	al,04h
		call	InitialEffects
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialVibrato:
		cmp	al,0bh
		jnz	@@NoInitialSetPanning
		mov	al,08h
		call	InitialEffects
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialSetPanning:
		cmp	al,0ch
		jnz	@@NoInitialPanningSlideLeft
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialPanningSlideLeft:
		cmp	al,0dh
		jnz	@@NoInitialPanningSlideRight
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialPanningSlideRight:
		cmp	al,0eh
		jnz	@@NoInitialPortamento
		mov	al,03h
		shl	ah,4
		call	InitialEffects
		jmp	@@NoInitialVolumeColumnEffect
@@NoInitialPortamento:

@@NoInitialVolumeColumnEffect:

		mov	ax,[di.CH_Effect]
		call	InitialEffects

		call	CalculateVoiceInformation

		add	bp,5
		mov	[di.CH_EffectTime],0
		add	di,ChanSize
		dec	cx
		jz	@@EndChannels
		jmp	@@PatternLoop
@@EndChannels:

		inc	[InternalRow]
@@EndPattern:

		cmp	[TimerModeToUse],0
		jz	@@SystemTimerUpdate

		mov	dx,cs:[BasePort]
		add	dx,CommandPort
		mov	al,8fh
		out	dx,al
		add	dx,2
		in	al,dx				;check IRQ status

		jmp	@@GUSTimerUpdate

@@SystemTimerUpdate:

		dec	[JumpOldTimer]
		jnz	@@GUSTimerUpdate
		mov	[JumpOldTimer],55
		pop	ds
		pop	es
		popad
		jmp	dword ptr cs:[OldIRQAddr]

@@GUSTimerUpdate:

		mov	al,20h
		out	0a0h,al
		mov	al,20h
		out	20h,al

		sti

		pop	ds
		pop	es
		popad
		iret
PlayerInterrupt		endp


;********************** Procedures Used by The Player *************************


UnpackRow	proc	near

		push	es

		mov	bx,cs:[PositionToUnpack]
		mov	bl,cs:[PatternOrder+bx]
		xor	bh,bh
		shl	bx,2
		mov	es,word ptr cs:PatternPointers[bx+2]
		mov	si,word ptr cs:PatternPointers[bx]

		mov	ax,cs:[RowToUnpack]
		mov	cs:[InternalRow],ax
		mov	cs:[CurrentRow],ax

		mov	bx,es
		cmp	bx,0			;check if pattern exists
		jz	@@FirstRow

		cmp	ax,0
		jz	@@FirstRow

@@ReadMoreChannelsSeekRow:

		mov	dl,es:[si]
		inc	si
		cmp	dl,0
		jz	@@NextRowSeekRow

		test	dl,00100000b
		jz	@@NoNoteAndInsInvalidSeekRow
		inc	si
		inc	si
@@NoNoteAndInsInvalidSeekRow:
		test	dl,01000000b
		jz	@@NoCommandAndInfoInvalidSeekRow
		mov	bl,es:[si]
		inc	si
		test	bl,10000000b
		jz	@@NoCommandAndInfoInvalidSeekRow
		inc	si
@@NoCommandAndInfoInvalidSeekRow:
		test	dl,10000000b
		jz	@@NoVolumeInvalidSeekRow
		inc	si
@@NoVolumeInvalidSeekRow:
		jmp	@@ReadMoreChannelsSeekRow

@@NextRowSeekRow:

		dec	ax
		jnz	@@ReadMoreChannelsSeekRow
@@FirstRow:

		mov	di,cs:[UsedChannels]
		lea	di,[4*edi+edi-5]
@@ClearRowData:
		mov	dword ptr cs:RowBuffer[di+0],007fffffh
		mov	cs:RowBuffer[di+4],0ffh

		sub	di,5
		jnc	@@ClearRowData

		mov	bx,es
		cmp	bx,0			;check if pattern exists
		jz	@@NextRow

@@ReadMoreChannels:

		mov	dl,es:[si]
		inc	si
		cmp	dl,0
		jz	@@NextRow

		xor	bh,bh
		mov	bl,dl
		and	bl,31
		cmp	bx,cs:[UsedChannels]
		jb	@@ChannelNumberValid
@@ReadUntilValid:
		test	dl,00100000b
		jz	@@NoNoteAndInsInvalid
		inc	si
		inc	si
@@NoNoteAndInsInvalid:
		test	dl,01000000b
		jz	@@NoCommandAndInfoInvalid
		mov	bl,es:[si]
		inc	si
		test	bl,10000000b
		jz	@@NoCommandAndInfoInvalid
		inc	si
@@NoCommandAndInfoInvalid:
		test	dl,10000000b
		jz	@@NoVolumeInvalid
		inc	si
@@NoVolumeInvalid:
		jmp	@@ReadMoreChannels

@@ChannelNumberValid:

		lea	di,[ebx+ebx*4]

		test	dl,00100000b
		jz	@@NoNoteAndIns
		mov	bx,es:[si]
		mov	word ptr cs:RowBuffer[di],bx
		inc	si
		inc	si	   
@@NoNoteAndIns:

		test	dl,01000000b
		jz	@@NoCommandAndInfo
		mov	bl,es:[si]
		inc	si
		mov	bh,bl
		and	bh,01111111b
		mov	cs:RowBuffer[di+2],bh
		test	bl,10000000b
		jz	@@NoCommandAndInfo
		mov	bl,es:[si]
		inc	si
		mov	cs:RowBuffer[di+3],bl
@@NoCommandAndInfo:

		test	dl,10000000b
		jz	@@NoVolume
		mov	bl,es:[si]
		mov	cs:RowBuffer[di+4],bl
		inc	si
@@NoVolume:

		jmp	@@ReadMoreChannels

@@NextRow:

		pop	es

		ret
UnpackRow	endp

SetNoteAndOctave	proc	near

		cmp	[FrequencyTable],1
		jz	@@LinearTable

		shl	eax,8+HighestOctave

		xor	edx,edx
		mov	ebx,[di.CH_C4SpdPrecalc]
		div	ebx

		mov	[di.CH_RealOctave],HighestOctave
@@GetNote:
		cmp	eax,1813
		jbe	@@GotNote
		dec	[di.CH_RealOctave]
		shr	eax,1
		jmp	@@GetNote
@@GotNote:
		mov	bx,ax
		mov	bl,[ReversePeriod+bx]
		mov	[di.CH_RealNote],bl

@@LinearTable:
		mov	bl,[di.CH_RealNote]
		mov	dl,[di.CH_RealOctave]

		sub	bl,[di.CH_RelativeNote]
		cmp	bl,12
		jge	@@TooHighNote
		cmp	bl,0
		jnl	@@NoteOK
		add	bl,12
		dec	dl
		jmp	@@NoteOK
@@TooHighNote:
		sub	bl,12
		inc	dl
@@NoteOK:
		mov	[di.CH_Note],bl

		sub	dl,[di.CH_RelativeOctave]
		cmp	dl,HighestOctave
		jg	@@TooHighOctave
		cmp	dl,0
		jnl	@@OctaveOK
		mov	dl,0
		jmp	@@OctaveOK
@@TooHighOctave:
		mov	dl,HighestOctave
@@OctaveOK:
		mov	[di.CH_Octave],dl

		ret
SetNoteAndOctave	endp

CalculateVoiceInformation	proc	near

		cmp	[di.CH_KeyOff],1
		jnz	@@NoFadeout
		test	[di.CH_VolumeEnvelopeType],00000001b
		jz	@@KeyOffImmediately

		mov	ax,[di.CH_VolumeFadeout]
		sub	[di.CH_VolumeFadeoutCounter],ax
		jnc	@@NoFadeout
		mov	[di.CH_KeyOff],0
		mov	[di.CH_VolumeFadeoutCounter],0
@@KeyOffImmediately:
		mov	[di.CH_Volume],0
		mov	[di.CH_RealVolume],0
@@NoFadeout:

		cmp	[di.CH_InstrumentType],0
		jz	@@NormalInstrument

		mov	[di.CH_AutoVibratoValue],0

		cmp	[di.CH_AutoVibratoDepth],0
		jz	@@NoAutoVibrato

		mov	bl,[di.CH_AutoVibratoPointer]
		add	bl,[di.CH_AutoVibratoRate]
		mov	[di.CH_AutoVibratoPointer],bl
		mov	si,[di.CH_AutoVibratoTableAddress]
		xor	bh,bh
		shl	bx,1
		mov	ax,[si+bx]
		xor	bh,bh
		mov	bl,[di.CH_AutoVibratoDepth]
		imul	bx

		cmp	[di.CH_AutoVibratoSweep],0
		jz	@@NoSweep
		cmp	[di.CH_AutoVibratoSweepCounter],255
		jz	@@NoSweep

		cmp	[di.CH_KeyOff],1
		jz	@@Sweep

		inc	[di.CH_AutoVibratoSweepCounter]
		mov	bl,[di.CH_AutoVibratoSweep]
		cmp	[di.CH_AutoVibratoSweepCounter],bl
		jb	@@Sweep
		mov	[di.CH_AutoVibratoSweepCounter],255
		jmp	@@NoSweep
@@Sweep:
		xor	bh,bh
		mov	bl,[di.CH_AutoVibratoSweepCounter]
		imul	bx
		mov	bl,[di.CH_AutoVibratoSweep]
		idiv	bx
@@NoSweep:

		sar	ax,8

		cwde

		mov	[di.CH_AutoVibratoValue],eax
		
@@NoAutoVibrato:

		test	[di.CH_VolumeEnvelopeType],00000001b
		jz	@@NoVolumeEnvelope

		mov	bl,[di.CH_VolumeEnvelopeCurrentPoint]

		test	[di.CH_VolumeEnvelopeType],00000100b
		jz	@@NoVolumeEnvelopeLoop
		cmp	bl,[di.CH_VolumeEnvelopeLoopEnd]
		jnz	@@NoVolumeEnvelopeLoop
		mov	bl,[di.CH_VolumeEnvelopeLoopBegin]
		mov	[di.CH_VolumeEnvelopeCurrentPoint],bl
		xor	bh,bh
		shl	bx,1
		mov	ax,[di.CH_VolumeEnvelopePoints+bx]
		mov	[di.CH_VolumeEnvelopePointer],ax
		shr	bx,1
@@NoVolumeEnvelopeLoop:

		cmp	[di.CH_KeyOff],1
		jz	@@NoVolumeEnvelopeSustain
		test	[di.CH_VolumeEnvelopeType],00000010b
		jz	@@NoVolumeEnvelopeSustain
		cmp	bl,[di.CH_VolumeEnvelopeSustainPoint]
		jnz	@@NoVolumeEnvelopeSustain
		xor	bh,bh
		mov	al,[di.CH_VolumeEnvelopePointValues+bx]
		mov	[di.CH_VolumeEnvelopeVolume],al
		jmp	@@NoVolumeEnvelope
@@NoVolumeEnvelopeSustain:

		inc	[di.CH_VolumeEnvelopePointer]

		mov	ax,[di.CH_VolumeEnvelopePointer]
		xor	bh,bh
		mov	bl,[di.CH_VolumeEnvelopeCurrentPoint]
		inc	bx
		shl	bx,1
		cmp	ax,[di.CH_VolumeEnvelopePoints+bx]
		jnz	@@NoNewVolumeEnvelopePoint
		shr	bx,1
		mov	[di.CH_VolumeEnvelopeCurrentPoint],bl
@@NoNewVolumeEnvelopePoint:
		mov	bl,[di.CH_VolumeEnvelopeCurrentPoint]
		inc	bl
		cmp	bl,[di.CH_VolumeEnvelopeNumOfPoints]
		jnz	@@CalculateVolumeEnvelope

		dec	[di.CH_VolumeEnvelopePointer]
		xor	bh,bh
		dec	bl
		mov	al,[di.CH_VolumeEnvelopePointValues+bx]
		mov	[di.CH_VolumeEnvelopeVolume],al
		jmp	@@NoVolumeEnvelope
@@CalculateVolumeEnvelope:

		shl	ecx,16

		xor	bh,bh
		dec	bl
		mov	al,[di.CH_VolumeEnvelopePointValues+bx+1]
		sub	al,[di.CH_VolumeEnvelopePointValues+bx]
		cbw
		shl	bx,1
		mov	cx,[di.CH_VolumeEnvelopePointer]
		sub	cx,[di.CH_VolumeEnvelopePoints+bx]
		imul	cx
		mov	cx,[di.CH_VolumeEnvelopePoints+bx+2]
		sub	cx,[di.CH_VolumeEnvelopePoints+bx]
		jnz	@@NoZeroDifferenceVolumeEnvelope
		xor	al,al
		jmp	@@ZeroDifferenceVolumeEnvelope
@@NoZeroDifferenceVolumeEnvelope:
		idiv	cx
@@ZeroDifferenceVolumeEnvelope:
		shr	bx,1
		add	al,[di.CH_VolumeEnvelopePointValues+bx]
		mov	[di.CH_VolumeEnvelopeVolume],al

		shr	ecx,16

@@NoVolumeEnvelope:

		test	[di.CH_PanningEnvelopeType],00000001b
		jz	@@NoPanningEnvelope

		mov	bl,[di.CH_PanningEnvelopeCurrentPoint]

		test	[di.CH_PanningEnvelopeType],00000100b
		jz	@@NoPanningEnvelopeLoop
		cmp	bl,[di.CH_PanningEnvelopeLoopEnd]
		jnz	@@NoPanningEnvelopeLoop
		mov	bl,[di.CH_PanningEnvelopeLoopBegin]
		mov	[di.CH_PanningEnvelopeCurrentPoint],bl
		xor	bh,bh
		shl	bx,1
		mov	ax,[di.CH_PanningEnvelopePoints+bx]
		mov	[di.CH_PanningEnvelopePointer],ax
		shr	bx,1
@@NoPanningEnvelopeLoop:

		cmp	[di.CH_KeyOff],1
		jz	@@NoPanningEnvelopeSustain
		test	[di.CH_PanningEnvelopeType],00000010b
		jz	@@NoPanningEnvelopeSustain
		cmp	bl,[di.CH_PanningEnvelopeSustainPoint]
		jnz	@@NoPanningEnvelopeSustain
		xor	bh,bh
		mov	al,[di.CH_PanningEnvelopePointValues+bx]
		mov	[di.CH_PanningEnvelopePanning],al
		jmp	@@NoPanningEnvelope
@@NoPanningEnvelopeSustain:

		inc	[di.CH_PanningEnvelopePointer]

		mov	ax,[di.CH_PanningEnvelopePointer]
		xor	bh,bh
		mov	bl,[di.CH_PanningEnvelopeCurrentPoint]
		inc	bx
		shl	bx,1
		cmp	ax,[di.CH_PanningEnvelopePoints+bx]
		jnz	@@NoNewPanningEnvelopePoint
		shr	bx,1
		mov	[di.CH_PanningEnvelopeCurrentPoint],bl
@@NoNewPanningEnvelopePoint:
		mov	bl,[di.CH_PanningEnvelopeCurrentPoint]
		inc	bl
		cmp	bl,[di.CH_PanningEnvelopeNumOfPoints]
		jnz	@@CalculatePanningEnvelope

		dec	[di.CH_PanningEnvelopePointer]
		xor	bh,bh
		dec	bl
		mov	al,[di.CH_PanningEnvelopePointValues+bx]
		mov	[di.CH_PanningEnvelopePanning],al
		jmp	@@NoPanningEnvelope
@@CalculatePanningEnvelope:

		shl	ecx,16

		xor	bh,bh
		dec	bl
		mov	al,[di.CH_PanningEnvelopePointValues+bx+1]
		sub	al,[di.CH_PanningEnvelopePointValues+bx]
		cbw
		shl	bx,1
		mov	cx,[di.CH_PanningEnvelopePointer]
		sub	cx,[di.CH_PanningEnvelopePoints+bx]
		imul	cx
		mov	cx,[di.CH_PanningEnvelopePoints+bx+2]
		sub	cx,[di.CH_PanningEnvelopePoints+bx]
		jnz	@@NoZeroDifferencePanningEnvelope
		xor	al,al
		jmp	@@ZeroDifferencePanningEnvelope
@@NoZeroDifferencePanningEnvelope:
		idiv	cx
@@ZeroDifferencePanningEnvelope:
		shr	bx,1
		add	al,[di.CH_PanningEnvelopePointValues+bx]
		mov	[di.CH_PanningEnvelopePanning],al

		shr	ecx,16

@@NoPanningEnvelope:

@@NormalInstrument:

		cmp	[StereoMode],1
		jnz	@@NoNewPanning

		mov	al,[di.CH_FinalPanning]
		mov	[di.CH_OldFinalPanning],al

		mov	al,[di.CH_Panning]

		cmp	[di.CH_InstrumentType],0
		jz	@@NormalPanning
		test	[di.CH_PanningEnvelopeType],00000001b
		jz	@@NormalPanning

		sub	al,128
		jc	@@PanningNegative
		neg	al
@@PanningNegative:
		add	al,128

		mov	bl,32
		sub	bl,[di.CH_PanningEnvelopePanning]
		imul	bl
		sar	ax,5

		xor	bh,bh
		mov	bl,[di.CH_Panning]
		
		add	ax,bx
		cmp	ax,255
		jbe	@@NormalPanning
		mov	al,255
@@NormalPanning:
		mov	[di.CH_FinalPanning],al
		cmp	[di.CH_OldFinalPanning],al
		jz	@@NoNewPanning

		shl	ax,4
	
		mov	dx,cs:[BasePort]
		add	dx,ActiveVoicePort
		mov	al,byte ptr [UsedChannels]
		sub	al,cl
		out	dx,al
		mov	dx,cs:[BasePort]
		add	dx,CommandPort
		mov	al,VoiceBalance
		out	dx,al
		mov	dx,cs:[BasePort]
		add	dx,DataHighPort
		mov	al,ah
		out	dx,al
@@NoNewPanning:

		mov	ax,[di.CH_FinalVolume]
		mov	[di.CH_OldFinalVolume],ax

		xor	ebx,ebx
		xor	edx,edx

		xor	eax,eax
		mov	ax,[di.CH_Volume]
		shl	eax,2

		mov	bx,[MainVolume]
		mul	ebx

		mov	bx,[GlobalVolume]
		mul	ebx

		test	[di.CH_VolumeEnvelopeType],00000001b
		jz	@@NoFadeoutVolume
		cmp	[di.CH_KeyOff],0
		jz	@@NoFadeoutVolume
		xor	ebx,ebx
		mov	bx,[di.CH_VolumeFadeoutCounter]
		mul	ebx
		shrd	eax,edx,15
		shr	edx,15
@@NoFadeoutVolume:

		test	[di.CH_VolumeEnvelopeType],00000001b
		jz	@@NoVolumeEnvelopeVolume
		xor	ebx,ebx
		mov	bl,[di.CH_VolumeEnvelopeVolume]
		mul	ebx
		shr	eax,6
@@NoVolumeEnvelopeVolume:

		shr	eax,6+6

		mov	[di.CH_FinalVolume],ax

		cmp	[di.CH_VibratoOn],0
		jnz	@@ChangeInFrequency

		cmp	[di.CH_PeriodChange],0
		jnz	@@ChangeInFrequency

		cmp	[di.CH_AutoVibratoValue],0
		jnz	@@ChangeInFrequency

		jmp	@@NoChangeInFrequency 
@@ChangeInFrequency:

		cmp	[FrequencyTable],1
		jz	@@LinearFrequencyTable

		mov	ebx,[di.CH_Period]
		add	ebx,[di.CH_PeriodChange]
		add	ebx,[di.CH_AutoVibratoValue]

		cmp	ebx,[HiLimit]
		jae	@@NoTooHighNote1
		mov	ebx,[HiLimit]
@@NoTooHighNote1:
	        cmp	ebx,[LoLimit]
		jbe	@@NoTooLowNote1
		mov	ebx,[LoLimit]
@@NoTooLowNote1:

		xor	edx,edx
		mov	eax,[CurrentDivisor]
		div	ebx

		cmp	[di.CH_VibratoOn],0
		jnz	@@Vibrato

		mov	[di.CH_NoteFrequency],ax
		mov	eax,[di.CH_Period]
		add	eax,[di.CH_PeriodChange]
		cmp	eax,[HiLimit]
		jae	@@NoTooHighNote2
		mov	eax,[HiLimit]
@@NoTooHighNote2:
		cmp	eax,[LoLimit]
		jbe	@@NoTooLowNote2
		mov	eax,[LoLimit]
@@NoTooLowNote2:
		mov	[di.CH_Period],eax
		call	SetNoteAndOctave

		cmp	[di.CH_PortamentoOn],1
		jz	@@GlissandoModeZero
		cmp	[di.CH_GlissandoMode],0
		jz	@@GlissandoModeZero

		xor	ebx,ebx
		mov	bl,[di.CH_RealNote]
		shl	bx,1+6
		mov	bx,[Periods+bx]
		mov	cl,[di.CH_RealOctave]
		mov	eax,[di.CH_C4SpdPrecalc]
		mul	ebx
		shr	eax,8
		shr	eax,cl

		mov	[di.CH_NoteFrequency],ax

@@GlissandoModeZero:

		jmp	@@NoChangeInFrequency
@@Vibrato:
		mov	[di.CH_VibratoFrequency],ax
		jmp	@@NoChangeInFrequency

@@LinearFrequencyTable:

		xor	eax,eax
		mov	al,[di.CH_RealOctave]
		mov	bl,12
		mul	bl
		add	al,[di.CH_RealNote]
		shl	ax,6
		add	al,[di.CH_RealNoteFragment]
		adc	ah,0
		sub	eax,[di.CH_PeriodChange]
		cmp	eax,0
		jg	@@LinearPositive1
		xor	eax,eax
@@LinearPositive1:
		mov	dl,al			;RealNoteFragment bits 0-7
		and	dl,63
		shr	eax,6
		mov	bl,12
		div	bl
		ror	edx,16			;bits 8-23 to dx
		mov	dl,ah			;RealNote bits 8-15
		mov	dh,al			;RealOctave bits 16-23

		xor	eax,eax
		mov	al,dh			;RealOctave bits 16-23
		mov	bl,12
		mul	bl
		add	al,dl			;RealNote bits 8-15
		shl	ax,6
		rol	edx,16			;bits 0-7 to dl
		add	al,dl			;RealNoteFragment bits 0-7
		adc	ah,0
		sub	eax,[di.CH_AutoVibratoValue]
		cmp	eax,0
		jg	@@LinearPositive2
		xor	eax,eax
@@LinearPositive2:

		cmp	[di.CH_VibratoOn],0
		jnz	@@LinearVibrato1
		mov	[di.CH_RealNoteFragment],dl
		ror	edx,16			;bits 8-23 to dx
		mov	[di.CH_RealNote],dl
		mov	[di.CH_RealOctave],dh
@@LinearVibrato1:

		mov	dl,al
		and	dl,63
		shr	eax,6
		mov	bl,12
		div	bl

		push	cx

		mov	cl,al
		xor	ebx,ebx
		mov	bl,ah
		shl	bx,6

		cmp	[di.CH_PortamentoOn],0
		jz	@@LinearGlissandoModeZero
		cmp	[di.CH_GlissandoMode],0
		jz	@@LinearGlissandoModeZero
		sub	bl,dl
@@LinearGlissandoModeZero:
		add	bl,dl

		shl	bx,1
		mov	bx,[Periods+bx]
		mov	eax,[di.CH_C4SpdPrecalc]
		mul	ebx
		shr	eax,8
		shr	eax,cl
		mov	[di.CH_Period],eax
		mov	ebx,eax
		xor	edx,edx
		mov	eax,[CurrentDivisor]
		div	ebx

		pop	cx

		cmp	[di.CH_VibratoOn],0
		jnz	@@LinearVibrato2

		call	SetNoteAndOctave

		mov     [di.CH_NoteFrequency],ax 
		jmp	@@NoChangeInFrequency
@@LinearVibrato2:
		mov     [di.CH_VibratoFrequency],ax
		jmp	@@NoChangeInFrequency

@@NoChangeInFrequency:
		ret
CalculateVoiceInformation	endp
