;*************************
;*                       *
;*  CapaPlay II Effects  *
;*                       *
;*************************


;************************* Effects Done Every Row *****************************


InitialEffects	proc	near

		mov	bl,al
		xor	bh,bh
		shl	bx,1
		jmp	[InitialJumps+bx]

;------------------------------------------------------------------------------

@@Arpeggio:
		cmp	ah,0
		jz	@@OldArpeggioParameters

		mov	bh,ah
		shr	bh,4
		and	ah,0fh
		mov	dh,[di.CH_RealNote]
		mov	dl,[di.CH_RealOctave]
		add	ah,dh
		add	bh,dh
		mov	al,dl
		mov	bl,dl
@@CheckIfArpeggioValue1OK:
		cmp	ah,12
		jb	@@ArpeggioValue1OK
		inc	al
		cmp	al,HighestOctave
		ja	@@ArpeggioOctave1TooHigh
		sub	ah,12
		jmp	@@CheckIfArpeggioValue1OK
@@ArpeggioOctave1TooHigh:
		mov	ah,11

@@ArpeggioValue1OK:
		cmp	bh,12
		jb	@@ArpeggioValue2OK
		inc	bl
		cmp	bl,HighestOctave
		ja	@@ArpeggioOctave2TooHigh
		sub	bh,12
		jmp	@@ArpeggioValue1OK
@@ArpeggioOctave2TooHigh:
		mov	bh,11
@@ArpeggioValue2OK:
		mov	byte ptr [di.CH_ArpeggioVals+0],dh
		mov	byte ptr [di.CH_ArpeggioVals+1],dl
		mov	byte ptr [di.CH_ArpeggioVals+2],ah
		mov	byte ptr [di.CH_ArpeggioVals+3],al
		mov	byte ptr [di.CH_ArpeggioVals+4],bh
		mov	byte ptr [di.CH_ArpeggioVals+5],bl

		mov	ax,[di.CH_NoteFrequency]
		mov	[di.CH_CalculatedArpeggioVals],ax

		push	cx

		xor	ebx,ebx
		mov	bl,byte ptr [di.CH_ArpeggioVals+2]
		shl	bx,1+6
		mov	bx,[Periods+bx]
		mov	cl,byte ptr [di.CH_ArpeggioVals+3]
		mov	eax,[di.CH_C4SpdPrecalc]
		mul	ebx
		shr	eax,8
		shr	eax,cl

		mov	ebx,eax
		xor	edx,edx
		mov	eax,[CurrentDivisor]
		div	ebx
		mov	[di.CH_CalculatedArpeggioVals+2],ax


		xor	ebx,ebx
		mov	bl,byte ptr [di.CH_ArpeggioVals+4]
		shl	bx,1+6
		mov	bx,[Periods+bx]
		mov	cl,byte ptr [di.CH_ArpeggioVals+5]
		mov	eax,[di.CH_C4SpdPrecalc]
		mul	ebx
		shr	eax,8
		shr	eax,cl

		mov	ebx,eax
		xor	edx,edx
		mov	eax,[CurrentDivisor]
		div	ebx
		mov	[di.CH_CalculatedArpeggioVals+4],ax

		pop	cx

@@OldArpeggioParameters:
		mov	[di.CH_ArpeggioOn],1
		ret

;------------------------------------------------------------------------------

@@SlideUp:
		cmp	ah,0
		jnz	@@NoLastParamsSlideUp
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsSlideUp:
		ret

;------------------------------------------------------------------------------

@@SlideDown:
		cmp	ah,0
		jnz	@@NoLastParamsSlideDown
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsSlideDown:
		ret

;------------------------------------------------------------------------------

@@Portamento:
		cmp	ah,0
		jz	@@NoNewPortamentoParameters
		mov	al,ah
		xor	ah,ah
		shl	ax,2
		mov	[di.CH_PortamentoSpeed],ax
@@NoNewPortamentoParameters:

		mov	bl,[di.CH_NoteDataCache]
		cmp	bl,253
		jae	@@NoNewPortamentoPeriod

		push	cx

		mov	cl,bl
		shr	cl,4
		and	ebx,0fh

		add	bl,[di.CH_RelativeNote]
		cmp	bl,12
		jge	@@TooHighNote
		cmp	bl,0
		jnl	@@NoteOK
		add	bl,12
		dec	cl
		jmp	@@NoteOK
@@TooHighNote:
		sub	bl,12
		inc	cl
@@NoteOK:
		add	cl,[di.CH_RelativeOctave]
		cmp	cl,HighestOctave
		jg	@@TooHighOctave
		cmp	cl,0
		jnl	@@OctaveOK
		mov	cl,0
		jmp	@@OctaveOK
@@TooHighOctave:
		mov	cl,HighestOctave
@@OctaveOK:

		cmp	[FrequencyTable],1
		jz	@@LinearPortamento

		shl	bx,1+6
		mov	bx,[Periods+bx]
		mov	eax,[di.CH_C4SpdPrecalc]
		mul	ebx
		shr	eax,8
		shr	eax,cl


		mov	[di.CH_PortamentoPeriod],eax

		pop	cx
		ret

@@LinearPortamento:
		mov	al,12
		mul	cl
		add	ax,bx
		shl	ax,6
		mov	word ptr [di.CH_PortamentoPeriod],ax

		pop	cx
		ret

@@NoNewPortamentoPeriod:
		ret

;------------------------------------------------------------------------------

@@Vibrato:
		mov	al,ah
		and	ah,0fh
		shr	al,4

		cmp	ah,0
		jz	@@NoNewVibratoDepth
		mov	[di.CH_VibratoDepth],ah
@@NoNewVibratoDepth:

		cmp	al,0
		jz	@@NoNewVibratoSpeed
		shl	al,2
		mov	[di.CH_VibratoSpeed],al
@@NoNewVibratoSpeed:

		cmp	[di.CH_OldVibratoOn],0
		jnz	@@LastEffectVibrato1
		mov	ax,[di.CH_NoteFrequency]
		cmp	[di.CH_VibratoOn],2
		jnz	@@NoVolumeColumnVibrato
		mov	ax,[di.CH_RealFrequency]
@@NoVolumeColumnVibrato:
		mov	[di.CH_VibratoFrequency],ax
@@LastEffectVibrato1:
		ret

;------------------------------------------------------------------------------

@@PortamentoVolumeSlide:
		cmp	ah,0
		jnz	@@NoLastParamsPortamentoVolumeSlide
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsPortamentoVolumeSlide:
		jmp	@@NoNewPortamentoParameters

;------------------------------------------------------------------------------

@@VibratoVolumeSlide:
		cmp	ah,0
		jnz	@@NoLastParamsVibratoVolumeSlide
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsVibratoVolumeSlide:

		cmp	[di.CH_OldVibratoOn],0
		jnz	@@LastEffectVibrato2
		mov	ax,[di.CH_NoteFrequency]
		mov	[di.CH_VibratoFrequency],ax
@@LastEffectVibrato2:
		ret

;------------------------------------------------------------------------------

@@Tremolo:
		cmp	ah,0
		jz	@@NoNewTremoloParameters
		mov	al,ah
		and	ah,0fh
		shr	al,4
		shl	al,2
		mov	[di.CH_TremoloSpeed],al
		mov	[di.CH_TremoloDepth],ah
@@NoNewTremoloParameters:
		ret

;------------------------------------------------------------------------------

@@SetPanning:
		cmp	[PanEffectOn],0
		jz	@@NoSetPanning

		mov	[di.CH_Panning],ah
@@NoSetPanning:
		ret

;------------------------------------------------------------------------------

@@SampleOffset:
		cmp	[di.CH_NoteTriggered],0
		jz	@@NoSampleOffset

		cmp	ah,0
		jnz	@@NoLastParamsSampleOffset
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsSampleOffset:

		and	eax,0000ff00h
		mov	ebx,[di.CH_SampleLength]
		cmp	eax,ebx
		jb	@@NoTooHighOffset
		xor	ax,ax
		cmp	[SampleOffsetType],0
		jz	@@NoTooHighOffset
		mov	[di.CH_InstrumentSet],1
@@NoTooHighOffset:
		mov	[di.CH_OffsetAddition],ax
@@NoSampleOffset:
		ret

;------------------------------------------------------------------------------

@@VolumeSlide:
		cmp	ah,0
		jnz	@@NoLastParamsVolumeSlide
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsVolumeSlide:

		cmp	[FastVolumeSlides],0
		jz	@@NoVolumeSlide
		mov	al,ah
		shr	ah,4
		test	al,0fh
		jz	@@VolumeUp
		mov	ah,al
		and	ah,0fh
		jmp	@@VolumeDown
@@VolumeUp:
		add	byte ptr [di.CH_Volume],ah
		cmp	byte ptr [di.CH_Volume],64
		jle	@@NoVolumeSlideTooHigh
		mov	[di.CH_Volume],64
@@NoVolumeSlideTooHigh:
		mov	ax,[di.CH_Volume]
		mov	[di.CH_RealVolume],ax
		ret
@@VolumeDown:
		sub	byte ptr [di.CH_Volume],ah
		cmp	byte ptr [di.CH_Volume],0
		jge	@@NoVolumeSlideTooLow
		mov	[di.CH_Volume],0
@@NoVolumeSlideTooLow:
		mov	ax,[di.CH_Volume]
		mov	[di.CH_RealVolume],ax
@@NoVolumeSlide:
		ret

;------------------------------------------------------------------------------

@@JumpToPosition:
		shr	ax,8
		cmp	ax,[RealNumOfOrders]
		jbe	@@NoTooHighJump
		mov	ax,[RealNumOfOrders]
@@NoTooHighJump:
		cmp	ax,[CurrentPosition]
		jae	@@NoJumpBack
		inc	[LoopCounter]
@@NoJumpBack:
		mov	[InternalRow],63
		mov	[CurrentPosition],ax
		mov	[BreakFlag],0
		ret

;------------------------------------------------------------------------------

@@SetVolume:
		cmp	ah,64
		jbe	@@NoTooHighVolume
		mov	ah,64
@@NoTooHighVolume:
		mov	byte ptr [di.CH_Volume],ah
		mov	byte ptr [di.CH_RealVolume],ah
		ret

;------------------------------------------------------------------------------

@@BreakPatternToRow:
		mov	[BreakFlag],1
		mov	bx,[CurrentPosition]
		inc	bx
		cmp	bx,[RealNumOfOrders]
		jbe	@@NoBreakWrap
		mov	bx,1
		inc	[LoopCounter]
@@NoBreakWrap:
		dec	bx
		mov	[BreakPattern],bx
		cmp	ah,64
		jb	@@NoFixBreak
		mov	ah,63
@@NoFixBreak:
		cmp	[IgnoreBreak],1
		jnz	@@BreakFlagSet
		mov	ah,byte ptr [OldBreakRow]
@@BreakFlagSet:
		mov	byte ptr [BreakRow],ah
		mov	[IgnoreBreak],0
		ret

;------------------------------------------------------------------------------

@@SetTempo:
		cmp	ah,20h
		jbe	@@InvalidTempo
		mov	[CurrentTempo],ah
		mov	byte ptr [OfficialTempo],ah
		shr	ax,7
		mov	bl,5
		cmp	[TempoCalculationType],1
		jz	@@TempoCalculationTypeOne
		shl	ax,6-1
		mov	bl,159
@@TempoCalculationTypeOne:
		div	bl
		mov	dl,al
		xor	dh,dh
		xor	ax,ax
		mov	bx,[SpeedDivisor]
		div	bx
		mov	word ptr [Speed],ax
		xor	ax,ax
		div	bx
		mov	word ptr [Speed+2],ax
@@InvalidTempo:
		ret

;------------------------------------------------------------------------------

@@SetSpeed:
		cmp	ah,0
		jnz	@@NoSetSpeedZero
		cmp	[SpeedZeroOn],1
		jz	@@SetSpeedZero
		ret
@@SetSpeedZero:
		mov	[LoopCounter],255
@@NoSetSpeedZero:
		mov	byte ptr [CurrentSpeed],ah
		mov	byte ptr [OfficialSpeed],ah
		mov	byte ptr [TickCounter],ah
		ret

;------------------------------------------------------------------------------

@@SetFilter:
		ret

;------------------------------------------------------------------------------

@@FineSlideUp:
		cmp	ah,0
		jnz	@@NoLastParamsFineSlideUp
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsFineSlideUp:

		xor	ebx,ebx
		mov	bl,ah
		shl	ebx,2

		sub	[di.CH_PeriodChange],ebx

		ret

;------------------------------------------------------------------------------

@@FineSlideDown:
		cmp	ah,0
		jnz	@@NoLastParamsFineSlideDown
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsFineSlideDown:

		xor	ebx,ebx
		mov	bl,ah
		shl	ebx,2

		add	[di.CH_PeriodChange],ebx

		ret

;------------------------------------------------------------------------------

@@GlissandoControl:
		mov	[di.CH_GlissandoMode],ah
		ret

;------------------------------------------------------------------------------

@@VibratoWaveform:
		push	cx
		mov	[VibratoWaveNum],ah
		mov	bx,offset [SiniTab]
		mov	cl,ah
		mov	dx,256
		shl	dx,cl
		sub	dx,256
		add	bx,dx
		mov	[VibratoWaveform],bx
		pop	cx
		ret

;------------------------------------------------------------------------------

@@FineTune:
		xor	ebx,ebx
		mov	bl,ah
		shl	bl,4
		add	bl,128
		shl	bx,1
		mov	bx,FineTuneCompare[bx]
		xor	edx,edx
		mov	eax,8363*4096
		div	ebx

		mov	[di.CH_C4SpdPrecalc],eax
		ret

;------------------------------------------------------------------------------

@@JumpToLoop:
		test	ah,10000000b
		jnz	@@GlobalJumpToLoop
		cmp	ah,0
		jnz	@@NoSetLoopPoint
		mov	ax,[CurrentRow]
		mov	[di.CH_JumpToLoopRow],ax
		ret
@@NoSetLoopPoint:
		mov	[di.CH_JumpToLoopOn],0
		cmp	[di.CH_JumpToLoopCounter],0
		jz	@@NotAlreadyJumpToLoop
		dec	[di.CH_JumpToLoopCounter]
		jz	@@NoJumpToLoop
		mov	[di.CH_JumpToLoopOn],1
		ret
@@NotAlreadyJumpToLoop:
		mov	byte ptr [di.CH_JumpToLoopCounter],ah
		mov	[di.CH_JumpToLoopOn],1
@@NoJumpToLoop:
		ret

@@GlobalJumpToLoop:
		and	ah,01111111b
		cmp	ah,0
		jnz	@@NoGlobalSetLoopPoint
		mov	ax,[CurrentRow]
		mov	[GlobalJumpToLoopRow],ax
		ret
@@NoGlobalSetLoopPoint:
		mov	[GlobalJumpToLoopOn],0
		cmp	[GlobalJumpToLoopCounter],0
		jz	@@NotAlreadyGlobalJumpToLoop
		dec	[GlobalJumpToLoopCounter]
		jz	@@NoGlobalJumpToLoop
		mov	[GlobalJumpToLoopOn],1
		ret
@@NotAlreadyGlobalJumpToLoop:
		mov	byte ptr [GlobalJumpToLoopCounter],ah
		mov	[GlobalJumpToLoopOn],1
@@NoGlobalJumpToLoop:
		ret

;------------------------------------------------------------------------------

@@TremoloWaveform:
		push	cx
		mov	[TremoloWaveNum],ah
		mov	bx,offset [SiniTab]
		mov	cl,ah
		mov	dx,256
		shl	dx,cl
		sub	dx,256
		add	bx,dx
		mov	[TremoloWaveform],bx
		pop	cx
		ret

;------------------------------------------------------------------------------

@@PanningSlide:
		cmp	ah,0
		jnz	@@NoLastParamsPanningSlide
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsPanningSlide:
		ret

;------------------------------------------------------------------------------

@@RetrigNote:
		push	cx

		cmp	byte ptr [di.CH_OldEffect],19h
		jnz	@@NoRetrig

		cmp	ah,0
		jnz	@@NoRetrigLastParams
		mov	ah,byte ptr [di.CH_OldEffect+1]
@@NoRetrigLastParams:

		mov	al,ah
		and	ah,0fh
		inc	[di.CH_RetrigTime]
		cmp	[di.CH_RetrigTime],ah
		jb	@@NoRetrig
		mov	[di.CH_RetrigTime],0
		mov	[di.CH_InstrumentSet],2
		shr	al,4
		test	al,7
		jz	@@NoRetrig
		test	al,8
		jz	@@RetrigVolumeDown

		and	al,7
		cmp	al,6
		jz	@@ThreeSecondsVolumeRetrig
		cmp	al,7
		jz	@@DoubleVolumeRetrig
		mov	bx,cx
		mov	cl,al
		dec	cl
		mov	ax,1
		shl	ax,cl
		mov	cx,bx
		add	[di.CH_Volume],ax
		cmp	[di.CH_Volume],64
		jbe	@@NoRetrig
		mov	[di.CH_Volume],64
		jmp	@@NoRetrig
@@ThreeSecondsVolumeRetrig:
		mov	ax,[di.CH_Volume]
		shl	ax,1
		add	ax,[di.CH_Volume]
		shr	ax,1
		cmp	ax,64
		jbe	@@NoTooHighRetrigVolume2
		mov	ax,64
@@NoTooHighRetrigVolume2:
		mov	[di.CH_Volume],ax
		jmp	@@NoRetrig
@@DoubleVolumeRetrig:
		mov	ax,[di.CH_Volume]
		shl	ax,1
		cmp	ax,64
		jbe	@@NoTooHighRetrigVolume3
		mov	ax,64
@@NoTooHighRetrigVolume3:
		mov	[di.CH_Volume],ax
		jmp	@@NoRetrig

@@RetrigVolumeDown:
		and	al,7
		cmp	al,6
		jz	@@TwoThirdsVolumeRetrig
		cmp	al,7
		jz	@@HalfVolumeRetrig
		mov	bx,cx
		mov	cl,al
		dec	cl
		mov	ax,1
		shl	ax,cl
		mov	cx,bx
		sub	[di.CH_Volume],ax
		jnc	@@NoRetrig
		mov	[di.CH_Volume],0
		jmp	@@NoRetrig
@@TwoThirdsVolumeRetrig:
		mov	ax,[di.CH_Volume]
		shl	ax,1
		mov	bl,3
		div	bl
		mov	byte ptr [di.CH_Volume],al
		jmp	@@NoRetrig
@@HalfVolumeRetrig:
		mov	ax,[di.CH_Volume]
		shr	ax,1
		mov	byte ptr [di.CH_Volume],al
		jmp	@@NoRetrig

@@NoRetrig:
		mov	ax,[di.CH_Volume]
		mov	[di.CH_RealVolume],ax
		pop	cx
		ret

;------------------------------------------------------------------------------

@@FineVolumeSlideUp:
		cmp	ah,0
		jnz	@@NoLastParamsFineVolumeSlideUp
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsFineVolumeSlideUp:

		add	byte ptr [di.CH_Volume],ah
		cmp	byte ptr [di.CH_Volume],64
		jle	@@NoFineVolumeTooHigh
		mov	[di.CH_Volume],64
@@NoFineVolumeTooHigh:
		mov	ax,[di.CH_Volume]
		mov	[di.CH_RealVolume],ax
		ret

;------------------------------------------------------------------------------

@@FineVolumeSlideDown:
		cmp	ah,0
		jnz	@@NoLastParamsFineVolumeSlideDown
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsFineVolumeSlideDown:

		sub	byte ptr [di.CH_Volume],ah
		cmp	byte ptr [di.CH_Volume],0
		jge	@@NoFineVolumeTooLow
		mov	[di.CH_Volume],0
@@NoFineVolumeTooLow:
		mov	ax,[di.CH_Volume]
		mov	[di.CH_RealVolume],ax
		ret

;------------------------------------------------------------------------------

@@CutNote:
		ret

;------------------------------------------------------------------------------

@@DelayNote:
		test	ah,10000000b
		jnz	@@SetSampleVolumeImmediately
		mov	ax,[di.CH_OldVolume]
		mov	[di.CH_Volume],ax
		mov	[di.CH_RealVolume],ax
@@SetSampleVolumeImmediately:
		ret

;------------------------------------------------------------------------------

@@DelayPattern:
		ret

;------------------------------------------------------------------------------

@@InvertLoop:
		ret

;------------------------------------------------------------------------------

@@Tremor:
		cmp	ah,0
		jz	@@NoNewTremorParameters
		mov	al,ah
		shr	al,4
		and	ah,0fh
		mov	[di.CH_TremorOnCount],al
		mov	[di.CH_TremorOffCount],ah
@@NoNewTremorParameters:

		mov	al,byte ptr [di.CH_OldEffect]
		cmp	al,20h
		jz	@@LastEffectTremor
		mov	ax,[di.CH_Volume]
		mov	[di.CH_TremorVolume],ax
		mov	[di.CH_TremorOn],1
		mov	[di.CH_TremorCounter],0
@@LastEffectTremor:
		ret
		

;------------------------------------------------------------------------------

@@ExtraFineSlideUp:
		cmp	ah,0
		jnz	@@NoLastParamsExtraFineSlideUp
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsExtraFineSlideUp:
		xor	ebx,ebx
		mov	bl,ah

		sub	[di.CH_PeriodChange],ebx

		ret

;------------------------------------------------------------------------------

@@ExtraFineSlideDown:
		cmp	ah,0
		jnz	@@NoLastParamsExtraFineSlideDown
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsExtraFineSlideDown:
		xor	ebx,ebx
		mov	bl,ah

		add	[di.CH_PeriodChange],ebx

		ret

;------------------------------------------------------------------------------

@@SetGlobalVolume:
		cmp	ah,64
		jbe	@@GlobalVolumeOK
		mov	ah,64
@@GlobalVolumeOK:
		mov	byte ptr [GlobalVolume],ah
		ret

;------------------------------------------------------------------------------

@@FineVibrato:
		call	@@Vibrato
		ret

;------------------------------------------------------------------------------

@@GlobalVolumeSlide:
		cmp	ah,0
		jnz	@@NoLastParamsGlobalVolumeSlide
		mov	ah,byte ptr [di.CH_OldEffect+1]
		mov	byte ptr [di.CH_Effect+1],ah
@@NoLastParamsGlobalVolumeSlide:
		ret

;------------------------------------------------------------------------------

@@SetEnvelopePosition:
		shr	ax,8

		xor	bx,bx
		mov	bl,[di.CH_VolumeEnvelopeNumOfPoints]
		dec	bl
		shl	bx,1
		cmp	ax,[di.CH_VolumeEnvelopePoints+bx]
		jb	@@NoTooHighVolumeEnvelopePoint
		mov	ax,[di.CH_VolumeEnvelopePoints+bx]
		dec	ax
		mov	[di.CH_VolumeEnvelopePointer],ax
		sub	bx,2
		jmp	@@GotVolumeEnvelopePoint
@@NoTooHighVolumeEnvelopePoint:
		mov	[di.CH_VolumeEnvelopePointer],ax

		mov	bl,[di.CH_VolumeEnvelopeNumOfPoints]
		dec	bx
		shl	bx,1
@@GetVolumeEnvelopePoint:
		cmp	[di.CH_VolumeEnvelopePoints+bx],ax
		jbe	@@GotVolumeEnvelopePoint
		sub	bx,2
		jnz	@@GetVolumeEnvelopePoint
@@GotVolumeEnvelopePoint:
		shr	bx,1
		mov	[di.CH_VolumeEnvelopeCurrentPoint],bl


		xor	bx,bx
		mov	bl,[di.CH_PanningEnvelopeNumOfPoints]
		dec	bl
		shl	bx,1
		cmp	ax,[di.CH_PanningEnvelopePoints+bx]
		jb	@@NoTooHighPanningEnvelopePoint
		mov	ax,[di.CH_PanningEnvelopePoints+bx]
		dec	ax
		mov	[di.CH_PanningEnvelopePointer],ax
		sub	bx,2
		jmp	@@GotPanningEnvelopePoint
@@NoTooHighPanningEnvelopePoint:
		mov	[di.CH_PanningEnvelopePointer],ax

		mov	bl,[di.CH_PanningEnvelopeNumOfPoints]
		dec	bx
		shl	bx,1
@@GetPanningEnvelopePoint:
		cmp	[di.CH_PanningEnvelopePoints+bx],ax
		jbe	@@GotPanningEnvelopePoint
		sub	bx,2
		jnz	@@GetPanningEnvelopePoint
@@GotPanningEnvelopePoint:
		shr	bx,1
		mov	[di.CH_PanningEnvelopeCurrentPoint],bl
		ret

;------------------------------------------------------------------------------


@@NoInitialJump:

		ret

InitialJumps	dw offset cs:[@@Arpeggio]			; 00
		dw offset cs:[@@SlideUp]			; 01
		dw offset cs:[@@SlideDown]			; 02
		dw offset cs:[@@Portamento]			; 03
		dw offset cs:[@@Vibrato]			; 04
		dw offset cs:[@@PortamentoVolumeSlide]		; 05
 		dw offset cs:[@@VibratoVolumeSlide]		; 06
 		dw offset cs:[@@Tremolo]			; 07
 		dw offset cs:[@@SetPanning]			; 08
 		dw offset cs:[@@SampleOffset]			; 09
		dw offset cs:[@@VolumeSlide]			; 0A
 		dw offset cs:[@@JumpToPosition]			; 0B
		dw offset cs:[@@SetVolume]			; 0C
 		dw offset cs:[@@BreakPatternToRow]		; 0D
		dw offset cs:[@@SetTempo]			; 0E
		dw offset cs:[@@SetSpeed]			; 0F
		dw offset cs:[@@SetFilter]			; 10 x
		dw offset cs:[@@FineSlideUp]			; 11
		dw offset cs:[@@FineSlideDown]			; 12
		dw offset cs:[@@GlissandoControl]		; 13
		dw offset cs:[@@VibratoWaveform]		; 14
		dw offset cs:[@@FineTune]			; 15
		dw offset cs:[@@JumpToLoop]			; 16
		dw offset cs:[@@TremoloWaveform]		; 17
		dw offset cs:[@@PanningSlide]			; 18 -
		dw offset cs:[@@RetrigNote]			; 19
		dw offset cs:[@@FineVolumeSlideUp]		; 1A
		dw offset cs:[@@FineVolumeSlideDown]		; 1B
		dw offset cs:[@@CutNote]			; 1C
		dw offset cs:[@@DelayNote]			; 1D
		dw offset cs:[@@DelayPattern]			; 1E
		dw offset cs:[@@InvertLoop]			; 1F x
 		dw offset cs:[@@Tremor]				; 20
		dw offset cs:[@@ExtraFineSlideUp]		; 21
		dw offset cs:[@@ExtraFineSlideDown]		; 22
 		dw offset cs:[@@SetGlobalVolume]		; 23
		dw offset cs:[@@FineVibrato]			; 24
		dw offset cs:[@@GlobalVolumeSlide]		; 25 -
		dw offset cs:[@@SetEnvelopePosition]		; 26 -
		dw offset cs:[@@NoInitialJump]			; 27 -
		dw offset cs:[@@NoInitialJump]			; 28 -
		dw offset cs:[@@NoInitialJump]			; 29 -
		dw offset cs:[@@NoInitialJump]			; 2A -
		dw offset cs:[@@NoInitialJump]			; 2B -
		dw offset cs:[@@NoInitialJump]			; 2C -
		dw offset cs:[@@NoInitialJump]			; 2D -
		dw offset cs:[@@NoInitialJump]			; 2E -
		dw offset cs:[@@NoInitialJump]			; 2F -
		dw offset cs:[@@NoInitialJump]			; 30 -
		dw offset cs:[@@NoInitialJump]			; 31 -
		dw offset cs:[@@NoInitialJump]			; 32 -
		dw offset cs:[@@NoInitialJump]			; 33 -
		dw offset cs:[@@NoInitialJump]			; 34 -
		dw offset cs:[@@NoInitialJump]			; 35 -
		dw offset cs:[@@NoInitialJump]			; 36 -
		dw offset cs:[@@NoInitialJump]			; 37 -
		dw offset cs:[@@NoInitialJump]			; 38 -
		dw offset cs:[@@NoInitialJump]			; 39 -
		dw offset cs:[@@NoInitialJump]			; 3A -
		dw offset cs:[@@NoInitialJump]			; 3B -
		dw offset cs:[@@NoInitialJump]			; 3C -
		dw offset cs:[@@NoInitialJump]			; 3D -
		dw offset cs:[@@NoInitialJump]			; 3E -
		dw offset cs:[@@NoInitialJump]			; 3F -
		dw offset cs:[@@NoInitialJump]			; 40 -
		dw offset cs:[@@NoInitialJump]			; 41 -
		dw offset cs:[@@NoInitialJump]			; 42 -
		dw offset cs:[@@NoInitialJump]			; 43 -
		dw offset cs:[@@NoInitialJump]			; 44 -
		dw offset cs:[@@NoInitialJump]			; 45 -
		dw offset cs:[@@NoInitialJump]			; 46 -
		dw offset cs:[@@NoInitialJump]			; 47 -
		dw offset cs:[@@NoInitialJump]			; 48 -
		dw offset cs:[@@NoInitialJump]			; 49 -
		dw offset cs:[@@NoInitialJump]			; 4A -
		dw offset cs:[@@NoInitialJump]			; 4B -
		dw offset cs:[@@NoInitialJump]			; 4C -
		dw offset cs:[@@NoInitialJump]			; 4D -
		dw offset cs:[@@NoInitialJump]			; 4E -
		dw offset cs:[@@NoInitialJump]			; 4F -
		dw offset cs:[@@NoInitialJump]			; 50 -
		dw offset cs:[@@NoInitialJump]			; 51 -
		dw offset cs:[@@NoInitialJump]			; 52 -
		dw offset cs:[@@NoInitialJump]			; 53 -
		dw offset cs:[@@NoInitialJump]			; 54 -
		dw offset cs:[@@NoInitialJump]			; 55 -
		dw offset cs:[@@NoInitialJump]			; 56 -
		dw offset cs:[@@NoInitialJump]			; 57 -
		dw offset cs:[@@NoInitialJump]			; 58 -
		dw offset cs:[@@NoInitialJump]			; 59 -
		dw offset cs:[@@NoInitialJump]			; 5A -
		dw offset cs:[@@NoInitialJump]			; 5B -
		dw offset cs:[@@NoInitialJump]			; 5C -
		dw offset cs:[@@NoInitialJump]			; 5D -
		dw offset cs:[@@NoInitialJump]			; 5E -
		dw offset cs:[@@NoInitialJump]			; 5F -
		dw offset cs:[@@NoInitialJump]			; 60 -
		dw offset cs:[@@NoInitialJump]			; 61 -
		dw offset cs:[@@NoInitialJump]			; 62 -
		dw offset cs:[@@NoInitialJump]			; 63 -
		dw offset cs:[@@NoInitialJump]			; 64 -
		dw offset cs:[@@NoInitialJump]			; 65 -
		dw offset cs:[@@NoInitialJump]			; 66 -
		dw offset cs:[@@NoInitialJump]			; 67 -
		dw offset cs:[@@NoInitialJump]			; 68 -
		dw offset cs:[@@NoInitialJump]			; 69 -
		dw offset cs:[@@NoInitialJump]			; 6A -
		dw offset cs:[@@NoInitialJump]			; 6B -
		dw offset cs:[@@NoInitialJump]			; 6C -
		dw offset cs:[@@NoInitialJump]			; 6D -
		dw offset cs:[@@NoInitialJump]			; 6E -
		dw offset cs:[@@NoInitialJump]			; 6F -
		dw offset cs:[@@NoInitialJump]			; 70 -
		dw offset cs:[@@NoInitialJump]			; 71 -
		dw offset cs:[@@NoInitialJump]			; 72 -
		dw offset cs:[@@NoInitialJump]			; 73 -
		dw offset cs:[@@NoInitialJump]			; 74 -
		dw offset cs:[@@NoInitialJump]			; 75 -
		dw offset cs:[@@NoInitialJump]			; 76 -
		dw offset cs:[@@NoInitialJump]			; 77 -
		dw offset cs:[@@NoInitialJump]			; 78 -
		dw offset cs:[@@NoInitialJump]			; 79 -
		dw offset cs:[@@NoInitialJump]			; 7A -
		dw offset cs:[@@NoInitialJump]			; 7B -
		dw offset cs:[@@NoInitialJump]			; 7C -
		dw offset cs:[@@NoInitialJump]			; 7D -
		dw offset cs:[@@NoInitialJump]			; 7E -
		dw offset cs:[@@NoInitialJump]			; 7F -

InitialEffects	endp


;************************ Effects Done Every Tick *****************************


LoopEffects	proc	near

		xor	bh,bh
		mov	bl,al
		shl	bx,1
		jmp	[LoopJumps+bx]

;------------------------------------------------------------------------------

@@Arpeggio:
		ret

;------------------------------------------------------------------------------

@@SlideUp:
		xor	ebx,ebx
		mov	bl,ah
		shl	ebx,2

		sub	[di.CH_PeriodChange],ebx

		ret

;------------------------------------------------------------------------------

@@SlideDown:
		xor	ebx,ebx
		mov	bl,ah
		shl	ebx,2

		add	[di.CH_PeriodChange],ebx

		ret

;------------------------------------------------------------------------------

@@Portamento:
		cmp	[FrequencyTable],1
		jz	@@LinearPortamento

		mov	eax,[di.CH_PortamentoPeriod]
		cmp	eax,[di.CH_Period]
		je	@@NoPortamento

		xor	ebx,ebx
		mov	bx,[di.CH_PortamentoSpeed]

		sub	eax,[di.CH_Period]
		jnc	@@PortamentoDown
		neg	eax
		cmp	eax,ebx
		jae	@@NoPortamentoUpFix
		mov	ebx,eax
@@NoPortamentoUpFix:
		sub	[di.CH_PeriodChange],ebx
		ret
@@PortamentoDown:
		cmp	eax,ebx
		jae	@@NoPortamentoDownFix
		mov	ebx,eax
@@NoPortamentoDownFix:
		add	[di.CH_PeriodChange],ebx
		ret

@@LinearPortamento:
		xor	eax,eax

		mov	al,[di.CH_RealOctave]
		mov	bl,12
		mul	bl
		add	al,[di.CH_RealNote]
		shl	ax,6
		add	al,[di.CH_RealNoteFragment]
		adc	ah,0

		mov	bx,word ptr [di.CH_PortamentoPeriod]
		sub	bx,ax
		jnc	@@LinearPortamentoUp
		neg	bx
		mov	ax,[di.CH_PortamentoSpeed]
		cmp	bx,ax
		jae	@@NoLinearPortamentoDownFix
		mov	ax,bx
@@NoLinearPortamentoDownFix:
		add	[di.CH_PeriodChange],eax
		ret
@@LinearPortamentoUp:
		mov	ax,[di.CH_PortamentoSpeed]
		cmp	bx,ax
		jae	@@NoLinearPortamentoUpFix
		mov	ax,bx
@@NoLinearPortamentoUpFix:
		sub	[di.CH_PeriodChange],eax
		ret

@@NoPortamento:
		ret

;------------------------------------------------------------------------------

@@Vibrato:
		mov	bl,[di.CH_VibratoPointer]
		add	bl,[di.CH_VibratoSpeed]
		mov	[di.CH_VibratoPointer],bl
		mov	si,[VibratoWaveform]
		xor	bh,bh
		shl	bx,1
		mov	ax,[si+bx]
		xor	bh,bh
		mov	bl,[di.CH_VibratoDepth]
		imul	bx
		sar	ax,5

		cwde

		add	[di.CH_PeriodChange],eax

		ret

;------------------------------------------------------------------------------

@@PortamentoVolumeSlide:
		call	@@VolumeSlide
		call	@@Portamento
		ret

;------------------------------------------------------------------------------

@@VibratoVolumeSlide:
		call	@@VolumeSlide
		call	@@Vibrato
		ret

;------------------------------------------------------------------------------

@@Tremolo:
		mov	bl,[di.CH_TremoloPointer]
		add	bl,[di.CH_TremoloSpeed]
		mov	[di.CH_TremoloPointer],bl
		mov	si,[TremoloWaveform]
		xor	bh,bh
		shl	bx,1
		mov	ax,[si+bx]
		xor	bh,bh
		mov	bl,[di.CH_TremoloDepth]
		imul	bx
		sar	ax,6

		add	ax,[di.CH_RealVolume]
		cmp	ax,64
		jle	@@NoTremoVolTooHigh
		mov	ax,64
@@NoTremoVolTooHigh:
		cmp	ax,0
		jge	@@NoTremoVolTooLow
		xor	ax,ax
@@NoTremoVolTooLow:
		mov	[di.CH_Volume],ax
		ret

;------------------------------------------------------------------------------

@@SetPanning:
		ret

;------------------------------------------------------------------------------

@@SampleOffset:
		ret

;------------------------------------------------------------------------------

@@VolumeSlide:
		test	ah,0fh
		jnz	@@VolumeSlideDown
@@VolumeSlideUp:
		shr	ah,4
		add	byte ptr [di.CH_Volume],ah
		cmp	[di.CH_Volume],64
		jbe	@@NoVolumeTooHigh
		mov	[di.CH_Volume],64
@@NoVolumeTooHigh:
		mov	ax,[di.CH_Volume]
		mov	[di.CH_RealVolume],ax
		ret
@@VolumeSlideDown:
		and	ah,0fh
		sub	byte ptr [di.CH_Volume],ah
		jnc	@@NoVolumeTooLow
		mov	[di.CH_Volume],0
@@NoVolumeTooLow:
		mov	ax,[di.CH_Volume]
		mov	[di.CH_RealVolume],ax
		ret

;------------------------------------------------------------------------------

@@JumpToPosition:
		ret

;------------------------------------------------------------------------------

@@SetVolume:
		ret

;------------------------------------------------------------------------------

@@BreakPatternToRow:
		cmp	[PatternDelayOn],1
		jnz	@@NoBreakPatternToRow
		mov	[IgnoreBreak],2
@@NoBreakPatternToRow:
		ret

;------------------------------------------------------------------------------

@@SetTempo:
		ret

;------------------------------------------------------------------------------

@@SetSpeed:
		ret

;------------------------------------------------------------------------------

@@SetFilter:
		ret

;------------------------------------------------------------------------------

@@FineSlideUp:
		ret

;------------------------------------------------------------------------------

@@FineSlideDown:
		ret

;------------------------------------------------------------------------------

@@GlissandoControl:
		ret

;------------------------------------------------------------------------------

@@VibratoWaveform:
		ret

;------------------------------------------------------------------------------

@@FineTune:
		ret

;------------------------------------------------------------------------------

@@JumpToLoop:
		ret

;------------------------------------------------------------------------------

@@TremoloWaveform:
		ret

;------------------------------------------------------------------------------

@@PanningSlide:
		cmp	[PanEffectOn],0
		jz	@@NoPanningSlide

		test	ah,0f0h
		jnz	@@PanningSlideRight

		and	ah,0fh
		sub	[di.CH_Panning],ah
		jnc	@@NoPanningSlide
		mov	[di.CH_Panning],0
		ret		
@@PanningSlideRight:

		shr	ah,4
		add	[di.CH_Panning],ah
		jnc	@@NoPanningSlide
		mov	[di.CH_Panning],255
		ret
@@NoPanningSlide:
		ret

;------------------------------------------------------------------------------

@@RetrigNote:
		push	cx

		cmp	ah,0
		jnz	@@NoRetrigLastParams
		mov	ah,byte ptr [di.CH_OldEffect+1]
@@NoRetrigLastParams:

		mov	al,ah
		and	ah,0fh
		inc	[di.CH_RetrigTime]
		cmp	[di.CH_RetrigTime],ah
		jb	@@NoRetrig
		mov	[di.CH_RetrigTime],0
		mov	[di.CH_InstrumentSet],2
		shr	al,4
		test	al,7
		jz	@@NoRetrig
		test	al,8
		jz	@@RetrigVolumeDown

		and	al,7
		cmp	al,6
		jz	@@ThreeSecondsVolumeRetrig
		cmp	al,7
		jz	@@DoubleVolumeRetrig
		mov	bx,cx
		mov	cl,al
		dec	cl
		mov	ax,1
		shl	ax,cl
		mov	cx,bx
		add	[di.CH_Volume],ax
		cmp	[di.CH_Volume],64
		jbe	@@NoRetrig
		mov	[di.CH_Volume],64
		jmp	@@NoRetrig
@@ThreeSecondsVolumeRetrig:
		mov	ax,[di.CH_Volume]
		shl	ax,1
		add	ax,[di.CH_Volume]
		shr	ax,1
		cmp	ax,64
		jbe	@@NoTooHighRetrigVolume2
		mov	ax,64
@@NoTooHighRetrigVolume2:
		mov	[di.CH_Volume],ax
		jmp	@@NoRetrig
@@DoubleVolumeRetrig:
		mov	ax,[di.CH_Volume]
		shl	ax,1
		cmp	ax,64
		jbe	@@NoTooHighRetrigVolume3
		mov	ax,64
@@NoTooHighRetrigVolume3:
		mov	[di.CH_Volume],ax
		jmp	@@NoRetrig

@@RetrigVolumeDown:
		and	al,7
		cmp	al,6
		jz	@@TwoThirdsVolumeRetrig
		cmp	al,7
		jz	@@HalfVolumeRetrig
		mov	bx,cx
		mov	cl,al
		dec	cl
		mov	ax,1
		shl	ax,cl
		mov	cx,bx
		sub	[di.CH_Volume],ax
		jnc	@@NoRetrig
		mov	[di.CH_Volume],0
		jmp	@@NoRetrig
@@TwoThirdsVolumeRetrig:
		mov	ax,[di.CH_Volume]
		shl	ax,1
		mov	bl,3
		div	bl
		mov	byte ptr [di.CH_Volume],al
		jmp	@@NoRetrig
@@HalfVolumeRetrig:
		mov	ax,[di.CH_Volume]
		shr	ax,1
		mov	byte ptr [di.CH_Volume],al
		jmp	@@NoRetrig

@@NoRetrig:
		mov	ax,[di.CH_Volume]
		mov	[di.CH_RealVolume],ax

		pop	cx
		ret

;------------------------------------------------------------------------------

@@FineVolumeSlideUp:
		ret

;------------------------------------------------------------------------------

@@FineVolumeSlideDown:
		ret

;------------------------------------------------------------------------------

@@CutNote:
		cmp	ah,0
		je	@@NoCutNote
		cmp	[di.CH_EffectTime],ah
		jb	@@NoCutNote
		mov	[di.CH_Volume],0
@@NoCutNote:
		ret

;------------------------------------------------------------------------------

@@DelayNote:
		push	cx

		and	ah,01111111b
		cmp	[di.CH_EffectTime],ah
		jb	@@NoDelayNote

		mov	bl,[di.CH_NoteDataCache]
		cmp	bl,253
		jae	@@NoDelayNote

		mov	cl,bl
		shr	cl,4
		mov	[di.CH_Octave],cl
		and	bl,0fh
		mov	[di.CH_Note],bl

		add	bl,[di.CH_RelativeNote]
		cmp	bl,12
		jge	@@TooHighNote
		cmp	bl,0
		jnl	@@NoteOK
		add	bl,12
		dec	cl
		jmp	@@NoteOK
@@TooHighNote:
		sub	bl,12
		inc	cl
@@NoteOK:
		mov	[di.CH_RealNote],bl
		shl	bx,1+6
		mov	bx,[Periods+bx]
		add	cl,[di.CH_RelativeOctave]
		cmp	cl,HighestOctave
		jg	@@TooHighOctave
		cmp	cl,0
		jnl	@@OctaveOK
		mov	cl,0
		jmp	@@OctaveOK
@@TooHighOctave:
		mov	cl,HighestOctave
@@OctaveOK:
		mov	[di.CH_RealOctave],cl

		mov	[di.CH_NoteDataCache],255

		xor	ah,ah
		mov	al,[di.CH_VolumeColumn]
		cmp	al,64
		jbe	@@SetDefinedVolume

		cmp	[di.CH_InstrumentDataCache],255
		jz	@@NoSetVolumeDelayNote

		mov	ax,[di.CH_SampleVolume]
@@SetDefinedVolume:
		mov	[di.CH_Volume],ax
		mov	[di.CH_RealVolume],ax
@@NoSetVolumeDelayNote:

		mov	[di.CH_VibratoPointer],128
		mov	[di.CH_TremoloPointer],128
		mov	[di.CH_NoteTriggered],1
		mov	[di.CH_BarSequencer],0

		xor	ebx,ebx
		mov	bl,[di.CH_RealNote]
		shl	bx,1+6
		mov	bx,[Periods+bx]
		mov	cl,[di.CH_RealOctave]
		mov	eax,[di.CH_C4SpdPrecalc]
		mul	ebx
		shr	eax,8
		shr	eax,cl
		mov	[di.CH_Period],eax

		mov	ebx,eax
		xor	edx,edx
		mov	eax,[CurrentDivisor]
		div	ebx

		mov	[di.CH_NoteFrequency],ax

		mov	[di.CH_InstrumentSet],2

@@NoDelayNote:
		pop	cx
		ret

;------------------------------------------------------------------------------

@@DelayPattern:
		cmp	[PatternDelayOn],1
		jz	@@NoDelayPattern
		cmp	ah,0
		jz	@@NoDelayPattern
		inc	ah
		mov	[PatternDelayCounter],ah
		mov	[PatternDelayOn],1
		mov	ax,[CurrentRow]
		mov	[PatternDelayRow],ax
@@NoDelayPattern:
		ret

;------------------------------------------------------------------------------

@@InvertLoop:
		ret

;------------------------------------------------------------------------------

@@Tremor:
		mov	al,[di.CH_TremorCounter]
		inc	al
		cmp	[di.CH_TremorOn],0
		jz	@@TremorOff
		mov	bx,[di.CH_TremorVolume]
		mov	[di.CH_Volume],bx
		mov	[di.CH_RealVolume],bx
		cmp	al,[di.CH_TremorOnCount]
		jb	@@NoTremor
		xor	al,al
		mov	[di.CH_TremorOn],0
		jmp	@@NoTremor
@@TremorOff:
		mov	[di.CH_Volume],0
		mov	[di.CH_RealVolume],0
		cmp	al,[di.CH_TremorOffCount]
		jb	@@NoTremor
		xor	al,al
		mov	[di.CH_TremorOn],1
@@NoTremor:
		mov	[di.CH_TremorCounter],al
		ret

;------------------------------------------------------------------------------

@@ExtraFineSlideUp:
		ret

;------------------------------------------------------------------------------

@@ExtraFineSlideDown:
		ret

;------------------------------------------------------------------------------

@@SetGlobalVolume:
		ret

;------------------------------------------------------------------------------

@@FineVibrato:
		mov	bl,[di.CH_VibratoPointer]
		add	bl,[di.CH_VibratoSpeed]
		mov	[di.CH_VibratoPointer],bl
		mov	si,[VibratoWaveform]
		xor	bh,bh
		shl	bx,1
		mov	ax,[si+bx]
		xor	bh,bh
		mov	bl,[di.CH_VibratoDepth]
		imul	bx
		sar	ax,7

		cwde

		add	[di.CH_PeriodChange],eax

		ret

;------------------------------------------------------------------------------

@@GlobalVolumeSlide:
		test	ah,0f0h
		jz	@@GlobalVolumeSlideDown
@@GlobalVolumeSlideUp:
		shr	ah,4
		add	byte ptr [GlobalVolume],ah
		cmp	[GlobalVolume],64 
		jbe	@@NoGlobalVolumeTooHigh
		mov	[GlobalVolume],64
@@NoGlobalVolumeTooHigh:
		ret
@@GlobalVolumeSlideDown:
		and	ah,0fh
		sub	byte ptr [GlobalVolume],ah
		jnc	@@NoGlobalVolumeTooLow
		mov	[GlobalVolume],0
@@NoGlobalVolumeTooLow:
		ret

;------------------------------------------------------------------------------

@@SetEnvelopePosition:
		ret

;------------------------------------------------------------------------------

@@NoLoopJump:

		ret

LoopJumps	dw offset cs:[@@Arpeggio]			; 00
		dw offset cs:[@@SlideUp]			; 01
		dw offset cs:[@@SlideDown]			; 02
		dw offset cs:[@@Portamento]			; 03
		dw offset cs:[@@Vibrato]			; 04
		dw offset cs:[@@PortamentoVolumeSlide]		; 05
 		dw offset cs:[@@VibratoVolumeSlide]		; 06
 		dw offset cs:[@@Tremolo]			; 07
 		dw offset cs:[@@SetPanning]			; 08
 		dw offset cs:[@@SampleOffset]			; 09
		dw offset cs:[@@VolumeSlide]			; 0A
 		dw offset cs:[@@JumpToPosition]			; 0B
		dw offset cs:[@@SetVolume]			; 0C
 		dw offset cs:[@@BreakPatternToRow]		; 0D
		dw offset cs:[@@SetTempo]			; 0E
		dw offset cs:[@@SetSpeed]			; 0F
		dw offset cs:[@@SetFilter]			; 10 x
		dw offset cs:[@@FineSlideUp]			; 11
		dw offset cs:[@@FineSlideDown]			; 12
		dw offset cs:[@@GlissandoControl]		; 13
		dw offset cs:[@@VibratoWaveform]		; 14
		dw offset cs:[@@FineTune]			; 15
		dw offset cs:[@@JumpToLoop]			; 16
		dw offset cs:[@@TremoloWaveform]		; 17
		dw offset cs:[@@PanningSlide]			; 18
		dw offset cs:[@@RetrigNote]			; 19
		dw offset cs:[@@FineVolumeSlideUp]		; 1A
		dw offset cs:[@@FineVolumeSlideDown]		; 1B
		dw offset cs:[@@CutNote]			; 1C
		dw offset cs:[@@DelayNote]			; 1D
		dw offset cs:[@@DelayPattern]			; 1E
		dw offset cs:[@@InvertLoop]			; 1F x
 		dw offset cs:[@@Tremor]				; 20
		dw offset cs:[@@ExtraFineSlideUp]		; 21
		dw offset cs:[@@ExtraFineSlideDown]		; 22
 		dw offset cs:[@@SetGlobalVolume]		; 23
		dw offset cs:[@@FineVibrato]			; 24
		dw offset cs:[@@GlobalVolumeSlide]		; 25
		dw offset cs:[@@SetEnvelopePosition]		; 26
		dw offset cs:[@@NoLoopJump]			; 27 -
		dw offset cs:[@@NoLoopJump]			; 28 -
		dw offset cs:[@@NoLoopJump]			; 29 -
		dw offset cs:[@@NoLoopJump]			; 2A -
		dw offset cs:[@@NoLoopJump]			; 2B -
		dw offset cs:[@@NoLoopJump]			; 2C -
		dw offset cs:[@@NoLoopJump]			; 2D -
		dw offset cs:[@@NoLoopJump]			; 2E -
		dw offset cs:[@@NoLoopJump]			; 2F -
		dw offset cs:[@@NoLoopJump]			; 30 -
		dw offset cs:[@@NoLoopJump]			; 31 -
		dw offset cs:[@@NoLoopJump]			; 32 -
		dw offset cs:[@@NoLoopJump]			; 33 -
		dw offset cs:[@@NoLoopJump]			; 34 -
		dw offset cs:[@@NoLoopJump]			; 35 -
		dw offset cs:[@@NoLoopJump]			; 36 -
		dw offset cs:[@@NoLoopJump]			; 37 -
		dw offset cs:[@@NoLoopJump]			; 38 -
		dw offset cs:[@@NoLoopJump]			; 39 -
		dw offset cs:[@@NoLoopJump]			; 3A -
		dw offset cs:[@@NoLoopJump]			; 3B -
		dw offset cs:[@@NoLoopJump]			; 3C -
		dw offset cs:[@@NoLoopJump]			; 3D -
		dw offset cs:[@@NoLoopJump]			; 3E -
		dw offset cs:[@@NoLoopJump]			; 3F -
		dw offset cs:[@@NoLoopJump]			; 40 -
		dw offset cs:[@@NoLoopJump]			; 41 -
		dw offset cs:[@@NoLoopJump]			; 42 -
		dw offset cs:[@@NoLoopJump]			; 43 -
		dw offset cs:[@@NoLoopJump]			; 44 -
		dw offset cs:[@@NoLoopJump]			; 45 -
		dw offset cs:[@@NoLoopJump]			; 46 -
		dw offset cs:[@@NoLoopJump]			; 47 -
		dw offset cs:[@@NoLoopJump]			; 48 -
		dw offset cs:[@@NoLoopJump]			; 49 -
		dw offset cs:[@@NoLoopJump]			; 4A -
		dw offset cs:[@@NoLoopJump]			; 4B -
		dw offset cs:[@@NoLoopJump]			; 4C -
		dw offset cs:[@@NoLoopJump]			; 4D -
		dw offset cs:[@@NoLoopJump]			; 4E -
		dw offset cs:[@@NoLoopJump]			; 4F -
		dw offset cs:[@@NoLoopJump]			; 50 -
		dw offset cs:[@@NoLoopJump]			; 51 -
		dw offset cs:[@@NoLoopJump]			; 52 -
		dw offset cs:[@@NoLoopJump]			; 53 -
		dw offset cs:[@@NoLoopJump]			; 54 -
		dw offset cs:[@@NoLoopJump]			; 55 -
		dw offset cs:[@@NoLoopJump]			; 56 -
		dw offset cs:[@@NoLoopJump]			; 57 -
		dw offset cs:[@@NoLoopJump]			; 58 -
		dw offset cs:[@@NoLoopJump]			; 59 -
		dw offset cs:[@@NoLoopJump]			; 5A -
		dw offset cs:[@@NoLoopJump]			; 5B -
		dw offset cs:[@@NoLoopJump]			; 5C -
		dw offset cs:[@@NoLoopJump]			; 5D -
		dw offset cs:[@@NoLoopJump]			; 5E -
		dw offset cs:[@@NoLoopJump]			; 5F -
		dw offset cs:[@@NoLoopJump]			; 60 -
		dw offset cs:[@@NoLoopJump]			; 61 -
		dw offset cs:[@@NoLoopJump]			; 62 -
		dw offset cs:[@@NoLoopJump]			; 63 -
		dw offset cs:[@@NoLoopJump]			; 64 -
		dw offset cs:[@@NoLoopJump]			; 65 -
		dw offset cs:[@@NoLoopJump]			; 66 -
		dw offset cs:[@@NoLoopJump]			; 67 -
		dw offset cs:[@@NoLoopJump]			; 68 -
		dw offset cs:[@@NoLoopJump]			; 69 -
		dw offset cs:[@@NoLoopJump]			; 6A -
		dw offset cs:[@@NoLoopJump]			; 6B -
		dw offset cs:[@@NoLoopJump]			; 6C -
		dw offset cs:[@@NoLoopJump]			; 6D -
		dw offset cs:[@@NoLoopJump]			; 6E -
		dw offset cs:[@@NoLoopJump]			; 6F -
		dw offset cs:[@@NoLoopJump]			; 70 -
		dw offset cs:[@@NoLoopJump]			; 71 -
		dw offset cs:[@@NoLoopJump]			; 72 -
		dw offset cs:[@@NoLoopJump]			; 73 -
		dw offset cs:[@@NoLoopJump]			; 74 -
		dw offset cs:[@@NoLoopJump]			; 75 -
		dw offset cs:[@@NoLoopJump]			; 76 -
		dw offset cs:[@@NoLoopJump]			; 77 -
		dw offset cs:[@@NoLoopJump]			; 78 -
		dw offset cs:[@@NoLoopJump]			; 79 -
		dw offset cs:[@@NoLoopJump]			; 7A -
		dw offset cs:[@@NoLoopJump]			; 7B -
		dw offset cs:[@@NoLoopJump]			; 7C -
		dw offset cs:[@@NoLoopJump]			; 7D -
		dw offset cs:[@@NoLoopJump]			; 7E -
		dw offset cs:[@@NoLoopJump]			; 7F -

LoopEffects	endp
