;**************************
;*                        *
;*  CapaPlay II Commands  *
;*                        *
;**************************


;****************************** GUS Settings **********************************


public	_CP_GetIRQ,_CP_SetIRQ,_CP_GetDMA,_CP_SetDMA,_CP_GetBasePort
public	_CP_SetBasePort,_CP_SetLineIn,_CP_SetMicIn

_CP_GetIRQ	proc
		push	es ds si di bx cx

		mov	ax,cs
		mov	es,ax
		mov	ds,ax
		mov	si,offset cs:[EnviroSearch]
		mov	di,offset cs:[EnviroString]
		mov	ah,62h
		int	21h
		mov	ax,bx
		mov	cx,12
		call	ReadEnvString

		xor	ax,ax
		cmp	cs:[EnviroString],0
		jz	@@NoEnviroFoundIRQ

		xor	cx,cx
		xor	bx,bx
@@FindThreeCommas:
		inc	bx
		cmp	byte ptr cs:[EnviroString+bx],','
		jnz	@@FindThreeCommas
		inc	cx
		cmp	cx,3
		jnz	@@FindThreeCommas

		inc	bx
		cmp	byte ptr cs:[EnviroString+bx+1],','
		jz	@@NextIsComma
		mov	ax,10
		inc	bx
@@NextIsComma:

		mov	bl,byte ptr cs:[EnviroString+bx]
		sub	bx,48
		add	ax,bx

@@NoEnviroFoundIRQ:

		pop	cx bx di si ds es
		ret
_CP_GetIRQ	endp

_CP_SetIRQ	proc
		arg	NewIRQ:byte
		push	bp
		mov	bp,sp
		
		push	ax
		
		xor	ah,ah
		mov	al,NewIRQ
		mov	cs:[GUSIRQ],ax

		pop	ax

		pop	bp
		ret
_CP_SetIRQ	endp

_CP_GetDMA	proc
		push	es ds si di bx cx

		mov	ax,cs
		mov	es,ax
		mov	ds,ax
		mov	si,offset cs:[EnviroSearch]
		mov	di,offset cs:[EnviroString]
		mov	ah,62h
		int	21h
		mov	ax,bx
		mov	cx,12
		call	ReadEnvString

		xor	ax,ax
		cmp	cs:[EnviroString],0
		jz	@@NoEnviroFoundDMA

		xor	cx,cx
		xor	bx,bx
@@FindComma:
		inc	bx
		cmp	byte ptr cs:[EnviroString+bx],','
		jnz	@@FindComma

		inc	bx
		cmp	byte ptr cs:[EnviroString+bx+1],','
		jz	@@NextIsComma
		mov	ax,10
		inc	bx
@@NextIsComma:

		mov	bl,byte ptr cs:[EnviroString+bx]
		sub	bx,48
		add	ax,bx

@@NoEnviroFoundDMA:

		pop	cx bx di si ds es
		ret
_CP_GetDMA	endp

_CP_SetDMA	proc
		arg	NewDMA:byte
		push	bp
		mov	bp,sp

		push	ax
		
		xor	ah,ah
		mov	al,NewDMA
		mov	cs:[GUSDMA],ax

		pop	ax

		pop	bp
		ret
_CP_SetDMA	endp

_CP_GetBasePort	proc
		push	es ds si di bx cx

		mov	ax,cs
		mov	es,ax
		mov	ds,ax
		mov	si,offset cs:[EnviroSearch]
		mov	di,offset cs:[EnviroString]
		mov	ah,62h
		int	21h
		mov	ax,bx
		mov	cx,12
		call	ReadEnvString

		xor	ax,ax
		cmp	cs:[EnviroString],0
		jz	@@NoEnviroFoundPort

		xor	bh,bh
		mov	bl,byte ptr cs:[EnviroString+1]
		sub	bx,49
		shl	bx,1
		mov	ax,cs:[GUSPorts+bx]

@@NoEnviroFoundPort:

		pop	cx bx di si ds es
		ret
_CP_GetBasePort	endp

_CP_SetBasePort	proc
		arg	NewBasePort:word
		push	bp
		mov	bp,sp
		
		push	ax
		
		mov	ax,NewBasePort
		mov	cs:[BasePort],ax

		pop	ax

		pop	bp
		ret
_CP_SetBasePort	endp

_CP_SetLineIn	proc
		arg	LineInState:byte
		push	bp
		mov	bp,sp
		
		push	ax
		
		mov	al,LineInState
		xor	al,1
		mov	cs:[LineIn],al

		pop	ax

		pop	bp
		ret
_CP_SetLineIn	endp

_CP_SetMicIn	proc
		arg	MicInState:byte
		push	bp
		mov	bp,sp

		push	ax
		
		mov	al,MicInState
		shl	al,2
		mov	cs:[MicIn],al

		pop	ax

		pop	bp
		ret
_CP_SetMicIn	endp


;******************************* Load/Unload **********************************


public	_CP_LoadModule,_CP_LoadOnlyPatterns,_CP_FreeModule

_CP_LoadModule	proc
		arg	ModName:dword,StartOffset:dword,TransferMode:byte
		push	bp
		mov	bp,sp

		push	dx ds

		mov	al,TransferMode
		mov	[TransferModeToUse],al

		cmp	[GUSDMA],0
		jnz	@@UseGivenTransferMode
		mov	[TransferModeToUse],0
@@UseGivenTransferMode:

		mov	cs:[ReadOnlyPatterns],0

		lds	dx,ModName

		mov	eax,StartOffset
		mov	cs:[FileStartOffset],eax

		call	LoadModule

		pop	ds dx

		mov	ax,cs:[ErrorCode]

		pop	bp
		ret
_CP_LoadModule	endp

_CP_LoadOnlyPatterns	proc
		arg	ModName:dword,StartOffset:dword,TransferMode:byte
		push	bp
		mov	bp,sp
		
		push	dx ds

		mov	al,TransferMode
		mov	[TransferModeToUse],al
		
		mov	cs:[ReadOnlyPatterns],1

		lds	dx,ModName

		mov	eax,StartOffset
		mov	cs:[FileStartOffset],eax

		call	LoadModule

		pop	ds dx

		mov	ax,cs:[ErrorCode]

		pop	bp
		ret
_CP_LoadOnlyPatterns	endp

_CP_FreeModule	proc
		push	ax es

		call	_CP_StopModule

		cmp	cs:[PatternMem],0
		jz	@@NoPatternMemory
		mov	es,cs:[PatternMem]
		mov	ax,4900h
		int	21h
@@NoPatternMemory:

		cmp	cs:InstrumentPointers[0+2],0
		jz	@@NoInstrumentInfoMemory
		mov	es,cs:InstrumentPointers[0+2]
		mov	ax,4900h
		int	21h
@@NoInstrumentInfoMemory:

		pop	es ax
		ret
_CP_FreeModule	endp


;***************************** Start/Stop/Pause *******************************


public _CP_StartModule,_CP_StopModule,_CP_PauseModule

_CP_StartModule	proc
		arg	Amplification:byte,DefaultPanning:byte,TimerMode:byte
		push	bp
		mov	bp,sp
		
		pusha
		push	ds

		mov	ax,cs
		mov	ds,ax

		mov	al,TimerMode
		mov	[TimerModeToUse],al
		cmp	[GUSIRQ],0
		jnz	@@UseGivenTimerMode
		mov	[TimerModeToUse],0
@@UseGivenTimerMode:


		cmp	[TimerModeToUse],0
		jz	@@SystemTimerSpeed

		mov	[SpeedDivisor],1250
		jmp	@@GUSTimerSpeed
@@SystemTimerSpeed:
		mov	[SpeedDivisor],1000
@@GUSTimerSpeed:


		xor	ebx,ebx
		mov	bl,Amplification
		add	bl,16

		cmp	Amplification,0ffh
		jnz	@@UserDefinedAmplification
		mov	bx,[UsedChannels]
		dec	bx
		mov	bl,ChannelAmplifications[bx]
		and	ebx,0ffh
@@UserDefinedAmplification:

		mov	cx,256

		mov	ax,[DefaultGUSVol]
		mov	[GUSVol],ax
		xor	edx,edx
		mov	si,offset [DefaultGUSVol+2]
		mov	di,2
@@AmplifyVolumeLoop:
		xor	eax,eax
		mov	ax,[si]
		sub	ax,[DefaultGUSVol]
		mul	ebx
		shr	eax,6
		add	ax,[DefaultGUSVol]
		mov	[GUSVol+di],ax
		add	si,2
		add	di,2
		dec	cx
		jnz	@@AmplifyVolumeLoop

		mov	al,byte ptr [InitialVolume]
		mov	byte ptr [GlobalVolume],al

		xor	ah,ah
		mov	al,[InitialSpeed]
		cmp	ax,0
		jnz	@@NoInitialSpeedZero
		mov	ax,6
@@NoInitialSpeedZero:
		mov	[CurrentSpeed],ax
		mov	[OfficialSpeed],ax
		mov	[TickCounter],ax

		xor	ah,ah
		mov	al,[InitialTempo]
		mov	[CurrentTempo],al
		mov	[OfficialTempo],ax
		shl	ax,1
		mov	bl,5
		cmp	[TempoCalculationType],1
		jz	@@TempoCalculationTypeOne
		shl	ax,6-1
		mov	bl,159
@@TempoCalculationTypeOne:
		div	bl
		mov	dl,al
		xor	dh,dh
		xor	ax,ax
		mov	bx,[SpeedDivisor]
		div	bx
		mov	word ptr [Speed],ax
		xor	ax,ax
		div	bx
		mov	word ptr [Speed+2],ax
		mov	[SpeedAdd],0
		mov	[Counter],0
		mov	[Time],0

		mov	[ChanOn],0ffffffffh

		mov	[InternalRow],0
		mov	[CurrentPosition],1
		mov	ax,offset [SiniTab]
		mov	[VibratoWaveform],ax
		mov	[TremoloWaveform],ax
		mov	[VibratoWaveNum],0
		mov	[TremoloWaveNum],0

		mov	[LoopCounter],0
		mov	[PauseModule],0

		mov	[PatternDelayOn],0
		mov	[PatternDelayCounter],0
		mov	[PatternDelayRow],0

		mov	[MainVolume],64

		cli

		mov	di,offset [ChannelInfo]
		mov	cx,ChanSize*32-1
@@ClearVarLoop:
		mov	byte ptr [di],0
		inc	di
		dec	cx
		jnz	@@ClearVarLoop

		mov	di,offset [ChannelInfo]
		xor	si,si
		mov	cx,[UsedChannels]
@@SetPanLoop:
		mov	[di.CH_Effect],127
		mov	[di.CH_OldEffect],127
		mov	[di.CH_C4SpdPrecalc],4096
		mov	[di.CH_OldC4SpdPrecalc],4096
		mov	[di.CH_OldInstrument],255
		mov	[di.CH_CurrentInstrument],255
		mov	[di.CH_Period],13696

		mov	al,[PanningDefaults+si]
		test	al,20h
		jnz	@@SetGivenPanning

		dec	al
		mov	bl,DefaultPanning
		imul	bl
		add	ax,128
		mov	[di.CH_Panning],al
		mov	[di.CH_FinalPanning],al
;		mov	bl,15
;		mul	bl
		shl	ax,4
		jmp	@@SetDefaultPanning
@@SetGivenPanning:
		and	al,0fh
		mov	bl,17
		mul	bl
		mov	byte ptr [di.CH_Panning],al
		mov	byte ptr [di.CH_FinalPanning],al
		mov	ah,[PanningDefaults+si]
@@SetDefaultPanning:

		mov	dx,[BasePort]
		add	dx,ActiveVoicePort
		mov	al,byte ptr [UsedChannels]
		sub	al,cl
		out	dx,al
		mov	dx,[BasePort]
		add	dx,CommandPort
		mov	al,VoiceBalance
		out	dx,al
		mov	dx,[BasePort]
		add	dx,DataHighPort
		mov	al,ah
		out	dx,al

		add	di,ChanSize
		inc	si
		dec	cx
		jnz	@@SetPanLoop

		mov	dx,[BasePort]
		in	al,dx
		mov	[IOStateBeforeInit],al

		cmp	[TimerModeToUse],0
		jz	@@SystemTimerOn

		mov	al,01001000b
		or	al,[LineIn]
		or	al,[MicIn]
		out	dx,al

		mov	bx,[GUSIRQ]
		add	dx,IRQDMACtrlPort
		mov	al,[IRQToPort+bx]
		out	dx,al

		in	al,0a1h
		mov	ah,al
		in	al,21h
		mov	cl,bl
		mov	dx,1
		shl	dx,cl
		not	dx
		and	ax,dx
		out	21h,al
		mov	al,ah
		out	0a1h,al

		cmp	bx,7
		jle	@@IrqNoOverSeven
		add	bx,60h
@@IrqNoOverSeven:
		add	bx,8
		shl	bx,2
		xor	ax,ax
		mov	es,ax
		mov	dx,es:[bx]
		mov	word ptr [OldIRQAddr],dx
		mov	dx,es:[bx+2]
		mov	word ptr [OldIRQAddr+2],dx
		mov	dx,offset [PlayerInterrupt]
		mov	es:[bx],dx
		mov	dx,cs
		mov	es:[bx+2],dx

		mov	dx,[BasePort]
		add	dx,CommandPort
		mov	al,Timer1
		out	dx,al
		add	dx,2
		mov	al,246			;10*80 micro seconds
		out	dx,al

		sub	dx,2
		mov	al,TimerControl
		out	dx,al
		add	dx,2
		mov	al,4
		out	dx,al

		mov	dx,[BasePort]
		add	dx,TimerCtrlPort
		mov	al,4
		out	dx,al
		inc	dx
		mov	al,1
		out	dx,al

		jmp	@@GUSTimerOn

@@SystemTimerOn:

		mov	al,00000000b
		or	al,[LineIn]
		or	al,[MicIn]
		out	dx,al

		mov	[JumpOldTimer],55

		xor	ax,ax
		mov	es,ax
		mov	bx,8*4
		mov	ax,es:[bx]
		mov	word ptr [OldIRQAddr],ax
		mov	ax,es:[bx+2]
		mov	word ptr [OldIRQAddr+2],ax

		mov	ax,offset [PlayerInterrupt]
		mov	es:[bx],ax
		mov	ax,cs
		mov	es:[bx+2],ax

		mov	al,36h
		out	43h,al
		mov	al,169
		out	40h,al
		mov	al,4
		out	40h,al

@@GUSTimerOn:

		sti

		pop	ds
		popa

		pop	bp
		ret
_CP_StartModule	endp

_CP_StopModule	proc

		push	ax bx cx dx es

		cli

		cmp	[Time],0
		jz	@@ModuleNotPlaying

		mov	dx,cs:[BasePort]	; Speaker Off!!!
		mov	al,[IOStateBeforeInit]
		or	al,cs:[LineIn]
		or	al,cs:[MicIn]
		out	dx,al

		cmp	[TimerModeToUse],0
		jz	@@SystemTimerOff

		mov	bx,cs:[GUSIRQ]

		in	al,0a1h
		mov	ah,al
		in	al,21h
		mov	cl,bl
		mov	dx,1
		shl	dx,cl
		or	ax,dx
		out	21h,al
		mov	al,ah
		out	0a1h,al

		cmp	bx,7
		jle	@@IrqNoOverSeven
		add	bx,60h
@@IrqNoOverSeven:
		add	bx,8
		shl	bx,2
		xor	ax,ax
		mov	es,ax

		mov	dx,word ptr cs:[OldIRQAddr]
		mov	es:[bx],dx
		mov	dx,word ptr cs:[OldIRQAddr+2]
		mov	es:[bx+2],dx

		mov	dx,cs:[BasePort]
		add	dx,CommandPort
		mov	al,TimerControl
		out	dx,al
		add	dx,2
		xor	al,al
		out	dx,al

		jmp	@@GUSTimerOff

@@SystemTimerOff:

		mov	al,36h
		out	43h,al
		mov	al,0
		out	40h,al
		mov	al,0
		out	40h,al

		xor	ax,ax
		mov	es,ax
		mov	bx,8*4
		mov	ax,word ptr cs:[OldIRQAddr]
		mov	es:[bx],ax
		mov	ax,word ptr cs:[OldIRQAddr+2]
		mov	es:[bx+2],ax

@@GUSTimerOff:

		sti

		mov	dx,cs:[BasePort]
		add	dx,ActiveVoicePort
		mov	cx,[UsedChannels]
@@VoiceClearL:
		mov	al,cl
		dec	al
		out	dx,al
		inc	dx
		mov	al,0
		out	dx,al
		add	dx,2
		mov	al,3	; Voice Off
		out	dx,al
		sub	dx,2
		mov	al,0Dh
		out	dx,al
		add	dx,2
		mov	al,3	; Ramp Off
		out	dx,al
		sub	dx,3
		dec	cx
		jnz	@@VoiceClearL

		mov	[Time],0
@@ModuleNotPlaying:

		pop	es dx cx bx ax

		ret
_CP_StopModule	endp

_CP_PauseModule	proc

		push	dx

		xor	cs:[PauseModule],1

		mov	al,00001000b		; Speaker On!!!
		or	al,cs:[LineIn]
		or	al,cs:[MicIn]

		cmp	cs:[PauseModule],0
		jz	@@NoPauseModuleSpeakerOff
		mov	al,00001010b		; Speaker Off!!!
		or	al,cs:[LineIn]
		or	al,cs:[MicIn]
@@NoPauseModuleSpeakerOff:
		mov	dx,cs:[BasePort]
		out	dx,al

		mov	al,cs:[PauseModule]

		pop	dx

		ret
_CP_PauseModule	endp


;********************** Set General Module Information ************************


public	_CP_SetSpeedZeroMode,_CP_SetPanEffectMode,_CP_SetVBlankMode
public	_CP_SetAmigaLimitsMode

_CP_SetPanEffectMode	proc
		arg	PanEffectMode:byte
		push	bp
		mov	bp,sp

		push	ax
		
		mov	al,PanEffectMode
		mov	cs:[PanEffectOn],al

		pop	ax

		pop	bp
		ret
_CP_SetPanEffectMode	endp

_CP_SetSpeedZeroMode	proc
		arg	SpeedZeroMode:byte
		push	bp
		mov	bp,sp

		push	ax
		
		mov	al,SpeedZeroMode
		mov	cs:[SpeedZeroOn],al

		pop	ax

		pop	bp
		ret
_CP_SetSpeedZeroMode	endp

_CP_SetVBlankMode	proc
		arg	VBlankMode:byte
		push	bp
		mov	bp,sp

		push	ax
		
		mov	al,VBlankMode
		mov	cs:[VBlank],al

		pop	ax

		pop	bp
		ret
_CP_SetVBlankMode	endp

_CP_SetAmigaLimitsMode	proc
		arg	AmigaLimitsMode:byte
		push	bp
		mov	bp,sp
		
		cmp	AmigaLimitsMode,1
		jz	@@AmigaLimits

		mov	cs:[LoLimit],219136/8
		mov	cs:[HiLimit],4
		
		pop	bp
		ret
@@AmigaLimits:
		mov	cs:[LoLimit],27392/8	;54784
		mov	cs:[HiLimit],3628/8

		pop	bp
		ret
_CP_SetAmigaLimitsMode	endp


;********************** Get General Module Information ************************


public	_CP_GetModuleName,_CP_GetModuleType,_CP_GetModuleLength
public	_CP_GetNumOfPatterns,_CP_GetNumOfInstruments,_CP_GetNumOfChannels
public	_CP_GetNumOfUsedChannels,_CP_GetRestartPosition
public	_CP_GetUsedPatternMemory,_CP_GetUsedInstrumentInfoMemory
public	_CP_GetUsedGUSMemory,_CP_GetFileSize

_CP_GetModuleName	proc
		mov	dx,cs
		mov	ax,offset cs:[ModuleName]
		ret
_CP_GetModuleName	endp

_CP_GetModuleType	proc
		mov	al,cs:[ModuleType]
		ret
_CP_GetModuleType	endp

_CP_GetModuleLength	proc
		mov	ax,cs:[RealNumOfOrders]
		ret
_CP_GetModuleLength	endp

_CP_GetNumOfPatterns	proc
		mov	ax,cs:[RealNumOfPatterns]
		ret
_CP_GetNumOfPatterns	endp

_CP_GetNumOfInstruments	proc
		mov	ax,cs:[NumOfInstruments]
		ret
_CP_GetNumOfInstruments	endp

_CP_GetNumOfChannels	proc
		mov	ax,cs:[NumOfChannels]
		ret
_CP_GetNumOfChannels	endp

_CP_GetNumOfUsedChannels	proc
		mov	ax,cs:[UsedChannels]
		ret
_CP_GetNumOfUsedChannels	endp

_CP_GetRestartPosition	proc
		mov	ax,cs:[RestartPosition]
		ret
_CP_GetRestartPosition	endp

_CP_GetUsedPatternMemory	proc
		mov	dx,word ptr cs:[RepackedSize+2]
		mov	ax,word ptr cs:[RepackedSize]
		ret
_CP_GetUsedPatternMemory	endp

_CP_GetUsedInstrumentInfoMemory	proc
		mov	dx,word ptr cs:[InstrumentInfoSize+2]
		mov	ax,word ptr cs:[InstrumentInfoSize]
		ret
_CP_GetUsedInstrumentInfoMemory	endp

_CP_GetUsedGUSMemory	proc
		mov	ax,word ptr cs:[GUSMemoryUsed]
		mov	dx,word ptr cs:[GUSMemoryUsed+2]

		add	ax,word ptr cs:[GUSMemoryUsed+4]
		adc	dx,word ptr cs:[GUSMemoryUsed+4+2]

		add	ax,word ptr cs:[GUSMemoryUsed+8]
		adc	dx,word ptr cs:[GUSMemoryUsed+8+2]

		add	ax,word ptr cs:[GUSMemoryUsed+12]
		adc	dx,word ptr cs:[GUSMemoryUsed+12+2]

		ret
_CP_GetUsedGUSMemory	endp

_CP_GetFileSize	proc
		mov	dx,word ptr cs:[FileSize+2]
		mov	ax,word ptr cs:[FileSize]
		ret
_CP_GetFileSize	endp


;********************** Set General Playing Information ***********************


public	_CP_SetPosition,_CP_SetGlobalVolume,_CP_SetMainVolume
public	_CP_RestoreInitialVolume,_CP_SetSpeed,_CP_SetTempo
public	_CP_RestoreSpeedAndTempo,_CP_SetDefaultPanning

_CP_SetPosition	proc
		arg	NewPosition:word
		push	bp
		mov	bp,sp

		pusha

		mov	bx,NewPosition
		inc	bx
		jz	@@NoTooHighPosition
		cmp	bx,cs:[RealNumOfOrders]
		ja	@@TooHighPosition
		mov	cs:[CurrentPosition],bx
		dec	bx
@@NoTooHighPosition:

		mov	cs:[PositionToUnpack],bx
		mov	cs:[RowToUnpack],0

		call	UnpackRow

		mov	dx,cs:[BasePort]
		add	dx,ActiveVoicePort
		xor	ch,ch
		mov	cl,cs:[NumVoices]
@@SetPositionVoiceClear:
		mov	al,cl
		dec	al
		out	dx,al
		inc	dx
		mov	al,0
		out	dx,al
		add	dx,2
		mov	al,3	; Voice Off
		out	dx,al
		sub	dx,2
		mov	al,0Dh
		out	dx,al
		add	dx,2
		mov	al,3	; Ramp Off
		out	dx,al
		sub	dx,3
		dec	cx
		jnz	@@SetPositionVoiceClear

		mov	di,offset cs:[ChannelInfo]
		mov	cx,cs:[UsedChannels]
@@SetPositionClearVarLoop:
		mov	cs:[di.CH_CurrentInstrument],255
		mov	cs:[di.CH_OldInstrument],255
		mov	cs:[di.CH_Volume],0
		mov	cs:[di.CH_Bar],0
		mov	cs:[di.CH_Effect],127
		mov	cs:[di.CH_OldEffect],127
		mov	cs:[di.CH_EffectTime],0
		mov	cs:[di.CH_C4SpdPrecalc],4096
		mov	cs:[di.CH_OldC4SpdPrecalc],4096
		mov	cs:[di.CH_PortamentoOn],0
		mov	cs:[di.CH_Period],13696
		mov	cs:[di.CH_JumpToLoopCounter],0
		mov	cs:[di.CH_JumpToLoopOn],0
		add	di,ChanSize
		dec	cx
		jnz	@@SetPositionClearVarLoop

		mov	cs:[PatternDelayOn],0
		mov	cs:[PatternDelayRow],0
		mov	cs:[PatternDelayCounter],0

@@TooHighPosition:

		popa

		pop	bp
		ret
_CP_SetPosition	endp

_CP_SetGlobalVolume	proc
		arg	NewVolume:word
		push	bp
		mov	bp,sp

		push	ax

		mov	ax,[NewVolume]
		cmp	ax,64
		jb	@@GlobalVolumeOK
		mov	ax,64
@@GlobalVolumeOK:
		mov	cs:[GlobalVolume],ax

		pop	ax

		pop	bp
		ret
_CP_SetGlobalVolume	endp

_CP_SetMainVolume	proc
		arg	NewVolume:word
		push	bp
		mov	bp,sp

		push	ax		

		mov	ax,[NewVolume]
		cmp	ax,64
		jb	@@MainVolumeOK
		mov	ax,64
@@MainVolumeOK:
		mov	cs:[MainVolume],ax

		pop	ax

		pop	bp
		ret
_CP_SetMainVolume	endp

_CP_RestoreInitialVolume	proc
		push	ax

		xor	ah,ah
		mov	al,cs:[InitialVolume]
		mov	cs:[GlobalVolume],ax

		pop	ax
		ret
_CP_RestoreInitialVolume	endp

_CP_SetSpeed	proc
		arg	NewSpeed:word
		push	bp
		mov	bp,sp

		push	ax

		mov	ax,NewSpeed
		mov	byte ptr [CurrentSpeed],al
		mov	byte ptr [TickCounter],al

		pop	ax

		pop	bp
		ret
_CP_SetSpeed	endp

_CP_SetTempo	proc
		arg	NewTempo:word
		push	bp
		mov	bp,sp

		push	ax bx dx

		mov	ax,NewTempo
		mov	[CurrentTempo],al
		xor	ah,ah
		shl	ax,1
		mov	bl,5
		cmp	[TempoCalculationType],1
		jz	@@TempoCalculationTypeOne
		shl	ax,6-1
		mov	bl,159
@@TempoCalculationTypeOne:
		div	bl
		mov	dl,al
		mov	dh,0
		mov	ax,0
		mov	bx,cs:[SpeedDivisor]
		div	bx
		mov	word ptr cs:[Speed],ax
		mov	ax,0
		div	bx
		mov	word ptr cs:[Speed+2],ax

		pop	dx bx ax

		pop	bp
		ret
_CP_SetTempo	endp

_CP_RestoreSpeedAndTempo	proc
		arg
		push	bp
		mov	bp,sp

		push	ax bx dx

		mov	ax,[OfficialTempo]
		mov	[CurrentTempo],al
		xor	ah,ah
		shl	ax,1
		mov	bl,5
		cmp	[TempoCalculationType],1
		jz	@@TempoCalculationTypeOne
		shl	ax,6-1
		mov	bl,159
@@TempoCalculationTypeOne:
		div	bl
		mov	dl,al
		mov	dh,0
		mov	ax,0
		mov	bx,cs:[SpeedDivisor]
		div	bx
		mov	word ptr cs:[Speed],ax
		mov	ax,0
		div	bx
		mov	word ptr cs:[Speed+2],ax

		mov	ax,[OfficialSpeed]
		mov	byte ptr [CurrentSpeed],al
		mov	byte ptr [TickCounter],al

		pop	dx bx ax

		pop	bp
		ret
_CP_RestoreSpeedAndTempo	endp

_CP_SetDefaultPanning	proc
		arg	DefaultPanning:byte
		push	bp
		mov	bp,sp

		cmp	cs:[StereoMode],1
		jnz	@@NoPanning

		pusha

		xor	di,di
		xor	si,si
		mov	cx,cs:[UsedChannels]
@@SetDefaultPanLoop:
		mov	al,cs:[PanningDefaults+si]
		dec	al
		mov	bl,DefaultPanning
		imul	bl
		add	ax,128
		mov	[ChannelInfo.CH_Panning+di],al
		mov	[ChannelInfo.CH_FinalPanning+di],al
;		mov	bl,15
;		mul	bl
		shl	ax,4
	
		mov	dx,cs:[BasePort]
		add	dx,ActiveVoicePort
		mov	al,byte ptr cs:[UsedChannels]
		sub	al,cl
		out	dx,al
		mov	dx,cs:[BasePort]
		add	dx,CommandPort
		mov	al,VoiceBalance
		out	dx,al
		mov	dx,cs:[BasePort]
		add	dx,DataHighPort
		mov	al,ah
		out	dx,al

		add	di,ChanSize
		inc	si
		dec	cx
		jnz	@@SetDefaultPanLoop

		popa
@@NoPanning:

		pop	bp
		ret
_CP_SetDefaultPanning	endp


;********************** Get General Playing Information ***********************


public	_CP_GetRow,_CP_GetNumOfRows,_CP_GetPosition,_CP_GetPattern
public	_CP_GetGlobalVolume,_CP_GetMainVolume,_CP_GetSpeed,_CP_GetTempo
public	_CP_GetPlayingTime,_CP_GetTimer,_CP_GetLoopCounter

_CP_GetRow	proc
		mov	al,byte ptr cs:[CurrentRow]
		ret
_CP_GetRow	endp

_CP_GetNumOfRows	proc
		arg	PositionNum:word
		push	bp
		mov	bp,sp

		push	bx

		mov	bx,PositionNum
		mov	bl,cs:PatternOrder[bx]
		xor	bh,bh
		xor	ah,ah
		mov	al,cs:LastRowNum[bx]
		inc	ax

		pop	bx

		pop	bp
		ret
_CP_GetNumOfRows	endp

_CP_GetPosition	proc
		mov	ax,cs:[CurrentPosition]
		dec	ax
		jnc	@@NoZeroPosition
		xor	ax,ax
@@NoZeroPosition:
		ret
_CP_GetPosition	endp

_CP_GetPattern	proc
		push	bx

		mov	bx,cs:[CurrentPosition]
		dec	bx
		jc	@@ZeroPosition
		mov	al,cs:[PatternOrder+bx]
@@ZeroPosition:
		pop	bx
		ret
_CP_GetPattern	endp

_CP_GetGlobalVolume	proc
		mov	ax,cs:[GlobalVolume]
		ret
_CP_GetGlobalVolume	endp

_CP_GetMainVolume	proc
		mov	ax,cs:[MainVolume]
		ret
_CP_GetMainVolume	endp

_CP_GetSpeed	proc
		mov	ax,cs:[CurrentSpeed]
		ret
_CP_GetSpeed	endp

_CP_GetTempo	proc
		xor	ah,ah
		mov	al,cs:[CurrentTempo]
		ret
_CP_GetTempo	endp

_CP_GetPlayingTime	proc
		push	bx dx

		mov	ax,word ptr cs:[Time+2]
		shl	eax,16
		mov	ax,word ptr cs:[Time]
		xor	edx,edx
		xor	ebx,ebx
		mov	bx,cs:[SpeedDivisor]
		div	ebx

		pop	dx bx
		ret
_CP_GetPlayingTime	endp

_CP_GetTimer	proc
		mov	ax,word ptr cs:[Time]
		mov	dx,word ptr cs:[Time+2]
		ret
_CP_GetTimer	endp

_CP_GetLoopCounter	proc
		mov	al,cs:[LoopCounter]
		ret
_CP_GetLoopCounter	endp


;************************* Set Channel Information ****************************


public	_CP_SetChannelPanning,_CP_SetChannelMute,_CP_PlaySample,_CP_StopSample

_CP_SetChannelPanning	proc
		arg	ChannelNum:word,NewPanning:byte
		push	bp
		mov	bp,sp

		push	ax bx dx

		cmp	cs:[StereoMode],1
		jnz	@@NoPanning
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	al,NewPanning
		mov	byte ptr [ChannelInfo.CH_Panning+bx],al
		mov	byte ptr [ChannelInfo.CH_FinalPanning+bx],al
		shl	ax,4

		mov	dx,cs:[BasePort]
		add	dx,ActiveVoicePort
		mov	al,byte ptr ChannelNum
		out	dx,al
		mov	dx,cs:[BasePort]
		add	dx,CommandPort
		mov	al,VoiceBalance
		out	dx,al
		mov	dx,cs:[BasePort]
		add	dx,DataHighPort
		mov	al,ah
		out	dx,al

@@NoPanning:
		pop	dx bx ax

		pop	bp
		ret
_CP_SetChannelPanning	endp

_CP_SetChannelMute	proc
		arg	ChannelNum:word,MuteState:byte
		push	bp
		mov	bp,sp

		push	cx

		mov	cx,ChannelNum

		cmp	MuteState,1
		jz	@@MuteChannel

		mov	eax,1
		rol	eax,cl
		or	cs:[ChanOn],eax

		pop	cx

		pop	bp
		ret
@@MuteChannel:

		mov	eax,-2
		rol	eax,cl
		and	cs:[ChanOn],eax

		pop	cx

		pop	bp
		ret
_CP_SetChannelMute	endp

_CP_PlaySample	proc
		arg	ChannelNum:word,InstrumentNum:word,SampleNum:word,Note:byte,Octave:byte
		push	bp
		mov	bp,sp

		pusha
		push	ds es

		mov	ax,cs
		mov	ds,ax

		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax

		xor	ebx,ebx
		mov	bl,Note
		mov	cl,Octave
	
		add	bl,es:[si+SampleRelativeNote]
		and	bl,0fh
		cmp	bl,12
		jge	@@TooHighNote
		cmp	bl,0
		jnl	@@NoteOK
		add	bl,12
		dec	cl
		jmp	@@NoteOK
@@TooHighNote:
		sub	bl,12
		inc	cl
@@NoteOK:
		shl	bx,1+6
		mov	bx,[Periods+bx]
		shl	cl,4
		add	cl,es:[si+SampleRelativeNote]
		shr	cl,4
		cmp	cl,HighestOctave
		jg	@@TooHighOctave
		cmp	cl,0
		jnl	@@OctaveOK
		mov	cl,0
		jmp	@@OctaveOK
@@TooHighOctave:
		mov	cl,HighestOctave
@@OctaveOK:
		mov	eax,es:[si+SampleC4SpdPrecalc]
		mul	ebx
		shr	eax,8
		shr	eax,cl
@@OnlyTrigger:

		cmp	eax,[HiLimit]
		jae	@@NotTooHigh
		mov	eax,[HiLimit]
@@NotTooHigh:

		cmp	eax,[LoLimit]
		jbe	@@NotTooLow
		mov	eax,[LoLimit]
@@NotTooLow:
		mov	ebx,eax
		xor	edx,edx
		mov	eax,[CurrentDivisor]
		div	ebx

		push	ax				;store frequency

		mov	dx,[BasePort]
		add	dx,ActiveVoicePort
		mov	ax,ChannelNum
		out	dx,al
		inc	dx

		mov	al,WriteVoiceMode
		out	dx,al
		add	dx,2
		mov	al,3
		out	dx,al
		sub	dx,DataHighPort
		rept	6
		in	al,dx
		endm
		add	dx,CommandPort

		mov	al,SampleStartLo
		out	dx,al
		inc	dx
		mov	eax,es:[si+SampleOffset]
		cmp	byte ptr es:[si+Sample16Bit],1
		jnz	@@No16BitSample1
		mov	ebx,eax
		and	eax,0c0000h
		and	ebx,03ffffh
		shr	ebx,1
		add	eax,ebx
@@No16BitSample1:
		shr	eax,7
		and	eax,1fffh
		out	dx,ax
		dec	dx
		mov	al,SampleStartHi
		out	dx,al
		inc	dx
		mov	ax,word ptr es:[si+SampleOffset]
		jnz	@@No16BitSample2
		shr	ax,1
@@No16BitSample2:
		and	ax,7fh
		shl	ax,9
		out	dx,ax
		sub	dx,DataLowPort
		rept	6
		in	al,dx
		endm
		add	dx,CommandPort

		mov	al,SampleEndLo
		out	dx,al
		inc	dx
		mov	eax,es:[si+SampleLength]
		add	eax,es:[si+SampleOffset]
		jnz	@@No16BitSample3
		mov	ebx,eax
		and	eax,0c0000h
		and	ebx,03ffffh
		shr	ebx,1
		add	eax,ebx
@@No16BitSample3:
		shr	eax,7
		and	eax,1fffh
		out	dx,ax
		dec	dx
		mov	al,SampleEndHi
		out	dx,al
		inc	dx
		mov	ax,word ptr es:[si+SampleLength]
		add	ax,word ptr es:[si+SampleOffset]
		jnz	@@No16BitSample4
		shr	ax,1
@@No16BitSample4:
		and	ax,7fh
		shl	ax,9
		out	dx,ax
		dec	dx

		mov	al,LoopStartLo
		out	dx,al
		inc	dx
		mov	eax,es:[si+SampleLoopBegin]
		add	eax,es:[si+SampleOffset]
		jnz	@@No16BitSample5
		mov	ebx,eax
		and	eax,0c0000h
		and	ebx,03ffffh
		shr	ebx,1
		add	eax,ebx
@@No16BitSample5:
		shr	eax,7
		and	eax,1fffh
		out	dx,ax
		dec	dx
		mov	al,LoopStartHi
		out	dx,al
		inc	dx
		mov	ax,word ptr es:[si+SampleLoopBegin]
		add	ax,word ptr es:[si+SampleOffset]
		jnz	@@No16BitSample6
		shr	ax,1
@@No16BitSample6:
		and	ax,7fh
		shl	ax,9
		out	dx,ax
		dec	dx

		mov	al,WriteVoiceMode
		out	dx,al
		add	dx,2
		mov	al,3
		out	dx,al
		sub	dx,2

		xor	bh,bh
		mov	bl,es:[si+SampleVolume]
		shl	bx,2+1
		mov	bx,[GUSVol+bx]

		mov	dx,bx
		mov	dl,bh
		cmp	dl,dh
		jne	@@SetVol

		mov	dx,[BasePort]
		add	dx,CommandPort

		mov	al,VolumeCtrl
		out	dx,al
		add	dx,2
		mov	al,3
		out	dx,al
		sub	dx,2

		mov	al,SetVolume
		out	dx,al
		mov	ax,bx
		inc	dx
		out	dx,ax
		dec	dx
		jmp	@@NoSetVol

@@SetVol:
		mov	dx,[BasePort]
		add	dx,CommandPort

		mov	al,VolumeCtrl
		out	dx,al
		add	dx,2
		mov	al,3
		out	dx,al
		sub	dx,2

		mov	al,VolRampStart
		out	dx,al
		xor	ax,ax
		inc	dx
		out	dx,ax
		dec	dx

		mov	al,VolRampEnd
		out	dx,al
		mov	ax,bx
		inc	dx
		out	dx,ax
		dec	dx

		mov	al,VolumeCtrl
		out	dx,al
		xor	al,al
		add	dx,2
		out	dx,al
		sub	dx,2
@@NoSetVol:

		mov	al,SetVoiceFreq
		out	dx,al
		inc	dx
		pop	ax				;get frequency
		out	dx,ax
		dec	dx


		mov	al,WriteVoiceMode
		out	dx,al
		add	dx,2
		mov	al,es:[si+SampleLoopType]
		shl	al,3
		test	al,00010000b
		jz	@@No2WayLoop
		or	al,00001000b
@@No2WayLoop:
		cmp	byte ptr es:[si+Sample16Bit],1
		jnz	@@No16BitSample7
		or	al,00000100b
@@No16BitSample7:
		out	dx,al
		sub	dx,DataHighPort
		rept	6
		in	al,dx
		endm
		add	dx,CommandPort

@@NoSuchSample:

		pop	es ds
		popa

		pop	bp
		ret
_CP_PlaySample	endp

_CP_StopSample	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp

		push	ax dx

		mov	dx,cs:[BasePort]
		add	dx,ActiveVoicePort
		mov	ax,ChannelNum
		out	dx,al
		inc	dx
		mov	al,0
		out	dx,al
		add	dx,2
		mov	al,3	; Voice Off
		out	dx,al
		sub	dx,2
		mov	al,0Dh
		out	dx,al
		add	dx,2
		mov	al,3	; Ramp Off
		out	dx,al
		sub	dx,3

		pop	dx ax

		pop	bp
		ret
_CP_StopSample	endp


;************************* Get Channel Information ****************************


public	_CP_GetChannelNote,_CP_GetChannelOctave,_CP_GetChannelVolume
public	_CP_GetChannelEffect,_CP_GetChannelEffectParams
public	_CP_GetChannelInstrument,_CP_GetChannelSample,_CP_GetChannelBar
public	_CP_GetChannelNoteTrigger,_CP_GetChannelPanning,_CP_GetChannelMute

_CP_GetChannelNote	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp

		push	bx

		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	al,cs:[ChannelInfo.CH_Note+bx]

		pop	bx

		pop	bp
		ret
_CP_GetChannelNote	endp

_CP_GetChannelOctave	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp

		push	bx
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	al,cs:[ChannelInfo.CH_Octave+bx]

		pop	bx

		pop	bp
		ret
_CP_GetChannelOctave	endp

_CP_GetChannelVolume	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp
		
		push	bx
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	ax,cs:[ChannelInfo.CH_Volume+bx]

		pop	bx

		pop	bp
		ret
_CP_GetChannelVolume	endp

_CP_GetChannelEffect	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp
		
		push	bx
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	al,byte ptr cs:[ChannelInfo.CH_Effect+bx]

		pop	bx

		pop	bp
		ret
_CP_GetChannelEffect	endp

_CP_GetChannelEffectParams	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp
		
		push	bx
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	al,byte ptr cs:[ChannelInfo.CH_Effect+bx+1]

		pop	bx

		pop	bp
		ret
_CP_GetChannelEffectParams	endp

_CP_GetChannelInstrument	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp
		
		push	bx
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	ax,cs:[ChannelInfo.CH_CurrentInstrument+bx]

		pop	bx

		pop	bp
		ret
_CP_GetChannelInstrument	endp

_CP_GetChannelSample	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp
		
		push	bx
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	ax,cs:[ChannelInfo.CH_CurrentSample+bx]

		pop	bx

		pop	bp
		ret
_CP_GetChannelSample	endp

_CP_GetChannelBar	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp
		
		push	bx
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	al,cs:[ChannelInfo.CH_Bar+bx]

		pop	bx

		pop	bp
		ret
_CP_GetChannelBar	endp

_CP_GetChannelNoteTrigger	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp
		
		push	bx
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		mov	al,byte ptr cs:[ChannelInfo.CH_NoteTriggered+bx]

		pop	bx

		pop	bp
		ret
_CP_GetChannelNoteTrigger	endp

_CP_GetChannelPanning	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp
		
		push	bx
		
		mov	bx,ChannelNum
		shl	bx,1
		mov	bx,cs:[ChannelPointers+bx]
		xor	ah,ah
		mov	al,cs:[ChannelInfo.CH_FinalPanning+bx]

		pop	bx

		pop	bp
		ret
_CP_GetChannelPanning	endp

_CP_GetChannelMute	proc
		arg	ChannelNum:word
		push	bp
		mov	bp,sp

		push	cx

		mov	cx,ChannelNum
		mov	eax,cs:[ChanOn]
		shr	eax,cl
		and	al,1
		xor	al,1

		pop	cx

		pop	bp
		ret
_CP_GetChannelMute	endp


;******************** Set Instrument/Sample Information ***********************


public	_CP_SetSampleMute

_CP_SetSampleMute	proc
		arg	InstrumentNum:word,SampleNum:word,MuteState:byte
		push	bp
		mov	bp,sp
		
		push	bx si es
		
		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	al,MuteState
		mov	es:[si+SampleMute],al
@@NoSuchSample:

		pop	es si bx

		pop	bp
		ret
_CP_SetSampleMute	endp


;******************** Get Instrument/Sample Information ***********************


public	_CP_GetInstrumentName,_CP_GetNumOfSamples
public	_CP_GetSampleName,_CP_GetSampleSize,_CP_GetSampleC4Spd
public	_CP_GetSampleVolume,_CP_GetSamplePanning,_CP_GetSampleLoopType
public	_CP_GetSampleLoopBegin,_CP_GetSampleLength,_CP_GetSample16Bit
public	_CP_GetSampleMute

_CP_GetInstrumentName	proc
		arg	InstrumentNum:word
		push	bp
		mov	bp,sp

		push	bx

		mov	dx,cs
		mov	ax,offset cs:[ModuleName+28]

		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchInstrument
		shl	bx,2
		mov	dx,word ptr cs:InstrumentPointers[bx+2]
		mov	ax,word ptr cs:InstrumentPointers[bx]
		add	ax,InstrumentName
@@NoSuchInstrument:

		pop	bx

		pop	bp
		ret
_CP_GetInstrumentName	endp

_CP_GetNumOfSamples	proc
		arg	InstrumentNum:word
		push	bp
		mov	bp,sp

		push	es si bx
		
		mov	bx,InstrumentNum
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	al,es:[si+NumOfSamples]

		pop	bx si es

		pop	bp
		ret
_CP_GetNumOfSamples	endp

_CP_GetSampleName	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp

		push	si es bx

		mov	dx,cs
		mov	ax,offset cs:[ModuleName+28]

		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	ax,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	ax,InstrumentStructureSize
		add	ax,SampleName
		add	ax,si
		mov	dx,es
@@NoSuchSample:

		pop	bx es si

		pop	bp
		ret
_CP_GetSampleName	endp

_CP_GetSampleSize	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp
		
		push	si es bx

		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	dx,es:[si+SampleSize+2]
		mov	ax,es:[si+SampleSize]

		pop	bx es si

		pop	bp
		ret
@@NoSuchSample:
		xor	ax,ax
		xor	dx,dx

		pop	bx es si

		pop	bp
		ret
_CP_GetSampleSize	endp

_CP_GetSampleC4Spd	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp
		
		push	si es bx
		
		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	ax,es:[si+SampleC4Spd]

		pop	bx es si

		pop	bp
		ret
@@NoSuchSample:
		xor	ax,ax

		pop	bx es si

		pop	bp
		ret
_CP_GetSampleC4Spd	endp

_CP_GetSampleVolume	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp
		
		push	si es bx
		
		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	al,es:[si+SampleVolume]

		pop	bx es si

		pop	bp
		ret
@@NoSuchSample:
		xor	al,al

		pop	bx es si

		pop	bp
		ret
_CP_GetSampleVolume	endp

_CP_GetSamplePanning	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp
		
		push	si es bx

		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	al,es:[si+SamplePanning]

		pop	bx es si

		pop	bp
		ret
@@NoSuchSample:
		xor	al,al

		pop	bx es si

		pop	bp
		ret
_CP_GetSamplePanning	endp

_CP_GetSampleLoopType	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp
		
		push	si es bx
		
		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	al,es:[si+SampleLoopType]

		pop	bx es si

		pop	bp
		ret
@@NoSuchSample:
		xor	al,al

		pop	bx es si

		pop	bp
		ret
_CP_GetSampleLoopType	endp

_CP_GetSampleLoopBegin	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp
		
		push	si es bx
		
		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	dx,es:[si+SampleLoopBegin+2]
		mov	ax,es:[si+SampleLoopBegin]

		pop	bx es si

		pop	bp
		ret
@@NoSuchSample:
		xor	ax,ax
		xor	dx,dx

		pop	bx es si

		pop	bp
		ret
_CP_GetSampleLoopBegin	endp

_CP_GetSampleLength	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp
		
		push	si es bx
		
		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	dx,es:[si+SampleLength+2]
		mov	ax,es:[si+SampleLength]

		pop	bx es si

		pop	bp
		ret
@@NoSuchSample:
		xor	ax,ax
		xor	dx,dx

		pop	bx es si

		pop	bp
		ret
_CP_GetSampleLength	endp

_CP_GetSample16Bit	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp
		
		push	si es bx
		
		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	al,es:[si+Sample16Bit]

		pop	bx es si

		pop	bp
		ret
@@NoSuchSample:
		xor	al,al

		pop	bx es si

		pop	bp
		ret
_CP_GetSample16Bit	endp

_CP_GetSampleMute	proc
		arg	InstrumentNum:word,SampleNum:word
		push	bp
		mov	bp,sp
		
		push	si es bx
		
		mov	bx,InstrumentNum
		cmp	cs:[NumOfInstruments],bx
		jbe	@@NoSuchSample
		shl	bx,2
		les	si,cs:InstrumentPointers[bx]
		mov	ax,SampleNum
		cmp	es:[si+NumOfSamples],al
		jbe	@@NoSuchSample
		mov	bl,SampleStructureSize
		mul	bl
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		add	si,ax
		mov	al,es:[si+SampleMute]

		pop	bx es si

		pop	bp
		ret
@@NoSuchSample:
		xor	al,al

		pop	bx es si

		pop	bp
		ret
_CP_GetSampleMute	endp


;**************** Command unit internal procedures/constants ******************

; DS:SI  -- String to search for
; ES:DI  -- Place to put
; CX     -- Maximum size to copy
; AX     -- PspAddress

EnviroSearch	db	8,'ULTRASND'
EnviroString	db	255 dup (0)
GUSPorts	dw	210h,220h,230h,240h,250h,260h

ReadEnvString	proc
		push	es di cx
		mov	es,ax
		mov	es,es:[2Ch]
		xor	di,di
		lodsb
		or	al,al
		je	@@EnvRetNul
		mov	ah,al
		mov	dx,si
		xor	al,al
@@EnvCompare:	mov	ch,al
		mov	si,dx
		mov	cl,ah
		mov	si,dx
		repe	cmpsb
		jne	@@EnvSkip
		cmp	byte ptr es:[di],'='
		jne	@@EnvNoEqual
@@EnvFound:	mov	ax,es
		mov	ds,ax
		mov	si,di
		inc	si
		pop	cx bx es
		mov	di,bx
@@EnvCopyLoop:	lodsb
		or	al,al
		je	@@EnvDone
		stosb
		loop	@@EnvCopyLoop
@@EnvDone:	not	cl

		mov	al,0
		stosb
		ret
@@EnvSkip:	dec	di
@@EnvNoEqual:	mov	cx,7FFFh
		sub	cx,di
		jbe	@@EnvRetNul
		repne	scasb
		jcxz	@@EnvRetNul
		cmp	byte ptr es:[di],al
		jne	@@EnvCompare
@@EnvRetNul:	pop	cx di es
		stosb
		ret
ReadEnvString	endp
