;*********************************
;*                               *
;*  CapaPlay II Loader Routines  *
;*                               *
;*********************************


;************************** The Main Loader Routine ***************************

LoadModule	proc	near

;   ErrorCode
; 	0	No error 
; 	1	File not found
; 	2	File read error
; 	3	Out of memory
; 	4	Unknown module format
;	5	Unknown module version
;	6	Module corrupted

		pusha

		mov	cs:[ErrorCode],0
		mov	cs:[PatternMem],0
		mov	cs:InstrumentPointers[0+2],0

	;ds = filename segment
	;dx = filename offset

		call	FileOpen
		jnc	@@NoOpenError
		mov	cs:[ErrorCode],1
		jmp	@@FileNotFound
@@NoOpenError:
		mov	dx,word ptr cs:[FileStartOffset]
		mov	cx,word ptr cs:[FileStartOffset+2]
		mov	bx,cs:[FileHandle]
		mov	ax,4200h
		int	21h
		neg	ax
		neg	dx
		mov	word ptr cs:[FileSize],ax
		mov	word ptr cs:[FileSize+2],dx

		xor	cx,cx
		xor	dx,dx
		call	FileSeek
		cmp	cs:[ErrorCode],0
		jnz	@@FileLoadOK

		mov	ax,cs
		mov	ds,ax

		mov	cx,1084
		mov	dx,offset cs:[FileHeader]
		mov	ax,cs
		mov	ds,ax
		call	FileRead
		cmp	cs:[ErrorCode],0
		jnz	@@NoxxCH

;---------------------------- Check Module Format -----------------------------

		mov	bx,'.M'
		cmp	bx,word ptr cs:FileHeader[1080]
		jne	@@NoMK4_1
		mov	bx,'.K'
		cmp	bx,word ptr cs:FileHeader[1082]
		jne	@@NoMK4_1
		mov	cs:[NumOfChannels],4
		mov	si,offset cs:FileHeader[952]
		mov	cs:[ModuleType],1
		call	MODLoader
		jmp	@@FileLoadOK
@@NoMK4_1:
		mov	bx,'!M'
		cmp	bx,word ptr cs:FileHeader[1080]
		jne	@@NoMK4_2
		mov	bx,'!K'
		cmp	bx,word ptr cs:FileHeader[1082]
		jne	@@NoMK4_2
		mov	cs:[NumOfChannels],4
		mov	si,offset cs:FileHeader[952]
		mov	cs:[ModuleType],1
		call	MODLoader
		jmp	@@FileLoadOK
@@NoMK4_2:
		mov	bx,'LF'
		cmp	bx,word ptr cs:FileHeader[1080]
		jne	@@NoFLT4
		mov	bx,'4T'
		cmp	bx,word ptr cs:FileHeader[1082]
		jne	@@NoFLT4
		mov	cs:[NumOfChannels],4
		mov	si,offset cs:FileHeader[952]
		mov	cs:[ModuleType],1
		call	MODLoader
		jmp	@@FileLoadOK
@@NoFLT4:
		mov	bx,'CO'
		cmp	bx,word ptr cs:FileHeader[1080]
		jne	@@NoOCTA
		mov	bx,'AT'
		cmp	bx,word ptr cs:FileHeader[1082]
		jne	@@NoOCTA
		mov	cs:[NumOfChannels],8
		mov	si,offset cs:FileHeader[952]
		mov	cs:[ModuleType],1
		call	MODLoader
		jmp	@@FileLoadOK
@@NoOCTA:
		mov	bx,'NH'
		cmp	bx,word ptr cs:FileHeader[1082]
		jne	@@NoxCHN
		mov	bl,'C'
		cmp	bl,byte ptr cs:FileHeader[1081]
		jne	@@NoxCHN
		mov	al,byte ptr cs:FileHeader[1080]
		sub	al,30h
		mov	byte ptr cs:[NumOfChannels],al
		mov	si,offset cs:FileHeader[952]
		mov	cs:[ModuleType],1
		call	MODLoader
		jmp	@@FileLoadOK
@@NoxCHN:
		mov	bx,'HC'
		cmp	bx,word ptr cs:FileHeader[1082]
		jne	@@NoxxCH
		mov	ah,byte ptr cs:FileHeader[1080]
		mov	al,byte ptr cs:FileHeader[1081]
		sub	ax,3030h
		aad
		mov	byte ptr cs:[NumOfChannels],al
		mov	si,offset cs:FileHeader[952]
		mov	cs:[ModuleType],1
		call	MODLoader
		jmp	@@FileLoadOK
@@NoxxCH:

		cmp	dword ptr cs:FileHeader[2ch],'MRCS'
		jnz	@@NoS3M

		mov	cs:[ModuleType],2
		call	S3MLoader
		jmp	@@FileLoadOK
@@NoS3M:
		mov	ax,cs
		mov	ds,ax
		mov	si,offset cs:[FileHeader]
		mov	es,ax
		mov	di,offset cs:[XMIDText]
		mov	cx,16/4
		rep	cmpsd
		jne	@@NoXM

		mov	cs:[ModuleType],3
		call	XMLoader
		jmp	@@FileLoadOK
@@NoXM:

		mov	cs:[ErrorCode],4
@@FileLoadOK:
		cmp	cs:[ErrorCode],0
		jz	@@NoLoadErrors
		mov	cs:[FileSize],0

		cmp	cs:[ErrorCode],2
		jnz	@@NoCorruptedModule
		mov	cs:[ErrorCode],6
		jmp	@@NoLoadErrors
@@NoCorruptedModule:

		cmp	cs:InstrumentPointers[0+2],0
		jz	@@NoInstrumentMem
		mov	es,cs:InstrumentPointers[0+2]
		mov	ax,4900h
		int	21h
@@NoInstrumentMem:
		cmp	cs:[PatternMem],0
		jz	@@NoLoadErrors
		mov	es,cs:[PatternMem]
		mov	ax,4900h
		int	21h
@@NoLoadErrors:

		call	FileClose

		cmp	cs:[ErrorCode],0
		jnz	@@FileNotFound
		call	PrepareSamples
@@FileNotFound:

		popa
		ret
LoadModule	endp


;******************************* MOD Loader ***********************************


MODLoader	proc	near
		pusha
		push	ds
		push	es

		mov	cs:[LoLimit],219136/8
		mov	cs:[HiLimit],4
		mov	cs:[InitialVolume],64
		mov	cs:[InitialSpeed],6
		mov	cs:[InitialTempo],125
		mov	cs:[FastVolumeSlides],0
		mov	cs:[FrequencyTable],0
		mov	cs:[StereoMode],1
		mov	cs:[PortamentoType],0
		mov	cs:[SampleOffsetType],1
		mov	cs:[TempoCalculationType],0
		
		mov	cs:[GUSMemoryUsed],0
		mov	cs:[GUSMemoryUsed+4],0
		mov	cs:[GUSMemoryUsed+8],0
		mov	cs:[GUSMemoryUsed+12],0

		mov	cs:[InstrumentInfoSize],0
		
		push	si

		mov	ax,cs
		mov	ds,ax
		mov	es,ax
		mov	si,offset cs:[FileHeader]
		mov	di,offset cs:[ModuleName]
		xor	eax,eax
		mov	cx,28/4
		rep	stosd
		mov	di,offset cs:[ModuleName]
		mov	cx,20/4
		rep	movsd
		
		mov	di,offset cs:[LastRowNum]
		mov	eax,03f3f3f3fh
		mov	cx,256/4
		rep	stosd

		pop	si

		mov	di,31
@@SetMODPanning:
		mov	al,cs:[MODPanning+di]
		mov	cs:[PanningDefaults+di],al
		dec	di
		jge	@@SetMODPanning

		mov	ax,cs:[si-2]
		cmp	ah,120
		jb	@@RestartPositionSet
		xor	ah,ah
@@RestartPositionSet:
		mov	byte ptr cs:[RestartPosition+1],0
		mov	byte ptr cs:[RestartPosition],ah
		xor	ah,ah
		mov	cs:[RealNumOfOrders],ax
		mov	di,offset cs:[PatternOrder]
		mov	cx,128
@@CopyOrderData:
		mov	al,cs:[si]
		mov	cs:[di],al
		cmp	al,ah
		jb	@@NoHigherPattern
		xchg	ah,al
@@NoHigherPattern:
		inc	si
		inc	di
		dec	cx
		jnz	@@CopyOrderData

		shr	ax,8
		inc	ax
		mov	cs:[RealNumOfPatterns],ax

;------------------------------ Read Samples ----------------------------------

		cmp	cs:[ReadOnlyPatterns],1
		jnz	@@ReadSamples
		jmp	@@ReadPatterns
@@ReadSamples:

		call	InitGUS

		mov	ax,cs:[RealNumOfPatterns]
		shl	ax,8
		mov	bx,cs:[NumOfChannels]
		mul	bx
		mov	cx,dx
		mov	dx,1084
		add	dx,ax
		adc	cx,0
		call	FileSeek

		mov	cs:[NumOfInstruments],31

		mov	bx,0ffffh
		mov	ax,4800h
		int	21h
		mov	ax,4800h			;Allocate max memory
		int	21h
		mov	word ptr cs:InstrumentPointers[0+2],ax
		mov	word ptr cs:InstrumentPointers[0],0
		mov	es,ax
		xor	di,di

		mov	cs:[BufferMem],9000h
		mov	ds,cs:[BufferMem]

		mov	si,offset cs:FileHeader[20]
		xor	bp,bp
		xor	di,di
		mov	cx,31
@@LoadInstrument:
		push	cx

		mov	word ptr cs:InstrumentPointers[bp+2],es
		mov	word ptr cs:InstrumentPointers[bp],di

		mov	ax,cs
		mov	ds,ax

		add	di,InstrumentName
		xor	eax,eax
		mov	cx,28/4
		rep	stosd
		sub	di,28
		mov	cx,22/2
		rep	movsw
		sub	di,22
		sub	di,InstrumentName

		mov	byte ptr es:[di+InstrumentType],0

		mov	byte ptr es:[di+NumOfSamples],0

		mov	cx,cs:[si]
		add	si,2
		rol	cx,8
		cmp	cx,2
		ja	@@SampleExists
		add	si,6
		jmp	@@NoSamplesInInstrument
@@SampleExists:
		mov	byte ptr es:[di+NumOfSamples],1

		add	di,InstrumentStructureSize
		add	cs:[InstrumentInfoSize],InstrumentStructureSize

		mov	byte ptr es:[di+Sample16Bit],0
		mov	byte ptr es:[di+SampleMute],0
		mov	byte ptr es:[di+SamplePanning],128
		mov	byte ptr es:[di+SampleRelativeNote],0
		
		shl	cx,1
		mov	word ptr es:[di+SampleSize+2],0
		mov	word ptr es:[di+SampleSize],cx

		mov	ds,cs:[BufferMem]
		xor	dx,dx
		call	FileRead

		add	di,SampleName
		xor	ax,ax
		mov	cx,22/2
		rep	stosw
	       	sub	di,22
		sub	di,SampleName

		xor	ebx,ebx
		mov	bl,cs:[si]
		inc	si
		shl	bl,4
		add	bl,128
		shl	bx,1
		mov	bx,cs:FineTuneCompare[bx]
		mov	es:[di+SampleC4Spd],bx
		xor	edx,edx
		mov	eax,8363*4096
		div	ebx

		mov	es:[di+SampleC4SpdPrecalc],eax

		mov	al,cs:[si]
		inc	si
		mov	es:[di+SampleVolume],al

		mov	ax,cs:[si]
		add	si,2
		xchg	ah,al
		mov	cx,cs:[si]
		add	si,2
		xchg	ch,cl
		shl	ax,1
		shl	cx,1
		add	cx,ax
		mov	word ptr es:[di+SampleLoopBegin+2],0
		mov	word ptr es:[di+SampleLoopBegin],ax
		mov	word ptr es:[di+SampleLength+2],0
		mov	word ptr es:[di+SampleLength],cx

		mov	byte ptr es:[di+SampleLoopType],0

		mov	dx,es:[di+SampleSize]
		sub	cx,ax
		cmp	cx,2
		jbe	@@NoLoopAtAll
		mov	byte ptr es:[di+SampleLoopType],1
		add	cx,ax
		cmp	dx,cx
		jb	@@NoLoopAtAll
		mov	dx,cx
@@NoLoopAtAll:
		mov	es:[di+SampleLength],dx

		mov	ebx,cs:[GUSMemoryUsed]
		add	ebx,cs:[GUSMemoryUsed+4]
		add	ebx,cs:[GUSMemoryUsed+8]
		add	ebx,cs:[GUSMemoryUsed+12]

		mov	es:[di+SampleOffset],ebx

		xor	ecx,ecx
		mov	cx,es:[di+SampleLength]
		add	ebx,ecx
		inc	ebx
		cmp	cs:[TransferModeToUse],0
		jz	@@NoDMATransferAlign
		add	ebx,31
		and	ebx,not 31
@@NoDMATransferAlign:
		mov	eax,ebx
		shr	eax,18
		and	ebx,262143
		mov	cs:[GUSMemoryUsed],ebx
		cmp	eax,1
		jnz	@@Bank0Free
		mov	cs:[GUSMemoryUsed],262144
		mov	cs:[GUSMemoryUsed+4],ebx
@@Bank0Free:
		cmp	eax,2
		jnz	@@Bank1Free
		mov	cs:[GUSMemoryUsed],262144
		mov	cs:[GUSMemoryUsed+4],262144
		mov	cs:[GUSMemoryUsed+8],ebx
@@Bank1Free:
		cmp	eax,3
		jnz	@@Bank2Free
		mov	cs:[GUSMemoryUsed],262144
		mov	cs:[GUSMemoryUsed+4],262144
		mov	cs:[GUSMemoryUsed+8],262144
		mov	cs:[GUSMemoryUsed+12],ebx
@@Bank2Free:
		mov	ebx,es:[di+SampleOffset]

		mov	al,0	;8 bits
		mov	ah,0	;signed
		call	DumpSampleToGUS

		add	di,SampleStructureSize
		add	cs:[InstrumentInfoSize],SampleStructureSize

		jmp	@@SampleFound

@@NoSamplesInInstrument:

		add	di,InstrumentStructureSize
		add	cs:[InstrumentInfoSize],InstrumentStructureSize

@@SampleFound:

		mov	bx,es
		mov	ax,di
		shr	ax,4
		and	di,15
		add	bx,ax
		mov	es,bx

		pop	cx

		add	bp,4
		dec	cx
		jnz	@@LoadInstrument
@@Loaded:

		xor	eax,eax
		mov	ebx,cs:[InstrumentInfoSize]
		add	ebx,15
		shr	ebx,4
		mov	es,word ptr cs:InstrumentPointers[0+2]
		mov	ax,4A00h		;Resize instrument info segment
		int	21h

;------------------------------ Read Patterns ---------------------------------

@@ReadPatterns:
		mov	cs:[UsedChannels],0

		xor	cx,cx
		xor	dx,dx
		mov	bx,cs:[FileHandle]
		mov	ax,4201h
		int	21h
		add	word ptr cs:[FileSize],ax
		adc	word ptr cs:[FileSize+2],dx


		xor	cx,cx
		mov	dx,1084
		call	FileSeek

		mov	bx,0ffffh
		mov	ax,4800h
		int	21h
		mov	ax,4800h			;Allocate max memory
		int	21h
		mov	cs:[PatternMem],ax
		mov	cs:[SegPattern],ax
		mov	cs:[OfsPattern],0
		mov	cs:[BufferMem],9000h
		mov	cs:[RepackedSize],0


		xor	di,di
@@ClearRowData:
		mov	dword ptr cs:RowBuffer[di+0],007fffffh
		mov	cs:RowBuffer[di+4],0ffh

		add	di,5
		cmp	di,32*5
		jnz	@@ClearRowData


		mov	ds,cs:[BufferMem]

		xor	bp,bp
		mov	cx,cs:[RealNumOfPatterns]
@@LoadLoop:
		push	cx

		mov	ax,cs:[NumOfChannels]
		shl	ax,8
		cmp	cx,7
		jbe	@@LessThanSevenPatternsLeft
		mov	cx,7
@@LessThanSevenPatternsLeft:
		mov	bx,cx
		mul	bx
		mov	cx,ax
		xor	dx,dx
		call	FileRead

		xor	si,si

		pop	cx
		push	cx

		cmp	cx,7
		jbe	@@ConvertBunchOfPatterns
		mov	cx,7
@@ConvertBunchOfPatterns:
		push	cx

		mov	ax,cs:[OfsPattern]
		mov	bx,cs:[SegPattern]
		mov	word ptr cs:[PatternPointers+bp],ax
		mov	word ptr cs:[PatternPointers+bp+2],bx

		cmp	bx,9000h
		jb	@@EnoughMemoryForPatterns
		mov	cs:[ErrorCode],3
		jmp	@@EndOfMODLoad
@@EnoughMemoryForPatterns:

		mov	cx,64
@@ConvertPattern:

		xor	di,di
		mov	dx,cs:[NumOfChannels]
@@ConvertRow:

		xor	ebx,ebx
		mov	bh,ds:[si+0]
		and	bh,00001111b
		mov	bl,ds:[si+1]
		mov	al,255
		cmp	bx,0
		jz	@@NoNote
		xor	al,al
@@AdjustOctave:
		cmp	bx,907
		jb	@@OctaveOK
		shr	bx,1
		sub	al,16
		jmp	@@AdjustOctave
@@OctaveOK:
		add	al,cs:MODPeriodCompare[bx]
		
@@NoNote:
		mov	cs:RowBuffer[di+0],al


		mov	ah,ds:[si+0]
		and	ah,11110000b
		mov	al,ds:[si+2]
		shr	al,4
		add	al,ah
		dec	al
		mov	cs:RowBuffer[di+1],al

;--------------------- Convert MOD effects to C2M effects ---------------------

		mov	ah,ds:[si+3]
		mov	al,ds:[si+2]
		and	al,00001111b
		cmp	al,0
		jnz	@@Effect
		cmp	ah,0
		jnz	@@Effect
		mov	al,7fh
		jmp	@@ConvertEffectOK
@@Effect:
		cmp	al,0eh
		jz	@@EffectE

		cmp	al,5
		jnz	@@NoPortamentoVolumeSlide
		cmp	ah,0
		jnz	@@NoPortamentoVolumeSlide
		mov	al,3
		jmp	@@ConvertEffectOK
@@NoPortamentoVolumeSlide:

		cmp	al,6
		jnz	@@NoVibratoVolumeSlide
		cmp	ah,0
		jnz	@@NoVibratoVolumeSlide
		mov	al,4
		jmp	@@ConvertEffectOK
@@NoVibratoVolumeSlide:

		cmp	al,0ch
		jnz	@@NoSetVolume
		cmp	ah,64
		jbe	@@NoTooHighVolume
		mov	ah,64
@@NoTooHighVolume:
		mov	cs:RowBuffer[di+4],ah
		xor	ah,ah
		mov	al,7fh
		jmp	@@ConvertEffectOK
@@NoSetVolume:

		cmp	al,0dh
		jnz	@@NoBreakRow
		mov	al,ah
		shr	ah,4
		and	al,0fh
		aad
		mov	ah,al
		mov	al,0dh
		jmp	@@ConvertEffectOK
@@NoBreakRow:

		cmp	al,08h
		jnz	@@NoSet7bitPanning

		cmp	ah,0a4h				;surround
		jnz	@@NoSurroundPan
		mov	ah,040h
		jmp	@@NoTooHighPanning
@@NoSurroundPan:
		cmp	ah,80h
		jbe	@@NoTooHighPanning
		mov	al,7fh
		xor	ah,ah
@@NoTooHighPanning:
		mov	al,ah
		mov	bl,255
		mul	bl
		shl	ax,1
		mov	al,08h
		jmp	@@ConvertEffectOK
@@NoSet7bitPanning:

		cmp	al,0fh
		jnz	@@NoSetTempo
		cmp	cs:[VBlank],1
		jz	@@NoSetTempo
		cmp	ah,20h
		jb	@@NoSetTempo
		mov	al,0eh
@@NoSetTempo:
		jmp	@@ConvertEffectOK
@@EffectE:
		mov	al,ah
		shr	al,4
		and	ah,00001111b

		cmp	al,08h
		jnz	@@NoSet4bitPanning

		mov	al,ah
		mov	bl,17
		mul	bl
		mov	ah,al
		mov	al,08h
		jmp	@@ConvertEffectOK
@@NoSet4bitPanning:

		add	al,10h

		cmp	al,1dh
		jnz	@@NoDelayNote
		or	ah,10000000b
		jmp	@@ConvertEffectOK
@@NoDelayNote:

		jmp	@@ConvertEffectOK

@@ConvertEffectOK:
		mov	cs:RowBuffer[di+2],al
		mov	cs:RowBuffer[di+3],ah

		add	di,5
		add	si,4

		dec	dx
		jnz	@@ConvertRow

		call	Repacker

		dec	cx
		jnz	@@ConvertPattern

		add	bp,4
		pop	cx
		dec	cx
		jnz	@@ConvertBunchOfPatterns

		pop	cx

		sub	cx,7
		ja	@@LoadLoop

		mov	ebx,cs:[RepackedSize]
		add	ebx,15
		shr	ebx,4
		mov	es,cs:[PatternMem]
		mov	ax,4A00h		;Resize repacked patternmem
		int	21h

		call	InitGUS

@@EndOfMODLoad:

		pop	es
		pop	ds
		popa
		ret
MODLoader	endp


;******************************* S3M Loader ***********************************


S3MLoader	proc	near
		pushad
		push	ds
		push	es

		mov	cs:[RestartPosition],0
		mov	cs:[FrequencyTable],0
		mov	cs:[PortamentoType],0
		mov	cs:[SampleOffsetType],0
		mov	cs:[TempoCalculationType],1

		mov	cs:[GUSMemoryUsed],0
		mov	cs:[GUSMemoryUsed+4],0
		mov	cs:[GUSMemoryUsed+8],0
		mov	cs:[GUSMemoryUsed+12],0

		mov	cs:[InstrumentInfoSize],0

		mov	ax,cs
		mov	ds,ax
		mov	es,ax
		mov	si,offset cs:[FileHeader]
		mov	di,offset cs:[ModuleName]
		xor	eax,eax
		mov	cx,28/4
		rep	stosd
		mov	di,offset cs:[ModuleName]
		mov	cx,28/4
		rep	movsd

		mov	di,offset cs:[LastRowNum]
		mov	eax,03f3f3f3fh
		mov	cx,256/4
		rep	stosd

		xor	cx,cx
		xor	dx,dx
		call	FileSeek

		mov	cx,60h
		mov	dx,offset cs:[FileHeader]
		mov	ax,cs
		mov	ds,ax
		call	FileRead

		mov	ax,word ptr cs:FileHeader[20h]
		mov	cs:[NumOfOrders],ax
		mov	ax,word ptr cs:FileHeader[22h]
		mov	cs:[NumOfInstruments],ax
		mov	ax,word ptr cs:FileHeader[24h]
		mov	cs:[NumOfPatterns],ax

		mov	al,byte ptr cs:FileHeader[30h]
		mov	cs:[InitialVolume],al
		mov	al,byte ptr cs:FileHeader[31h]
		mov	cs:[InitialSpeed],al
		mov	al,byte ptr cs:FileHeader[32h]
		cmp	al,20h
		ja	@@TempoAbove20h
		mov	al,7fh
@@TempoAbove20h:
		mov	cs:[InitialTempo],al
		mov	al,byte ptr cs:FileHeader[33h]
		shr	al,7
		mov	cs:[StereoMode],al
		mov	al,byte ptr cs:FileHeader[35h]
		cmp	al,252
		sete	al
		mov	cs:[S3MDefaultPan],al

		mov	bx,40h
		mov	di,-1
		xor	si,si
@@ChannelSettings:
		mov	[S3MChannelCoords+si],255
		mov	al,byte ptr cs:FileHeader[bx]
		test	al,128
		jnz	@@UnusedChannel
		test	al,16
		jnz	@@UnusedChannel
		inc	di
		mov	[S3MChannelCoords+si],di
		mov	cs:[PanningDefaults+di],1
		cmp	cs:[StereoMode],0
		jz	@@UnusedChannel
		mov	cs:[PanningDefaults+di],0
		test	al,8
		jz	@@UnusedChannel
		mov	cs:[PanningDefaults+di],2
@@UnusedChannel:
		inc	bx
		inc	si
		inc	si
		cmp	si,64
		jb	@@ChannelSettings
		inc	di
		mov	cs:[NumOfChannels],di


		mov	cs:[LoLimit],219136/8
		mov	cs:[HiLimit],4
		mov	ax,word ptr cs:FileHeader[26h]
		test	ax,16
		jz	@@NormalLimits
		mov	cs:[LoLimit],27392/8	;54784
		mov	cs:[HiLimit],3628/8
@@NormalLimits:
		mov	cs:[FastVolumeSlides],0
		test	ax,64
		jz	@@NormalSlides
		mov	cs:[FastVolumeSlides],1
@@NormalSlides:
	
		mov	ax,word ptr cs:FileHeader[28h]
		cmp	ax,1300h
		jnz	@@NormalSlides2
		mov	cs:[FastVolumeSlides],1
@@NormalSlides2:


		mov	cx,cs:[NumOfInstruments]
		add	cx,cs:[NumOfPatterns]
		shl	cx,1
		add	cx,cs:[NumOfOrders]
		xor	ah,ah
		mov	al,cs:[S3MDefaultPan]
		shl	ax,5
		add	cx,ax
		mov	dx,offset cs:[FileHeader]
		mov	ax,cs
		mov	ds,ax
		call	FileRead

		mov	cs:[RealNumOfOrders],0
		mov	cs:[RealNumOfPatterns],0
		mov	cx,cs:[NumOfOrders]
		xor	di,di
		xor	ax,ax
		xor	bx,bx
		xor	dx,dx
@@OrdersRead:
		cmp	dx,1
		jz	@@SkipOrder
		xor	ah,ah
		mov	al,byte ptr cs:FileHeader[bx]
		cmp	al,254
		jae	@@SkipOrder
		inc	cs:[RealNumOfOrders]
		mov	cs:[PatternOrder+di],al
		inc	di
		inc	ax
		cmp	ax,cs:[RealNumOfPatterns]
		jbe	@@SkipOrder
		mov	cs:[RealNumOfPatterns],ax
@@SkipOrder:
		cmp	al,255
		jb	@@NotEndOfSong
		mov	dx,1
@@NotEndOfSong:
		inc	bx
		dec	cx
		jnz	@@OrdersRead

		mov	cx,cs:[NumOfInstruments]
		xor	di,di
@@InstrumentPointerRead:
		mov	ax,word ptr cs:FileHeader[bx]
		mov	word ptr cs:[InstrumentPointers+di],ax
		inc	bx
		inc	bx
		add	di,4
		dec	cx
		jnz	@@InstrumentPointerRead

		mov	cx,cs:[NumOfPatterns]
		xor	di,di
@@PatternPointerRead:
		mov	ax,word ptr cs:FileHeader[bx]
		mov	word ptr cs:[PatternPointers+di],ax
		inc	bx
		inc	bx
		add	di,4
		dec	cx
		jnz	@@PatternPointerRead

		cmp	cs:[S3MDefaultPan],0
		jz	@@NoS3MDefaultPan
		mov	cx,32
		xor	di,di
@@PanningPositionsRead:
		mov	al,byte ptr cs:FileHeader[bx]
		test	al,20h
		jz	@@NotAST3Pan
		mov	cs:[PanningDefaults+di],al
@@NotAST3Pan:
		inc	bx
		inc	di
		dec	cx
		jnz	@@PanningPositionsRead
@@NoS3MDefaultPan:

		mov	bx,0ffffh
		mov	ax,4800h
		int	21h
		mov	ax,4800h			;Allocate max memory
		int	21h
		mov	es,ax

		xor	di,di
		xor	bp,bp
@@InstrumentInfoRead:
		shl	bp,2

		xor	cx,cx
		mov	dx,word ptr cs:InstrumentPointers[bp]
		shl	dx,4
		call	FileSeek

		mov	cx,4ch
		mov	dx,offset cs:[FileHeader]
		call	FileRead

		mov	word ptr cs:InstrumentPointers[bp+2],es
		mov	word ptr cs:InstrumentPointers[bp],di

		add	di,InstrumentName
		mov	si,offset cs:FileHeader[30h]
		mov	cx,28/4
		rep	movsd
		mov	byte ptr es:[di],0
		sub	di,28
		sub	di,InstrumentName

		mov	byte ptr es:[di+InstrumentType],0

		mov	byte ptr es:[di+NumOfSamples],0

		cmp	byte ptr cs:[FileHeader],1
		jnz	@@NotASample

		mov	byte ptr es:[di+NumOfSamples],1

		add	di,InstrumentStructureSize
		add	cs:[InstrumentInfoSize],InstrumentStructureSize

		add	di,SampleName
		xor	ax,ax
		mov	cx,22/2
		rep	stosw
		sub	di,22
		sub	di,SampleName

		mov	byte ptr es:[di+Sample16Bit],0
		mov	byte ptr es:[di+SampleMute],0
		mov	byte ptr es:[di+SamplePanning],128
		mov	byte ptr es:[di+SampleRelativeNote],0

		mov	bx,0eh
		xor	eax,eax
		mov	ax,word ptr cs:FileHeader[bx]
		shl	eax,4
		mov	es:[di+SampleOffset],eax
		add	bx,2
		xor	eax,eax
		mov	ax,word ptr cs:FileHeader[bx]
		mov	es:[di+SampleSize],eax
		add	bx,4
		mov	ax,word ptr cs:FileHeader[bx]
		mov	es:[di+SampleLoopBegin],eax
		add	bx,4
		mov	ax,word ptr cs:FileHeader[bx]
		mov	es:[di+SampleLength],eax
		add	bx,4
		mov	al,byte ptr cs:FileHeader[bx]
		mov	es:[di+SampleVolume],al
		add	bx,3
		mov	al,byte ptr cs:FileHeader[bx]
		and	ax,1
		mov	es:[di+SampleLoopType],al
		inc	bx
		mov	dx,word ptr cs:FileHeader[bx]
		xor	ebx,ebx
		mov	bx,dx
		xor	edx,edx

		mov	es:[di+SampleC4Spd],bx
		mov	eax,8363*4096
		cmp	ebx,0
		jnz	@@NoTooLowC4Spd
		mov	ebx,1
@@NoTooLowC4Spd:
		div	ebx
		mov	es:[di+SampleC4SpdPrecalc],eax

		add	di,SampleStructureSize
		add	cs:[InstrumentInfoSize],SampleStructureSize

		jmp	@@SampleFound
@@NotASample:

		add	di,InstrumentStructureSize
		add	cs:[InstrumentInfoSize],InstrumentStructureSize
@@SampleFound:

		mov	bx,es
		mov	ax,di
		shr	ax,4
		add	bx,ax
		and	di,15
		mov	es,bx

		cmp	bx,9000h
		jb	@@EnoughMemoryForSampleInfo
		mov	cs:[ErrorCode],3
		jmp	@@EndOfS3MLoad
@@EnoughMemoryForSampleInfo:

		shr	bp,2

		inc	bp
		cmp	bp,cs:[NumOfInstruments]
		jnz	@@InstrumentInfoRead

		mov	ebx,cs:[InstrumentInfoSize]
		add	ebx,15
		shr	ebx,4
		mov	es,word ptr cs:InstrumentPointers[0+2]
		mov	ax,4A00h		;Resize instrument info segment
		int	21h

;------------------------------- Read patterns --------------------------------

		mov	cs:[UsedChannels],0

		xor	di,di
@@ClearOldData:
		mov	cs:RowParameter[di],0

		inc	di
		cmp	di,32
		jnz	@@ClearOldData

		mov	bx,0ffffh
		mov	ax,4800h
		int	21h
		mov	ax,4800h			;Allocate max memory
		int	21h
		mov	cs:[PatternMem],ax
		mov	cs:[SegPattern],ax
		mov	cs:[OfsPattern],0
		mov	cs:[BufferMem],9000h

		mov	cx,cs:[NumOfPatterns]
		xor	si,si
		mov	cs:[RepackedSize],0
@@TransferPatterns:
		push	cx

		xor	cx,cx
		mov	dx,word ptr cs:[PatternPointers+si]
		shld	cx,dx,4
		shl	dx,4
		call	FileSeek

		mov	cx,2
		mov	ax,cs
		mov	ds,ax
		mov	dx,offset cs:[FileHeader]
		call	FileRead

		mov	cx,word ptr cs:[FileHeader]
		cmp	cx,12352
		jbe	@@PatternExists
		mov	word ptr cs:[PatternPointers+si],0
		mov	word ptr cs:[PatternPointers+si+2],0
		jmp	@@EndOfPattern
@@PatternExists:
		mov	ds,cs:[BufferMem]
		xor	dx,dx
		call	FileRead

		mov	ax,cs:[OfsPattern]
		mov	bx,cs:[SegPattern]
		mov	word ptr cs:[PatternPointers+si],ax
		mov	word ptr cs:[PatternPointers+si+2],bx

		cmp	bx,9000h
		jb	@@EnoughMemoryForPatterns
		pop	cx
		mov	cs:[ErrorCode],3
	       	jmp	@@EndOfS3MLoad
@@EnoughMemoryForPatterns:


		xor	di,di
@@ClearRowData:
		mov	dword ptr cs:RowBuffer[di+0],007fffffh
		mov	cs:RowBuffer[di+4],0ffh

		add	di,5
		cmp	di,32*5
		jnz	@@ClearRowData

		push	bp

		xor	bp,bp
		xor	cx,cx
@@UnpackPattern:

		mov	ch,0

		mov	dl,ds:[bp]
		inc	bp
		cmp	dl,0
		jnz	@@NotNextRow
		mov	ch,1
		inc	cl
		jmp	@@NextRow
@@NotNextRow:

		xor	bh,bh
		mov	bl,dl
		and	bl,31
		shl	bx,1
		mov	di,cs:[S3MChannelCoords+bx]
		cmp	di,255
		jz	@@ReadUntilValid
		cmp	di,cs:[NumOfChannels]
		jb	@@ChannelNumberValid
@@ReadUntilValid:
		test	dl,32
		jz	@@NoNoteAndInsInvalid
		inc	bp
		inc	bp
@@NoNoteAndInsInvalid:
		test	dl,64
		jz	@@NoVolumeInvalid
		inc	bp
@@NoVolumeInvalid:
		test	dl,128
		jz	@@NoCommandAndInfoInvalid
		inc	bp
		inc	bp
@@NoCommandAndInfoInvalid:
		jmp	@@NextRow
@@ChannelNumberValid:

		lea	di,[edi+edi*4]

		test	dl,32
		jz	@@NoNoteAndIns
		mov	bx,ds:[bp]
		dec	bh
		mov	word ptr cs:RowBuffer[di],bx
		inc	bp
		inc	bp
@@NoNoteAndIns:

		test	dl,64
		jz	@@NoVolume
		mov	bl,ds:[bp]
		mov	cs:RowBuffer[di+4],bl
		inc	bp
@@NoVolume:

		test	dl,128
		jz	@@NoCommandAndInfo
		mov	bx,ds:[bp]
		dec	bl
		and	bl,7fh
		mov	word ptr cs:RowBuffer[di+2],bx
		inc	bp
		inc	bp
@@NoCommandAndInfo:


@@NextRow:

		cmp	ch,0
		jz	@@ReadMoreChannels
		xor	ch,ch

;--------------------- Convert S3M effects to C2M effects ---------------------

		push	si

		xor	si,si
		xor	di,di

		xor	bh,bh
@@ConvertEffects:
		cmp	cs:RowBuffer[si+3],0
		jz	@@OldParameters
		mov	al,cs:RowBuffer[si+3]
		mov	cs:RowParameter[di],al
@@OldParameters:

		mov	bl,cs:RowBuffer[si+2]
		cmp	bl,7fh
		jz	@@NoEffectToConvert

		mov	al,cs:S3MEffectCompare[bx]

		cmp	al,04h
		jnz	@@NoVibrato
		test	cs:RowBuffer[si+3],00001111b
		jnz	@@NoVibrato
		mov	cs:RowBuffer[si+3],0
@@NoVibrato:
		
		cmp	al,7fh
		jnz	@@ConvertEffectOK

		cmp	bl,2
		jnz	@@NoEffectBreakRow
		mov	ah,cs:RowBuffer[si+3]
		mov	al,ah
		shr	ah,4
		and	al,0fh
		aad
		mov	cs:RowBuffer[si+3],al
		mov	al,0dh
		jmp	@@ConvertEffectOK
@@NoEffectBreakRow:

		cmp	bl,18
		jnz	@@NoEffect18
		mov	bl,cs:RowBuffer[si+3]
		cmp	bl,0
		jnz	@@Effect18ParametersFound
		mov	bl,cs:RowParameter[di]
		mov	cs:RowBuffer[si+3],bl
@@Effect18ParametersFound:
		shr	bl,4
		mov	al,cs:S3MEffect18Compare[bx]
		and	cs:RowBuffer[si+3],0fh

		cmp	al,16h
		jnz	@@NoJumpToLoop
		or	cs:RowBuffer[si+3],10000000b
@@NoJumpToLoop:

		cmp	al,7fh
		jnz	@@ConvertEffect18OK

		cmp	bl,8
		jnz	@@NoSet4bitPanning1

		mov	al,cs:RowBuffer[si+3]
		mov	bl,17
		mul	bl
		mov	cs:RowBuffer[si+3],al
		mov	al,08h
		jmp	@@ConvertEffectOK
@@NoSet4bitPanning1:

@@ConvertEffect18OK:
		
		jmp	@@ConvertEffectOK
@@NoEffect18:


		cmp	bl,03
		jnz	@@NoVolumeEffect

		mov	al,cs:RowParameter[di]

		cmp	al,0f0h
		jz	@@VolumeSlide
		cmp	al,00fh
		jz	@@VolumeSlide

		mov	ah,al
		and	ah,0fh
		cmp	ah,0fh
		jnz	@@NoFineVolSlideUp
		shr	cs:RowBuffer[si+3],4
		mov	al,1ah
		jmp	@@ConvertEffectOK
@@NoFineVolSlideUp:

		mov	ah,al
		shr	ah,4
		cmp	ah,0fh
		jnz	@@NoFineVolSlideDown
		and	cs:RowBuffer[si+3],0fh
		mov	al,1bh
		jmp	@@ConvertEffectOK
@@NoFineVolSlideDown:

@@VolumeSlide:
		test	cs:RowBuffer[si+3],00001111b
		jz	@@NoVolumeSlideDown
		and	cs:RowBuffer[si+3],00001111b
@@NoVolumeSlideDown:
		mov	al,0ah
		jmp	@@ConvertEffectOK

@@NoVolumeEffect:

		cmp	bl,04
		jnz	@@NoSlideDown

		mov	al,cs:RowParameter[di]

		cmp	al,0dfh
		ja	@@ExtraFineSlideDown

		mov	al,02h
		jmp	@@ConvertEffectOK

@@ExtraFineSlideDown:

		cmp	al,0efh
		ja	@@FineSlideDown

		and	cs:RowBuffer[si+3],0fh
		mov	al,22h
		jmp	@@ConvertEffectOK

@@FineSlideDown:

		and	cs:RowBuffer[si+3],0fh
		mov	al,12h
		jmp	@@ConvertEffectOK

@@NoSlideDown:


		cmp	bl,05
		jnz	@@NoSlideUp

		mov	al,cs:RowParameter[di]

		cmp	al,0dfh
		ja	@@ExtraFineSlideUp

		mov	al,01h
		jmp	@@ConvertEffectOK

@@ExtraFineSlideUp:

		cmp	al,0efh
		ja	@@FineSlideUp

		and	cs:RowBuffer[si+3],0fh
		mov	al,21h
		jmp	@@ConvertEffectOK

@@FineSlideUp:

		and	cs:RowBuffer[si+3],0fh
		mov	al,11h
		jmp	@@ConvertEffectOK

@@NoSlideUp:

		cmp	bl,23
		jnz	@@NoSet7bitPanning

		cmp	cs:RowBuffer[si+3],0a4h			;surround
		jnz	@@NoSurroundPan
		mov	cs:RowBuffer[si+3],040h
		jmp	@@NoTooHighPanning
@@NoSurroundPan:
		cmp	cs:RowBuffer[si+3],80h
		jbe	@@NoTooHighPanning
		mov	al,7fh
		mov	cs:RowBuffer[si+3],0
@@NoTooHighPanning:
		mov	al,cs:RowBuffer[si+3]
		mov	bl,255
		mul	bl
		shl	ax,1
		mov	cs:RowBuffer[si+3],ah
		mov	al,08h
		jmp	@@ConvertEffectOK
@@NoSet7bitPanning:

		cmp	bl,25
		jnz	@@NoSet4bitPanning2

		mov	al,cs:RowBuffer[si+3]
		mov	bl,17
		mul	bl
		mov	cs:RowBuffer[si+3],al
		mov	al,08h
		jmp	@@ConvertEffectOK
@@NoSet4bitPanning2:
		
@@NoEffectToConvert:
		mov	al,7fh
@@ConvertEffectOK:
		mov	cs:RowBuffer[si+2],al

		inc	di
		add	si,5
		cmp	si,32*5
		jnz	@@ConvertEffects

		pop	si

		call	Repacker


@@ReadMoreChannels:

		cmp	cx,64
		jnz	@@UnpackPattern

		pop	bp

@@EndOfPattern:

		add	si,4

		pop	cx
		dec	cx
		jnz	@@TransferPatterns


		mov	ebx,cs:[RepackedSize]
		test	ebx,01111b
		jz	@@RepackedSizeAlign16
		add	ebx,16
@@RepackedSizeAlign16:
		shr	ebx,4
		mov	es,cs:[PatternMem]
		mov	ax,4A00h		;Resize repacked patternmem
		int	21h

		call	InitGUS

		cmp	cs:[ReadOnlyPatterns],1
		jz	@@EndOfS3MLoad

;------------------------------- Read Samples ---------------------------------

@@ReadSamples:

		cmp	cs:[NumOfInstruments],0
		jz	@@EndOfS3MLoad

		mov	cs:[BufferMem],9000h
		mov	ds,cs:[BufferMem]

		mov	bx,0ffffh
		mov	ax,4800h
		int	21h
		mov	ax,4800h			;Allocate max memory
		int	21h
		push	ax				;store the segment

		xor	si,si
		mov	cx,cs:[NumOfInstruments]
@@LoadInstruments:
		les	di,cs:InstrumentPointers[si]
		push	cx

		cmp	byte ptr es:[di+NumOfSamples],0
		je	@@NoIns

		add	di,InstrumentStructureSize

		mov	cx,word ptr es:[di+SampleOffset+2]
		mov	dx,word ptr es:[di+SampleOffset]
		mov	dword ptr es:[di+SampleOffset],0
		call	FileSeek
		mov	cx,es:[di+SampleSize]
		xor	dx,dx
		call	FileRead

		mov	ax,es:[di+SampleSize]
		cmp	byte ptr es:[di+SampleLoopType],0
		jz	@@NoLoopAtAll
		cmp	ax,es:[di+SampleLength]
		jb	@@NoLoopAtAll
		mov	ax,es:[di+SampleLength]
@@NoLoopAtAll:
		mov	es:[di+SampleLength],ax

		mov	ebx,cs:[GUSMemoryUsed]
		add	ebx,cs:[GUSMemoryUsed+4]
		add	ebx,cs:[GUSMemoryUsed+8]
		add	ebx,cs:[GUSMemoryUsed+12]

		mov	es:[di+SampleOffset],ebx

		xor	ecx,ecx
		mov	cx,es:[di+SampleLength]
		add	ebx,ecx
		inc	ebx
		cmp	cs:[TransferModeToUse],0
		jz	@@NoDMATransferAlign
		add	ebx,31
		and	ebx,not 31
@@NoDMATransferAlign:
		mov	eax,ebx
		shr	eax,18
		and	ebx,262143
		mov	cs:[GUSMemoryUsed],ebx
		cmp	eax,1
		jnz	@@Bank0Free
		mov	cs:[GUSMemoryUsed],262144
		mov	cs:[GUSMemoryUsed+4],ebx
@@Bank0Free:
		cmp	eax,2
		jnz	@@Bank1Free
		mov	cs:[GUSMemoryUsed],262144
		mov	cs:[GUSMemoryUsed+4],262144
		mov	cs:[GUSMemoryUsed+8],ebx
@@Bank1Free:
		cmp	eax,3
		jnz	@@Bank2Free
		mov	cs:[GUSMemoryUsed],262144
		mov	cs:[GUSMemoryUsed+4],262144
		mov	cs:[GUSMemoryUsed+8],262144
		mov	cs:[GUSMemoryUsed+12],ebx
@@Bank2Free:
		mov	ebx,es:[di+SampleOffset]

		mov	al,0	;8 bits
		mov	ah,1	;unsigned
		call	DumpSampleToGUS

@@NoIns:

		pop	cx

		add	si,4
		dec	cx
		jnz	@@LoadInstruments

		pop	es
		mov	ax,4900h
		int	21h

		xor	cx,cx
		xor	dx,dx
		mov	bx,cs:[FileHandle]
		mov	ax,4201h
		int	21h
		add	word ptr cs:[FileSize],ax
		adc	word ptr cs:[FileSize+2],dx

@@EndOfS3MLoad:

		pop	es
		pop	ds
		popad
		ret
S3MLoader	endp


;******************************** XM Loader ***********************************


XMLoader	proc	near

		cmp	word ptr cs:FileHeader[58],0104h
		jae	@@VersionSupported
		mov	cs:[ErrorCode],5
		jmp	@@EndOfXMLoad
@@VersionSupported:
	
		mov	cs:[InitialVolume],64
		mov	cs:[LoLimit],219136/8
		mov	cs:[HiLimit],4
		mov	cs:[StereoMode],1
		mov	cs:[FastVolumeSlides],0
		mov	cs:[PortamentoType],1
		mov	cs:[SampleOffsetType],1
		mov	cs:[TempoCalculationType],0

		mov	cs:[GUSMemoryUsed],0
		mov	cs:[GUSMemoryUsed+4],0
		mov	cs:[GUSMemoryUsed+8],0
		mov	cs:[GUSMemoryUsed+12],0

		mov	cs:[InstrumentInfoSize],0

		mov	di,31
@@SetMODPanning:
		mov	al,cs:[MODPanning+di]
		mov	cs:[PanningDefaults+di],al
		dec	di
		jge	@@SetMODPanning

		mov	ax,cs
		mov	ds,ax
		mov	es,ax
		mov	si,offset cs:FileHeader[17]
		mov	di,offset cs:[ModuleName]
		xor	eax,eax
		mov	cx,28/4
		rep	stosd
		mov	di,offset cs:[ModuleName]
		mov	cx,20/4
		rep	movsd

		mov	ax,word ptr cs:FileHeader[64]
		mov	cs:[RealNumOfOrders],ax
		mov	ax,word ptr cs:FileHeader[66]
		mov	cs:[RestartPosition],ax
		mov	ax,word ptr cs:FileHeader[68]
		mov	cs:[NumOfChannels],ax
		mov	ax,word ptr cs:FileHeader[70]
		mov	cs:[NumOfPatterns],ax
		mov	ax,word ptr cs:FileHeader[72]
		mov	cs:[NumOfInstruments],ax
		mov	ax,word ptr cs:FileHeader[74]
		mov	cs:[FrequencyTable],0
		test	ax,1
		jz	@@AmigaFrequencyTable
		mov	cs:[FrequencyTable],1
@@AmigaFrequencyTable:
		mov	ax,word ptr cs:FileHeader[76]
		mov	cs:[InitialSpeed],al
		mov	ax,word ptr cs:FileHeader[78]
		mov	cs:[InitialTempo],al

		xor	bx,bx
		mov	cx,cs:[RealNumOfOrders]
		xor	ah,ah
@@ReadPatternOrderData:
		mov	al,cs:FileHeader[80+bx]
		mov	cs:PatternOrder[bx],al
		cmp	al,ah
		jbe	@@NoHigherPattern
		mov	ah,al
@@NoHigherPattern:

		inc	bx
		dec	cx
		jnz	@@ReadPatternOrderData
		shr	ax,8
		inc	ax
		mov	cs:[RealNumOfPatterns],ax

		xor	cx,cx
		mov	dx,60
		add	dx,word ptr cs:FileHeader[60]
		adc	cx,word ptr cs:FileHeader[62]
		call	FileSeek

;------------------------------- Read patterns --------------------------------

		mov	cs:[UsedChannels],0

		mov	bx,0ffffh
		mov	ax,4800h
		int	21h
		mov	ax,4800h			;Allocate max memory
		int	21h
		mov	cs:[PatternMem],ax
		mov	cs:[SegPattern],ax
		mov	cs:[OfsPattern],0
		mov	cs:[BufferMem],9000h
		mov	ds,cs:[BufferMem]

		cmp	cs:[NumOfPatterns],0
		jz	@@NoPatterns

		xor	di,di
@@ClearRowData:
		mov	dword ptr cs:RowBuffer[di+0],007fffffh
		mov	cs:RowBuffer[di+4],0ffh

		add	di,5
		cmp	di,32*5
		jnz	@@ClearRowData

		xor	bp,bp
		mov	cs:[RepackedSize],0
@@ReadPatterns:
		shl	bp,2
		mov	ax,cs:[OfsPattern]
		mov	bx,cs:[SegPattern]
		mov	word ptr cs:[PatternPointers+bp],ax
		mov	word ptr cs:[PatternPointers+bp+2],bx
		shr	bp,2

		cmp	bx,9000h
		jb	@@EnoughMemoryForPatterns
		mov	cs:[ErrorCode],3
		jmp	@@EndOfXMLoad
@@EnoughMemoryForPatterns:

		xor	dx,dx
		mov	cx,4
		call	FileRead
		mov	dx,4
		mov	cx,ds:[0]
		sub	cx,4
		call	FileRead
		mov	ax,ds:[5]
		dec	ax
		mov	cs:LastRowNum[bp],al

		xor	dx,dx
		mov	cx,ds:[7]
		cmp	cx,0
		jz	@@NextPattern
		call	FileRead

		cmp	bp,cs:[RealNumOfPatterns]
		jae	@@NextPattern

		xor	si,si
		xor	ch,ch
		mov	cl,cs:LastRowNum[bp]
		inc	cx
@@UnpackPattern:

		xor	di,di
		mov	dx,cs:[NumOfChannels]
@@UnpackChannels:

		mov	bh,ds:[si]
		test	bh,10000000b
		jz	@@NonpackedData

		inc	si

		test	bh,00000001b
		jz	@@NoNote

		mov	al,ds:[si]
		cmp	al,97
		jnz	@@NoKeyOff1
		mov	al,254
		jmp	@@KeyOff1
@@NoKeyOff1:
		dec	al
		xor	ah,ah
		mov	bl,12
		div	bl
		shl	al,4
		add	al,ah
@@KeyOff1:
		mov	cs:RowBuffer[di+0],al
		inc	si
@@NoNote:
		test	bh,00000010b
		jz	@@NoInstrument
		mov	al,ds:[si]
		dec	al
		mov	cs:RowBuffer[di+1],al
		inc	si
@@NoInstrument:
		test	bh,00000100b
		jz	@@NoVolumeColumn
		mov	al,ds:[si]
		sub	al,10h
		mov	cs:RowBuffer[di+4],al
		inc	si
@@NoVolumeColumn:
		test	bh,00001000b
		jz	@@NoEffect
		mov	al,ds:[si]
		mov	cs:RowBuffer[di+2],al
		inc	si
@@NoEffect:
		test	bh,00010000b
		jz	@@NoEffectParams
		mov	al,ds:[si]
		mov	cs:RowBuffer[di+3],al
		inc	si
@@NoEffectParams:
		jmp	@@ChannelUnpacked

@@NonpackedData:
		mov	al,ds:[si]
		cmp	al,97
		jnz	@@NoKeyOff2
		mov	al,254
		jmp	@@KeyOff2
@@NoKeyOff2:
		dec	al
		xor	ah,ah
		mov	bl,12
		div	bl
		shl	al,4
		add	al,ah
@@KeyOff2:
		mov	cs:RowBuffer[di+0],al
		inc	si

		mov	al,ds:[si]
		dec	al
		mov	cs:RowBuffer[di+1],al
		inc	si

		mov	al,ds:[si]
		sub	al,10h
		mov	cs:RowBuffer[di+4],al
		inc	si

		mov	ax,ds:[si]
		mov	word ptr cs:RowBuffer[di+2],ax
		add	si,2

@@ChannelUnpacked:

;--------------------- Convert XM effects to C2M effects ----------------------

		mov	al,cs:RowBuffer[di+2]
		mov	ah,cs:RowBuffer[di+3]

		cmp	al,7fh
		jnz	@@Effect
		cmp	ah,0
		jnz	@@Effect
		mov	al,7fh
		jmp	@@ConvertEffectOK
@@Effect:
		cmp	al,0eh
		jz	@@EffectE

		cmp	al,10h
		jb	@@NormalPTEffect

		xor	bh,bh
		mov	bl,al
		sub	bx,10h
		mov	al,cs:XMEffectCompare[bx]
		cmp	al,7fh
		jnz	@@ConvertEffectOK
		mov	al,bl
		add	al,10h

		cmp	al,20
		jnz	@@NoEffectKeyOff
		xor	ah,ah
		mov	al,7fh
		mov	cs:RowBuffer[di+0],254
		jmp	@@ConvertEffectOK
@@NoEffectKeyOff:
		cmp	al,33
		jnz	@@NoExtraFineSlide
		mov	al,ah
		shr	al,4
		add	al,20h
		and	ah,00001111b
		jmp	@@ConvertEffectOK
@@NoExtraFineSlide:

		xor	ah,ah
		mov	al,7fh
		jmp	@@ConvertEffectOK

@@NormalPTEffect:

		cmp	al,0ch
		jnz	@@NoSetVolume
		cmp	ah,64
		jbe	@@NoTooHighVolume
		mov	ah,64
@@NoTooHighVolume:
		cmp	cs:RowBuffer[di+4],0ffh
		jnz	@@VoluleColumnReserved
		mov	cs:RowBuffer[di+4],ah
		mov	al,7fh
		mov	ah,0
		jmp	@@ConvertEffectOK
@@VoluleColumnReserved:
		jmp	@@ConvertEffectOK
@@NoSetVolume:

		cmp	al,0dh
		jnz	@@NoBreakRow
		mov	al,ah
		shr	ah,4
		and	al,0fh
		aad
		mov	ah,al
		mov	al,0dh
		jmp	@@ConvertEffectOK
@@NoBreakRow:

		cmp	al,0fh
		jnz	@@NoSetTempo
		cmp	cs:[VBlank],1
		jz	@@NoSetTempo
		cmp	ah,20h
		jb	@@NoSetTempo
		mov	al,0eh
@@NoSetTempo:
		jmp	@@ConvertEffectOK

@@EffectE:
		mov	al,ah
		shr	al,4
		and	ah,00001111b

		add	al,10h

		jmp	@@ConvertEffectOK

@@ConvertEffectOK:
		mov	cs:RowBuffer[di+2],al
		mov	cs:RowBuffer[di+3],ah

		add	di,5
		dec	dx
		jnz	@@UnpackChannels

		call	Repacker

		dec	cx
		jnz	@@UnpackPattern

@@NextPattern:
		inc	bp
		cmp	bp,cs:[NumOfPatterns]
		jnz	@@ReadPatterns
@@NoPatterns:

		mov	ebx,cs:[RepackedSize]
		test	ebx,01111b
		jz	@@RepackedSizeAlign16
		add	ebx,16
@@RepackedSizeAlign16:
		shr	ebx,4
		mov	es,cs:[PatternMem]
		mov	ax,4A00h		;Resize repacked patternmem
		int	21h

		call	InitGUS

;----------------------------- Read Instruments -------------------------------

		cmp	cs:[ReadOnlyPatterns],1
		jz	@@EndOfXMLoad

		cmp	cs:[NumOfInstruments],0
		jz	@@EndOfXMLoad

		mov	bx,0ffffh
		mov	ax,4800h
		int	21h
		mov	ax,4800h			;Allocate max memory
		int	21h
		mov	es,ax
		xor	di,di

		mov	cs:[BufferMem],9000h
		mov	ds,cs:[BufferMem]

		xor	bp,bp
		mov	cx,cs:[NumOfInstruments]
@@ReadInstruments:
		push	cx

		xor	dx,dx
		mov	cx,4
		call	FileRead
		mov	dx,4
		mov	cx,ds:[0]
		sub	cx,4
		call	FileRead

		mov	word ptr cs:InstrumentPointers[bp+2],es
		mov	word ptr cs:InstrumentPointers[bp],di

		add	di,InstrumentName
		xor	eax,eax
		mov	cx,28/4
		rep	stosd
		sub	di,28
		mov	si,4
		mov	cx,22/2
		rep	movsw
		sub	di,22
		sub	di,InstrumentName

		mov	byte ptr es:[di+InstrumentType],1

		mov	ax,ds:[27]
		mov	es:[di+NumOfSamples],al
		mov	cs:[XMNumOfSamples],ax

		add	cs:[InstrumentInfoSize],InstrumentStructureSize
		add	di,InstrumentStructureSize

		cmp	al,0
		jz	@@NoSamplesInInstrument

		push	bp

		mov	ax,ds:[29]
		mov	cs:[XMSampleHeaderSize],ax

		mov	si,33
		xor	bx,bx
		mov	cx,96/2
@@ReadKeyboardCompare:
		mov	ax,ds:[si]
		shl	ah,4
		add	al,ah
		mov	es:[di+KeyboardCompare+bx],al

		add	si,2
		inc	bx
		dec	cx
		jnz	@@ReadKeyboardCompare

		mov	al,ds:[233]
		mov	es:[di+VolumeType],al

		mov	al,ds:[225]
		mov	es:[di+NumOfVolumePoints],al

		mov	si,129
		xor	bx,bx
		mov	cx,48/4
@@ReadVolumeEnvelope:
		mov	ax,ds:[si]
		shl	bx,1
		mov	es:[di+VolumeEnvelopePoints+bx],ax
		shr	bx,1
		add	si,2
		mov	al,ds:[si]
		mov	es:[di+VolumeEnvelopePointValues+bx],al
		add	si,2

		inc	bx
		dec	cx
		jnz	@@ReadVolumeEnvelope

		mov	al,ds:[227]
		mov	es:[di+VolumeSustainPoint],al
		mov	al,ds:[228]
		mov	es:[di+VolumeLoopBegin],al
		mov	al,ds:[229]
		mov	es:[di+VolumeLoopEnd],al


		mov	al,ds:[234]
		mov	es:[di+PanningType],al

		mov	al,ds:[226]
		mov	es:[di+NumOfPanningPoints],al

		mov	si,177
		xor	bx,bx
		mov	cx,48/4
@@ReadPanningEnvelope:
		mov	ax,ds:[si]
		shl	bx,1
		mov	es:[di+PanningEnvelopePoints+bx],ax
		shr	bx,1
		add	si,2
		mov	al,ds:[si]
		mov	es:[di+PanningEnvelopePointValues+bx],al
		add	si,2

		inc	bx
		dec	cx
		jnz	@@ReadPanningEnvelope

		mov	al,ds:[230]
		mov	es:[di+PanningSustainPoint],al
		mov	al,ds:[231]
		mov	es:[di+PanningLoopBegin],al
		mov	al,ds:[232]
		mov	es:[di+PanningLoopEnd],al
		mov	al,ds:[234]


		mov	al,ds:[235]
		mov	es:[di+AutoVibratoType],al
		mov	al,ds:[236]
		mov	es:[di+AutoVibratoSweep],al
		mov	al,ds:[237]
		mov	es:[di+AutoVibratoDepth],al
		mov	al,ds:[238]
		mov	es:[di+AutoVibratoRate],al


		mov	ax,ds:[239]
		mov	es:[di+VolumeFadeout],ax

		add	cs:[InstrumentInfoSize],ExtendedInstrumentStructureSize
		add	di,ExtendedInstrumentStructureSize

		xor	bp,bp
@@ReadSampleInfo:

		xor	dx,dx
		mov	cx,cs:[XMSampleHeaderSize]
		call	FileRead


		mov	eax,ds:[0]
		mov	es:[di+SampleSize],eax
		shl	bp,2
		mov	cs:XMSampleSize[bp],eax
		shr	bp,2
		mov	eax,ds:[4]
		mov	es:[di+SampleLoopBegin],eax
		add	eax,ds:[8]
		mov	es:[di+SampleLength],eax

		mov	al,ds:[12]
		mov	es:[di+SampleVolume],al

		xor	ebx,ebx
		mov	bl,ds:[13]
		add	bl,128
		shl	bx,1
		mov	bx,cs:FineTuneCompare[bx]
		mov	es:[di+SampleC4Spd],bx
		xor	edx,edx
		mov	eax,8363*4096
		div	ebx
		mov	es:[di+SampleC4SpdPrecalc],eax

		mov	al,ds:[14]
		mov	ah,al
		and	al,00000011b
		mov	es:[di+SampleLoopType],al
		and	ah,00010000b
		shr	ah,4
		mov	es:[di+Sample16Bit],ah
		mov	cs:XMSample16Bit[bp],ah

		cmp	byte ptr es:[di+SampleLoopType],0
		jz	@@NoLoopCheckRequired
		mov	eax,es:[di+SampleLoopBegin]
		sub	eax,es:[di+SampleLength]
		cmp	eax,0
		jnz	@@NoLoopCheckRequired
		mov	byte ptr es:[di+SampleLoopType],0
@@NoLoopCheckRequired:

		mov	al,ds:[15]
		mov	es:[di+SamplePanning],al
		mov	al,ds:[16]
		shl	ax,8
		sar	ax,8
		mov	bl,12
		idiv	bl
		cmp	ah,0
		jge	@@PositiveNote
		add	ah,12
		dec	al
@@PositiveNote:
		shl	al,4
		add	al,ah
		mov	es:[di+SampleRelativeNote],al
		
		mov	byte ptr es:[di+SampleMute],0

		add	di,SampleName
		xor	ax,ax
		mov	cx,22/2
		rep	stosw
		sub	di,22
		mov	si,18
		mov	cx,22/2
		rep	movsw
		mov	byte ptr es:[di],0
		sub	di,22
		sub	di,SampleName

		mov	eax,es:[di+SampleSize]
		cmp	byte ptr es:[di+SampleLoopType],0
		jz	@@NoLoopAtAll
		cmp	eax,es:[di+SampleLength]
		jb	@@NoLoopAtAll
		mov	eax,es:[di+SampleLength]
@@NoLoopAtAll:
		mov	es:[di+SampleLength],eax

		shl	bp,2

		mov	cs:XMSampleLength[bp],eax

		cmp	byte ptr es:[di+Sample16Bit],0
		jz	@@GUSMemoryOrganizing8Bit

		mov	edx,es:[di+SampleLength]
		add	edx,2

		xor	ebx,ebx
@@ScanBanks16Bit:
		mov	eax,262144
		sub	eax,cs:GUSMemoryUsed[bx]
		cmp	eax,edx
		jb	@@BankFull16Bit

		mov	eax,cs:GUSMemoryUsed[bx]
		shl	ebx,18-2
		add	eax,ebx
		shr	ebx,18-2
		mov	cs:XMGUSOffset[bp],eax
		mov	es:[di+SampleOffset],eax

		add	cs:GUSMemoryUsed[bx],edx

		jmp	@@GUSMemoryOrganizingDone
@@BankFull16Bit:
		add	bx,4
		cmp	bx,16
		jnz	@@ScanBanks16Bit

		mov	byte ptr es:[di+Sample16Bit],2
		shr	bp,2
		mov	cs:XMSample16Bit[bp],2
		shl	bp,2

		shr	dword ptr es:[di+SampleSize],1
		shr	dword ptr es:[di+SampleLength],1
		shr	dword ptr es:[di+SampleLoopBegin],1

@@GUSMemoryOrganizing8Bit:
		mov	edx,es:[di+SampleLength]
		inc	edx
		xor	ebx,ebx
@@ScanBanks8Bit:
		mov	eax,262144
		sub	eax,cs:GUSMemoryUsed[bx]
		cmp	eax,edx
		jb	@@NotEnoughMemoryInBank8bit

		mov	eax,cs:GUSMemoryUsed[bx]
		shl	ebx,18-2
		add	eax,ebx
		shr	ebx,18-2
		mov	cs:XMGUSOffset[bp],eax
		mov	es:[di+SampleOffset],eax

		add	cs:GUSMemoryUsed[bx],edx
		
		jmp	@@GUSMemoryOrganizingDone
@@NotEnoughMemoryInBank8bit:
		cmp	cs:GUSMemoryUsed[bx+4],0
		jnz	@@BankFull8Bit
		sub	edx,eax
		mov	cs:GUSMemoryUsed[bx+4],edx

		mov	eax,cs:GUSMemoryUsed[bx]
		shl	ebx,18-2
		add	eax,ebx
		mov	cs:XMGUSOffset[bp],eax
		mov	es:[di+SampleOffset],eax
		shr	ebx,18-2

		mov	cs:GUSMemoryUsed[bx],262144

		jmp	@@GUSMemoryOrganizingDone
@@BankFull8Bit:
		add	bx,4
		cmp	bx,16
		jnz	@@ScanBanks8Bit
		mov	cs:XMGUSOffset[bp],1048576

@@GUSMemoryOrganizingDone:

		shr	bp,2


		xor	bx,bx
		cmp	cs:[TransferModeToUse],0
		jz	@@NoDMATransferAlign
@@DMATransferAlign:
		add	cs:[GUSMemoryUsed+bx],31
		and	cs:[GUSMemoryUsed+bx],not 31
		add	bx,4
		cmp	bx,4*4
		jnz	@@DMATransferAlign
		jmp	@@BanksAligned

@@NoDMATransferAlign:
		inc	cs:[GUSMemoryUsed+bx]
		and	cs:[GUSMemoryUsed+bx],not 1
		add	bx,4
		cmp	bx,4*4
		jnz	@@NoDMATransferAlign
@@BanksAligned:

		add	cs:[InstrumentInfoSize],SampleStructureSize
		add	di,SampleStructureSize

		inc	bp
		cmp	bp,cs:[XMNumOfSamples]
		jnz	@@ReadSampleInfo

;Move Samples to GUS!

		xor	bp,bp
@@MoveSamplesToGUS:
		shl	bp,2

		mov	cs:[XMDelta],0

		cmp	cs:XMSampleSize[bp],0
		jnz	@@SampleDataExists
		shr	bp,2
		jmp	@@EndOfSampleMove
@@SampleDataExists:

		cmp	word ptr cs:XMSampleSize[bp+2],0
		jz	@@SampleUnder64k
		xor	bx,bx
@@ReadSample64k:
		push	bx

		xor	dx,dx
		mov	cx,32768
		call	FileRead
		mov	dx,32768
		mov	cx,32768
		call	FileRead

		mov	cx,32768
		xor	si,si
		shr	bp,2
		cmp	cs:XMSample16Bit[bp],0
		jnz	@@Convert16BitSample64k

		xor	cx,cx
@@ConvertSample64k:
		mov	al,ds:[si]
		add	al,byte ptr cs:[XMDelta]
		mov	ds:[si],al
		mov	byte ptr cs:[XMDelta],al
		inc	si
		dec	cx
		jnz	@@ConvertSample64k

		jmp	@@ConvertReady64k

@@Convert16BitSample64k:
		mov	ax,ds:[si]
		add	ax,cs:[XMDelta]
		mov	cs:[XMDelta],ax
		mov	ds:[si],ax
		add	si,2
		dec	cx
		jnz	@@Convert16BitSample64k
@@ConvertReady64k:

		cmp	cs:XMSample16Bit[bp],2
		jnz	@@NoConvert16BitsInto8Bits64k
		xor	si,si
		mov	cx,32768
@@Convert16BitsInto8Bits64k:
		shl	si,1
		mov	al,ds:[si+1]
		shr	si,1
		mov	ds:[si],al

		inc	si
		dec	cx
		jnz	@@Convert16BitsInto8Bits64k
		
@@NoConvert16BitsInto8Bits64k:

		shl	bp,2

		mov	ebx,cs:XMGUSOffset[bp]

		mov	ecx,65536
		cmp	cs:XMSampleLength[bp],65536
		ja	@@Over64kSampleLeft
		mov	ecx,cs:XMSampleLength[bp]
@@Over64kSampleLeft:
		sub	cs:XMSampleLength[bp],ecx

		shr	bp,2

		add	cs:XMGUSOffset[bp],ecx

		mov	al,cs:XMSample16Bit[bp]	;8/16 bits
		cmp	cs:XMSample16Bit[bp],2
		jnz	@@NoConvert16BitsInto8BitsMode64k
		mov	al,0	;8 bits
		shr	ecx,1
		shl	bp,2
		sub	cs:XMGUSOffset[bp],ecx
		shr	bp,2
@@NoConvert16BitsInto8BitsMode64k:

		cmp	ecx,0
		jz	@@SampleMoved64k

		shl	bp,2

		mov	ah,0	;signed
		call	DumpSampleToGUS

@@SampleMoved64k:

		pop	bx

		inc	bx
		cmp	bx,word ptr cs:XMSampleSize[bp+2]
		jnz	@@ReadSample64k
@@SampleUnder64k:

		xor	dx,dx
		mov	cx,word ptr cs:XMSampleSize[bp]
		call	FileRead

		mov	cx,word ptr cs:XMSampleSize[bp]
		shr	cx,1
		xor	si,si
		shr	bp,2
		cmp	cs:XMSample16Bit[bp],0
		jnz	@@Convert16BitSample

		shl	bp,2
		mov	cx,word ptr cs:XMSampleSize[bp]
@@ConvertSample:
		mov	al,ds:[si]
		add	al,byte ptr cs:[XMDelta]
		mov	ds:[si],al
		mov	byte ptr cs:[XMDelta],al
		inc	si
		dec	cx
		jnz	@@ConvertSample
		shr	bp,2
		jmp	@@ConvertReady
@@Convert16BitSample:
		mov	ax,ds:[si]
		add	ax,cs:[XMDelta]
		mov	cs:[XMDelta],ax
		mov	ds:[si],ax
		add	si,2
		dec	cx
		jnz	@@Convert16BitSample
@@ConvertReady:

		cmp	cs:XMSample16Bit[bp],2
		jnz	@@NoConvert16BitsInto8Bits
		xor	si,si
		shl	bp,2
		mov	cx,word ptr cs:XMSampleSize[bp]
		shr	cx,1
		shr	bp,2
@@Convert16BitsInto8Bits:
		shl	si,1
		mov	al,ds:[si+1]
		shr	si,1
		mov	ds:[si],al

		inc	si
		dec	cx
		jnz	@@Convert16BitsInto8Bits
@@NoConvert16BitsInto8Bits:

		shl	bp,2
		mov	cx,word ptr cs:XMSampleLength[bp]
		shr	bp,2

		mov	al,cs:XMSample16Bit[bp] ;8/16 bits
		cmp	cs:XMSample16Bit[bp],2
		jnz	@@NoConvert16BitsInto8BitsMode
		mov	al,0	;8 bits
		shr	cx,1
@@NoConvert16BitsInto8BitsMode:

		shl	bp,2
		mov	ebx,cs:XMGUSOffset[bp]
		shr	bp,2

		cmp	cx,0
		jz	@@EndOfSampleMove

		mov	ah,0	;signed
		call	DumpSampleToGUS

@@EndOfSampleMove:

		inc	bp
		cmp	bp,cs:[XMNumOfSamples]
		jnz	@@MoveSamplesToGUS

		pop	bp
@@NoSamplesInInstrument:

		mov	bx,es
		mov	ax,di
		shr	ax,4
		and	di,15
		add	bx,ax
		mov	es,bx

		add	bp,4

		pop	cx
		dec	cx
		jnz	@@ReadInstruments

		mov	ebx,cs:[InstrumentInfoSize]
		add	ebx,15
		shr	ebx,4
		mov	es,word ptr cs:InstrumentPointers[0+2]
		mov	ax,4A00h		;Resize instrument info segment
		int	21h

		xor	cx,cx
		xor	dx,dx
		mov	bx,cs:[FileHandle]
		mov	ax,4201h
		int	21h
		add	word ptr cs:[FileSize],ax
		adc	word ptr cs:[FileSize+2],dx

@@EndOfXMLoad:

		ret
XMLoader	endp


;******************************* C2M Loader ***********************************


C2MLoader	proc	near

		ret
C2MLoader	endp


;****************************** Row Repacker **********************************


Repacker	proc	near
		pusha
		push	es

		mov	es,cs:[SegPattern]
		mov	di,cs:[OfsPattern]

		xor	si,si
		xor	bp,bp
		xor	al,al
@@RepackRow:

		cmp	cs:RowBuffer[si+0],255
		jz	@@NoNote
		or	al,00100000b
@@NoNote:
		cmp	cs:RowBuffer[si+1],255
		jz	@@NoInstrument
		or	al,00100000b
@@NoInstrument:

		cmp	cs:RowBuffer[si+2],127
		jz	@@NoEffect
		or	al,01000000b
@@NoEffect:

		cmp	cs:RowBuffer[si+3],0
		jz	@@NoEffectParams
		or	al,01000000b
@@NoEffectParams:

		cmp	cs:RowBuffer[si+4],255
		jz	@@NoVolumeColumn
		or	al,10000000b
@@NoVolumeColumn:

		test	al,11100000b
		jz	@@NothingToPack

		cmp	bp,cs:[UsedChannels]
		jb	@@NoHigherChannel
		mov	cs:[UsedChannels],bp
		inc	cs:[UsedChannels]
@@NoHigherChannel:

		mov	es:[di],al
		inc	di

		test	al,00100000b
		jz	@@NoNoteOrInstrumentToPack
		mov	dx,word ptr cs:RowBuffer[si+0]
		mov	es:[di],dx
		inc	di
		inc	di
@@NoNoteOrInstrumentToPack:

		test	al,01000000b
		jz	@@NoEffectToPack
		mov	dl,cs:RowBuffer[si+2]
		mov	es:[di],dl
		inc	di
		cmp	cs:RowBuffer[si+3],0
		jz	@@NoEffectToPack
		or	dl,10000000b
		mov	es:[di-1],dl
		mov	dh,cs:RowBuffer[si+3]
		mov	es:[di],dh
		inc	di
@@NoEffectToPack:

		test	al,10000000b
		jz	@@NoVolumeToPack
		mov	dl,cs:RowBuffer[si+4]
		mov	es:[di],dl
		inc	di
@@NoVolumeToPack:

@@NothingToPack:

		mov	dword ptr cs:RowBuffer[si+0],007fffffh
		mov	cs:RowBuffer[si+4],0ffh

		and	al,00011111b
		inc	al

		inc	bp

		add	si,5
		cmp	si,32*5
		jnz	@@RepackRow

		xor	al,al
		mov	es:[di],al				;row terminator
		inc	di

		mov	ax,cs:[OfsPattern]
		mov	cs:[OfsPattern],di
		sub	di,ax
		add	word ptr cs:[RepackedSize],di
		adc	word ptr cs:[RepackedSize+2],0

		mov	bx,cs:[OfsPattern]
		shr	bx,4
		add	bx,cs:[SegPattern]
		mov	cs:[SegPattern],bx
		and	cs:[OfsPattern],01111b

		pop	es
		popa
		ret
Repacker	endp


;**************** GUS Related Procedures Used by The Loaders ******************


InitGUS	proc	near
		pusha

		mov	bx,[UsedChannels]
		mov	[NumVoices],bl
		cmp	[NumVoices],14
		jae	@@NumOfChannelsAbove14
		mov	[NumVoices],14
@@NumOfChannelsAbove14:
		shl	bx,2
		mov	eax,[Divisors+bx]
		mov	[CurrentDivisor],eax

;	Init the UltraSound

		mov	bx,cs:[BasePort]
		mov	cx,bx
		add	bx,CommandPort
		add	cx,DataHighPort
		mov	dx,bx
		mov	al,Initialize
		out	dx,al
		mov	dx,cx
		mov	al,0
		out	dx,al
		mov	dx,cs:[BasePort]
		rept	6*10
		in	al,dx
		endm
		mov	dx,bx
		mov	al,4Ch
		out	dx,al
		mov	dx,cx
		mov	al,1
		out	dx,al
		mov	dx,cs:[BasePort]
		rept	6*10
		in	al,dx
		endm

		mov	dx,bx
		mov	al,DMACtrl
		out	dx,al
		mov	dx,cx
		mov	al,0
		out	dx,al
		mov	dx,bx
		mov	al,45h
		out	dx,al
		mov	dx,cx
		mov	al,0
		out	dx,al
		mov	dx,bx
		mov	al,49h
		out	dx,al
		mov	dx,cx
		mov	al,0
		out	dx,al

		mov	dx,bx
		mov	al,VoicesActive
		out	dx,al
		mov	dx,cx
		mov	al,cs:[NumVoices]
		dec	al
		or	al,0C0h
		out	dx,al

		mov	dx,cs:[BasePort]
		add	dx,StatusPort
		in	al,dx
		mov	dx,bx
		mov	al,DMACtrl
		out	dx,al
		mov	dx,cx
		in	al,dx
		mov	dx,bx
		mov	al,49h
		out	dx,al
		mov	dx,cx
		in	al,dx
		mov	dx,bx
		mov	al,8Fh
		out	dx,al
		mov	dx,cx
		in	al,dx

		push	cx
		mov	cx,32
@@VoiceClearLoop:
		mov	dx,cs:[BasePort]
		add	dx,ActiveVoicePort
		mov	al,cl
		dec	al
		out	dx,al
		inc	dx
		mov	al,0
		out	dx,al
		add	dx,2
		mov	al,3	; Voice Off
		out	dx,al
		sub	dx,2
		mov	al,0Dh
		out	dx,al
		add	dx,2
		mov	al,3	; Ramp Off
		out	dx,al
		dec	cx
		jnz	@@VoiceClearLoop
		pop	cx

; Set up DMA and IRQ

		push	bx

		mov	dx,cs:[BasePort]	;SETUP FOR DIGITAL ASIC
		add	dx,0fh
		mov	al,5
		out	dx,al
		sub	dx,0fh
		mov	al,3
		out	dx,al
		add	dx,IRQDMACtrlPort
		mov	al,0
		out	dx,al
		add	dx,0fh-IRQDMACtrlPort
		out	dx,al
		sub	dx,0fh

		mov	al,00000011b
		out	dx,al
		add	dx,IRQDMACtrlPort
		mov	bx,cs:[GUSDMA]
		mov	al,[DMAToPort+BX]
		out	dx,al			;SET DMA
		sub	dx,IRQDMACtrlPort

		mov	al,01000011b
		out	dx,al
		add	dx,IRQDMACtrlPort
		mov	bx,cs:[GUSIRQ]
		mov	al,[IRQToPort+BX]
		out	dx,al			;SET IRQ

		add	dx,ActiveVoicePort-IRQDMACtrlPort
		mov	al,0
		out	dx,al
		sub	dx,ActiveVoicePort
		mov	al,9			;SETUP DMA LATCH
		out	dx,al
		add	dx,ActiveVoicePort
		mov	al,0
		out	dx,al

		pop	bx

		mov	dx,bx
		mov	al,DMACtrl
		out	dx,al
		mov	dx,cx
		in	al,dx
		mov	dx,bx
		mov	al,49h
		out	dx,al
		mov	dx,cx
		in	al,dx
		mov	dx,bx
		mov	al,8Fh
		out	dx,al
		mov	dx,cx
		in	al,dx

		mov	dx,bx
		mov	al,Initialize
		out	dx,al
		mov	dx,cx
		mov	al,7
		out	dx,al

		xor	ch,ch
		mov	cl,cs:[NumVoices]
@@SetRampRateLoop:
		mov	dx,cs:[BasePort]
		add	dx,ActiveVoicePort
		mov	al,cs:[NumVoices]
		sub	al,cl
		out	dx,al

		mov	dx,cs:[BasePort]
		add	dx,CommandPort
		mov	al,VolRampRate
		out	dx,al
		mov	al,00011111b
		mov	dx,cs:[BasePort]
		add	dx,DataHighPort
		out	dx,al

		mov	dx,cs:[BasePort]
		add	dx,CommandPort
		mov	al,SetVolume
		out	dx,al
		mov	ax,cs:[GUSVol]
		add	ax,20000
		mov	dx,cs:[BasePort]
		add	dx,DataLowPort
		out	dx,ax
		dec	cx
		jnz	@@SetRampRateLoop

		mov	cs:[DMAInitialized],0

		popa
		ret
InitGUS	endp

DumpSampleToGUS	proc	near
; ebx	GUS Offset
; ds	segment of dumped data (must be a page for DMA transfer)
; cx	num of bytes to dump, 0=64k
; al	0=8bit, 1=16bit
; ah	0=signed, 1=unsigned

		cmp	cs:[TransferModeToUse],1
		jz	@@DMATransfer

		push	si

		cmp	ah,0
		jz	@@SignedSampleData
		xor	ah,ah
		push	cx
		xor	si,si
@@ConvertSampleData:
		sub	cx,ax
		add	si,ax
		xor	byte ptr ds:[si],128
		inc	si
		dec	cx
		jnz	@@ConvertSampleData
		pop	cx
@@SignedSampleData:

		xor	si,si
		mov	dx,cs:[BasePort]
		add	dx,CommandPort
@@MoveSampleToGUS:
		mov	al,DRAMAddrLo
		out	dx,al
		inc	dx
		mov	eax,ebx
		out	dx,ax
		dec	dx
		mov	al,DRAMAddrHi
		out	dx,al
		add	dx,2
		shr	eax,16
		out	dx,al
		add	dx,2
		mov	al,ds:[si]
		out	dx,al
		sub	dx,4
		inc	si
		inc	ebx
		dec	cx
		jnz	@@MoveSampleToGUS

		pop	si

		ret

@@DMATransfer:
		cmp	cs:[DMAInitialized],1
		jz	@@DMAInitialized

		mov	cs:[DMAInitialized],1

		pushad

		cli

		mov	cx,4
@@NextInitTransfer:

		mov	dx,cs:[BasePort]	;stop GUS DMA & clear all pending irqs
		add	dx,CommandPort
		mov	al,DMACtrl
		out	dx,al
		add	dx,2
		in	al,dx			;clear irq, but master irq is disabled
		mov	dx,cs:[BasePort]	;there happened no irq
		add	dx,StatusPort
		in	al,dx

		xor	dh,dh

		mov	si,cs:[GUSDMA]
		cmp	si,4
		mov	dl,cs:[DMAMask+si]
		mov	al,byte ptr cs:[GUSDMA]
		or	al,4
		out	dx,al			;Mask DMA-channel
		mov	dl,cs:[DMAClear+si]
		xor	al,al
		out	dx,al			;DMA clear
		mov	dl,cs:[DMAMode+si]
		mov	al,byte ptr cs:[GUSDMA]
		and	al,3
		or	al,01001000b
		out	dx,al			;DMA-mode for GUS
		mov	dl,cs:[DMAAddress+si]
		mov	al,0
		out	dx,al			;offset low
		mov	al,0
		out	dx,al			;offset high
		mov	dl,cs:[DMACount+si]
		mov	al,1
		out	dx,al
		mov	al,0
		out	dx,al
		mov	dl,cs:[DMAPage+si]
		mov	al,0
		out	dx,al
		mov	dl,cs:[DMAMask+si]
		mov	ax,si
		and	al,3
		out	dx,al			;demask DMA-channel

		mov	dx,cs:[BasePort]	;setup GUS for DMA transfer
		add	dx,CommandPort
		mov	al,DMAAddr		;set DMA address
		out	dx,al
		cmp	si,4
		xor	eax,eax
		inc	dx
		out	dx,ax
		dec	dx
		mov	al,DMACtrl
		out	dx,al
		inc	dx
		inc	dx
		mov	ax,si
		and	al,4			;select 8/16-bit channel
		or	al,00100001b		;start DMA transfer
		out	dx,al

		xor	dh,dh
		mov	dl,cs:[DMAStatus+si]
		mov	ah,cs:[DMAStatusBits+si]
@@InitTransferLoop:
		in	al,dx			;wait for transfer end
		test	al,ah
		jz	@@InitTransferLoop

		mov	dx,cs:[BasePort]	;stop GUS DMA
		add	dx,CommandPort
		mov	al,DMACtrl
		out	dx,al
		add	dx,2
		in	al,dx			;clear irq, but master irq is disabled
		mov	dx,cs:[BasePort]	;there happened no irq
		add	dx,StatusPort
		in	al,dx


		dec	cx
		jnz	@@NextInitTransfer

		sti

		popad
@@DMAInitialized:

		inc	cx
		and	cx,not 1

		cmp	cx,0
		jnz	@@Under64KTransfer

		mov	cx,65536-4

		call	@@Under64KTransfer

		mov	edx,ds:[65536-4]
		mov	ds:[0],edx

		add	ebx,65536-4
		mov	cx,4
@@Under64KTransfer:

		mov	edx,ebx
		and	edx,3ffffh
		and	ecx,0ffffh
		add	edx,ecx
		test	edx,0c0000h
		jz	@@NoGUSBankCrossed

		sub	cx,dx

		call	@@NoGUSBankCrossed

		and	ecx,0ffffh
		add	ebx,ecx

		push	bx es di si

		mov	bx,ds
		mov	es,bx
		xor	di,di
		mov	si,cx
		mov	cx,dx
		add	cx,3
		shr	ecx,2
		rep	movsd

		pop	si di es bx

		mov	cx,dx

@@NoGUSBankCrossed:

		pushad

		cli

		push	ebx			;store GUS offset
		mov	di,ax			;store bit/data info

		mov	dx,cs:[BasePort]	;stop GUS DMA & clear all pending irqs
		add	dx,CommandPort
		mov	al,DMACtrl
		out	dx,al
		add	dx,2
		in	al,dx			;clear irq, but master irq is disabled
		mov	dx,cs:[BasePort]	;there happened no irq
		add	dx,StatusPort
		in	al,dx

		xor	dh,dh

		mov	bx,ds
		mov	ax,bx			;convert address to page and offset
		shl	bx,4			;offset
		shr	ah,4			;page
		mov	al,ah
		mov	si,cs:[GUSDMA]
		cmp	si,4
		jb	@@DMA8Bits1
		shrd	bx,ax,1			;address for 16-bit DMA
		shr	cx,1
@@DMA8Bits1:
		mov	dl,cs:[DMAMask+si]
		mov	al,byte ptr cs:[GUSDMA]
		or	al,4
		out	dx,al			;Mask DMA-channel
		mov	dl,cs:[DMAClear+si]
		xor	al,al
		out	dx,al			;DMA clear
		mov	dl,cs:[DMAMode+si]
		mov	al,byte ptr cs:[GUSDMA]
		and	al,3
		or	al,01001000b
		out	dx,al			;DMA-mode for GUS
		mov	dl,cs:[DMAAddress+si]
		mov	al,bl			;DMA channel 1-4
		out	dx,al			;offset low
		mov	al,bh
		out	dx,al			;offset high
		mov	dl,cs:[DMACount+si]
		mov	al,cl
		out	dx,al			;size low
		mov	al,ch
		out	dx,al			;size high
		mov	dl,cs:[DMAPage+si]
		mov	al,ah
		out	dx,al			;page
		mov	dl,cs:[DMAMask+si]
		mov	ax,si
		and	al,3
		out	dx,al			;demask DMA-channel

		pop	ebx			;get GUS offset

		mov	dx,cs:[BasePort]	;setup GUS for DMA transfer
		add	dx,CommandPort
		mov	al,DMAAddr		;set DMA address
		out	dx,al
		cmp	si,4
		jb	@@DMA8Bits2
		mov	eax,ebx
		and	ebx,0c0000h
		and	eax,03ffffh
		shr	eax,1
		add	ebx,eax
@@DMA8Bits2:
		mov	eax,ebx
		shr	eax,4
		inc	dx	
		out	dx,ax
		dec	dx
		mov	al,DMACtrl
		out	dx,al
		inc	dx
		inc	dx
		mov	ax,si
		and	al,4			;select 8/16-bit channel
		mov	bx,di			;get bit/data info
		cmp	bh,0
		jz	@@SignedDMATransfer
		or	al,10000000b		;select signed/unsigned
@@SignedDMATransfer:
		cmp	bl,1
		jnz	@@Transfer8BitData
		or	al,01000000b
@@Transfer8BitData:
		or	al,00100001b		;start DMA transfer
		out	dx,al

		xor	dh,dh
		mov	dl,cs:[DMAStatus+si]
		mov	ah,cs:[DMAStatusBits+si]
@@TransferLoop:
		in	al,dx			;wait for transfer end
		test	al,ah
		jz	@@TransferLoop

		mov	dx,cs:[BasePort]	;stop GUS DMA
		add	dx,CommandPort
		mov	al,DMACtrl
		out	dx,al
		add	dx,2
		in	al,dx			;clear irq, but master irq is disabled
		mov	dx,cs:[BasePort]	;there happened no irq
		add	dx,StatusPort
		in	al,dx

		sti

		popad

		ret
DumpSampleToGUS	endp

PrepareSamples	proc	near
		pusha
		push	es

		cmp	cs:[NumOfInstruments],0
		jz	@@NoInstruments

		xor	bp,bp
@@PrepareInstrument:

		shl	bp,2
		les	si,cs:InstrumentPointers[bp]
		shr	bp,2

		mov	cl,es:[si+NumOfSamples]
		cmp	byte ptr es:[si+InstrumentType],1
		jnz	@@NormalInstrument
		add	si,ExtendedInstrumentStructureSize
@@NormalInstrument:
		add	si,InstrumentStructureSize
		cmp	cl,0
		jz	@@EmptyInstrument
@@PrepareSample:

		cmp	byte ptr es:[si+Sample16Bit],1
		jz	@@Prepare16BitSample

		mov	ebx,es:[si+SampleLength]
		dec	ebx
		cmp	byte ptr es:[si+SampleLoopType],0
		jz	@@NoLooping8BitSample
		mov	ebx,es:[si+SampleLoopBegin]
@@NoLooping8BitSample:
		add	ebx,es:[si+SampleOffset]

		mov	dx,cs:[BasePort]
		add	dx,CommandPort

		mov	al,DRAMAddrLo
		out	dx,al
		inc	dx
		mov	eax,ebx
		out	dx,ax
		dec	dx
		mov	al,DRAMAddrHi
		out	dx,al
		add	dx,2
		shr	eax,16
		out	dx,al
		add	dx,2
		in	al,dx
		mov	ch,al
		sub	dx,4

		mov	ebx,es:[si+SampleLength]
		add	ebx,es:[si+SampleOffset]

		mov	al,DRAMAddrLo
		out	dx,al
		inc	dx
		mov	eax,ebx
		out	dx,ax
		dec	dx
		mov	al,DRAMAddrHi
		out	dx,al
		add	dx,2
		shr	eax,16
		out	dx,al
		add	dx,2
		mov	al,ch
		out	dx,al
		sub	dx,4

		jmp	@@Prepare8BitSample

@@Prepare16BitSample:

		mov	ebx,es:[si+SampleLength]
		sub	ebx,2
		cmp	byte ptr es:[si+SampleLoopType],1
		jnz	@@NoLooping16BitSample
		mov	ebx,es:[si+SampleLoopBegin]
@@NoLooping16BitSample:
		add	ebx,es:[si+SampleOffset]

		push	cx

		mov	dx,cs:[BasePort]
		add	dx,CommandPort

		mov	al,DRAMAddrLo
		out	dx,al
		inc	dx
		mov	eax,ebx
		out	dx,ax
		dec	dx
		mov	al,DRAMAddrHi
		out	dx,al
		add	dx,2
		shr	eax,16
		out	dx,al
		add	dx,2
		in	al,dx
		mov	ch,al
		sub	dx,4
		inc	ebx

		mov	al,DRAMAddrLo
		out	dx,al
		inc	dx
		mov	eax,ebx
		out	dx,ax
		dec	dx
		mov	al,DRAMAddrHi
		out	dx,al
		add	dx,2
		shr	eax,16
		out	dx,al
		add	dx,2
		in	al,dx
		mov	cl,al
		sub	dx,4

		mov	ebx,es:[si+SampleLength]
		add	ebx,es:[si+SampleOffset]

		mov	al,DRAMAddrLo
		out	dx,al
		inc	dx
		mov	eax,ebx
		out	dx,ax
		dec	dx
		mov	al,DRAMAddrHi
		out	dx,al
		add	dx,2
		shr	eax,16
		out	dx,al
		add	dx,2
		mov	al,ch
		out	dx,al
		sub	dx,4
		inc	ebx

		mov	al,DRAMAddrLo
		out	dx,al
		inc	dx
		mov	eax,ebx
		out	dx,ax
		dec	dx
		mov	al,DRAMAddrHi
		out	dx,al
		add	dx,2
		shr	eax,16
		out	dx,al
		add	dx,2
		mov	al,cl
		out	dx,al
		sub	dx,4

		pop	cx

@@Prepare8BitSample:

		add	si,SampleStructureSize

		dec	cl
		jnz	@@PrepareSample
@@EmptyInstrument:

		inc	bp
		cmp	bp,cs:[NumOfInstruments]
		jnz	@@PrepareInstrument
@@NoInstruments:

		pop	es
		popa
		ret
PrepareSamples	endp


;********************** Procedures Used by The Loaders ************************


FileSeek	proc	near
		push	ax
		push	bx
		push	cx			;cx=high word
		push	dx			;dx=low word

		add	dx,word ptr cs:[FileStartOffset]
		adc	cx,word ptr cs:[FileStartOffset+2]

		mov	bx,cs:[FileHandle]
		mov	ax,4200h
		int	21h
		jnc	@@NoFileSeekError
		mov	cs:[ErrorCode],2
@@NoFileSeekError:
		pop	dx
		pop	cx
		pop	bx
		pop	ax

		ret
FileSeek	endp


FileRead	proc	near

		push	ax
		push	bx
		push	cx
		push	dx
		push	ds
		mov	ax,3F00h
		mov	bx,cs:[FileHandle]
		int	21h
		jc	@@FileReadError
		cmp	ax,cx
		jnz	@@FileReadError
		pop	ds
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		ret
@@FileReadError:
		mov	cs:[ErrorCode],2
		pop	ds
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		ret

FileRead	endp

FileOpen	proc	near
		push	ax
		push	dx
		push	ds
		mov	ax,3D00h
		int	21h
		mov	cs:[FileHandle],ax
		jnc	@@NoErrorOpen
		mov	cs:[ErrorCode],1
@@NoErrorOpen:
		pop	ds
		pop	dx
		pop	ax
		ret
FileOpen	endp

FileClose	proc	near
		push	ax
		push	bx
		mov	ax,3E00h
		mov	bx,cs:[FileHandle]
		int	21h
		pop	bx
		pop	ax
		ret
FileClose	endp
