/*
 * Module: Space.c for SMC Ethernet LAN Adapters
 * Project: UMAC/LMAC for SMC LAN Adapters UNIX Driver
 *
 *
 *		Copyright (c) 1993 by Standard MicroSystems Corporation
 *		All rights reserved.  Contains confidential information and
 *		trade secrets proprietary to
 *			Standard MicroSystems Corporation
 *			6 Hughes
 *			Irvine, California  92718
 *
 */
#ident "@(#)Space.c	1.0 - 93/06/19"
/*
 * Configuration file for WD8003 series boards
 *	-- WD8003E (Ethernet), WD8003EBT (Ethernet with Boot Rom),
 *	   WD8003ET/A, WD8003E/A (Ethernet Micro Channel*),
 *	   WD8003WT (Ethernet Twisted-pair),
 * 	   WD8003S (Starlan), WD8003SH (Starlan with on-board Hub),
 *	   WD8003ST/A (Starlan Micro Channel).
 * All user configurable options are here (automatically set for
 *	Micro Channel cards).
 *
 *	* Micro Channel is a trademark of IBM
 */

#include "sys/types.h"
#include "sys/stream.h"
#include "sys/smc.h"
/* Include the following for LAI_TCP */
#include "sys/socket.h"
#include "sys/net/if.h"
/************************/
#include "sys/macstat.h" /* DLPI */
#include "config.h"

#define SMEDEBUG	0	/* Enable/Disable driver debugging */

#define MAXMULTI	16		/* Number of multicast addrs/board */

#if defined(SME3_UNITS)
#define NSME	4
#define TOT_UNITS (SME3_UNITS+SME2_UNITS+SME1_UNITS+SME0_UNITS)
#elif defined(SME2_UNITS)
#define NSME	3
#define TOT_UNITS (SME2_UNITS+SME1_UNITS+SME0_UNITS)
#elif defined(SME1_UNITS)
#define NSME	2
#define TOT_UNITS (SME1_UNITS+SME0_UNITS)
#else
#define NSME	1
#define TOT_UNITS (SME0_UNITS)
#endif


struct smedev smedevs[TOT_UNITS];
struct smestat smestats[NSME];
Adapter_Struc smeparams[NSME]; 
struct mac_stats emacstats[NSME];  /* DLPI */
int    sme_boardcnt = NSME;
/* Define the following for LAI_TCP */
struct	ifstats	smes_ifstats[NSME];
int	smeboardfirst[NSME];
/*******/

struct smemaddr smemultiaddrs[NSME * MAXMULTI];	/* multicast addr storage */
int    sme_multisize = MAXMULTI;		/* # of multicast addrs/board */

int 	     sme_debug = SMEDEBUG;		/* can be enabled dynamically */

struct initparms smeinitp[NSME] = {
#if SME0_0
    {
	0,				/* board index */
	SME0_0_VECT,			/* interrupt level */
	SME0_0_SIOA,			/* I/O port for device */
	SME0_0_SCMA,		/* address of board's memory */
	SME0_0_ECMA - SME0_0_SCMA + 1,	/* memory size */
	SME0_UNITS			/* number of minor devices allowed */
    },
#endif /* SME_0 */
#if SME1_0
    {
	1,				/* board index */
	SME1_0_VECT,			/* interrupt level */
	SME1_0_SIOA,			/* I/O port for device */
	SME1_0_SCMA,		/* address of board's memory */
	SME1_0_ECMA - SME1_0_SCMA + 1,	/* memory size */
	SME1_UNITS			/* number of minor devices allowed */
    },
#endif /* SME1_0 */
#if SME2_0 
    {
	2,				/* board index */
	SME2_0_VECT,			/* interrupt level */
	SME2_0_SIOA,			/* I/O port for device */
	SME2_0_SCMA,		/* address of board's memory */
	SME2_0_ECMA - SME2_0_SCMA + 1,	/* memory size */
	SME2_UNITS			/* number of minor devices allowed */
    },
#endif /* SME2_0 */
#if SME3_0
    {
	3,				/* board index */
	SME3_0_VECT,			/* interrupt level */
	SME3_0_SIOA,			/* I/O port for device */
	SME3_0_SCMA,		/* address of board's memory */
	SME3_0_ECMA - SME3_0_SCMA + 1,	/* memory size */
	SME3_UNITS			/* number of minor devices allowed */
    },
#endif /* SME3_0 */
};
