/*
 * Module: Header File for SMC Ethernet LAN Adapters
 * Project: UMAC/LMAC for UNIX SVR3.2
 *
 *
 *		Copyright (c) 1993 by Standard MicroSystems Corporation
 *		All rights reserved.  Contains confidential information and
 *		trade secrets proprietary to
 *			Standard MicroSystems Corporation
 *			6 Hughes
 *			Irvine, California  92718
 *
 */


#ident "@(#)smc.h	1.00 - 93/06/10"

/*
 *
 * Revision History:
 *
 * 1.0   T_NGO 06/10/93 Created
 *
 *
 */


#ifndef	FALSE
#define	FALSE	0
#endif

#ifndef	TRUE
#define	TRUE 1
#endif

typedef	int LM_STATUS;
typedef	unsigned int UINT;
typedef	unsigned long ULONG;
typedef	unsigned long *PULONG;
typedef	unsigned short USHORT;
typedef	unsigned short *PUSHORT;
typedef	unsigned char UCHAR;
typedef	unsigned char *PUCHAR;
typedef	char	BOOLEAN;
typedef	void VOID;
#ifndef MC_SLOTS
#define MC_SLOTS 8
#endif

#define SRC_ALIGN	0
#define DEST_ALIGN	1

#define nextsize(len) ((len+64)*2)

/*
 * Configuration options for WD 8003
 */

#define SMEVPKTSZ	(3*256)
#define SMEHIWAT		(32*SMEVPKTSZ)
#define SMELOWAT		(8*SMEVPKTSZ)
#define SMEMAXPKT	1500
#define SMEMAXPKTLLC	1497	/* max packet when using LLC1 */
#define SMEMINSEND	60	/* 64 - 4 bytes CRC */
#define SMEMINRECV	60	/* 64 - 4 bytes CRC */
#define NUM_TX_BUFFERS  2


/* status bits */
#define SMES_OPEN	0x01	/* minor device is opened */
#define SMES_PROM	0x02	/* promiscuous mode enabled */
#define SMES_XWAIT	0x04	/* waiting to be rescheduled */
#define SMES_ISO		0x08	/* ISO address has been bound */
#define SMES_SU		0x80	/* opened by privileged user */
#define SMES_RWAIT	0x100	/* waiting for read reschedule */

/* link protocol type */
/* defined in lihdr.h */

#define		ismulticast(mp)	(*mp->b_rptr&1)

struct smemaddr {
   unsigned char filterbit;	/* the hashed value of entry */
   unsigned char entry[6];		/* multicast addresses are 6 bytes */
   unsigned char dummy;	      /* For alignment problems with SCO */
};

union crc_reg {			/* structure for software crc */
	unsigned int value;
	struct {
		unsigned a0	:1;
		unsigned a1	:1;
		unsigned a2	:1;
		unsigned a3	:1;
		unsigned a4	:1;
		unsigned a5	:1;
		unsigned a6	:1;
		unsigned a7	:1;
		unsigned a8	:1;
		unsigned a9	:1;
		unsigned a10	:1;
		unsigned a11	:1;
		unsigned a12	:1;
		unsigned a13	:1;
		unsigned a14	:1;
		unsigned a15	:1;
		unsigned a16	:1;
		unsigned a17	:1;
		unsigned a18	:1;
		unsigned a19	:1;
		unsigned a20	:1;
		unsigned a21	:1;
		unsigned a22	:1;
		unsigned a23	:1;
		unsigned a24	:1;
		unsigned a25	:1;
		unsigned a26	:1;
		unsigned a27	:1;
		unsigned a28	:1;
		unsigned a29	:1;
		unsigned a30	:1;
		unsigned a31	:1;
	} bits;
};

/* this structure is a kludge to get UNIX to accept the LM 
   adapter structure guidelines */

struct initparms {
	ushort adapter_num;
	ushort irq_value;
	ushort io_base;
	ulong ram_base;
	ulong ram_size;
	ushort sme_minors;
/*
	ushort media_type;
	/*caddr_t adapter_text_ptr;*/
};


typedef struct _ADAPTER_STRUC{


	unsigned char		adapter_num;
	unsigned char		pc_bus;
	unsigned short		io_base;
  	unsigned char		adapter_name[12];
  	unsigned short		irq_value;   
  	unsigned short		rom_size;
  	unsigned long		rom_base;
	unsigned long		rom_access;	/* OS dependent */
  	unsigned short		ram_size;
  	unsigned long		ram_base;
  	unsigned long		ram_access;	/* OS dependent */
  	unsigned short		ram_usable;
  	unsigned short		io_base_new;	/* for PutConfig */
  	unsigned char		node_address[6];
  	unsigned short		max_packet_size;
  	unsigned short		num_of_tx_buffs;
  	unsigned short		receive_mask;
  	unsigned short		adapter_status;
  	unsigned short		media_type;
	unsigned short		adapter_bus;
	unsigned short		pos_id;	
	unsigned short		adapter_flags;
  	unsigned char		slot_num;
	unsigned char		rx_lookahead_size;	/* Size of UMAC's max lookahead size*/
							/* in 16-byte chunks.*/
/* Local vars for each adapter 
*/

	unsigned short		bic_type;
	unsigned short		nic_type;
	unsigned long		board_id;
/*
	unsigned short		board_id;
	unsigned short		extra_info;
*/
	unsigned short		mode_bits;
	unsigned short		status_bits;
	unsigned short		xmit_buf_size;
	unsigned short		xmit_flag_offset;
	unsigned short		config_mode;      /* 1 to save to EEROM, 0 for local save */
	unsigned short		page_offset_mask;
	unsigned long		*easp;
	unsigned char	LaarEnter;
	unsigned char	LaarExit;
	unsigned char	InterruptMask;
/*
 * Early Stuff
 */
	unsigned char	XmitRetry;
	unsigned int	XmitThreshold;
	unsigned short Early_Rx_Slope;


   caddr_t	    ptr_rx_crc_errors;
   caddr_t	    ptr_rx_too_big;
   caddr_t	    ptr_rx_lost_pkts;
   caddr_t	    ptr_rx_align_errors;
   caddr_t	    ptr_rx_overruns;
   caddr_t	    ptr_tx_deferred;
   caddr_t	    ptr_tx_max_collisions;
   caddr_t	    ptr_tx_one_collision;
   caddr_t	    ptr_tx_mult_collisions;
   caddr_t	    ptr_tx_ow_collisions;
   caddr_t	    ptr_tx_CD_heartbeat;
   caddr_t	    ptr_tx_carrier_lost;
   caddr_t	    ptr_tx_underruns;

/* now we have our smc-unix unique stuff */

   short    sme_minors;		/* number of minor devices allowed */
   short    sme_bflags;		/* flags used for various config options */
   short    sme_major;		/* major device number */
   short    sme_firstd;		/* first minor device for this major */
   int	   sme_noboard;	/* board present flag */
   int	   sme_str_open;	/* number of streams open */
   long	   sme_nextq;		/* next queue to be scheduled */
   int	   sme_enabled;	/* board has been enabled. can now receive data */
   int	   sme_init;		/* board has been initialized */
   unsigned char perm_node_address[6]; /* uniq node addr for this lan */

   int	   sme_txbuf_busy;	/* flag for transmission buffer */
   unsigned char   sme_nxtpkt;		/* page # of next packet to remove */
   long	    sme_ncount;		/* count of bufcalls */
   long	    sme_proms;		/* number of promiscuous streams */
   long	    sme_devmode;		/* device mode (e.g. PROM) */
   int	    sme_multicnt;	/* number of defined multicast addresses */
   struct   smemaddr *sme_multip; /* last referenced multicast address */
   struct   smemaddr *sme_multiaddrs;	/* array of multicast addresses */
}Adapter_Struc, *Ptr_Adapter_Struc;


/*
 *  NOTE: Structure should be ordered so that they will pack on 2 byte
 *  boundaries.
 */

struct smedev {
   unsigned short  sme_flags;	/* flags to indicate various status' */
   unsigned short  sme_type;	/* LLC/Ether */
   queue_t	  *sme_qptr;	/* points queue associated with open device */
   unsigned short  sme_mask;	/* mask for ether type or LLC SAPs */
   unsigned short  sme_state;	/* state variable for DL_INFO */
   long		   sme_sap;	/* sap or ethertype depending on sme_type */
   long		   sme_oldsap;
   Ptr_Adapter_Struc sme_macpar;	/* board specific parameters */
   struct smestat  *sme_stats;	/* driver and board statistics */
#ifdef DLPI
   struct mac_stats *pmac_stats;	/* driver statistics */
#endif
   unsigned short  sme_no;	/* index number from front of array */
   unsigned short  sme_rws;	/* receive window size - for LLC2 */
   unsigned short  sme_sws;	/* send window size - for LLC2 */
   unsigned short  sme_rseq;	/* receive sequence number - for LLC2 */
   unsigned short  sme_sseq;	/* send sequence number - for LLC2 */
   unsigned short  sme_snap[3];	/* for SNAP and other extentions */
};

/* board config (bflags) */
#define SMEF_MEM16OK   0x01	/* safe to leave board in MEM16 mode and not */
				/* disable interrupts on the smebcopy */
#define SMEF_NODISABLE 0x02	/* is it safe to not disable interrupts during */
				/* MEM16 operation */

/* Debug Flags and other info */

#define SMESYSCALL	0x01	/* trace syscall functions */
#define SMEPUTPROC	0x02	/* trace put procedures */
#define SMESRVPROC	0x04	/* trace service procedures */
#define SMERECV		0x08	/* trace receive processing */
#define SMERCVERR	0x10	/* trace receive errors */
#define SMEDLPRIM	0x20	/* trace DL primitives */
#define SMEINFODMP	0x40	/* dump info req data */
#define SMEDLPRIMERR	0x80	/* mostly llccmds errors */
#define SMEDLSTATE      0x100	/* print state chages */
#define SMETRACE	       0x200	/* trace loops */
#define SMEINTR	       0x400	/* trace interrupt processing */
#define SMEBOARD	       0x800	/* trace access to the board */
#define SMELLC1	      0x1000	/* trace llc1 processing */
#define SMESEND	      0x2000	/* trace sending */
#define SMEBUFFER      0x4000	/* trace buffer/canput fails */
#define SMESCHED       0x8000	/* trace scheduler calls */
#define SMEXTRACE      0x10000	/* trace wdsend attempts */
#define SMEMULTHDW     0x20000	/* trace multicast register filter bits */
#define SMEOVERFLOW     0x40000	/* trace OVW */
#define SMEIOCTL     0x80000	/* trace IOCTL */

/* define llc class 1 and mac structures and macros */

struct llctype {
   unsigned short	llc_length;
   unsigned char	llc_dsap;
   unsigned char	llc_ssap;
   unsigned char	llc_control;
   unsigned char	llc_info[1];
};

struct ethertype {
   unsigned short ether_type;
   unsigned char ether_data[1];
};

struct sme_machdr {
   unsigned char mac_dst[6];
   unsigned char mac_src[6];
   union {
      struct ethertype ether;
      struct llctype llc;
   } mac_llc;
};

typedef struct sme_machdr machdr_t;

#define LLC_SAP_LEN	1	/* length of sap only field */
#define LLC_LSAP_LEN	2	/* length of sap/type field  */
#define LLC_TYPE_LEN    2	/* ethernet type field length */
#define LLC_ADDR_LEN	6	/* length of 802.3/ethernet address */
#define LLC_LSAP_HDR_SIZE 3
#define LLC_SNAP_SIZE   5	/* SNAP header size */
#define LLC_HDR_SIZE	(LLC_ADDR_LEN+LLC_ADDR_LEN+LLC_LSAP_HDR_SIZE+LLC_LSAP_LEN)
#define LLC_EHDR_SIZE	(LLC_ADDR_LEN+LLC_ADDR_LEN+LLC_TYPE_LEN)

#define LLC_LIADDR_LEN	(LLC_ADDR_LEN+LLC_SAP_LEN)
#define LLC_ENADDR_LEN  (LLC_ADDR_LEN+LLC_TYPE_LEN)

union llc_bind_fmt {
   struct llca {
      unsigned char  lbf_addr[LLC_ADDR_LEN];
      unsigned short lbf_sap;
   } llca;
   struct llcb {
      unsigned char  lbf_addr[LLC_ADDR_LEN];
      unsigned short lbf_sap;
      unsigned long  lbf_xsap;
      unsigned long  lbf_type;
   } llcb;
   struct llcc {
      unsigned char lbf_addr[LLC_ADDR_LEN];
      unsigned char lbf_sap;
      unsigned char lbf_snap[5];
   } llcc;
};

#define LLC_LENGTH(m)	ntohs(((struct sme_machdr *)m)->mac_llc.llc.llc_length)
#define LLC_DSAP(m)	(((struct sme_machdr *)m)->mac_llc.llc.llc_dsap)
#define LLC_SSAP(m)	(((struct sme_machdr *)m)->mac_llc.llc.llc_ssap)
#define LLC_CONTROL(m)	(((struct sme_machdr *)m)->mac_llc.llc.llc_control)
#define LLC_SNAP(m)	(((struct sme_machdr *)m)->mac_llc.llc.llc_info)

#define ETHER_TYPE(m)	ntohs(((struct sme_machdr *)m)->mac_llc.ether.ether_type)

#define SMEMAXSAPVALUE	0xFF	/* largest LSAP value */

/* other useful macros */

#define HIGH(x) ((x>>8)&0xFF)
#define LOW(x)	(x&0xFF)

/* recoverable error conditions */

#define SMEE_OK		0	/* normal condition */
#define SMEE_NOBUFFER	1	/* couldn't allocb */
#define SMEE_INVALID	2	/* operation isn't valid at this time */
#define SMEE_BOUND	3	/* stream is already bound */
#define SMEE_BLOCKED	4	/* blocked at next queue */

/* LLC specific data - should be in separate header (later) */

#define LLC_UI		0x03	/* unnumbered information field */
#define LLC_XID		0xAF	/* XID with P == 0 */
#define LLC_TEST	0xE3	/* TEST with P == 0 */

#define LLC_P		0x10	/* P bit for use with XID/TEST */
#define LLC_XID_FMTID	0x81	/* XID format identifier */
#define LLC_SERVICES	0x01	/* Services supported */
#define LLC_GLOBAL_SAP	0XFF	/* Global SAP address */
#define LLC_GROUP_ADDR	0x01	/* indication in DSAP of a group address */
#define LLC_RESPONSE	0x01	/* indication in SSAP of a response */

#define	RETIX_ISO	(-2)
#define NOVELL_SAP	(-3)	/* Novell 802.3 mode */
#define	DEFAULT_SAP	((ulong) 0xFFFFFFFE)	/* LLI or RETIX_ISO */
#define	NETWARE_SAP	((ulong) 0x000000FF)	/* LLI */
#define MIN_ETYPE	0x5DD
#define LLC_SNAP_SAP	0xAA	/* SNAP sap from 802.1 */

#define LLC_XID_INFO_SIZE	3 /* length of the INFO field */

struct rcv_buf {
	unsigned char	status;
	unsigned char	nxtpg;
	short		datalen;
	machdr_t	pkthdr;
};

typedef struct rcv_buf rcv_buf_t;

/*
 * WD 8003 event statistics
 */

#define SMES_NSTATS	21	

#ifdef M_XENIX
typedef unsigned long	ulong;
#endif

struct smestat {
    ulong	smes_nstats;	/* number of stat fields */
    /* non-hardware */
    ulong	smes_nobuffer;	/* 0 */
    ulong	smes_blocked;	/* 1 */
    ulong	smes_blocked2;	/* 2 */
    ulong	smes_multicast;	/* 3 */

   /* transmit */
   ulong	smes_xpkts;	/* 4 */
   ulong	smes_xbytes;	/* 5 */
   ulong	smes_excoll;	/* 6 */
   ulong	smes_one_coll;	/* 7 */
   ulong	smes_coll;	/* 8 */
   ulong	smes_ow_coll;	/* 9 */
   ulong	smes_fifounder;	/* 10 */
   ulong	smes_carrier;	/* 11 */

   /* receive */
   ulong	smes_rpkts;	/* 12 */
   ulong	smes_rbytes;	/* 13 */
   ulong	smes_crc;	/* 14 */
   ulong	smes_align;	/* 15 */
   ulong	smes_fifoover;	/* 16 */
   ulong	smes_lost;	/* 17 */

   /* added */
   ulong	smes_intrs;	/* 18 */
   ulong	smes_ovw;	/* 19 */
   ulong	smes_rx_too_big;	/* 20 */
   ulong	smes_lbolt;
	
};

/* datalink layer i/o controls */
#define DLIOC	('D'<<8)
#define DLGBROAD	(('D' << 8) | 3)  /* get broadcast address entry */
#define DLGSTAT		(('D' << 8) | 4)  /* get statistics values */
#define DLGADDR		(('D' << 8) | 5)  /* get physical addr of interface */
#define DLPROM		(('D' << 8) | 6)  /* toggle promiscuous mode */
#define DLSADDR		(('D' << 8) | 7)  /* set physical addr of interface */
#define DLGCLRSTAT	(('D' << 8) | 8)  /* get statistics and zero entries */
#define DLSMULT		(('D' << 8) | 9)  /* set multicast address entry */
#define DLRESET		(('D' << 8) | 10) /* reset to power up condition */
#define DLGSAP		(('D' << 8) | 11) /* get driver sap value */
#define DLGMULT		(('D' << 8) | 12) /* get multicast address entry */
#define DLGBRDTYPE	(('D' << 8) | 13) /* get board type */
#define DLDMULT 	(('D' << 8) | 14) /* delete multicast address entry */

/* mac layer i/o controls */
#ifndef	DLPI
#define MACIOC(x)	(('M' << 8) | (x))
#endif
#define MACIOC_DIAG	MACIOC(1)	/* set diagnostic mode */
#define MACIOC_UNIT	MACIOC(2)	/* unit select */
#define MACIOC_SETMCA	MACIOC(3)	/* multicast setup */
#define MACIOC_DELMCA	MACIOC(4)	/* multicast delete */
#define MACIOC_DELAMCA	MACIOC(5)	/* flush multicast table */
#define MACIOC_GETMCA	MACIOC(6)	/* get multicast table */
#ifndef	DLPI
/*#define MACIOC_GETSTAT	MACIOC(7)	/* dump statistics */
#endif
#define MACIOC_GETADDR	MACIOC(8)	/* get mac address */
#define MACIOC_SETADDR	MACIOC(9)	/* set mac address */

