
/*
**
**
*/

#include "sys/types.h"
#include "sys/stream.h"
#include "sys/socket.h"
#include "/etc/conf/cf.d/config.h"

/*
** Definition for media type selection.
** The following definition should be the same as pnpinit.h
*/
#define MEDIA_UTP	0
#define MEDIA_BNC	1
#define MEDIA_AUI	2
#define MEDIA_AUTO	3
#define MEDIA_DEFAULT	-1


/*
** DE-220 card media selection. Can have one of the following values:
**
**	MEDIA_UTP	- twisted pair connection
**	MEDIA_BNC	- BNC connection
**	MEDIA_AUI	- AUI connection
**	MEDIA_AUTO	- Automatic detect connected media
**	MEDIA_DEFAULT	- Use EEPROM setting.
**
*/
#define ND22E_MediaType_0	MEDIA_AUTO
#define ND22E_MediaType_1	MEDIA_AUTO
#define ND22E_MediaType_2	MEDIA_AUTO
#define ND22E_MediaType_3	MEDIA_AUTO



#if defined(D22E3_UNITS)
#define ND22EUNIT (D22E3_UNITS+D22E2_UNITS+D22E1_UNITS+D22E_UNITS)
int de220media[ND22EUNIT] = {
	ND22E_MediaType_0,
	ND22E_MediaType_1,
	ND22E_MediaType_2,
	ND22E_MediaType_3
	};
#elif defined(D22E2_UNITS)
#define ND22EUNIT (D22E2_UNITS+D22E1_UNITS+D22E_UNITS)
int de220media[ND22EUNIT] = {
	ND22E_MediaType_0,
	ND22E_MediaType_1,
	ND22E_MediaType_2,
	};
#elif defined(D22E1_UNITS)
#define ND22EUNIT (D22E1_UNITS+D22E_UNITS)
int de220media[ND22EUNIT] = {
	ND22E_MediaType_0,
	ND22E_MediaType_1,
	};
#elif defined(D22E_UNITS)
#define ND22EUNIT D22E_UNITS
int de220media[ND22EUNIT] = {
	ND22E_MediaType_0,
	};
#endif

ulong DE220_BOARDS = ND22EUNIT;



