uses Crt, NW40;

  {
   This program shows how to use the system calls and the NW40 unit to
   send requests to a NW v4.0 server

   Set your default drive to a NetWare v4.x file server before running
   this program
  }


VAR cCode : Word;
    i     : Word;
    key   : Char;

Function ASCIIz(VAR Arr): String;
         {Convert zero delimited ASCII to PASCAL String}
VAR A: Array[1..$FF] of Byte absolute Arr;
    S: String;
    i: Byte;
BEGIN
  S[0] := #$FF;
  Move(A[1], S[1], $FF);
  FOR i := $FF DownTo 1 DO
      IF (A[i]=0) THEN S[0] := Char(i);
  ASCIIz := S;
END;



PROCEDURE PressToContinue;
VAR c : Char;
BEGIN
  Write('Press any key to continue ... ');
  c := ReadKey;  IF c=#0 THEN c := ReadKey;
  Write(#13);
  ClrEol
END;

Procedure ShowMem(VAR MemoryStart; Len: WORD);
          {Dump contents of any memory location defined by MemoryStart}
VAR Memo : Array[0..$7FFF] of CHAR absolute MemoryStart;
    i    : Word;
    j    : Byte;
BEGIN
   i := 0;
   Repeat
       For j := 0 to 15 DO BEGIN
           Write(hex2(Byte(Memo[i+j])), ' ');
           IF j=7 THEN Write(' ');
           END;
       Write(' | ');
       For j := 0 to 15 DO BEGIN
           IF Memo[i+j]<' ' THEN Write('.')
                            else Write(Memo[i+j]);
           IF j=7 THEN Write(' ');
           END;
       WriteLn;
       Inc(i, 16)
       Until i>Len;
END;


Procedure ShowVolInfo;
VAR v      : Byte;
    VolInfo: NW40_ExtVolInfo;
BEGIN
   For v := 0 to 64 do BEGIN
       cCode := NW40_GetExtendedVolumeInformation(v, VolInfo);
       IF (cCode=0) THEN
          WITH VolInfo Do BEGIN

               ShowMem(VolInfo, 200); PressToContinue;

               WriteLn('Volume Name:             ', volumeName);
               WriteLn('Volume Type:             ', volumeType);
               WriteLn('Sector Size:             ', sectorSize);
               WriteLn('Sectors per Cluster:     ', sectorsPerCluster);
               WriteLn('Compressed Sectors:      ', compressedSectors);
               WriteLn('Migrated Files:          ', migratedFiles);
               WriteLn('Dir Entries:             ', totalDirectoryEntries);
               WriteLn('Avail Dir Entries:       ', unUsedDirectoryEntries);
               PressToContinue;
               END
          ELSE IF (cCode<>$98) THEN WriteLn('Get Vol Info returned status ', hex2(cCode), ' for volume ', v)
       END
END;

Procedure Ping_NDS;
VAR PingNDSResult: NW40_PingNDSResult;
BEGIN
   cCode := NW40_PingForNDSNCP(PingNDSResult);
   IF cCode>0
      THEN WriteLn('Ping NDS returned status ', hex2(cCode))
      else WITH PingNDSResult Do BEGIN
           WriteLn('Ping Version:         ', PingVersion);
           WriteLn(ASCIIz(TreeName));
           Write
           END;
END;


Procedure GetBinderyContext;
VAR BinderyContext: NW40_BinderyContext;
    ContextName: String;
BEGIN
   cCode := NW40_ReturnBinderyContext(BinderyContext);
    IF cCode>0
      THEN WriteLn('Get Bindery Context returned status ', hex2(cCode))
      else WITH BinderyContext Do BEGIN
           ContextName := '';
           For i := 1 to NameLength DO ContextName := ContextName + Name[i, 1];
           WriteLn(ContextName);  {we assume std ASCII here}
           END;
END;


Procedure CPUInfo;
VAR CPUInformation: NW40_CPUInfo;
    CPU           : Byte;
    j             : Byte;
BEGIN
   CPU := 0;
   Repeat
       cCode := NW40_CPUInformation(CPU, CPUInformation);
       IF cCode>0
          THEN WriteLn('Get CPU Info (CPU ', CPU, ') returned status ', hex2(cCode))
          else WITH CPUInformation Do BEGIN
               WriteLn('Number of CPUs:       ', NumberOfCPUs);
               j := 1;  i := 0;
               While (j<=3) and (i<=200) DO BEGIN
                  IF CPUInfo.Info[i] <> #0
                     THEN Write(CPUInfo.Info[i])
                     ELSE BEGIN
                          WriteLn;
                          inc(j)
                          END;
                  inc(i);
                  END;
               END;
       inc(CPU)
       Until (CPU>=CPUInformation.NumberOfCPUs) or (cCode>0)
END;


Procedure GetLoadedNLMs;
VAR NLMsLoaded:     NW40_NLMsLoaded;
    NLM_Index:      Byte;
    NLMInformation: NW40_NLMInformation;
    j:              WORD;
    NLMText:        Array[1..3] of String;
BEGIN
   cCode := NW40_GetNLMsLoaded(0, NLMsLoaded);
   IF cCode>0
      THEN WriteLn('Get NLMs Loaded returned status ', hex2(cCode))
      else For NLM_Index := 1 to NLMsLoaded.NLMsReturned DO
               BEGIN
               cCode := NW40_GetNLMInformation(NLMsLoaded.NLMNumbers[NLM_Index], NLMInformation);
               IF cCode>0
                  THEN WriteLn('Get NLM Info returned status ', hex2(cCode))
                  else With NLMInformation DO BEGIN
                       j := 0;
                       MOVE(NLMStrings[j], NLMText[1,0], SizeOf(NLMText[1]));
                       Write(NLMText[1], ' ');
                       Write('(Type ', NLMInfo.NLMtype, ': ');
                       Case NLMInfo.NLMType of
                         0: Write('Std NLM');
                         1: Write('LAN Driver');
                         2: Write('Disk Driver');
                         3: Write('Name Space');
                         4: Write('Support Program');
                         5: Write('Mirrored Server Link');
                         6: Write('OS NLM');
                         7: Write('Paged High NLM');
                         8: Write('Host Adapter Module');
                         9: Write('Custom Device');
                        10: Write('File System Engine');
                        11: Write('Real Mode NLM');
                        12: Write('Hidden NLM');
                        END;
                       Write(')  v', NLMInfo.majorVersion, '.', NLMInfo.minorVersion);
                       IF NLMInfo.revision>0 THEN Write(Char($60+NLMInfo.revision));
                       WriteLn(' (', NLMInfo.month, '-', NLMInfo.day, '-', NLMInfo.year, ')');
                       j := j + 1 + Length(NLMText[1]);
                       MOVE(NLMStrings[j], NLMText[2,0], SizeOf(NLMText[2]));
                       IF Pos(#0, NLMText[2])>0 THEN NLMText[2,0] := Char(Pos(#0, NLMText[2])-1);
                       WriteLn('  ', NLMText[2]);
                       j := j + 1 + Length(NLMText[2]);
                       MOVE(NLMStrings[j], NLMText[3,0], SizeOf(NLMText[3]));
                       IF Pos(#0, NLMText[3])>0 THEN NLMText[3,0] := Char(Pos(#0, NLMText[3])-1);
                       {This corrects bugs in the strings}
                       WriteLn('  ', NLMText[3]);
                       END;
               IF (NLM_Index Mod 6)=0 THEN PressToContinue
               END;
END;

PROCEDURE OSInfo;
VAR OSVersionInformation: NW40_OSVersionInformation;
BEGIN
   cCode := NW40_GetOSVersionInformation(OSVersionInformation);
   IF cCode>0
      THEN WriteLn('Get OS Version Info returned status ', hex2(cCode))
      else With OSVersionInformation DO BEGIN
           WriteLn(' OSMajorVersion              ', OSMajorVersion);
           WriteLn(' OSMinorVersion              ', OSMinorVersion);
           WriteLn(' OSRevisionNum               ', OSRevisionNum);
           WriteLn(' accountingVersion           ', accountingVersion);
           WriteLn(' VAPVersion                  ', VAPVersion);
           WriteLn(' queueingVersion             ', queueingVersion);
           WriteLn(' securityRestrictionsLevel   ', securityRestrictionsLevel);
           WriteLn(' bridgingSupport             ', bridgingSupport);
           WriteLn(' maxNumOfVolumes             ', maxNumOfVolumes);
           WriteLn(' numOfConnSlots              ', numOfConnSlots);
           WriteLn(' maxLoggedInConns            ', maxLoggedInConns);
           WriteLn(' maxNumOfNameSpaces          ', maxNumOfNameSpaces);
           WriteLn(' maxNumOfLans                ', maxNumOfLans);
           WriteLn(' maxNumOfMediaTypes          ', maxNumOfMediaTypes);
           WriteLn(' maxNumOfProtocols           ', maxNumOfProtocols);
           WriteLn(' maxMaxSubdirTreeDepth       ', maxMaxSubdirTreeDepth);
           WriteLn(' maxNumOfDataStreams         ', maxNumOfDataStreams);
           WriteLn(' maxNumOfSpoolPrinters       ', maxNumOfSpoolPrinters);
           WriteLn(' serialNum                   ', serialNum);
           WriteLn(' applicationNum              ', applicationNum);
           END;
END;


Procedure LANInfo;
VAR BoardList:   NW40_BoardList;
    Board_Index: Byte;
    LANConfiguration: NW40_LANConfiguration;
BEGIN
   cCode := NW40_ActiveLANBoardList(0, BoardList);
   IF cCode>0
      THEN WriteLn('Get Board List returned status ', hex2(cCode))
      else With BoardList DO BEGIN
           WriteLn('LAN boards supported:    ', MaxNumOfLANs);
           WriteLn('LAN boards returned:     ', ItemsCount);
           For Board_Index := 1 to ItemsCount DO BEGIN
               cCode := NW40_GetLANConfiguration(BoardNumber[Board_Index], LANConfiguration);
               IF cCode>0
                  THEN WriteLn('Get Board Configuration returned status ', hex2(cCode))
                  else With LANConfiguration DO BEGIN

                       WriteLn(' DriverCFG_MajorVersion     ', DriverCFG_MajorVersion);
                       WriteLn(' DriverCFG_MinorVersion     ', DriverCFG_MinorVersion);
                       Write(  ' DriverNodeAddress          ');
                       For i := 1 to 6 DO Write(hex2(DriverNodeAddress[i])); WriteLn;
                       WriteLn(' DriverModeFlags  	         ', DriverModeFlags  	);
                       WriteLn(' DriverBoardNum  	         ', DriverBoardNum);
                       WriteLn(' DriverBoardInstance        ', DriverBoardInstance);
                       WriteLn(' DriverMaxSize              ', DriverMaxSize);
                       WriteLn(' DriverMaxRecvSize          ', DriverMaxRecvSize);
                       WriteLn(' DriverRecvSize             ', DriverRecvSize);
                       WriteLn(' DriverCardID               ', DriverCardID);
                       WriteLn(' DriverMediaID              ', DriverMediaID);
                       WriteLn(' DriverTransportTime        ', DriverTransportTime);
                       WriteLn(' DriverSrcRouting           ', DriverSrcRouting);
                       WriteLn(' DriverLineSpeed            ', DriverLineSpeed);
                       WriteLn(' DriverReserved             ', DriverReserved);
                       WriteLn(' DriverMajorVersion         ', DriverMajorVersion);
                       WriteLn(' DriverMinorVersion         ', DriverMinorVersion);
                       WriteLn(' DriverFlags                ', DriverFlags);
                       WriteLn(' DriverSendRetries          ', DriverSendRetries);
                       WriteLn(' DriverLink                 ', DriverLink);
                       WriteLn(' DriverSharingFlags         ', DriverSharingFlags);
                       WriteLn(' DriverSlot                 ', DriverSlot);
                       WriteLn(' DriverIOPortsAndLengths[1] ', DriverIOPortsAndLengths[1]);
                       WriteLn(' DriverIOPortsAndLengths[2] ', DriverIOPortsAndLengths[2]);
                       WriteLn(' DriverIOPortsAndLengths[3] ', DriverIOPortsAndLengths[3]);
                       WriteLn(' DriverIOPortsAndLengths[4] ', DriverIOPortsAndLengths[4]);
                       WriteLn(' DriverMemDecode0           ', DriverMemDecode0);
                       WriteLn(' DriverLength0              ', DriverLength0);
                       WriteLn(' DriverMemDecode1           ', DriverMemDecode1);
                       WriteLn(' DriverLength1              ', DriverLength1);
                       WriteLn(' DriverInterrupt[1]         ', DriverInterrupt[1]);
                       WriteLn(' DriverInterrupt[2]         ', DriverInterrupt[2]);
                       WriteLn(' DriverDMAUsage[1]          ', DriverDMAUsage[1]);
                       WriteLn(' DriverDMAUsage[2]          ', DriverDMAUsage[2]);
                       WriteLn(' DriverLogicalName          ', ASCIIz(DriverLogicalName));
                       WriteLn(' DriverCardName             ', ASCIIz(DriverCardName));
                       WriteLn(' DriverMediaType            ', ASCIIz(DriverMediaType));
                       END
               END;
           END;
END;


PROCEDURE GetFileServerInfo;
VAR FileServerInfo : NW40_FileServerInfo;
BEGIN
   cCode := NW40_GetServerInformation(FileServerInfo);
   IF cCode>0
      THEN WriteLn('Get File Server Info returned status ', hex2(cCode))
      else WITH FileServerInfo DO BEGIN
           WriteLn('NCP Total Requests     ', NCPTotalRequests:8);
           WriteLn('Server Utilization     ', ServerUtilization:8);
           WriteLn('Total Packets Serviced ', TotalPacketsServiced:8);
           END;
END;

PROCEDURE GetCacheInfo;
VAR CacheInfo : NW40_CacheCounters;
BEGIN
   cCode := NW40_GetCacheInformation(CacheInfo);
   IF cCode>0
      THEN WriteLn('Get Cache Info returned status ', hex2(cCode))
      else WITH CacheInfo DO BEGIN
           WriteLn('Original Cache Buffers ', originalNumOfCacheBuffers:8);
           WriteLn('Current Cache Buffers  ', currentNumOfCacheBuffers:8);
           WriteLn('Number of Cache Checks ', numCacheChecks:8);
           WriteLn('Number of Cache Hits   ', numCacheHits:8);
           WriteLn('Dirty Cache Buffers    ', numDirtyBlocks:8);
           END
END;

Procedure DisplayServers;
VAR ServerInfo : NWFSE_NETWORK_SERVER_INFO;
BEGIN
   cCode := NW40_GetKnownServers(0, OT_File_ServerL, ServerInfo);
   IF (cCode>0)
      THEN WriteLn('Get Known Servers returned status ', hex2(cCode))
      else ShowMem(ServerInfo, 300);
END;


Procedure UserInfo;
CONST MaxConn = 20;
VAR UserInformation: NW40_UserInformation;
    ConnectionNumber: LongInt;
    kBRead, kBWritten: LongInt;
BEGIN
   ConnectionNumber := 1;
   While ConnectionNumber <= MaxConn DO BEGIN
       cCode := NW40_GetUserInformation(ConnectionNumber, UserInformation);
       Write('Connection', ConnectionNumber:4, ' - ');
       IF (cCode>0)
          THEN WriteLn('Get User Info returned status ', hex2(cCode))
          else With UserInformation DO BEGIN
               Move(totalBytesRead[2],    kBRead,    4);  kBRead    := kBRead div 4;
               Move(totalBytesWritten[2], kBWritten, 4);  kBWritten := kBWritten div 4;
               WriteLn('Connection Number       ', ConnNum);
               WriteLn('Name                    ', UserName);
               WriteLn('kB Read:         ', kBRead:8);
               WriteLn('kB Written:      ', kbWritten:8);
               WriteLn('total Requests:  ', totalRequests:8);
               PressToContinue;
               END;
       Inc(ConnectionNumber)
       END;
END;

Procedure ShowMenu;
BEGIN
   ClrScr;
   WriteLn('  Get Information about a NW v4.0 Server     (ESC to Exit)');
   WriteLn;
   WriteLn('        1: Volume Info');
   WriteLn('        2: NDS    Info');
   WriteLn('        3: CPU    Info');
   WriteLn('        4: NLM    Info');
   WriteLn('        5: OS     Info');
   WriteLn('        6: LAN    Info');
   WriteLn('        7: Server Info');
   WriteLn('        8: Display Servers');
   WriteLn('        9: User   Info');
   WriteLn;  Write('  Enter Choice: ');
END;


BEGIN
   Repeat
      ShowMenu;
      key := ReadKey;
      WriteLn; WriteLn;
      Case Key of
        '1': ShowVolInfo;
        '2': BEGIN
             Ping_NDS;
             ShowMem(ReceiveBuffer, 100);
             GetBinderyContext;
             ShowMem(ReceiveBuffer, 100);
             END;
        '3': CPUInfo;
        '4': GetLoadedNLMs;
        '5': OSInfo;
        '6': LANInfo;
        '7': BEGIN
             GetFileServerInfo;
             GetCacheInfo
             END;
        '8': DisplayServers;
        '9': UserInfo;
        END; {case}
      IF Key in ['1'..'9'] THEN PressToContinue
      until key = #27
END.
