unit nw40;

interface

uses DOS;


{General types and Variables}

TYPE
   RequestBuffer	= ARRAY[0..256] of BYTE;
   RequestControl	= RECORD
	   Len : WORD;
	   Fct : BYTE;
	   END;
   ReplyBuffer		= ARRAY[0..512] of BYTE;
   Str2           = String[2];
   ObjectName     = Array[1..48] of Char;

VAR
   reg            : Registers;
   SendBuffer		: RequestBuffer;
	ReceiveBuffer	: ReplyBuffer;


FUNCTION hex2(Number: BYTE): str2;
Function LongSwap(L1: LongInt): LongInt;




{Types and Variables for our test cases}

CONST
   OT_File_ServerL = $400;




{Types and Variables for NW 4.0 function return data}

TYPE NW40_ConnList = Record
                     Fields : Word;
                     Entry  : Array[1..50] of LongInt;
                     END;
TYPE NW40_ExtVolInfo = Record
                       DataLength : Word;
                       volumeType,
                       statusFlagBits,
                       sectorSize,
                       sectorsPerCluster,
                       volumeSizeInClusters,
                       freedClusters,
                       subAllocFreeableClusters,
                       freeableLimboSectors,
                       nonFreeableLimboSectors,
                       nonFreeableAvailSubAllocSectors,
                       notUsableSubAllocSectors,
                       subAllocClusters,
                       dataStreamsCount,
                       limboDataStreamsCount,
                       oldestDeletedFileAgeInTicks,
                       compressedDataStreamsCount,
                       compressedLimboDataStreamsCount,
                       unCompressableDataStreamsCount,
                       preCompressedSectors,
                       compressedSectors,
                       migratedFiles,
                       migratedSectors,
                       clustersUsedByFAT,
                       clustersUsedByDirectories,
                       clustersUsedByExtendedDirs,
                       totalDirectoryEntries,
                       unUsedDirectoryEntries,
                       totalExtendedDirectoryExtants,
                       unUsedExtendedDirectoryExtants,
                       extendedAttributesDefined,
                       extendedAttributeExtantsUsed,
                       directoryServicesObjectID,
                       volumeLastModifiedDateAndTime:    LongInt;
                       volumeName: String;
                       END;
TYPE NW40_ObjectsEffectiveRights = RECORD
                      EffectiveRights:  WORD;
                      reserved:         Array[1..6] of Byte
                      END;
TYPE SERVER_AND_VCONSOLE_INFO = RECORD
                      currentServerTime:  LongInt;
                      vconsoleVersion:	   Byte;
                      vconsoleRevision:	Byte;
                      reserved:           Word;
                      END;

TYPE NW40_BoardList = Record
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      MaxNumOfLANs:      LongInt;
                      ItemsCount:        LongInt;
                      BoardNumber:       Array[1..50] of LongInt
                      END;
TYPE TCPUInfo =       Record
                      pageTableOwnerFlag: LongInt;
                      CPUTypeFlag:        LongInt;
                      coProcessorFlag:    LongInt;
                      busTypeFlag:        LongInt;
                      IOEngineFlag:       LongInt;
                      FSEngineFlag:       LongInt;
                      nonDedicatedFlag:   LongInt;
                      Info:               Array[0..200] of Char; {CPU String; Num CoProc; BusString}
                      END;
TYPE NW40_CPUInfo   = Record
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      NumberOfCPUs:      LongInt;
                      CPUInfo:           TCPUInfo
                      END;
TYPE NW40_CacheCounters = Record
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      {memory counters}
                      readExistingBlockCount:       LongInt;
                      readExistingWriteWaitCount:   LongInt;

                      readExistingPartialReadCount: LongInt;  {2}
                      readExistingReadErrorCount:   LongInt;
                      writeBlockCount:              LongInt;
                      writeEntireBlockCount:        LongInt;

                      getDiskCount:                 LongInt;  {3}
                      getDiskNeedToAllocCount:      LongInt;
                      getDiskSomeoneBeatMeCount:    LongInt;
                      getDiskPartialReadCount:      LongInt;

                      getDiskReadErrorCount:        LongInt;  {4}
                      getAsyncDiskCount:            LongInt;
                      getAsyncDiskNeedToAlloc:      LongInt;
                      getAsyncDiskSomeoneBeatMe:    LongInt;

                      errorDoingAsyncReadCount:     LongInt;  {5}
                      getDiskNoReadCount:           LongInt;
                      getDiskNoReadAllocCount:      LongInt;
                      getDiskNoReadSomeoneBeatMeCount: LongInt;

                      diskWriteCount:               LongInt;  {6}
                      diskWriteAllocCount:          LongInt;
                      diskWriteSomeoneBeatMeCount:  LongInt;
                      writeErrorCount:              LongInt;

                      waitOnSemaphoreCount:         LongInt;  {7}
                      allocBlockWaitForSomeoneCount: LongInt;
                      allocBlockCount:              LongInt;
                      allocBlockWaitCount:          LongInt;
                      {CACHE_MEM_COUNTERS}
                      originalNumOfCacheBuffers:    LongInt;  {8}
                      currentNumOfCacheBuffers:     LongInt;
                      cacheDirtyBlockThreshold:     LongInt;
                      waitNodeCount:                LongInt;

                      waitNodeAllocFailureCount:    LongInt;  {9}
                      moveCacheNodeCount:           LongInt;
                      moveCacheNodeFromAvailCount:  LongInt;
                      accelerateCacheNodeWriteCount:LongInt;

                      removeCacheNodeCount:         LongInt;  {10}
                      removeCacheNodeFromAvailCount:LongInt;
                      {cache trend counters}
                      numCacheChecks:               LongInt;
                      numCacheHits:                 LongInt;

                      numDirtyCacheChecks:          LongInt;  {11}
                      numDirtyCacheHits:            LongInt;
                      cacheUsedWhileChecking:       LongInt;
                      waitForDirtyBlocksDecreaseCount: LongInt;

                      allocBlockFromAvailCount:     LongInt;  {}
                      allocBlockFromLRUCount:       LongInt;
                      allocBlockAlreadyWaiting:     LongInt;
                      LRUSittingTime:               LongInt;
                      {CACHE_INFO}
                      maxByteCount:                 LongInt;
                      minNumOfCacheBuffers:         LongInt;
                      minCacheReportThreshold:      LongInt;
                      allocWaitingCount:            LongInt;

                      numDirtyBlocks:               LongInt;
                      cacheDirtyWaitTime:           LongInt;
                      cacheMaxConcurrentWrites:     LongInt;
                      maxDirtyTime:                 LongInt;

                      numOfDirCacheBuffers:         LongInt;
                      cacheByteToBlockShiftFactor:  LongInt;
                      END;
TYPE NW40_FileServerInfo  = Record
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      NCPStationsInUseCount:           LongInt;
                      NCPStationsPeakCount:            LongInt;
                      NCPTotalRequests:                LongInt;
                      ServerUtilization:               LongInt;
                      replyCancelledCount:             LongInt;
                      writeHeldOffCount:               LongInt;
                      writeHeldOffWithDuplicateRequest:LongInt;
                      invalidRequestTypeCount:         LongInt;
                      beingAbortedCount:               LongInt;
                      alreadyDoingReallocCount:        LongInt;
                      deAllocInvalidSlotCount:         LongInt;
                      deAllocBeingProcessedCount:      LongInt;
                      deAllocForgedPacketCount:        LongInt;
                      deAllocStillTransmittingCount:   LongInt;
                      startStationErrorCount:          LongInt;
                      invalidSlotCount:                LongInt;
                      beingProcessedCount:             LongInt;
                      forgedPacketCount:               LongInt;
                      stillTransmittingCount:          LongInt;
                      reExecuteRequestCount:           LongInt;
                      invalidSequenceNumCount:         LongInt;
                      duplicateIsBeingSentAlreadyCnt:  LongInt;
                      sentPositiveAcknowledgeCount:    LongInt;
                      sentDuplicateReplyCount:         LongInt;
                      noMemForStationCtrlCount:        LongInt;
                      noAvailableConnsCount:           LongInt;
                      reallocSlotCount:                LongInt;
                      reallocSlotCameTooSoonCount:     LongInt;
                      TooManyHops,
                      UnknownNetWork,
                      NoSpaceForService,
                      NoReceiveBuffers,
                      NotMyNetwork:                    Word;
                      NetBIOSPropagated,
                      TotalPacketsServiced,
                      TotalPacketsRouted:              LongInt
                      end;
TYPE NW40_Route =     RECORD
                      NetIDNumber:        LongInt;
                      HopsToNet:          Word;
                      NetStatus:          Word;
                      TimeToNet:          Word;
                      END;
TYPE NWFSE_NETWORK_ROUTER_INFO = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      NumberOfEntries:    LongInt;
                      KnownRoutes:        Array[1..20] of NW40_Route
                      END;
TYPE NW40_KnownServer = RECORD
                      Network:            LongInt;
                      Node:               Array[1..6] of BYTE;
                      Socket:             Word;
                      HopsToServer:       Word;
                      ServerName:         ObjectName; {packed !}
                      END;
TYPE NWFSE_NETWORK_SERVER_INFO = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      NumberOfEntries:    LongInt;
                      Case Boolean of
                        True:  (KnownServers:       Array[1..20] of NW40_KnownServer);
                        False: (Data:               Array[1..20*SizeOf(NW40_KnownServer)] of Byte);
                      END;
TYPE NW40_RouterInformation = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      NetIDNumber:               LongInt;
                      HopsToNetCount:            WORD;
                      NetStatus:                 Word;
                      TimeToNet:                 Word
                      END;
TYPE NW40_NLMsLoaded = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
{                     MoreFlag:                  WORD; }
                      NLMCount:                  LongInt;
                      NLMsReturned:              LongInt;
                      NLMNumbers:                Array[1..50] of LongInt
                      END;
TYPE NW40_OSVersionInformation = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      OSMajorVersion:               Byte;
                      OSMinorVersion:               Byte;
                      OSRevisionNum:                Byte;
                      accountingVersion:            Byte;
                      VAPVersion:                   Byte;
                      queueingVersion:              Byte;
                      securityRestrictionsLevel:    Byte;
                      bridgingSupport:              Byte;
                      maxNumOfVolumes:              LongInt;
                      numOfConnSlots:               LongInt;
                      maxLoggedInConns:             LongInt;
                      maxNumOfNameSpaces:           LongInt;
                      maxNumOfLans:                 LongInt;
                      maxNumOfMediaTypes:           LongInt;
                      maxNumOfProtocols:            LongInt;
                      maxMaxSubdirTreeDepth:        LongInt;
                      maxNumOfDataStreams:          LongInt;
                      maxNumOfSpoolPrinters:        LongInt;
                      serialNum:                    LongInt;
                      applicationNum:               Word;
                      END;
TYPE NW40_ProtocolStacks = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      StackNumberCount:          LongInt;
                      StackNumbers:              Array[1..50] of LongInt;
                      END;
TYPE NW40_ServerSetCategories = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      numberOfSetCategories: LongInt;
                      nextSequenceNumber:    LongInt;
                      categoryName:		      String;
                      END;
TYPE NW40_ServerSetCommandsInfo = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      numberOfSetCommands:       LongInt;
                      nextSequenceNumber:        LongInt;
                      setCmdType:                LongInt;
                      setCmdCategory:            LongInt;
                      setCmdFlags:               LongInt;
                      setCmdName:                String;
	                                              {The setCmdName String variable contains
                                                 setCmdValues :   Byte;
                                                 setCmdValue:		Array[1..x] of Byte;
                                                 after the string end}
                      END;
TYPE NW40_IPXSPXInformation = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      IPXSendPacketCount:        LongInt;
                      IPXMalformPacketCount:     Word;
                      IPXGetECBRequestCount:     LongInt;
                      IPXGetECBFailCount:        LongInt;
                      IPXAESEventCount:          LongInt;
                      IPXPostponedAESCount:      Word;
                      IPXMaxConfiguredSocketCount: Word;
                      IPXMaxOpenSocketCount:     Word;
                      IPXOpenSocketFailCount:    Word;
                      IPXListenECBCount:         LongInt;
                      IPXECBCancelFailCount:     Word;
                      IPXGetLocalTargetFailCount:Word;
                      SPXMaxConnsCount:          Word;
                      SPXMaxUsedConns:           Word;
                      SPXEstConnReq:             Word;
                      SPXEstConnFail:            Word;
                      SPXListenConnectReq:       Word;
                      SPXListenConnectFail:      Word;
                      SPXSendCount:              LongInt;
                      SPXWindowChokeCount:       LongInt;
                      SPXBadSendCount:           Word;
                      SPXSendFailCount:          Word;
                      SPXAbortedConn:            Word;
                      SPXListenPacketCount:      LongInt;
                      SPXBadListenCount:         Word;
                      SPXIncomingPacketCount:    LongInt;
                      SPXBadInPacketCount:       Word;
                      SPXSuppressedPackCount:    Word;
                      SPXNoSesListenECBCount:    Word;
                      SPXWatchDogDestSesCount:   Word;
                      END;
TYPE NW40_LANCommonInfo     = RECORD
                      notSupportedMask:        LongInt;
                      totalTxPAcketCount:      LongInt;
                      totalRxPacketCount:      LongInt;
                      noECBAvailableCount:     LongInt;
                      packetTxTooBigCount:     LongInt;
                      packetTxTooSmallCount:   LongInt;
                      packetRxOverflowCount:   LongInt;
                      packetRxTooBigCount:     LongInt;
                      packetRxTooSmallCount:   LongInt;
                      packetTxMiscErrorCount:  LongInt;
                      packetRxMiscErrorCount:  LongInt;
                      retryTxCount:            LongInt;
                      checksumErrorCount:      LongInt;
                      hardwareRxMismatchCount: LongInt;
                      reserved:                Array[1..50] of Byte;
                      END;
TYPE NW40_CommonCounters = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      statisticsMajorVersion:    Byte;
                      statisticsMinorVersion:    Byte;
                      numberOfGenericCounters:   LongInt;
                      numberOfCounterBlocks:     LongInt;
                      customVariableCount:       LongInt;
                      NextCounterBlock:          LongInt;
                      CommonInfo:                NW40_LANCommonInfo;
                      END;
TYPE NW40_LANConfiguration = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      DriverCFG_MajorVersion:       BYTE;
                      DriverCFG_MinorVersion:       BYTE;
                      DriverNodeAddress:            Array[1..6] of BYTE;
                      DriverModeFlags:    	       WORD;
                      DriverBoardNum:    	          WORD;
                      DriverBoardInstance:          WORD;
                      DriverMaxSize:                LongInt;
                      DriverMaxRecvSize:            LongInt;
                      DriverRecvSize:               LongInt;
                      {Reserved1:                   Array[1..3] of LongInt;}
                      DriverCardID:                 WORD;
                      DriverMediaID:                WORD;
                      DriverTransportTime:          WORD;
                      {DriverReserved               Array[1..16] of BYTE;}
                      DriverSrcRouting:             LongInt;
                      DriverLineSpeed:              WORD;
                      DriverReserved:               Word;
                      DriverMajorVersion:           BYTE;
                      DriverMinorVersion:           BYTE;
                      DriverFlags:                  WORD;
                      DriverSendRetries:            WORD;
                      DriverLink:                   LongInt;
                      DriverSharingFlags:           WORD;
                      DriverSlot:                   WORD;
                      DriverIOPortsAndLengths:      Array[1..4] of WORD;
                      DriverMemDecode0:             LongInt;
                      DriverLength0:                WORD;
                      DriverMemDecode1:             LongInt;
                      DriverLength1:                WORD;
                      DriverInterrupt:              Array[1..2] of BYTE;
                      DriverDMAUsage:               Array[1..2] of BYTE;
                      {Reserved2                    Array[1..3] of LongInt;}
                      DriverLogicalName:            Array[1..18] of Char;
                      DriverIOReserved:             Array[1..14] of Byte;
                      DriverCardName:               Array[1..128] of Char;
                      DriverMediaType:              Array[1..40] of Char;
                      DriverCustomVars:             Array[1..180] of BYTE;
                      END;
TYPE NW40_NLMInfo = RECORD
                      identificationNum:     LongInt;
                      flags:                 LongInt;
                      NLMtype:               LongInt;
                      {type 1..12: LAN, DSK, NAM, utility NLM, MSL, OS NLM,
                              paged NLM, HAM, CDM, file system NLM, real mode NLM, hidden NLM}
                      parentID:              LongInt;
                      majorVersion:          LongInt;
                      minorVersion:          LongInt;
                      revision:              LongInt;
                      year:                  LongInt;
                      month:                 LongInt;
                      day:                   LongInt;
                      allocAvailableBytes:   LongInt;
                      allocFreeCount:        LongInt;
                      lastGarbageCollection: LongInt;
                      messageLanguage:       LongInt;  {wrong}
                      numOfReferencedPublics:LongInt;
                      END;
TYPE NW40_NLMInformation = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      NLMInfo:               NW40_NLMInfo;
                      NLMStrings:            Array[0..200] of Char;
                      { containing 3 LStrings: NLMFileName, NLMName, CopyRight}
                      END;
TYPE NW40_UserInformation = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      connNum:                LongInt;
                      useCount:               LongInt;
                      connServiceType:        Byte;
                      loginTime:              Array[1.. 7] of Byte;
                      status:                 LongInt;
                      expirationTime:         LongInt;

                      objType:                LongInt;
                      transactionFlag:        Byte;
                      logicalLockThreshold:   Byte;
                      recordLockThreshold:    Byte;
                      fileWriteFlags:         Byte;  {Includes active and stop bits}
                      fileWriteState:         Byte;
                      filler:                 Byte;
                      fileLockCount:          Word;
                      recordLockCount:        Word;
                      totalBytesRead:         Array[1.. 6] of Byte;
                      totalBytesWritten:      Array[1.. 6] of Byte;
                      totalRequests:          LongInt;
                      heldRequests:           LongInt;
                      heldBytesRead:          Array[1.. 6] of Byte;
                      heldBytesWritten:       Array[1.. 6] of Byte;
                      UserName:               String;
                      END;
TYPE NW40_LFSCounters = Record
                      readFile,
                      writeFile,
                      deleteFile,
                      renMove,
                      openFile,
                      createFile,
                      createAndOpenFile,
                      closeFile,
                      scanDeleteFile,
                      salvageFile,
                      purgeFile,
                      migrateFile,
                      deMigrateFile,
                      createDir,
                      deleteDir,
                      directoryScans,
                      mapPathToDirNum,
                      modifyDirEntry,
                      getAccessRights,
                      getAccessRightsFromIDs,
                      mapDirNumToPath,
                      getEntryFromPathStrBase,
                      getOtherNSEntry,
                      getExtDirInfo,
                      getParentDirNum,
                      addTrusteeR,
                      scanTrusteeR,
                      delTrusteeR,
                      purgeTrust,
                      findNextTrustRef,
                      scanUserRestNodes,
                      addUserRest,
                      deleteUserRest,
                      rtnDirSpaceRest,
                      getActualAvailDskSp,
                      cntOwnedFilesAndDirs,
                      migFileInfo,
                      volMigInfo,
                      readMigFileData,
                      getVolusageStats,
                      getActualVolUsageStats,
                      getDirUsageStats,
                      NMFileReadsCount,
                      NMFileWritesCount,
                      {/* mapPathToDirectoryNumberOrPhantom:*/ LongInt}
                      { documents are contradicory - tests required;
                        not sure about these counters }
                      mapPathToDirNumOrPhantom,
                      {/* stationHasAccessRightsGrantedBelow:*/ LongInt}
                      stationHasAccessRgtsGntedBelow,
                      {/* getDataStreamLengthsFromPathStringBase:*/ LongInt}
                      gtDataStreamLensFromPathStrBase,
                      checkAndGetDirectoryEntry,
                      getDeletedEntry,
                      getOriginalNameSpace,
                      getActualFileSize,
                      verifyNameSpaceNumber,
                      verifyDataStreamNumber,
                      checkVolumeNumber,
                      commitFile,
                      VMGetDirectoryEntry,
                      createDMFileEntry,
                      renameNameSpaceEntry,
                      logFile,
                      releaseFile,
                      clearFile,
                      setVolumeFlag,
                      clearVolumeFlag,
                      getOriginalInfo,
                      createMigratedDir,
                      F3OpenCreate,
                      F3InitFileSearch,
                      F3ContinueFileSearch,
                      F3RenameFile,
                      F3ScanForTrustees,
                      F3ObtainFileInfo,
                      F3ModifyInfo,
                      F3EraseFile,
                      F3SetDirHandle,
                      F3AddTrustees,
                      F3DeleteTrustees,
                      F3AllocDirHandle,
                      F3ScanSalvagedFiles,
                      F3RecoverSalvagedFiles,
                      F3PurgeSalvageableFile,
                      F3GetNSSpecificInfo,
                      F3ModifyNSSpecificInfo,
                      F3SearchSet,
                      F3GetDirBase,
                      F3QueryNameSpaceInfo,
                      F3GetNameSpaceList,
                      F3GetHugeInfo,
                      F3SetHugeInfo,
                      F3GetFullPathString,
                      F3GetEffectiveDirectoryRights : LongInt
                      END;
TYPE NW40_VolumeSwitchInformation = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      TotalLFSCounters:     LongInt;
                      CurrentLFSCounters:   LongInt;
                      LFSCounters:          NW40_LFSCounters
                      END;
TYPE UnicodeName = Array[1..200, 1..2] of Char;
TYPE NW40_PingNDSResult = RECORD
                      PingVersion:       LongInt;
                      TreeNameLength:    LongInt;
                      {TreeName:          UnicodeName; wrong!}
                      TreeName:          Array[1..200] of Char;
                      END;
TYPE NW40_BinderyContext = RECORD
                      NameLength:    LongInt;
                      Name:          UnicodeName;
                      END;


Function RawCall(Fct: BYTE; Req_L: WORD): Word;
Function RawCallWithHeader(Fct, SubFct: BYTE; Req_L: WORD): Word;

Function NW40_ChangeConnectionState(NewState: Byte): Word;
Function NW40_ClearConnectionNumber(Number: LongInt): Word;
Function NW40_GetConnectionList(ObjId: LongInt; SearchNumber: LongInt; Var CL: NW40_ConnList): Word;
Function NW40_SetWatchDogDelayInterval(Minutes: LongInt): Word;
Function NW40_GetExtendedVolumeInformation(VolNr: LongInt; Var VolInfo: NW40_ExtVolInfo): Word;
Function NW40_GetObjectEffectiveRights(ObjID: LongInt; DirHandle: Byte; Path: String; VAR EffRights: Word): Word;
Function NW40_ActiveLANBoardList(StartNumber: LongInt; VAR BoardList: NW40_BoardList): Word;
Function NW40_CPUInformation(CPUNumber: LongInt; VAR CPUInformation: NW40_CPUInfo): Word;
Function NW40_GetCacheInformation(VAR CacheInfo : NW40_CacheCounters): Word;
Function NW40_GetServerInformation(VAR FileServerInfo : NW40_FileServerInfo): Word;
Function NW40_GetKnownNetWorks(StartNumber: LongInt; VAR RouterInfo : NWFSE_NETWORK_ROUTER_INFO): Word;
Function NW40_GetKnownServers(StartNumber, ServerType: LongInt; VAR ServerInfo : NWFSE_NETWORK_SERVER_INFO): Word;
Function NW40_GetNetworkRouterInformation(NetworkNumber: LongInt; VAR RouterInformation: NW40_RouterInformation): Word;
Function NW40_GetNLMsLoaded(StartNumber: LongInt; VAR NLMsLoaded: NW40_NLMsLoaded): Word;
Function NW40_GetOSVersionInformation(VAR OSVersionInformation: NW40_OSVersionInformation): Word;
Function NW40_GetProtocolStackByBoard(LANBoardNumber: LongInt; VAR ProtocolStacks: NW40_ProtocolStacks): Word;
Function NW40_GetServerSetCategories(StartNumber: LongInt; VAR ServerSetCategories: NW40_ServerSetCategories): Word;
Function NW40_GetServerSetCommandsInfo(StartNumber: LongInt; VAR ServerSetCommandsInfo: NW40_ServerSetCommandsInfo): Word;
Function NW40_GetIPXSPXInformation(VAR IPXSPXInformation: NW40_IPXSPXInformation): Word;
Function NW40_GetLANCommonCounters(LANBoardNumber:LongInt; BlockNumber:LongInt; VAR CommonCounters:NW40_CommonCounters): Word;
Function NW40_GetLANConfiguration(LANBoardNumber: LongInt; VAR LANConfiguration: NW40_LANConfiguration): Word;
Function NW40_GetNLMInformation(NLMNumber: LongInt; VAR NLMInformation: NW40_NLMInformation): Word;
Function NW40_GetUserInformation(ConnectionNumber: LongInt; VAR UserInformation: NW40_UserInformation): Word;
Function NW40_GetVolumeSwitchInformation(StartItemNumber: LongInt; VAR VolumeSwitchInfo: NW40_VolumeSwitchInformation): Word;
Function NW40_MonitorNDSConnection: Word;
Function NW40_PingForNDSNCP(VAR PingNDSResult: NW40_PingNDSResult): Word;
Function NW40_ReturnBinderyContext(VAR BinderyContext: NW40_BinderyContext): Word;


Procedure TestAllCalls;



implementation

FUNCTION hex2(Number: BYTE): str2;
CONST  hexa : Array[0..15] of Char = '0123456789ABCDEF';
BEGIN
	hex2[0] := #2;
	hex2[1] := hexa[Number SHR 4];
   hex2[2] := hexa[Number AND $0F];
END;

Function LongSwap(L1: LongInt): LongInt;
VAR L2 : LongInt;
    L1a: Array[1..4] of Byte absolute L1;
    L2a: Array[1..4] of Byte absolute L2;
    i  : Byte;
BEGIN
   For i := 0 to 3 do L2a[i] := L1a[4-i];
   LongSwap := L2
END;


Function  RawCall(Fct: BYTE; Req_L: WORD): Word;
VAR   ReceiveLength : WORD absolute ReceiveBuffer;
BEGIN  {len incl. Function Nr}
	ReceiveLength    := SizeOf(ReceiveBuffer);
   ReceiveBuffer[2] := 0;
	WITH reg DO BEGIN
		DS := seg(SendBuffer);     SI := ofs(SendBuffer);
		ES := seg(ReceiveBuffer);  DI := ofs(ReceiveBuffer);
		CX := Req_L+2; {for IPX}   DX := ReceiveLength;
		AH := $F2;                 AL := Fct
		END;
   MsDos(reg);
   RawCall := reg.AL;
END;


Function RawCallWithHeader(Fct, SubFct: BYTE; Req_L: WORD): Word;
VAR Request : RECORD
      Len : Word;
      Fct : Byte;
	   END absolute SendBuffer;
BEGIN  {len incl. Function Nr}
   Request.Len       := Swap(Req_L);
   Request.Fct       := SubFct;
   RawCallWithHeader := RawCall(Fct, Req_L);
END;





Function NW40_ChangeConnectionState(NewState: Byte): Word;
VAR Req : Record
          RC:      RequestControl;
          State:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.State := NewState;
   NW40_ChangeConnectionState := RawCallWithHeader($17, $1D, SizeOf(Req)-2);
END;

Function NW40_ClearConnectionNumber(Number: LongInt): Word;
VAR Req : Record
          RC:      RequestControl;
          Conn:    LongInt
          END  absolute SendBuffer;
BEGIN
   Req.Conn := Number;
   NW40_ClearConnectionNumber := RawCallWithHeader($17, $FE, SizeOf(Req)-2);
END;

Function NW40_GetConnectionList(ObjId: LongInt; SearchNumber: LongInt; Var CL: NW40_ConnList): Word;
VAR Req : Record
          RC:      RequestControl;
          ObjID:   LongInt;
          SConn:   LongInt;   {init with -1}
          END  absolute SendBuffer;
BEGIN
   Req.ObjID  := ObjID;
   Req.SConn  := SearchNumber;
   NW40_GetConnectionList := RawCallWithHeader($17, $1F, SizeOf(Req)-2);
   Move(ReceiveBuffer, CL, SizeOf(CL))
END;

Function NW40_SetWatchDogDelayInterval(Minutes: LongInt): Word;
VAR Req : Record
          RC:       RequestControl;
          Interval: LongInt   {in minutes}
          END  absolute SendBuffer;
BEGIN
   Req.Interval := Minutes;
   NW40_SetWatchDogDelayInterval := RawCallWithHeader($17, $1E, SizeOf(Req)-2);
END;


Function NW40_GetExtendedVolumeInformation(VolNr: LongInt; Var VolInfo: NW40_ExtVolInfo): Word;
VAR Req : Record
          RC:      RequestControl;
          VolNr:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.VolNr := VolNr;
   NW40_GetExtendedVolumeInformation := RawCallWithHeader($16, $33, SizeOf(Req)-2);
   Move(ReceiveBuffer, VolInfo, SizeOf(VolInfo))
END;


Function NW40_GetObjectEffectiveRights(ObjID: LongInt; DirHandle: Byte; Path: String; VAR EffRights: Word): Word;
VAR Req : Record
          RC:      RequestControl;
          ObjID:   LongInt;
          Handle:  Byte;
          Path:    String
          END  absolute SendBuffer;
    Rep : NW40_ObjectsEffectiveRights absolute ReceiveBuffer;
BEGIN
   Req.ObjID := ObjID;
   Req.Handle:= DirHandle;
   Req.Path  := Path;
   NW40_GetObjectEffectiveRights := RawCallWithHeader($16, $32, 9+Length(Path));
   EffRights := Rep.EffectiveRights
END;

Function NW40_ActiveLANBoardList(StartNumber: LongInt; VAR BoardList: NW40_BoardList): Word;
VAR Req : Record
          RC:            RequestControl;
          StartNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.StartNumber := StartNumber;
   NW40_ActiveLANBoardList := RawCallWithHeader($7B, $14, SizeOf(Req)-2);
   Move(ReceiveBuffer, BoardList, SizeOf(BoardList))
END;


Function NW40_CPUInformation(CPUNumber: LongInt; VAR CPUInformation: NW40_CPUInfo): Word;
VAR Req : Record
          RC:      RequestControl;
          CPUNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.CPUNumber := CPUNumber;
   NW40_CPUInformation := RawCallWithHeader($7B, $8, SizeOf(Req)-2);
   Move(ReceiveBuffer, CPUInformation, SizeOf(CPUInformation))
END;

Function NW40_GetCacheInformation(VAR CacheInfo : NW40_CacheCounters): Word;
BEGIN
   NW40_GetCacheInformation := RawCallWithHeader($7B, $1, 1);
   Move(ReceiveBuffer, CacheInfo, SizeOf(CacheInfo))
END;


Function NW40_GetServerInformation(VAR FileServerInfo : NW40_FileServerInfo): Word;
BEGIN
   NW40_GetServerInformation := RawCallWithHeader($7B, $2, 1);
   Move(ReceiveBuffer, FileServerInfo, SizeOf(FileServerInfo))
END;


VAR RouterInfo : NWFSE_NETWORK_ROUTER_INFO;
Function NW40_GetKnownNetWorks(StartNumber: LongInt; VAR RouterInfo : NWFSE_NETWORK_ROUTER_INFO): Word;
VAR Req : Record
          RC:            RequestControl;
          StartNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.StartNumber := StartNumber;
   NW40_GetKnownNetWorks := RawCallWithHeader($7B, $35, SizeOf(Req)-2);
   Move(ReceiveBuffer, RouterInfo, SizeOf(RouterInfo))
END;


Function NW40_GetKnownServers(StartNumber, ServerType: LongInt; VAR ServerInfo : NWFSE_NETWORK_SERVER_INFO): Word;
Const SNL = SizeOf(NW40_KnownServer);  {12+2+48}
VAR Req : Record
          RC:            RequestControl;
          StartNumber, ServerType:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.StartNumber := StartNumber;
   Req.ServerType  := ServerType;
   NW40_GetKnownServers := RawCallWithHeader($7B, $38, SizeOf(Req)-2);
   Move(ReceiveBuffer, ServerInfo, SizeOf(ServerInfo));
END;

Function NW40_GetNetworkRouterInformation(NetworkNumber: LongInt; VAR RouterInformation: NW40_RouterInformation): Word;
VAR Req : Record
          RC:      RequestControl;
          NetworkNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.NetworkNumber := NetworkNumber;
   NW40_GetNetworkRouterInformation := RawCallWithHeader($7B, $33, SizeOf(Req)-2);
   Move(ReceiveBuffer, RouterInformation, SizeOf(RouterInformation))
END;


Function NW40_GetNLMsLoaded(StartNumber: LongInt; VAR NLMsLoaded: NW40_NLMsLoaded): Word;
VAR Req : Record
          RC:      RequestControl;
          StartNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.StartNumber := StartNumber;
   NW40_GetNLMsLoaded := RawCallWithHeader($7B, $0A, SizeOf(Req)-2);
   Move(ReceiveBuffer, NLMsLoaded, SizeOf(NLMsLoaded))
END;

Function NW40_GetOSVersionInformation(VAR OSVersionInformation: NW40_OSVersionInformation): Word;
BEGIN
   NW40_GetOSVersionInformation := RawCallWithHeader($7B, $0D, 1);
   Move(ReceiveBuffer, OSVersionInformation, SizeOf(OSVersionInformation))
END;


Function NW40_GetProtocolStackByBoard(LANBoardNumber: LongInt; VAR ProtocolStacks: NW40_ProtocolStacks): Word;
VAR Req : Record
          RC:      RequestControl;
          LANBoardNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.LANBoardNumber := LANBoardNumber;
   NW40_GetProtocolStackByBoard := RawCallWithHeader($7B, $29, SizeOf(Req)-2);
   Move(ReceiveBuffer, ProtocolStacks, SizeOf(ProtocolStacks))
END;


Function NW40_GetServerSetCategories(StartNumber: LongInt; VAR ServerSetCategories: NW40_ServerSetCategories): Word;
VAR Req : Record
          RC:      RequestControl;
          StartNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.StartNumber := StartNumber;
   NW40_GetServerSetCategories := RawCallWithHeader($7B, $3D, SizeOf(Req)-2);
   Move(ReceiveBuffer, ServerSetCategories, SizeOf(ServerSetCategories))
END;


Function NW40_GetServerSetCommandsInfo(StartNumber: LongInt; VAR ServerSetCommandsInfo: NW40_ServerSetCommandsInfo): Word;
VAR Req : Record
          RC:      RequestControl;
          StartNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.StartNumber := StartNumber;
   NW40_GetServerSetCommandsInfo := RawCallWithHeader($7B, $3C, SizeOf(Req)-2);
   Move(ReceiveBuffer, ServerSetCommandsInfo, SizeOf(ServerSetCommandsInfo))
END;


Function NW40_GetIPXSPXInformation(VAR IPXSPXInformation: NW40_IPXSPXInformation): Word;
BEGIN
   NW40_GetIPXSPXInformation := RawCallWithHeader($7B, $06, 1);
   Move(ReceiveBuffer, IPXSPXInformation, SizeOf(IPXSPXInformation))
END;


Function NW40_GetLANCommonCounters(LANBoardNumber:LongInt; BlockNumber:LongInt; VAR CommonCounters:NW40_CommonCounters): Word;
VAR Req : Record
          RC:      RequestControl;
          LANBoardNumber:   LongInt;
          BlockNumber:      LongInt;  {start with 0}
          END  absolute SendBuffer;
BEGIN
   Req.LANBoardNumber := LANBoardNumber;
   Req.BlockNumber    := BlockNumber;
   NW40_GetLANCommonCounters := RawCallWithHeader($7B, $16, SizeOf(Req)-2);
   Move(ReceiveBuffer, CommonCounters, SizeOf(CommonCounters))
END;


Function NW40_GetLANConfiguration(LANBoardNumber: LongInt; VAR LANConfiguration: NW40_LANConfiguration): Word;
VAR Req : Record
          RC:      RequestControl;
          LANBoardNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.LANBoardNumber := LANBoardNumber;
   NW40_GetLANConfiguration := RawCallWithHeader($7B, $15, SizeOf(Req)-2);
   Move(ReceiveBuffer, LANConfiguration, SizeOf(LANConfiguration))
END;


Function NW40_GetNLMInformation(NLMNumber: LongInt; VAR NLMInformation: NW40_NLMInformation): Word;
VAR Req : Record
          RC:      RequestControl;
          NLMNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.NLMNumber := NLMNumber;
   NW40_GetNLMInformation := RawCallWithHeader($7B, $0B, SizeOf(Req)-2);
   Move(ReceiveBuffer, NLMInformation, SizeOf(NLMInformation))
END;


Function NW40_GetUserInformation(ConnectionNumber: LongInt; VAR UserInformation: NW40_UserInformation): Word;
VAR Req : Record
          RC:      RequestControl;
          ConnectionNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.ConnectionNumber := ConnectionNumber;
   NW40_GetUserInformation := RawCallWithHeader($7B, $04, SizeOf(Req)-2);
   Move(ReceiveBuffer, UserInformation, SizeOf(UserInformation))
END;


Function NW40_GetVolumeSwitchInformation(StartItemNumber: LongInt; VAR VolumeSwitchInfo: NW40_VolumeSwitchInformation): Word;
VAR Req : Record
          RC:      RequestControl;
          StartItemNumber:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.StartItemNumber := StartItemNumber;
   NW40_GetVolumeSwitchInformation := RawCallWithHeader($7B, $09, SizeOf(Req)-2);
   Move(ReceiveBuffer, VolumeSwitchInfo, SizeOf(VolumeSwitchInfo))
END;


Function NW40_MonitorNDSConnection: Word;
BEGIN
   SendBuffer[0] := $5;
   NW40_MonitorNDSConnection := RawCall($68, 1);
END;


Function NW40_PingForNDSNCP(VAR PingNDSResult: NW40_PingNDSResult): Word;
BEGIN
   FillChar(SendBuffer, 4, 0);
   SendBuffer[0] := 1;
   NW40_PingForNDSNCP := RawCall($68, 2);
   Move(ReceiveBuffer, PingNDSResult, SizeOf(PingNDSResult))
END;


Function NW40_ReturnBinderyContext(VAR BinderyContext: NW40_BinderyContext): Word;
BEGIN
   SendBuffer[0] := $4;
   NW40_ReturnBinderyContext := RawCall($68, 1);
   Move(ReceiveBuffer, BinderyContext, SizeOf(BinderyContext))
END;





Procedure TestAllCalls;
VAR Dummy : Array[1..500] of Byte;  {just a working space for responses}
    ConnList :              NW40_ConnList absolute Dummy;
    VolInfo :               NW40_ExtVolInfo absolute Dummy;
    BoardList :             NW40_BoardList absolute Dummy;
    CPUInformation :        NW40_CPUInfo absolute Dummy;
    CacheInfo :             NW40_CacheCounters absolute Dummy;
    FileServerInfo :        NW40_FileServerInfo absolute Dummy;
    ServerInfo :            NWFSE_NETWORK_SERVER_INFO absolute Dummy;
    RouterInformation :     NW40_RouterInformation absolute Dummy;
    NLMsLoaded :            NW40_NLMsLoaded absolute Dummy;
    OSVersionInformation :  NW40_OSVersionInformation absolute Dummy;
    ProtocolStacks :        NW40_ProtocolStacks absolute Dummy;
    ServerSetCategories :   NW40_ServerSetCategories absolute Dummy;
    ServerSetCommandsInfo : NW40_ServerSetCommandsInfo absolute Dummy;
    IPXSPXInformation :     NW40_IPXSPXInformation absolute Dummy;
    CommonCounters :        NW40_CommonCounters absolute Dummy;
    LANConfiguration :      NW40_LANConfiguration absolute Dummy;
    NLMInformation :        NW40_NLMInformation absolute Dummy;
    UserInformation :       NW40_UserInformation absolute Dummy;
    VolumeSwitchInfo :      NW40_VolumeSwitchInformation absolute Dummy;
    PingNDSResult :         NW40_PingNDSResult absolute Dummy;
    BinderyContext :        NW40_BinderyContext absolute Dummy;
    EffRights:              Word                absolute Dummy;

BEGIN
   {
    This routine just calls all APIs from this unit;
    use a LANalyser to view request and reply packets.

    The support module for the LANalyser to understand NW 4.0 NCP is
    on NetWire NovLib
   }

   WriteLn('ChangeConnectionState:         ', hex2(NW40_ChangeConnectionState(0)));
   WriteLn('ChangeConnectionState:         ', hex2(NW40_ChangeConnectionState(1)));

   WriteLn('NW40_ClearConnectionNumber:    ', hex2(NW40_ClearConnectionNumber(50)));
   WriteLn('NW40_GetConnectionList:        ', hex2(NW40_GetConnectionList($01000000, -1, ConnList)));
   WriteLn('SetWatchDogDelayInterval:      ', hex2(NW40_SetWatchDogDelayInterval(15)));
   WriteLn('GetExtendedVolumeInformation:  ', hex2(NW40_GetExtendedVolumeInformation(0, VolInfo)));
   WriteLn('GetObjectEffectiveRights:      ', hex2(NW40_GetObjectEffectiveRights($01000000, 0, 'SYS:PUBLIC', EffRights)));
   WriteLn('ActiveLANBoardList:            ', hex2(NW40_ActiveLANBoardList(0, BoardList)));
   WriteLn('CPUInformation:                ', hex2(NW40_CPUInformation(0, CPUInformation )));
   WriteLn('GetCacheInformation:           ', hex2(NW40_GetCacheInformation(CacheInfo)));
   WriteLn('GetServerInformation:          ', hex2(NW40_GetServerInformation(FileServerInfo)));
   WriteLn('GetKnownNetWorks:              ', hex2(NW40_GetKnownNetWorks(0, RouterInfo)));
   WriteLn('GetKnownServers:               ', hex2(NW40_GetKnownServers(0, OT_File_ServerL, ServerInfo)));
   WriteLn('GetNetworkRouterInformation:   ', hex2(NW40_GetNetworkRouterInformation(LongSwap($49211010), RouterInformation)));
   WriteLn('GetNLMsLoaded:                 ', hex2(NW40_GetNLMsLoaded(0, NLMsLoaded)));
   WriteLn('GetOSVersionInformation:       ', hex2(NW40_GetOSVersionInformation(OSVersionInformation)));
   WriteLn('GetProtocolStackByBoard:       ', hex2(NW40_GetProtocolStackByBoard(1, ProtocolStacks)));
   WriteLn('GetServerSetCategories:        ', hex2(NW40_GetServerSetCategories(1, ServerSetCategories)));
   WriteLn('GetServerSetCommandsInfo:      ', hex2(NW40_GetServerSetCommandsInfo(1, ServerSetCommandsInfo)));
   WriteLn('GetIPXSPXInformation:          ', hex2(NW40_GetIPXSPXInformation(IPXSPXInformation)));
   WriteLn('GetLANCommonCounters:          ', hex2(NW40_GetLANCommonCounters(1, 0, CommonCounters)));
   WriteLn('GetLANConfiguration:           ', hex2(NW40_GetLANConfiguration(1, LANConfiguration)));
   WriteLn('GetNLMInformation:             ', hex2(NW40_GetNLMInformation(2, NLMInformation)));
   WriteLn('GetUserInformation:            ', hex2(NW40_GetUserInformation(11, UserInformation)));
   WriteLn('GetVolumeSwitchInformation:    ', hex2(NW40_GetVolumeSwitchInformation(1, VolumeSwitchInfo)));

   WriteLn('MonitorNDSConnection:         ', hex2(NW40_MonitorNDSConnection));
   WriteLn('PingForNDSNCP:                ', hex2(NW40_PingForNDSNCP(PingNDSResult)));
   WriteLn('ReturnBinderyContext:         ', hex2(NW40_ReturnBinderyContext(BinderyContext)));
END;


BEGIN

END.




{

TYPE NW40_ZZZ = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      END;
Var   ZZZ : NW40_ZZZ absolute Dummy;
Function NW40_XXX(YYY: LongInt; VAR ZZZ: NW40_ZZZ): Word;
VAR Req : Record
          RC:      RequestControl;
          YYY:   LongInt
          END  absolute SendBuffer;
BEGIN
   Req.YYY := YYY;
   NW40_XXX := RawCallWithHeader($7B, $, SizeOf(Req)-2);
   Move(ReceiveBuffer, ZZZ, SizeOf(ZZZ))
END;

   WriteLn('XXX:         ', hex2(NW40_XXX(1, ZZZ)));

TYPE NW40_ZZZ = RECORD
                      serverTimeAndVConsoleInfo: SERVER_AND_VCONSOLE_INFO;
                      END;
Var   ZZZ : NW40_ZZZ absolute Dummy;
Function NW40_XXX(YYY: LongInt; VAR ZZZ: NW40_ZZZ): Word;
VAR Req : Record
          RC:      RequestControl;
          YYY:   LongInt
          END  absolute SendBuffer;
BEGIN
   SendBuffer[0] := $;
   Req.YYY := YYY;
   NW40_XXX := RawCall($6B, $, SizeOf(Req)-2);
   Move(ReceiveBuffer, ZZZ, SizeOf(ZZZ))
END;

   WriteLn('XXX:         ', hex2(NW40_XXX(1, ZZZ)));


}
