//
// file.hpp : Declares the class interfaces for the low level file read classes.
//
// Copyright (c) 1994 Michael Taylor
//

#ifndef __FILE_HPP__
#define __FILE_HPP__

#include <zapph\mdi.hpp>

#define MAXLINELEN	1024

#define PREV	1
#define NEXT	0

#ifdef WINDOWS
#define HUGE huge
#else
#define HUGE
#endif

typedef int (zEvH::*KeyProc)(zKeyEvt *);

class FileRead
{
public:
	FileRead(char * fname=NULL);
	~FileRead();
	int 	completed ();
	char * 	name ();
	void 	setpageStart ();
	long    startOffset () {return pageStart - filebuf;}
	long    PageSize () {return pageEnd - pageStart;}
	void 	setpageStart (char HUGE *);
	void 	setpageEnd ();
	void 	moveToPageStart ();
	char HUGE * moveToLineNo (long i);
	void 	moveToPageEnd ();
	void 	moveToFindPos () {currpos = findstart; lineno = findline;}
	void 	setFindPos () {findstart = currpos;findline = lineno;}
	void 	setFindPos (char HUGE *fpos) {findstart = fpos;findline = lineno;}
	int 	atStart ();
	int 	atEnd ();
	void 	toStart ();
	void 	toEnd ();
	long	fsize () { return filesize; }
	char HUGE * getPos () {return currpos;}
	void 	setPos (char HUGE *p) {currpos = p;}
	void 	setFindLine (int i) {findline = i;}
	void 	setFindLine () {findline = lineno;}
	long 	getFindLine () {return findline;}
	void	setLineNo (int i) {lineno = i;}
	long 	offset () { return (long) (currpos - filebuf);}
	long	LineNo () { return lineno;}
	long	FindLine () { return findline;}
	long	StartLineNo () { return startline;}
	long	TotalLines () { return totallines;}
	void	wrap (int i) { wordwrap = i;}
	int	wrap () { return wordwrap; }
protected:
	char HUGE * GetLine (long *, int);
private:
	virtual int ch(zKeyEvt*);
	int 	ReadInFile ();
	char 	filename[256];
	char 	currline[MAXLINELEN];
	long 	filesize;
	char HUGE *filebuf;
	char HUGE *currpos;
	char HUGE *pageStart;
	char HUGE *pageEnd;
	char HUGE *findstart;		// where to start find
	int	wordwrap;
	int 	gotfile;
	long	lineno;
	long	totallines;
	long	startline;
	long 	endline;
	long	findline;
#ifdef WINDOWS
	HGLOBAL hglb;
#endif
};

#endif // __FILE_HPP__
