/****************************************************************************
 * PRT2WFX.C                v3.1
 *
 * code to allow an app to print to WinFax as easily as to default printer.
 *
 * (C)opyright 1993 Delrina Coportation.
 ****************************************************************************/
#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <print.h>
#include <string.h>
#include "prt2wfx.h"

extern PRINTDLG pd;   // the Main application's default PRINTDLG Structure   
extern PRINTDLG wfxpd;// the Main application's WinFax PRINTDLG Structure 

BOOL GetWinFaxDefaultInfo(void);  // local prototype 
                            
/************************************************************************
 * GetPrinterDC()
 *
 * get a device context to either default printer or WinFax printer
 ************************************************************************/
HDC FAR PASCAL GetPrinterDC( BOOL bWinFax)
{
       	if (bWinFax)
	  		return (GetWinFaxPrinter());
	  	else
         	return (GetDefaultPrinter());	
}         	


/************************************************************************
 * GetWinFaxPrinter()
 *
 * Uses the Windows PrintDlg function to obtain a device context for
 * the WinFax Printer
 *. 
 ************************************************************************/
HDC FAR PASCAL GetWinFaxPrinter(void)
{   
	
	if (!GetWinFaxDefaultInfo())
		return (NULL);
							
	//Now call Windows PrintDlg with default settings for WinFax Driver
	
    if (!PrintDlg((LPPRINTDLG)&wfxpd))
        return(NULL);
    
    // Note: wfxpd.hDevMode & wfxpd.hDevNames must be
    // freed by the application when the program exits.
  	   
    return(wfxpd.hDC);
}
         

/************************************************************************
 * GetDefaultPrinter()
 *
 *   Uses the Windows PrintDlg fuction to obtain the default printer
 *   device context.
 *
 ************************************************************************/
HDC FAR PASCAL GetDefaultPrinter(void)
{

    if (!PrintDlg((LPPRINTDLG)&pd))
        return(NULL);  
        
    // Note: pd.hDevMode & pd.hDevNames are allocated by PrintDlg() and  must be
    // freed by the application when the program exits.
 
    return(pd.hDC);
}

/**********************************************************************************
* GetWinFaxDefaultInfo()
*
* Update the Global Winfax PRNTDLG stucture with Default info from the Driver
*
************************************************************************************/
BOOL GetWinFaxDefaultInfo(void)
{
    LPDEVMODE   lpDevMode;
    LPDEVNAMES  lpDevNames;
    LPSTR       lpszDriverName;
    LPSTR       lpszDeviceName;
    LPSTR       lpszPortName;
    HINSTANCE      hDriver;
    FARPROC     lpExtDeviceModeFunc;
    int 		iDevModeSize, iResult;
   
	char szDevice[80], szDriver[20], szPort[20];
    char    szPrtInfo[120], szDriverFileName[14];
    LPSTR   lpBegin;
    
    szDevice[0]= '\0'; szDriver[0]= '\0'; szPort[0]= '\0';

    if (wfxpd.hDevNames && wfxpd.hDevMode)
    	return TRUE; // structures have already been initialized.
    
    //use the WIN.INI to get the default printer string
    szPrtInfo[0]= '\0';
    GetProfileString( "devices", "WinFax", szPrtInfo, szPrtInfo, sizeof(szPrtInfo));

    // break down the string in to components

    lstrcpy( szDevice, "WinFax");                    //extract device name

    if ((lpBegin= _fstrtok( szPrtInfo, ", ")) != NULL)  //extract driver name
        lstrcpy( szDriver, lpBegin);

    if ((lpBegin= _fstrtok( NULL, ", ")) != NULL)       //extract port name
        lstrcpy( szPort, lpBegin);

    if ((szDriver==NULL) || (szPort==NULL))
    	return FALSE;

	// Since we are using the Windows Common Print Dlg. We must allocate memory for
	// the hDevName and hDevMode elements of the PRINTDLG structure
  
    // Get a handle to the WinFax Driver
    lstrcpy(szDriverFileName, szDriver);
    lstrcat(szDriverFileName, ".DRV");
    hDriver = LoadLibrary(szDriverFileName);
    
    if(hDriver <=  HINSTANCE_ERROR) 
    	return FALSE;  // unable to load WinFax Driver

   // Get Procedure address of the ExtDeviceMode function in the Driver
    lpExtDeviceModeFunc = GetProcAddress(hDriver, "ExtDeviceMode");
     
  	if (lpExtDeviceModeFunc == NULL)
   		return FALSE;  // could not find fuction in the Driver
   		
   // Allocate memory for the DEVNAMES structure to pass to PrintDlg 	
   	wfxpd.hDevNames=GlobalAlloc(GHND, sizeof(DEVNAMES)+
   						lstrlen(szDevice)+lstrlen(szDriver)+lstrlen(szPort)+3);
   	lpDevNames = (LPDEVNAMES) GlobalLock(wfxpd.hDevNames);
   	
   	// Initialize the DevNames structure with values obtained from WIN.INI
   	
   	// Driver
   	lpDevNames->wDriverOffset = sizeof(DEVNAMES);
   	lpszDriverName = (LPSTR) (lpDevNames+1);
   	lstrcpy(lpszDriverName, szDriver);
   	
   	//Device
   	lpDevNames->wDeviceOffset = lpDevNames->wDriverOffset+lstrlen(szDriver)+1;
   	lpszDeviceName = lpszDriverName + lstrlen (szDriver) +1;
   	lstrcpy(lpszDeviceName, szDevice);
   	
   	//Port
   	lpDevNames->wOutputOffset = lpDevNames->wDeviceOffset+lstrlen(szDevice)+1;
   	lpszPortName = lpszDeviceName + lstrlen(szDevice)+1;
   	lstrcpy(lpszPortName, szPort);
   	
    GlobalUnlock(wfxpd.hDevNames);
    	
   	//Get the size of the driver's DEVMODE structure (including private data) by
   	//calling the driver's ExtDeviceMode Function.
   
    iDevModeSize= (*lpExtDeviceModeFunc)((HWND) wfxpd.hwndOwner, (HINSTANCE) hDriver,
    						 (LPDEVMODE) NULL, (LPSTR) szDevice, (LPSTR) szPort,
   						            (LPDEVMODE) NULL, (LPSTR) NULL, (WORD) 0 );
    
   	// Allocate memory for the DEVMODE structure
   
   	wfxpd.hDevMode = GlobalAlloc (GHND, (DWORD) iDevModeSize);
   	lpDevMode = (LPDEVMODE) GlobalLock(wfxpd.hDevMode);
        
    // Ask driver to fill in the default DEVMODE structure
	iResult = (*lpExtDeviceModeFunc)((HWND) wfxpd.hwndOwner, (HINSTANCE) hDriver,
                        (LPDEVMODE) lpDevMode,(LPSTR) szDevice, (LPSTR) szPort,
   						(LPDEVMODE) NULL, (LPSTR) NULL, (WORD) DM_OUT_BUFFER );
   
   GlobalUnlock(wfxpd.hDevMode);
   FreeLibrary(hDriver);
   
   if(iResult < 0)  
    	return FALSE; // function failed   						
   else
   		return TRUE; //success!  						            
}
