//tabs=4
//
//		==========
//		SIGHTTPD.C
//      ==========
//
// This is the C source for a DLL that finds the Windows Web Server httpd
// and sends it a message that signals it to cycle its logfile(s). It was
// written to be used from the Visual Basic usage analyzer VBUSAGE.
//
// WARNING: The message code (WM_USER+13) is hardwired.
//
// History:
//    Who               When        What
//    ----------------- ---------   --------------------------------------
//    Robert B. Denny   04-Jun-94   Created - First internal test release
//

#include <windows.h>
#define WEP_NEEDEDoff

HINSTANCE _hInst;				// Instance handle of this DLL
HWND hTheWindow;				// Used by WindCatcher() during enumeration

BOOL CALLBACK WindCatcher(HWND hWnd, LPARAM lparam);

//--------------------------------------------------------------------------
//
// LibMain() - DLL entry function
//
// Called only once, when the DLL is first loaded. Nothing to do here.
//
//--------------------------------------------------------------------------
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg,
								WORD cbHeapSize, LPSTR lpszCmdLine)
{

	if(cbHeapSize !=0 )
		UnlockData(0);                  // Unlock data segment
	_hInst = hInstance;                  // Save our instance handle

	return(1);
}

//--------------------------------------------------------------------------
//
// WEP() - DLL termination function
//
// Notes:  In Borland C++, we don't need a WEP function, BC4 provides
//         its own, and calls ours, if present. Here we just disable
//         the code...
//
// WARNING: Do not export WEP in the module definition file if using
//          BC4. It is not needed.
//
//--------------------------------------------------------------------------
#if defined (WEP_NEEDED)
#pragma argsused
int CALLBACK WEP(int nParamater)
{
	return(0);
}
#endif



//--------------------------------------------------------------------------
//
// SigHTTPD() - Signal Windows httpd to cycle log(s).
//
// Enumerates windows looking for one whose name starts with 'httpd'. Once
// found, it posts a (WM_USER + 13) message to that window. The wParam of
// the message tells which logfiles to cycle (mask):
//
//	wParam = 1		Cycle access log
//	wParam = 2		Cycle Error log
//	wParam = 3		Cycle both logs
//
// Returns non-zero (-1, true) if successful, else 0 (false)
//--------------------------------------------------------------------------
int FAR PASCAL SigHTTPD(BOOL fAcc, BOOL fErr)
{
	FARPROC lpfnEnumWinCB;			// Thunk for enum callback

	hTheWindow = NULL;				// Assume failure

	lpfnEnumWinCB = MakeProcInstance((FARPROC)WindCatcher, _hInst);
	EnumWindows(lpfnEnumWinCB, NULL);
	FreeProcInstance(lpfnEnumWinCB);

	if(hTheWindow != NULL)			// If we found an httpd running
	{
		WORD mask = 0;

		if(fAcc) mask |= 1;			// Make the mask
		if(fErr) mask |= 2;
		//
		// NOTE: This is hard-coded for httpd V1.2b8.
		//
		return(PostMessage(hTheWindow, (WM_USER + 13), mask, 0));
	}
	return(0);
}


//------------------------------------------------------------------------
//
// WindCatcher() - Callback function for EnumTaskWindows(). Passes
//                 back a copy of the next window handle.
//
//------------------------------------------------------------------------
#define BUF_LEN 64
#pragma argsused
BOOL CALLBACK WindCatcher (HWND hWnd, LPARAM lparam)
{
	char buf[BUF_LEN+1];
	static const char *tgtName = "httpd";
	register int i;

	GetWindowText(hWnd, (LPSTR)buf, BUF_LEN);	// Get name
	for(i=0; i < 5; i++)						// Avoid huge C library
		if(buf[i] != tgtName[i])
			break;
	if(i == 5)
	{											// Found it
		hTheWindow = hWnd;
		return(FALSE);
	}
	return(TRUE);								// Keep going
}

