.\" Copyright (c) 1989, 1991 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"     @(#)crypt.3	6.7 (Berkeley) 5/21/91
.\"
.Dd May 21, 1991
.Dt CRYPT 3
.Os
.Sh NAME
.Nm crypt ,
.Nm setkey ,
.Nm encrypt ,
.Nm des_setkey ,
.Nm des_cipher
.Nd DES encryption
.Sh SYNOPSIS
.Ft char
.Fn *crypt "const char *key" "const char *setting"
.Ft int
.Fn setkey "char *key"
.Ft int
.Fn encrypt "char *block" "int flag"
.Ft int
.Fn des_setkey "const char *key"
.Ft int
.Fn des_cipher "const char *in" "char *out" "long salt" "int count"
.Sh DESCRIPTION
The
.Xr crypt
function
performs password encryption.
It is derived from the
.Tn NBS
Data Encryption Standard.
Additional code has been added to deter
key search attempts.
The first argument to
.Nm crypt
is
a
.Dv NUL Ns -terminated
string (normally a password typed by a user).
The second is a character array, 9 bytes in length, consisting of an
underscore (``_'') followed by 4 bytes of iteration count and 4 bytes
of salt.
Both the iteration
.Fa count
and the 
.Fa salt
are encoded with 6 bits per character, least significant bits first.
The values 0 to 63 are encoded by the characters ``./0-9A-Za-z'',
respectively.
.Pp
The
.Fa salt
is used to induce disorder in to the
.Tn DES
algorithm
in one of 16777216
possible ways
(specifically, if bit
.Em i
of the
.Ar salt
is set then bits
.Em i
and
.Em i+24
are swapped in the
.Tn DES
``E'' box output).
The
.Ar key
is divided into groups of 8 characters (a short final group is null-padded)
and the low-order 7 bits of each each character (56 bits per group) are
used to form the DES key as follows: the first group of 56 bits becomes the
initial DES key.
For each additional group, the XOR of the group bits and the encryption of
the DES key with itself becomes the next DES key.
Then the final DES key is used to perform
.Ar count
cumulative encryptions of a 64-bit constant.
The value returned is a
.Dv NUL Ns -terminated
string, 20 bytes in length, consisting
of the
.Ar setting
followed by the encoded 64-bit encryption.
.Pp
For compatibility with historical versions of
.Xr crypt 3 ,
the
.Ar setting
may consist of 2 bytes of salt, encoded as above, in which case an
iteration
.Ar count
of 25 is used, fewer perturbations of
.Tn DES
are available, at most 8
characters of
.Ar key
are used, and the returned value is a
.Dv NUL Ns -terminated
string 13 bytes in length.
.Pp
The
functions,
.Fn encrypt ,
.Fn setkey ,
.Fn des_setkey
and
.Fn des_cipher
allow limited access to the
.Tn DES
algorithm itself.
The
.Ar key
argument to
.Fn setkey
is a 64 character array of
binary values (numeric 0 or 1).
A 56-bit key is derived from this array by dividing the array
into groups of 8 and ignoring the last bit in each group.
.Pp
The
.Fn encrypt
argument
.Fa block
is also a 64 character array of
binary values.
If the value of
.Fa flag
is 0,
the argument
.Fa block
is encrypted, otherwise it
is decrypted.
The encryption or decryption is returned in the original
array
.Fa block
after using the
key specified
by
.Fn setkey
to process it.
.Pp
The
.Fn des_setkey
and
.Fn des_cipher
functions are faster but less portable than
.Fn setkey
and
.Fn encrypt .
The argument to
.Fn des_setkey
is a character array of length 8.
The
.Em least
significant bit in each character is ignored and the next 7 bits of each
character are concatenated to yield a 56-bit key.
The function
.Fn des_cipher
encrypts (or decrypts if
.Fa count
is negative) the 64-bits stored in the 8 characters at
.Fa in
using
.Xr abs 3
of
.Fa count
iterations of
.Tn DES
and stores the 64-bit result in the 8 characters at
.Fa out .
The
.Fa salt
specifies perturbations to
.Tn DES
as described above.
.Pp
The function
.Fn crypt
returns a pointer to the encrypted value on success and NULL on failure.
The functions
.Fn setkey ,
.Fn encrypt ,
.Fn des_setkey ,
and
.Fn des_cipher
return 0 on success and 1 on failure.
Historically, the functions
.Fn setkey
and
.Fn encrypt
did not return any value.
They have been provided return values primarily to distinguish
implementations where hardware support is provided but not
available or where the DES encryption is not available due to the
usual political silliness.
.Sh SEE ALSO
.Xr login 1 ,
.Xr passwd 1 ,
.Xr getpass 3 ,
.Xr passwd 5
.sp
.Rs
.%T "Mathematical Cryptology for Computer Scientists and Mathematicians"
.%A Wayne Patterson
.%D 1987
.%N ISBN 0-8476-7438-X
.Re
.Rs
.%T "Password Security: A Case History"
.%A R. Morris
.%A Ken Thompson
.%J "Communications of the ACM"
.%V vol. 22
.%P pp. 594-597
.%D Nov. 1979
.Re
.Rs
.%T "DES will be Totally Insecure within Ten Years"
.%A M.E. Hellman
.%J "IEEE Spectrum"
.%V vol. 16
.%P pp. 32-39
.%D July 1979
.Re
.Sh HISTORY
A rotor-based
.Fn crypt
function appeared in
.At v6 .
The current style
.Fn crypt
first appeared in
.At v7 .
.Sh BUGS
Dropping the
.Em least
significant bit in each character of the argument to
.Fn des_setkey
is ridiculous.
.Pp
The
.Fn crypt
function leaves its result in an internal static object and returns
a pointer to that object.
Subsequent calls to
.Fn crypt
will modify the same object.
