
/* *************************************************************** */
/*                                                                 */
/*                                                                 */
/*                                                                 */
/*   SMTP4W.DLL  (Version 2.0)                                     */
/*                                                                 */
/*                                                                 */
/*                                                   By Ph. Jounin */
/*                                        Internet ark@ifh.sncf.fr */
/* *************************************************************** */


#ifndef SMTP4W_API

#include <winsock.h>

#ifdef __cplusplus  
extern "C" {            /* Assume C declarations for C++ */   
#endif  /* __cplusplus */   

#define  SMTP4W_INBUFFER    1024 /* see RFC 821 */
#define  SMTP4W_NAME         256 /* its already a long name */



/* ----------------------------------------------------------- */

/* ASCII or binary tranfser */
#define   TYPE_A   'A'
#define   TYPE_I   'I'


/* ----------------------------------------------------------- */
/*              Return codes of FTP functions                  */
/* ----------------------------------------------------------- */
/* success */
#define  SMTPERR_OK                    0 /* succesful function                */
#define  SMTPERR_FORWARDED             1 /* cf SmtpVerify                     */
#define  SMTPERR_CANCELBYUSER         -1 /* Transfer aborted by  SmtpAbort    */

/* user's or programmer's Errors  */
#define  SMTPERR_SESSIONUSED        1001 /* User has already a FTP session    */
#define  SMTPERR_NOTINITIALIZED     1002 /* SmtpInit has not been called      */
#define  SMTPERR_NOTCONNECTED       1003 /* User is not connected to a server */
#define  SMTPERR_CANTOPENFILE       1004 /* can not open specified file       */
#define  SMTPERR_NOACTIVESESSION    1006 /* SmtpRelease without SmtpInit      */
#define  SMTPERR_STILLCONNECTED     1007 /* SmtpRelease without any Close     */
#define  SMTPERR_SERVERCANTEXECUTE  1008 /* file action not taken             */
#define  SMTPERR_STORAGEEXCEDED     1009 /* server can not store message      */
#define  SMTPERR_TRANSFERREFUSED    1011 /* Host refused the transfer         */
#define  SMTPERR_WINSOCKNOTUSABLE   1012 /* A winsock.DLL ver 1.1 is required */
#define  SMTPERR_CANTCLOSE          1013 /* Close failed (cmd is in progress) */
#define  SMTPERR_SYNTAXERROR        1014 /* Error in parameters               */
#define  SMTPERR_UNKNOWNUSER        6000

/* TCP errors */
#define  SMTPERR_UNKNOWNHOST        2001 /* can not resolve host adress       */
#define  SMTPERR_NOREPLY            2002 /* host does not send an answer      */
#define  SMTPERR_CANTCONNECT        2003 /* Error during connection           */
#define  SMTPERR_CONNECTREJECTED    2004 /* host has no SMTP server           */
#define  SMTPERR_SENDREFUSED        2005 /* can't send data (network down)    */
#define  SMTPERR_TIMEOUT            2007 /* timeout occured                   */

/* SMTP server errors */
#define  SMTPERR_UNEXPECTEDANSWER   3001  /* answer was not expected          */
#define  SMTPERR_SERVICECLOSED      3002  /* service unavailable              */
#define  SMTPERR_NOTIMPLEMENTED     3003  /* host recognize but can't exec cmd*/
#define  SMTPERR_CANTWRITE          3004  /* server can not write data        */
#define  SMTPERR_MIMENOTSUPPORTED   3005  /* server doesn't support MIME ext. */

/* Resource errors */
#define  SMTPERR_CANTCREATEWINDOW   5002  /* Insufficent free resources       */
#define  SMTPERR_INSMEMORY          5003  /* Insuffisent Heap memory          */
#define  SMTPERR_CANTCREATESOCKET   5004  /* no more socket                   */
#define  SMTPERR_CANTBINDSOCKET     5005  /* bind is not succesful            */
#define  SMTPERR_BLOCKINGCALL       5006  /* Close rejected : blocking call   */


/* ----------------------------------------------------------- */

struct S_SmtpData
{
   SOCKET   ctrl_socket;    /* control stream       init INVALID_SOCKET */
   BOOL     bVerbose;       /* verbose mode         init FALSE          */ 
   BOOL     b8Mime;         /* supports 8 bits MIME protocol            */
   BOOL     bSize;          /* supports the SIZE keyword                */
   unsigned short    nPort; /* connexion Port       init FTP_DEFPORT    */
   unsigned uTimeOut;       /* TimeOut in seconds   init FTP_DEFTIMEOUT */
   char     szInBuf [SMTP4W_INBUFFER]; /* incoming Buffer               */
   char     szRejected [SMTP4W_NAME]; /* first rejected user */
   int      nRejected;                /* its rank            */
}; /* struct S_SmtpData */


struct S_Verbose
{
   HWND          hVerboseWnd;  /* window which the message is to be passed    */
   UINT          nVerboseMsg;  /* msg to be sent each time a line is received */
};

/* global structure */
struct S_ProcData
{  
   /* -- task data */
   HTASK      hTask;              /* Task Id                              */
   HWND       hParentWnd;         /* handle given to the FtpInit function */
   HINSTANCE  hInstance;          /* Task Instance                        */
   HFILE      hDataFile;
   HFILE      hLogFile;
   /* -- Mesasge information */
   struct S_Verbose   VMsg; /* to be sent each time a frame has been received */
   /* -- Smtp information */
   struct S_SmtpData  smtp;
   /* -- Linked list */
   struct S_ProcData far *Next;
   struct S_ProcData far *Prev;
}; /* struct S_ProcData */

typedef struct S_ProcData far * LPProcData;



/* **************************************************************** */
/*                                                                  */
/*                    P R O T O T Y P E S                           */
/*                                                                  */
/* **************************************************************** */

/* Utilities functions */
int PASCAL FAR WEP (int nType);
int PASCAL FAR Smtp4wVer (LPSTR szVerStr, int nStrSize);

/* change default parameters */
int  PASCAL FAR SmtpSetVerboseMode (BOOL bVerboseMode, HWND hVerboseWnd, UINT wMsg);
void PASCAL FAR SmtpSetDefaultTimeOut (int nTo_in_sec);
void PASCAL FAR SmtpSetDefaultPort(int nDefPort);
int  PASCAL FAR SmtpLogTo (HFILE hLogFile);
int  PASCAL FAR SmtpWhichHasFailed (LPSTR szUserId, UINT uUserSize);

/* Init functions */
int PASCAL FAR SmtpRelease (void);
int PASCAL FAR SmtpInit (HWND hParentWnd);

/* Connection */
int PASCAL FAR SmtpOpenConnection (LPSTR szSmtpServer);
int PASCAL FAR SmtpCloseConnection (void);
int PASCAL FAR SmtpLocalClose (void);


/* Commands */
int PASCAL FAR SmtpHello (LPSTR szDomainName);
int PASCAL FAR SmtpMail (LPSTR szMailFrom);
int PASCAL FAR SmtpRcpt (LPSTR szMailTo);
int PASCAL FAR SmtpMultiRcpt (LPSTR far *lpMailTo);
int PASCAL FAR SmtpVerify (LPSTR szUser, LPSTR szFullName, 
                           int FullNameSize);

/* data commands */
int PASCAL FAR SmtpOpenDataChannel (void);
int PASCAL FAR SmtpCloseDataChannel (void);
int PASCAL FAR SmtpSendThroughDataChannel (LPSTR sData, UINT uDataSize);
int PASCAL FAR SmtpFileThroughDataChannel (LPSTR szFile);
int PASCAL FAR SmtpData (LPSTR sData, UINT uDataSize);
int PASCAL FAR SmtpFile (LPSTR szFile);

/* Main Command */
int PASCAL FAR SmtpSendMail (LPSTR szSmtpServer,
                             LPSTR szDomainName,
                             LPSTR szFrom,
                             LPSTR szTo,
                             LPSTR szCopyTo,
                             LPSTR szSubject,
                             LPSTR szData,
                             UINT  uBufSize);
int PASCAL FAR SmtpSendFile (LPSTR szSmtpServer,
                             LPSTR szDomainName,
                             LPSTR szFrom,
                             LPSTR szTo,
                             LPSTR szCopyTo,
                             LPSTR szHeaders,
                             LPSTR szFile);
int PASCAL FAR SmtpSendMimeFile (LPSTR szSmtpServer,
                                 LPSTR szDomainName,
                                 LPSTR szFrom,
                                 LPSTR szTo,
                                 LPSTR szCopyTo,
                                 LPSTR szHeaders,
                                 LPSTR szFile);

/* _______________________________________________________________ */

#ifdef __cplusplus     
}  /* End of extern "C" */   
#endif /* ifdef __cplusplus */  

#define SMTP4W_API loaded
#endif /* ifndef SMTP4W_API */

