//*******************************************************************
//
//
//    Sample App for Smtp4w
// 
//              Version 2.0 By Philippe Jounin
//*******************************************************************

#define  STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "..\smtp4w.h"
#include "mail.rh"

#define    START_MAIL             WM_USER+103


/* informations sur l'application */
struct S_Setupata
{
   char   szAppName[20]; // name of application
}  SetUpData;        // donnees partagees entre main et systeme

/* Handle des fenetres */
HINSTANCE hInst;                // hInstance of application
HWND      hwnd;                 // hWnd of main window
HWND      hwnd_dlg;             // hWnd of dialog window



// function prototypes
BOOL FAR PASCAL   QCSUBMsgProc (HWND hWndDlg, WORD Message,WORD wParam, LONG lParam);

#define  MSG_INITERROR    "Sorry ! Smtp4w initialisation error"


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*   About dialog Callback                                     */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

BOOL CALLBACK _export AboutDlgProc(HWND hWndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
char szBuf  [100];
char szText [200];
    switch ( msg )
    {
       case WM_COMMAND:
          switch (wParam)
            {
              case IDOK :
                  EndDialog (hWndDlg, 0);
                  break;
            }  /* case WM_COMMAND */
          break;
       case WM_INITDIALOG :
          Smtp4wVer (szBuf, sizeof szBuf);
          wsprintf (szText, "Sample App for Smtp4w\n\n%s", szBuf);
          SetDlgItemText (hWndDlg, IDC_ABOUT, szText);
          break;
     }
return FALSE;
} /* NewDestDlgProc */



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*   Dest dialog Callback                                      */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

static char szNewDest [128];

BOOL CALLBACK _export NewDestDlgProc(HWND hWndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch ( msg )
    {
        case WM_COMMAND:
          switch (wParam)
            {
              case IDOK :
                  GetDlgItemText (hWndDlg, IDC_NEWDEST, szNewDest, sizeof szNewDest);
                  EndDialog (hWndDlg, 0);
                  break;

              case IDCANCEL :
                  szNewDest[0] = 0;  /* annulation du nom */
                  EndDialog (hWndDlg, 0);
                  break;
            }  /* case WM_COMMAND */
          break;
     }
return FALSE;
} /* NewDestDlgProc */


char *GetNewDestName (char *szBuf, int nLength)
{
return  lstrcpyn (szBuf,szNewDest, nLength);
} /* GetNewDestName */



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*   Main dialog callback                                      */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
BOOL _export FAR PASCAL QCSUBMsgProc ( HWND hWndDlg, WORD Message,
                               WORD wParam, LONG lParam )
{
int     Rc, Evan, nToDel;
char    szBuf[128];
static char szTo[1024];  /* should be dynamically allocated !! */
static char szTxt [1024];
char    szFrom [60];
char    szSrv [60];


  switch (Message)
    {
      case WM_INITDIALOG :
         /* start Smtp4w then check return code */
         Rc = SmtpInit (hWndDlg);
         if (Rc!= SMTPERR_OK)
                  MessageBox (hWndDlg, MSG_INITERROR, "Mail", MB_OK);
         else     PostMessage (hWndDlg, START_MAIL, 0, 0);
         break; 

      case WM_COMMAND :
         switch (wParam)
           {
               case IDOK :
                   /* read input data */
                   GetDlgItemText(hWndDlg, IDC_FROM,szFrom,sizeof szFrom);
                   GetDlgItemText(hWndDlg, IDC_SERVER,szSrv,sizeof szSrv);
                   GetDlgItemText(hWndDlg, IDC_TEXTE,szTxt,sizeof szTxt);
                   Evan=0 ;  
                   do
                      {
                       szBuf[0] = 0;
                       SendDlgItemMessage (hWndDlg, IDC_LISTE_DEST, 
                                                LB_GETTEXT, Evan++, (LPARAM) szBuf);
                       if (szBuf[0] != 0  && Evan!=0)    lstrcat (szTo, ", ");
                       lstrcat (szTo, szBuf);
                      }
                   while (szBuf[0] != 0);
                        
                   /* all dat have been read -> sen mail */
                   Rc=SmtpSendMail (szSrv, NULL, szFrom, szTo, NULL, NULL, szTxt, 0);
                   /* print return code */
                   wsprintf (szBuf, "%s\nSmtp4w Returns %d", Rc==SMTPERR_OK ? "Success" : "Error", Rc);
                   MessageBox (hWndDlg, szBuf, "Mail", MB_OK);
                   break;

               case IDCANCEL:
                   /* Ends Smtp4w use */
                   SmtpRelease ();
                   EndDialog (hWndDlg, FALSE);
                   break;

               case ID_ABOUT :
                   Rc = DialogBox(hInst, "AboutDlg", hWndDlg, AboutDlgProc);
                   if (Rc==-1)     MessageBeep ((unsigned) -1);
                   break;

              case IDC_AJOUT :   /* bouton Ajout du groupe */
                   Rc = DialogBox(hInst, "NewDestDlg", hWndDlg, NewDestDlgProc);
                   if (Rc==-1)
                            MessageBox (hWndDlg, "Insuffisent Memory", "Mail", MB_OK);
                   GetNewDestName (szBuf, sizeof szBuf);
                   if (szBuf[0]!=0)
                            SendDlgItemMessage (hWndDlg, IDC_LISTE_DEST, LB_INSERTSTRING, -1, (LPARAM) szBuf);
                   break;

               case IDC_SUPPR :   /* bouton Supprimer du groupe */
                   nToDel = SendDlgItemMessage (hWndDlg, IDC_LISTE_DEST, LB_GETCURSEL, 0, 0l);
                   if (nToDel>=0)
                         SendDlgItemMessage (hWndDlg, IDC_LISTE_DEST, LB_DELETESTRING, nToDel, 0);
                   break;
               default :
                   return FALSE;
             }
         break;

        case WM_CLOSE :
             PostMessage (hWndDlg, WM_COMMAND, IDCANCEL, 0);
             break;

        default :
             return FALSE;
       }
return TRUE;
} /* QCSUBMsgProc */




//*******************************************************************
int PASCAL WinMain    (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                       LPSTR lpszCmdLine, int cmdShow)
{
int     Rc;

     hInst = hInstance;
     Rc = DialogBox (hInst, "MAIL_DLG",0, (DLGPROC)QCSUBMsgProc) != -1;
     if (! Rc)
           MessageBox (NULL, "Can not open Dialog Box", SetUpData.szAppName, MB_OK);
return TRUE;
} /* WinMain */


//*******************************************************************




