/*---------------------------------------
   EMF13.C -- Enhanced Metafile Demo #13
              (c) Charles Petzold, 1994
  ---------------------------------------*/

#include <windows.h>
#include <string.h>

char szClass [] = "EMF13" ;
char szTitle [] = "EMF13: Enhanced Metafile Demo #13" ;

void DrawRuler (HDC hdc, int cx, int cy)
     {
     char    ch ;
     HFONT   hFont ;
     int     i, iHeight ;
     LOGFONT lf ;

     Rectangle (hdc, 0, 0, cx + 1, cy + 1) ;

     for (i = 0 ; i < 96 ; i++)
          {
               if (i % 16 == 0) iHeight = cy /  2 ;    // inches
          else if (i %  8 == 0) iHeight = cy /  3 ;    // half inches
          else if (i %  4 == 0) iHeight = cy /  5 ;    // quarter inches
          else if (i %  2 == 0) iHeight = cy /  8 ;    // eighths
          else                  iHeight = cy / 12 ;    // sixteenths

          MoveToEx (hdc, i * cx / 96, cy, NULL) ;
          LineTo   (hdc, i * cx / 96, cy - iHeight) ;
          }

     memset (&lf, 0, sizeof (lf)) ;

     lf.lfHeight = cy / 2 ;

     strcpy (lf.lfFaceName, "Times New Roman") ;

     hFont = CreateFontIndirect (&lf) ;

     SelectObject (hdc, hFont) ;
     SetTextAlign (hdc, TA_BOTTOM | TA_CENTER) ;
     SetBkMode    (hdc, TRANSPARENT) ;

     for (i = 1 ; i <= 5 ; i++)
          {
          ch = (char) (i + '0') ;

          TextOut (hdc, i * cx / 6, cy / 2, &ch, 1) ;
          }

     SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
     DeleteObject (hFont) ;
     }

void CreateRoutine (HWND hwnd)
     {
     HDC          hdcEMF ;
     HENHMETAFILE hemf ;
     int          cxMms, cyMms, cxPix, cyPix, xDpi, yDpi ;

     hdcEMF = CreateEnhMetaFile (NULL, "emf13.emf", NULL,
                                 "EMF13\0EMF Demo #13\0") ;

     cxMms = GetDeviceCaps (hdcEMF, HORZSIZE) ;
     cyMms = GetDeviceCaps (hdcEMF, VERTSIZE) ;
     cxPix = GetDeviceCaps (hdcEMF, HORZRES) ;
     cyPix = GetDeviceCaps (hdcEMF, VERTRES) ;

     xDpi = cxPix * 254 / cxMms / 10 ;
     yDpi = cyPix * 254 / cyMms / 10 ;

     DrawRuler (hdcEMF, 6 * xDpi, yDpi) ;

     hemf = CloseEnhMetaFile (hdcEMF) ;

     DeleteEnhMetaFile (hemf) ;
     }

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     ENHMETAHEADER emh ;
     HENHMETAFILE  hemf ;
     POINT         pt ;
     int           cxImage, cyImage ;
     RECT          rect ;

     SetMapMode (hdc, MM_HIMETRIC) ;

     SetViewportOrgEx (hdc, 0, cyArea, NULL) ;

     pt.x = cxArea ;
     pt.y = 0 ;

     DPtoLP (hdc, &pt, 1) ;

     hemf = GetEnhMetaFile ("emf13.emf") ;

     GetEnhMetaFileHeader (hemf, sizeof (emh), &emh) ;

     cxImage = emh.rclFrame.right - emh.rclFrame.left ;
     cyImage = emh.rclFrame.bottom - emh.rclFrame.top ;

     rect.left   = (pt.x - cxImage) / 2 ;
     rect.top    = (pt.y + cyImage) / 2 ;
     rect.right  = (pt.x + cxImage) / 2 ;
     rect.bottom = (pt.y - cyImage) / 2 ;

     PlayEnhMetaFile (hdc, hemf, &rect) ;

     DeleteEnhMetaFile (hemf) ;
     }
