/*----------------------------------------
   EZTEST6.C -- EZFONT Test Program # 6
                (c) Charles Petzold, 1994
  ----------------------------------------*/

#include <windows.h>
#include <string.h>
#include "ezfont.h"

char szClass [] = "EzTest6" ;
char szTitle [] = "EzTest6:  EZFONT Test Program # 6" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     CHAR       szBuffer [64] ;
     HFONT      hFont ;
     INT        i, y, iDeciPtHeight = 120 ;
     TEXTMETRIC tm ;
     XFORM      xform ;

     SetBkMode (hdc, TRANSPARENT) ;
     SetGraphicsMode (hdc, GM_ADVANCED) ;

     y = 0 ;

     for (i = 1 ; i <= 6 ; i++)
          {
          xform.eM11 = (FLOAT) i ;
          xform.eM12 = (FLOAT) 0 ;
          xform.eM21 = (FLOAT) 0 ;
          xform.eM22 = (FLOAT) i ;
          xform.eDx  = (FLOAT) 0 ;
          xform.eDy  = (FLOAT) 0 ;

          SetWorldTransform (hdc, &xform) ;

          hFont = EzCreateFont (hdc, "Times New Roman Bold",
                                iDeciPtHeight, 0, 0, TRUE) ;

          SelectObject (hdc, hFont) ;
          GetTextMetrics (hdc, &tm) ;

          wsprintf (szBuffer, "%d pts x %d, %d units high",
                    iDeciPtHeight / 10, i,
                    tm.tmHeight - tm.tmInternalLeading) ;

          TextOut (hdc, 0, y, szBuffer, strlen (szBuffer)) ;

          SelectObject (hdc, GetStockObject (SYSTEM_FONT)) ;
          DeleteObject (hFont) ;

          y += (tm.tmHeight - tm.tmInternalLeading) / 2 ;
          }
     }
