/*-----------------------------------------
   WIDEPATH.C -- WidenPath Demo
                 (c) Charles Petzold, 1994
  -----------------------------------------*/

#include <windows.h>

char szClass [] = "WidePath" ;
char szTitle [] = "WidePath: WidenPath Demo" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     static char * szOper  [] = { "Stroke, ", "Fill, ", "S & F, " } ;
     static char * szFill  [] = { "Alt", "Wind" } ;
     static char * szWide [] = { "", " (Widened)" } ;
     int           x, y ;

               // Define a logical display area

     SetMapMode (hdc, MM_ANISOTROPIC) ;
     SetWindowExtEx (hdc, 100, 100, NULL) ;
     SetViewportExtEx (hdc, cxArea / 4, cyArea / 3, NULL) ;

               // Set text alignment and brush

     SetTextAlign (hdc, TA_UPDATECP) ;
     SelectObject (hdc, GetStockObject (LTGRAY_BRUSH)) ;

     for (x = 0 ; x < 4 ; x++)
     for (y = 0 ; y < 3 ; y++)
          {
                    // Set the proper viewport origin

          SetViewportOrgEx (hdc, x * cxArea / 4,
                                 y * cyArea / 3, NULL) ;

                    // Display text descriptions

          MoveToEx (hdc, 0, 0, NULL) ;

          TextOut (hdc, 0, 0, szOper [y],     strlen (szOper [y])) ;
          TextOut (hdc, 0, 0, szFill [x % 2], strlen (szFill [x % 2])) ;
          TextOut (hdc, 0, 0, szWide [x > 1], strlen (szWide [x > 1])) ;

                    // Create a path with an open and closed subpath

          BeginPath (hdc) ;

          MoveToEx (hdc, 10, 30, NULL) ;
          LineTo   (hdc, 50, 70) ;
          LineTo   (hdc, 90, 30) ;

          MoveToEx (hdc, 10, 50, NULL) ;
          LineTo   (hdc, 50, 90) ;
          LineTo   (hdc, 90, 50) ;
          CloseFigure (hdc) ;

          EndPath (hdc) ;

                    // Possibly widen the path by a 10 width pen

          if (x > 1)
               {
               SelectObject (hdc, CreatePen (PS_SOLID, 10, 0)) ;
               WidenPath (hdc) ;
               DeleteObject (SelectObject (hdc, GetStockObject (BLACK_PEN))) ;
               }

                    // Set polygon filling mode

          SetPolyFillMode (hdc, x % 2 ? WINDING : ALTERNATE) ;

                    // Stroke, fill, or stroke and fill the path

          switch (y)
               {
               case 0:   StrokePath (hdc) ;         break ;
               case 1:   FillPath (hdc) ;           break ;
               case 2:   StrokeAndFillPath (hdc) ;  break ;
               }
          }
     }
