//-------------------------------------------------------------------
// WinVer - A DOS program that displays the version and operating mode 
// of Windows.
//
// Copyright 1994 Douglas Boling
//-------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>   

int GetWinEnv (int *, int *);

char *szModeText [3] = {"Real", "Standard", "Enhanced"};
char *szCopyright = "\nWinVer 1.0 Copyright 1994 Douglas Boling\n\n";

int main () {

	char szTemp[34];
	int WV, WM;

	printf (szCopyright);

	if (GetWinEnv (&WV, &WM))
		printf ("Windows not running\n");
	else {
		printf ("Windows version ");
		itoa (WV >> 8, szTemp, 10);
		printf (szTemp);
		printf (".");
		itoa (WV & 0x0ff, szTemp, 10);
		printf (szTemp);

		printf (" running in ");
		printf (szModeText[WM-1]);
		printf (" mode.\n");
	}
	return 0;
}
int GetWinEnv (int *psWinVer, int *psWinMode) {

	union REGS regs;
	struct SREGS segregs;

	//
	// Call Multiplex 160A to see if Windows 3.1 running
	//
	regs.x.ax = 0x160A;
	int86 (0x2f, &regs, &regs);
	if (regs.x.ax == 0) {
		*psWinVer = regs.x.bx;
		*psWinMode = regs.x.cx;
		return 0;
	}
	//
	// Call Multiplex 1600 to see if Windows enhanced mode running
	//
	regs.x.ax = 0x1600;
	int86 (0x2f, &regs, &regs);
	if (regs.h.al != 0) {
		if ((regs.h.al == 0xff) || (regs.h.al == 0x80))
			*psWinVer = 0x20A;
		else
			*psWinVer = (regs.h.al << 8) | regs.h.ah;

		*psWinMode = 3;
		return 0;
	}
	//
	// Call Multiplex 4680 to see if Windows standard or real mode
	//
	regs.x.ax = 0x4680;
	int86 (0x2f, &regs, &regs);
	//
	// If no response, not running under Windows.
	//
	if (regs.h.al != 0) {
		*psWinVer = 0;
		*psWinMode = 0;
		return 1;
	}
	//
	// See if DOS task switcher, If so, not Windows
	//
	regs.x.ax = 0x4b02;
	regs.x.bx = 0;
	regs.x.di = 0;
	segregs.es = 0;
	int86x (0x2f, &regs, &regs, &segregs);
	if (regs.h.al == 0)
		return 1;
	*psWinVer = 0x300;
	*psWinMode = 1;
	//
	// Simulate start of protected mode Windows.  If rejected, assume
	// that Std mode Windows running.
	//
	regs.x.ax = 0x1605;
	int86 (0x2f, &regs, &regs);
	if (regs.x.cx == 0xffff)
		(*psWinMode)++;
	//
	// Call Terminate Win to fix any programs that count init/term
	// Windows calls.
	//
	regs.x.ax = 0x1606;
	int86 (0x2f, &regs, &regs);

	return 0;
}

