;====================================================================
;	CONFIX - A handy device driver
;
;	Copyright (c) 1994 Douglas Boling
;====================================================================
		page	66,132
;--------------------------------------------------------------------
; CODE segment
;--------------------------------------------------------------------
		code	segment	
		assume	cs:code
MAXPARAMS	equ	10
RESULTPTR	equ	offset end_of_code + 256

init_req	struc
irLen		db	?			;Size of structure
irUnit		db	?
irFunction	db	?			;Requested function 
irStatus	dw	?			;Returned status
irReserved	db	8 dup (?)
irUnits		db	?			;Number of block drives
irEndAddress	dd	?			;End addr of driver
irParmAddress	dd	?			;Ptr to cmd line parms
irDriveNumber	db	?			;1st drive number
irMessageflag	dw	?			;Error word
init_req	ends

;====================================================================
;Device driver header
;====================================================================
		org	0			;Offset 0 for DD

header		dd	-1			;Ptr to next driver
		dw	8000h			;Attribute bits
		dw	offset strategy		;Ptr to strategy routine
		dw	offset interrupt	;Ptr to interrupt routine
		db	"CONFIX  "		;Device name

program		db	10,13,"CONFIX 1.0",10,13
	        db      "Copyright (c) 1994 Douglas Boling",13,10
	        db      "First published in PC Magazine, Feburary 22, 1994"
	        db      13,10,"$",1Ah
;
;Data needed for the driver
;
		even
req_header_ptr	dd	0			;Ptr to request header

cmdptr		dw	0			;Pointers to the parsed
parm1ptr	dw	0			;  parameters.
parm2ptr	dw	0
parm3ptr	dw	0
parm4ptr	dw	0
parm5ptr	dw	0
parm6ptr	dw	0
parm7ptr	dw	0
parm8ptr	dw	0
parm9ptr	dw	0
parm10ptr	dw	0
stringptr	dd	0
num_params	dw	0

saved_ss	dw	?
saved_sp	dw	?

cmdlist		db	"PAUSE",0      
		db	"CAPSLOCK",0   
		db	"NUMLOCK",0    
		db	"SCROLLLOCK",0 
		db	"CLS",0	       
		db	"REM",0	       
		db	"VIDMODE",0    
		db	"SMLFONT",0    
		db	"NORMFONT",0    
		db	"PRINTSCR",0   
		db	"ECHO",0       
		db	"PEEK",0       
		db	"POKE",0       
		db	"IN",0	       
		db	"OUT",0	       
		db	0

cmdtbl		dw	offset	pause_cmd
		dw	offset	capslock_cmd
		dw	offset	numlock_cmd
		dw	offset	scrlock_cmd
		dw	offset	cls_cmd
		dw	offset	rem_cmd
		dw	offset	setmode_cmd
		dw	offset	v50mode_cmd
		dw	offset	v25mode_cmd
		dw	offset	prtscr_cmd
		dw	offset	echo_cmd
		dw	offset	peek_cmd
		dw	offset	poke_cmd
		dw	offset	in_cmd
		dw	offset	out_cmd

errmsg0		db	"Allowable commands:",13,10
		db	9,"CLS"
		db	9,"REM"
		db	9," ECHO"
		db	9,"PAUSE",13,10
		db	9,"VIDMODE"
		db	9,"SMLFONT"
		db	9," NORMFONT",13,10
		db	9,"NUMLOCK"
		db	9,"CAPSLOCK"
		db	" SCROLLLOCK",13,10
		db	9,"PEEK"
		db	9,"POKE"
		db	9," IN"
		db	9,"OUT$"

errmsg1		db	"Must be ON or OFF$"
errmsg2		db	"Must be 0 - 255$"
errmsg3		db	"Number too large$"
errmsg4		db	"Required number missing$"

infomsg1	db	"Press any key when ready$"
endmsg		db	13,10,"$"

;====================================================================
;STRATEGY - Handles strategy calls from DOS by copying the request
;           header pointer into an internal buffer.
;====================================================================
strategy	proc	far
		assume	cs:code,ds:nothing,es:nothing
		mov	word ptr cs:[req_header_ptr],bx
		mov	word ptr cs:[req_header_ptr+2],es
		ret
strategy	endp
;====================================================================
;INTERRUPT - Handles interrupt calls from DOS by implimenting the
;            device driver functions
;====================================================================
interrupt	proc	far
		assume	cs:code,ds:nothing,es:nothing
		push	ax
		push	bx
		push	cx
		push	dx
		push	di
		push	si
		push	bp
		push	ds
		push	es
		pushf
		cld				;All string operations UP
		mov	di,cs
		mov	ds,di
		assume	ds:code
		les	di,req_header_ptr	;Get ptr to request header
		mov	al,es:[di.irFunction]	;Get requested function
	 	or	al,al			;If not INIT, error.
		mov	ax,8003h		;Load error status
		jne	interrupt_exit

		call	init			;CONFIX only has Init func
		les	di,req_header_ptr	;Get ptr to request header
		mov	ax,100h			;Set done bit
interrupt_exit:
		mov	es:[di.irStatus],ax	;Set status
		popf
		pop	es
		pop	ds
		pop	bp
		pop	si
		pop	di
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		ret
interrupt	endp
;--------------------------------------------------------------------
; Start of code.						    	
;--------------------------------------------------------------------
init		proc    near
	        assume  cs:code,ds:code
	        cld               		;Set string ops 'up.'
		lds	si,req_header_ptr	 ;Get ptr to request header
		mov	word ptr ds:[si.irEndAddress],0		;Set memory
		mov	word ptr ds:[si.irEndAddress+2],cs	;  size
		lds	si,ds:[si.irParmAddress]
		call	parse_line
		mov	ax,cs
		mov	ds,ax
		mov	es,ax
		mov	si,cmdptr
		or	si,si
		je	init_end
		call	upper			;Convert cmd to upper case
		mov	di,offset cmdlist	;ES:DI - ptr to cmd list
		call	findstr
		mov	dx,offset errmsg0
		jc	init_1
		shl	bx,1
		call	[bx+cmdtbl]		;Call function
		jnc	init_end
init_1:
		call	printmsg		;Print message
init_end:
		ret
init		endp

;--------------------------------------------------------------------
; PRTSCR - Prints the screen.  REM - No operation
;--------------------------------------------------------------------
prtscr_cmd	proc	near
		assume	cs:code,ds:code
		int	5			;BIOS print screen int
rem_cmd:
		clc
		ret
prtscr_cmd	endp

;--------------------------------------------------------------------
; PAUSE CMD - Pause command
;--------------------------------------------------------------------
pause_cmd	proc	near
		assume	cs:code,ds:code
		cmp	word ptr [stringptr+2],0
		jne	pause_1
		mov	dx,offset infomsg1	;Press any key msg
		call	printmsg		;Print prompt
		jmp	short pause_2
pause_1:
		call	echo_cmd
pause_2:
		call	getkey			;Wait for key
		clc
		ret
pause_cmd	endp

;--------------------------------------------------------------------
; ECHO - Echos a string to the display.
;--------------------------------------------------------------------
echo_cmd	proc	near
		assume	cs:code,ds:code
		push	ds
		lds	si,StringPtr		;Get ptr to prompt
		or	si,si
		je	echo_4
		xor	bx,bx			;Clear quote flag
echo_1:
		lodsb				;If CR, exit
		cmp	al,0dh
		je	echo_4
		cmp	al,'"'			;Check for quotes
		jne	echo_2
		not	bl			;Toggle quote flag
		cmp	byte ptr ds:[si],'"'
		jne	echo_1
		inc	si			;Skip extra quote
		not	bl			;Un-Toggle quote flag
		jmp	echo_3
echo_2:
		or	bl,bl			;See if within quotes
		je	echo_3
		cmp	al,'A'			;Yes, convert letters
		jb	echo_3			;  to lower case
		cmp	al,'Z'
		ja	echo_3
		or	al,20h
echo_3:		
		mov	ah,2			;DOS print char
		mov	dl,al
		int	21h
		jmp	short echo_1
echo_4:
		call	printcr
echo_exit:
		clc
		pop	ds
		ret
echo_cmd	endp

;--------------------------------------------------------------------
; LOCK CMD - Set or clear keyboard locks
;--------------------------------------------------------------------
lock_cmd	proc	near
		assume	cs:code,ds:code

capslock_cmd:	mov	bh,40h			;Bit for caps lock
		jmp	short lock_0
scrlock_cmd:	mov	bh,10h			;Bit for scroll lock
		jmp	short lock_0
numlock_cmd:	mov	bh,20h			;Bit for num lock

lock_0:
		push	es
		mov	dx,offset errmsg1	;Bad param msg
		mov	si,parm1ptr		;Cap 1st param
		or	si,si			;If no param, error
		je	lock_error
		call	upper

		mov	di,40h			;BIOS data segment
		mov	es,di
		mov	di,17h			;Offset of lock byte

		mov	bl,es:[di]		;Get keyboard lock byte
		cmp	byte ptr ds:[si],'O'	;See if param ON or OFF
		jne	lock_error

		mov	ax,ds:[si+1]
		cmp	ax,"FF"
		je	lock_off
		cmp	al,'N'
		jne	lock_error
		cmp	ah,' '
		ja	lock_error
		or	bl,bh			;Set bit
		jmp	short lock_1
lock_off:
		not	bh
		and	bl,bh			;Clear bit
lock_1:
		mov	es:[di],bl		;Write back lock byte
		clc
lock_exit:
		pop	es
		ret
lock_error:
		stc
		jmp	short lock_exit
lock_cmd	endp
;--------------------------------------------------------------------
; CLS - Clear screen
;--------------------------------------------------------------------
cls_cmd		proc	near
		assume	cs:code,ds:code
		push	es
		mov	ah,0fh			;Get video mode
		int	10h
		push	bx			;Save active video page 
		push	ax			;Save number of cols
		cmp	al,3			;See if in text mode
		jbe	cls_1
		mov	ah,0
		cmp	al,7
		jne	cls_2
cls_1:
		mov	ah,2			;Print space with DOS to
		mov	dl,' '			;  get current background
		int	21h			;  attr.
		mov	ax,0e08h		;Back up over space
		int	10h
		mov	ah,8			;Get attribute used by DOS
		int	10h
cls_2:
		mov	bh,ah			;Copy attribute
		xor	cx,cx			;Start in upper left corner

		pop	dx			;Get back num of cols
		mov	dl,dh

		mov	di,40h			;BIOS data segment
		mov	es,di
		mov	dh,es:[84h]		;Get screen rows
		mov	ax,0600h		;Scroll scrn all the way up
		int	10h
		pop	bx

		mov	ah,2			;Set cursor pos
		xor	dx,dx			;row, col = 0,0
		int	10h
		pop	es
		ret
cls_cmd		endp

;--------------------------------------------------------------------
; SETMODE - Sets the video mode
;--------------------------------------------------------------------
setmode_cmd	proc	near
		assume	cs:code,ds:code
		mov	dx,offset errmsg2	;Bad number msg
		mov	si,parm1ptr		;Cap 1st param
		or	si,si			;If no param, error
		je	setmode_error
		call	asc2hex			;Convert to number
		jc	setmode_exit
		or	ah,ah			;See if num too big
		jc	setmode_error
		
		int	10h			;AH already 0
		clc
setmode_exit:
		ret
setmode_error:
		stc
		jmp	short setmode_exit
setmode_cmd	endp

;--------------------------------------------------------------------
; V50MODE - Switches to 50 line mode for VGA or 43 lines for EGA
;--------------------------------------------------------------------
v50mode_cmd	proc	near
		assume	cs:code,ds:code
		call	getvid			;Get video type
		cmp	al,6			;If MDA, CGA or PGC
		je	v50mode_exit		;  exit.
		cmp	al,4
		jb	v50mode_exit
		mov	ax,1112h		;Switch to 8x8 font
		mov	bl,0			;block 0
		int	10h
v50mode_exit:
		clc
		ret
v50mode_cmd	endp
;--------------------------------------------------------------------
; V25MODE - Switches back to 25 line mode 
;--------------------------------------------------------------------
v25mode_cmd	proc	near
		assume	cs:code,ds:code
		call	getvid			;Get video type
		cmp	al,6			;If MDA, CGA or PGC
		je	v25mode_exit		;  exit.
		cmp	al,4
		jb	v25mode_exit
		mov	ax,1111h
		cmp	al,6			;If EGA use 8x14
		jb	v25mode_1
		mov	al,14h			;Set 8x16 font
v25mode_1:
		mov	bl,0			;block 0
		int	10h
		call	cls_cmd
v25mode_exit:
		clc
		ret
v25mode_cmd	endp
;------------------------------------------------------------------------
; PEEK CMD Returns byte(s) from memory
;------------------------------------------------------------------------
peek_cmd	proc    near
	        assume  cs:code,ds:code,es:code
		push	bp
	        mov     dx,offset errmsg4	;Not enough parameters
		cmp	num_params,2
		jb	peek_cmd_err1
		call    conv2num                ;Convert first two parms to
	        jc      peek_cmd_exit           ;  32 bit numbers.  
		mov	cx,1			;Assume 1 byte peek
		mov	bp,0			;Assume byte size peek
	        mov     di,RESULTPTR		;Pt to output buff
		mov	si,ax			;Save seg value

		cmp	num_params,3		;If 3rd param, it is the
		jb	peek_cmd_1		;  number of bytes to
		push	ax			;  return
		push	bx
		push	si
		mov	si,parm3ptr
		call	asc2hex
		mov	cx,ax
		pop	si
		pop	bx
		pop	ax
		cmp	num_params,4		;If 4th param, it signals
		jb	peek_cmd_1		;  word size peek
		mov	bp,1
		shr	cx,1
peek_cmd_1:
		and	cx,003fh		;Allow only 64 bytes out
		jne	peek_cmd_2
		mov	cx,1
peek_cmd_2:
		push	es
		mov	es,si
		mov	ax,es:[bx]
		pop	es

		or 	bp,bp			;If word size, print
		je	peek_cmd_3		;  high byte first.
		push	ax
		xor	al,al
		xchg	ah,al
		xor	dx,dx
		call	lead_zero
	        call    hex2asc                 ;Convert result to ASCII
		inc	bx
		dec	di
		pop	ax
peek_cmd_3:
		xor	ah,ah
		cwd
		call	lead_zero
	        call    hex2asc                 ;Convert result to ASCII
		inc	bx
		mov	byte ptr [di-1],' '	;Replace term 0 with space
		loop	peek_cmd_1

		mov	byte ptr [di-1],'$'	;Add terminating char
		mov	dx,RESULTPTR
		call	printmsg
peek_cmd_exit:
		pop	bp
	        ret
peek_cmd_err1:
		stc
		jmp	short peek_cmd_exit
peek_cmd	endp

;------------------------------------------------------------------------
; POKE CMD Writes a string of bytes to memory
;------------------------------------------------------------------------
poke_cmd	proc    near
	        assume  cs:code,ds:code,es:code
	        mov     dx,offset errmsg4	;Not enough parameters
		cmp	num_params,2
		jb	poke_cmd_error
	        call    conv2num                ;Convert first two parms to
	        jc      poke_cmd_exit          ;  32 bit numbers.  

		mov	cx,num_params
		sub	cx,2
	        mov     si,offset parm3ptr
		push	es
		mov	es,ax			;Load segment
		mov	di,bx			;Load offset
		cli		
poke_cmd_1:
		push	si
		mov	si,[si]			;Get ptr to next var	
	        call 	asc2hex
		pop	si
	        jnc	poke_cmd_3
poke_cmd_2:
		sti
		pop	es
		mov	dx,offset errmsg3	;Number too large
		stc	
		jmp	poke_cmd_exit
poke_cmd_3:
		or	dx,dx			;Check to see if poke
		jne	poke_cmd_2		;  val > 256
		or	ah,ah
		jne	poke_cmd_2

		stosb
		inc	si			;Move ptr to next var
		inc	si
		loop	poke_cmd_1
		pop	es
		clc
poke_cmd_exit:
	        ret
poke_cmd_error:
		stc
		jmp	short poke_cmd_exit
poke_cmd	endp

;------------------------------------------------------------------------
; IN CMD Returns a byte from an IO port.
;------------------------------------------------------------------------
in_cmd		proc    near
	        assume  cs:code,ds:code,es:code
	        mov     si,parm1ptr           ;Convert 1st param to hex
	        call    asc2hex
	        mov     dx,offset errmsg3      ;Number too large
	        jc      in_cmd_exit            ;If error, exit

		mov	dx,ax
		in	al,dx

		xor	ah,ah
		xor	dx,dx
	        mov     di,RESULTPTR
	        call    hex2asc                 ;Convert result to ASCII
		mov	byte ptr [di-1],'$'	;Add terminating char
		mov	dx,RESULTPTR
		call	printmsg
		clc
in_cmd_exit:
	        ret
in_cmd_error:
		stc
		jmp	short in_cmd_exit
in_cmd		endp

;------------------------------------------------------------------------
; OUT CMD Outputs a byte to an IO port.
;------------------------------------------------------------------------
out_cmd	proc    near
	        assume  cs:code,ds:code,es:code
	        call    conv2num                ;Convert first two parms to
	        jc      out_cmd_exit           ;  32 bit numbers.  
		mov	dx,offset errmsg3	;Number too large
		or	bh,bh
		jne	poke_cmd_error
		
		mov	dl,bl
		xchg	ax,dx
		out	dx,al
out_cmd_exit:
	        ret
out_cmd_error:
		stc
		jmp	short out_cmd_exit
out_cmd	endp
;--------------------------------------------------------------------
; Support routines
;--------------------------------------------------------------------
;--------------------------------------------------------------------
; GETVID - Returns the type of video card installed 
; Exit: AL primary video, AH secondard video:
;    0 - No adapter     1 - MDA          2 - CGA
;    3 - Reserved       4 - EGA color    5 - EGA mono
;    6 - PGC            7 - VGA mono     8 - VGA color
;    9 - reserved       A - MCGA digital B - MCGA mono
;    C - MCGA color
;--------------------------------------------------------------------
getvid		proc	near
		assume	cs:code,ds:nothing,es:nothing
		mov	ax,1a00h		;Read display combination
		int	10h			;  code.
		xchg	ax,bx
		cmp	bl,1ah			;See if function supported
		je	getvid_exit		;Yes, exit
		mov	ah,12h			;Get EGA information
		mov	bl,10h
		int	10h
		cmp	bl,10h			;See if EGA present
		je	getvid_chkcga
		mov	ax,4			;Set EGA code
		or	bh,bh			;See if color or mono EGA
		je	getvid_chk2mono		;0 = color
		inc	al			;Set mono EGA
		jmp	short getvid_chk2clr
getvid_chkcga:
		mov	ax,40h
		push	es
		mov	es,ax			;Point to BIOS data segment
		mov	bx,es:63h		;Get ptr to video ctlr regs
		pop	es
		mov	al,1			;Assume MDA
		cmp	bx,3b4h			;See if mono address
		je	getvid_chk2clr		;Yes, chk for second display
		inc	al 
getvid_chk2mono:
		mov	dx,3b4h
		call	tst_6845		;See if secondary mono card
		jne	getvid_exit
		inc	ah
		jmp	short getvid_exit
getvid_chk2clr:
		mov	dx,3d4h
		call	tst_6845		;See if secondard color card
		jne	getvid_exit
		mov	ah,2
getvid_exit:
		ret
getvid		endp
;--------------------------------------------------------------------
; TST_6845 - Tests for 6845 video controller.
; On Entry: DX - Base I/O address for 6845
; On Exit:  Zero flag set if 6845 found
;--------------------------------------------------------------------
tst_6845	proc	near
		assume	cs:code,ds:nothing,es:nothing
		push	ax
		push	cx
		mov	al,0fh			;Address cursor low reg
		out	dx,al
		inc	dx
		jmp	$+2			;Kill time
		in	al,dx			;Get and save cur loc
		mov	ah,al
		not	al			;Change value for test
		push	ax			;Save test value
		out	dx,al			;Write new cursor loc
		mov	cx,100
tst_1:				
		jmp	$+2			;Long delay so chip as time
		loop	tst_1			;  to update cursor
		in	al,dx			;Get cursor location 
		xchg	al,ah
		jmp	$+2			;Kill time
		out	dx,al			;Restore original value
		dec	dx			;Restore DX
		pop	cx			;Get test value
		cmp	ah,cl			;Compare read back value
		pop	cx
		pop	ax
		ret
tst_6845	endp
;--------------------------------------------------------------------
; PARSE LINE - Parse the command line
; Entry: DS:SI - ptr to line
;--------------------------------------------------------------------
parse_line	proc	near
		assume	cs:code,ds:nothing,es:nothing
		mov	di,cs
		mov	es,di
		mov	di,offset end_of_code

		push	bp
		mov	bp,offset cmdptr
		mov	cx,MAXPARAMS
		mov	bl,1			;Find 1st space past
		call	scan			;  program name
		dec	bl			;Find next char
		call	scan
parsep_1:
		mov	cs:[bp],di		;Save ptr to word
		inc	bp			;Pt BP to next ptr
		inc	bp
		cmp	bp,offset parm2ptr	;Hack to get ptr to non
		jne	parsep_2		;  parsed string.
		mov	word ptr [stringptr],si
		mov	word ptr [stringptr+2],ds
parsep_2:
		lodsb
		stosb
		cmp	al,1bh			;All ANSI esc char as
		je	parsep_2		;  a real character
		cmp	al,' '
		ja	parsep_2
		mov	byte ptr es:[di-1],0	;Terminate parameter
		dec	si
		call	scan			;Find next char
		jc	parsep_end
		loop	parsep_1
parsep_end:
		sub	cx,MAXPARAMS
		neg	cx
		mov	num_params,cx
		clc
		pop	bp
		ret
parse_line	endp
;-----------------------------------------------------------------------------
; FINDSTR  determines if a string is in a list.
; Entry:  DS:SI - Pointer to ASCII string to find.
;         ES:DI - Pointer to list of ASCIIZ strings.
;            CX - Size of string
; Exit:      DI - Pointer to entry in list
;            CF - Clear if string found
;            BX - If CF clear, index into list
;-----------------------------------------------------------------------------
findstr         proc    near
		assume	cs:code,ds:nothing,es:nothing
	        mov     dx,cx
	        or      dx,dx                   ;Save length of string
	        je      finds_2
	        xor     bx,bx                   ;Zero index counter
finds_1:
	        push    di
	        push    si
	        push    cx
	        repe    cmpsb                   ;Compare command
	        pop     cx
	        pop     si
	        pop     di
	        clc
	        je      findstr_exit
	        inc     bx                      ;Inc string count

	        push    cx
		mov	cx,16
		xor	al,al
	        repne   scasb			;Find end of string
	        pop     cx
	        jne     finds_2
	        cmp     byte ptr es:[di],0      ;See if second zero. If so
	        jne     finds_1                 ;  end of list.
finds_2:
	        stc                             ;Indicate string not found
findstr_exit:
	        ret
findstr         endp
;-----------------------------------------------------------------------
; CONV2NUM  converts the first two parameters to hex numbers.
; Exit:    DX AX - Number from 1st parameter
;          CX BX - Number from 2nd parameter
;          CF    - Set if either number too large
;          SI    - Set to error message if CF set
;-----------------------------------------------------------------------
conv2num        proc    near
		mov     si,parm2ptr		;Convert 2nd param to hex
		call    asc2hex
		jc      conv2num_error
		mov     bx,ax			;Copy second parameter
		mov     cx,dx
		
		mov     si,parm1ptr		;Convert 1st param to hex
		call    asc2hex
		jc      conv2num_error
conv2num_exit:
		ret
conv2num_error:
		mov     dx,offset errmsg3      ;Number too large
		jmp     short conv2num_exit
conv2num        endp
;------------------------------------------------------------------------
; ASC2HEX converts an ASCII number to hex
; Entry:     SI - Pointer to ASCIIZ string
; Exit:   DX,AX - Number
;            CF - Set if overflow
;------------------------------------------------------------------------
asc2hex         proc    near
		assume	cs:code,ds:nothing,es:nothing
		push	bx
		push	cx
		push	si
		xor	ax,ax			;Clear number
		cwd
		or	si,si
		je	asc_exit
asc_1:
		mov	cl,[si]			;Get digit
		inc	si
		cmp	cl,'9'
		jbe	asc_2
		and	cl,0dfh			;Make upper case
		sub	cl,7
asc_2:
		sub	cl,'0'			;Convert to hex
		jb	asc_exit
		cmp	cl,0fh
		ja	asc_error
		mov	bx,10h			;Shift number
		mul	bx			;If overflow, exit
		or	dx,dx
		jne	asc_error

		xor	ch,ch
		add	ax,cx			;add digit
		jnc	asc_1
asc_error:
		stc
		jmp	short asc_exit1
asc_exit:
		clc
asc_exit1:
		pop	si
		pop	cx
		pop	bx
		ret
asc2hex         endp

;------------------------------------------------------------------------
; ASC2HEX converts a hex number to ASCII 
; Entry:  DX,AX - Number
;         ES:DI - Pointer to buffer
;------------------------------------------------------------------------
hex2asc		proc	near
		assume	cs:code,ds:nothing,es:nothing
		push	cx
		mov	cl,0d0h			;Push end flag on stack
		push	cx
hex_1:
		mov	cl,al			;Get low nibble
		and	cl,0fh
		push	cx			;Save
		mov	cx,4			;Divide DX,AX by 16
hex_2:
		shr	dx,1
		rcr	ax,1
		loop	hex_2
		mov	cx,dx			;See if number zero
		or	cx,ax
		jne	hex_1
hex_3:
		pop	ax			;Get digit
		add	al,'0'			;Convert to ASCII
		cmp	al,'9'			;If digit end flag (d0h),
		jle	hex_4			;  the conversion will make
		add	al,7			;  make it a zero byte.
hex_4:
		stosb				;Save ASCII digit.  If not
		or	al,al			;  term zero, continue.
		jne	hex_3
hex_5:
		clc
		pop	cx
		ret
hex2asc		endp
;-----------------------------------------------------------------------
; Lead Zero - Adds a leading zero if number less than 10
; Entry: DI - Ptr to buffer
;        AL - Number to check
;-----------------------------------------------------------------------
lead_zero	proc	near
		cmp	al,10h
		jae	lead_zero_exit
		mov	byte ptr es:[di],'0'
		inc	di
lead_zero_exit:
		ret
lead_zero	endp
;--------------------------------------------------------------------
; SCAN Find next character
; Entry: DS:SI - ptr to line
;           BL - 0 find next char, 1 = find end of word
; Exit: CF - Set if end of line
;--------------------------------------------------------------------
scan		proc	near
		assume	cs:code,ds:nothing,es:nothing
scan_1:
		lodsb
		cmp	al,0dh			;See if end of line
		stc
		je	scan_end
		or	bl,bl
		je	scan_2
		cmp	al,1bh			;All ANSI esc char as
		je	scan_1			;  a real character
		cmp	al,' '
		ja	scan_1
		clc
scan_end:
		dec	si			;Back up to start of word
		ret
scan_2:
		cmp	al,1bh			;All ANSI esc char as
		je	scan_end		;  a real character
		cmp	al,' '
		jbe	scan_1
		jmp	short scan_end
scan		endp
;--------------------------------------------------------------------
; UPPER Convert string to upper case
; Entry: DS:SI - ptr to string
; Exit:  CX - Contains length of string
;--------------------------------------------------------------------
upper		proc	near
		assume	cs:code,ds:nothing,es:nothing
		push	si
		push	di
		push	es
		push	ds
		pop	es			;ES:DI = DS:SI
		mov	di,si
		xor	cx,cx			;Size = 0
upper_1:
		lodsb
		cmp	al,'a'
		jb	upper_2
		cmp	al,'z'
		ja	upper_2
		and	al,0dfh			;Capitolize
upper_2:
		inc	cx			;Inc count
		stosb
		or	al,al			;See if end of line
		jne	upper_1
		dec	cx
		pop	es
		pop	di
		pop	si
		ret
upper		endp
;--------------------------------------------------------------------
; PRINTMSG - Prints a message on the screen.
; Entry: DS:DX - Pointer to the line to print
;--------------------------------------------------------------------
printmsg	proc	near
		assume	cs:code,ds:nothing,es:nothing
		mov	ah,9			;Print string
		int	21h
		call	printcr
		ret
printmsg	endp
;--------------------------------------------------------------------
; PRINTCR - Prints a carrage return and line feed 
;--------------------------------------------------------------------
printcr		proc	near
		assume	cs:code,ds:nothing,es:nothing
		push	ds
		mov	dx,offset endmsg
		push	cs
		pop	ds
		mov	ah,9
		int	21h
		pop	ds
		ret
printcr		endp
;--------------------------------------------------------------------
; GETKEY - Returns a key from the keyboard
; Exit:  AL - Key code
;        AH - If 0, AL contains extended key code
;--------------------------------------------------------------------
getkey		proc	near
		assume	cs:code,ds:nothing,es:nothing
		mov	ah,1			;Get key
		int	21h
		mov	ah,1			;Set ext byte. also func num
		or	al,al			;If ext key, call func
		jne	getkey_1		;  again to get code
		int	21h
		xor	ah,ah			;Clear ext key byte
getkey_1:
		ret
getkey		endp
		even                            ;Set stack on word boundry
end_of_code     =       $
code		ends
		end
