#ifndef	LIBRARIES_CRM_H
#define LIBRARIES_CRM_H
/*
**	$Filename: libraries/crm.h $
**	$Release: 4.0 $
**      $Date: 26-Sep-93 $
**
**	CrM.library include and definition file
**
**	(c) 1992-3 Thomas Schwarz
**	All Rights Reserved
*/
/*------------------------------------------------------------------------*/

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

#ifndef UTILITY_TAGITEM_H
#include <utility/tagitem.h>
#endif

#define	CRMNAME	"CrM.library"

#define	CRMVERSION	4

/**************
 * Data Header
 **************/

struct DataHeader
{
   ULONG	dh_ID;
   WORD		dh_MinSecDist;
   ULONG	dh_OriginalLen;
   ULONG	dh_CrunchedLen;
};

/***************
 * CurrentStats
 ***************/
struct cmCurrentStats
{
   ULONG	cmcu_ToGo;
   ULONG	cmcu_Len;
};

/********************
 ** CrunchStruct(ure)
 ********************/
struct cmCrunchStruct
{
   APTR		cmcr_Src;		/* Source Start */
   ULONG	cmcr_SrcLen;		/* Source Len */
   APTR		cmcr_Dest;		/* Destination Start */
   ULONG	cmcr_DestLen;		/* Destination Len (maximum) */
   struct DataHeader *cmcr_DataHdr;	/* DataHeader */
   struct Hook *cmcr_DisplayHook;	/* Hook to display ToGo/Gain Counters */
 /*** Registers hold these values when the Hook is called:                  */
 /*** a0:struct Hook*  a2:struct cmCrunchStruct*  a1:struct cmCurrentStats* */
 /*** you have to return TRUE/FALSE in d0 to continue/abort crunching!      */
   UWORD	cmcr_DisplayStep;	/* time between 2 calls to the Hook */
   /******** readonly: ********/
   UWORD	cmcr_Offset;		/* desired Offset */
   UWORD	cmcr_HuffSize;		/* HuffLen in KBytes */
   UWORD	cmcr_Algo;		/* desired Packalgorithm */
   ULONG	cmcr_MaxOffset;		/* biggest possible Offset (Buffer allocated) */
   ULONG	cmcr_RealOffset;	/* currently used Offset */
   ULONG	cmcr_MinSecDist;	/* MinSecDist for packed Data */
   ULONG	cmcr_CrunchedLen;	/* Length of crunched Data at cmcr_Dest */
   /******** private: ********/
   ULONG	cmcr_HuffTabs;
   ULONG	cmcr_HuffBuf;
   ULONG	cmcr_HuffLen;
   ULONG	cmcr_SpeedLen;
   ULONG	cmcr_SpeedTab;
   ULONG	cmcr_MegaSpeedTab;
   UBYTE	cmcr_QuitFlag;		/* readonly: reason for failure */
   UBYTE	cmcr_OverlayFlag;
   UBYTE	cmcr_LEDFlashFlag;
   UBYTE	cmcr_Pad;
   /* CrunchStruct continues here, but LEAVE YOUR HANDS OFF!!! */
};
     
/*************************************
 ** Result Codes of cmCheckCrunched()
 ** and Symbols for the CMCS_Algo Tag
 *************************************/
#define	cm_Normal	1
#define	cm_LZH		2
#define	cmB_Sample	4
#define	cmF_Sample	(1<<cmB_Sample)
#define	cmB_PW		5
#define	cmF_PW		(1<<cmB_PW)
#define	cmB_Overlay	8			/* only for the */
#define	cmF_Overlay	(1<<cmB_Overlay)	/* CMCS_Algo Tag! */
#define	cmB_LEDFlash	9			/* only for the */
#define	cmF_LEDFlash	(1<<cmB_LEDFlash)	/* CMCS_Algo Tag! */

/** Use this mask to get the crunch algorithm without any other flags: */
#define	cm_AlgoMask	0xF

/**********************************
 ** Action Codes for cmProcessPW()
 **********************************/
#define	cm_AddPW	1
#define	cm_RemovePW	2
#define	cm_RemoveAll	3

/**********************************
 ** Action Codes for cmCryptData()
 **********************************/
#define	cm_EnCrypt	4
#define	cm_DeCrypt	5

/********************************************
 ** Action Codes for cmProcessCrunchStruct()
 ********************************************/
#define	cm_AllocStruct	6
#define	cm_FreeStruct	7

/************************************
 ** Tags for cmProcessCrunchStruct()
 ************************************/
#define	CM_TagBase	TAG_USER
#define	CMCS_Algo	(CM_TagBase+1)		/* default: cm_LZH */
#define	CMCS_Offset	(CM_TagBase+2)		/* default: $7ffe */
#define	CMCS_HuffSize	(CM_TagBase+3)		/* default: 16 */

/********************************************
 ** for older Code, _DON'T_ use in new code:
 ********************************************/
#define	dh_OrginalLen	dh_OriginalLen
#define	cm_Sample	16
#define	cm_NormSamp	(cm_Normal|cm_Sample)
#define	cm_LZHSamp	(cm_LZH|cm_Sample)

#endif
