/***
*mylib.h - definitions/declarations for library functions.
*
*for Public Domain, 1995, Gregg Jennings.  All wrongs reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Fast printing routines, user inputs, and miscelaneous
*
*Notice:
*   This source file may be freely used and distributed without restriction.
*******************************************************************************/

#ifndef GENERAL_H
#include "general.h"    /* machine dependent and compiler */
#endif                  /*  specific stuff */

/* user input type definitions (ctype stuff) */

#ifndef __WATCOMC__

#ifndef _PUNCT          /* use MSC equates */
#define _UPPER    0x1   /* upper case letter */
#define _LOWER    0x2   /* lower case letter */
#define _DIGIT    0x4   /* digit[0-9] */
#define _SPACE    0x8   /* tab, carriage return, newline, */
                        /* vertical tab or form feed */
#define _PUNCT    0x10  /* punctuation character */
#define _CONTROL  0x20  /* control character */
#define _BLANK    0x40  /* space char */
#define _HEX      0x80  /* hexadecimal digit */
#endif

#else

#define _HEX      _XDIGT
#define _CONTROL  _CNTRL
#define _BLANK    _SPACE
#endif

#define _ALPHA (_UPPER|_LOWER)
#define _ALNUM (_UPPER|_LOWER|_DIGIT)
#define _TEXT  (_ALNUM|_PUNCT|_BLANK)


/* number output */

extern unsigned char hexbyte(int a,int b);
extern int pn(unsigned int n,int base);
extern int pln(unsigned long n, int base);
extern void pnls(unsigned int n,unsigned int length,int base);
extern void pnlz(unsigned int n,unsigned int length,int base);
extern void plnls(unsigned long n,unsigned int length,int base);
extern void plnlz(unsigned long n,unsigned int length,int base);

extern int getlen(unsigned int n,int base);
extern int getlength(unsigned long i,int base);
extern int getnum(unsigned int max,unsigned int *num,int base);
extern int getnumber(unsigned long max,void *num,int base);

/* string input */

extern int getstr(char *s,unsigned int len,int mask);
extern int getver(char *s,int mode);
enum GETVER_MODE { NONE, MOV_YN, MOV_ARG, CLR_ARG=5, CLR_YN };
extern int convert(char *a);

/* misc. */

extern void directory(void );
extern void pname(char *s);
extern int search(unsigned char *s,unsigned char *t,unsigned int size,unsigned int len);
extern int isearch(unsigned char *s,unsigned char *t,unsigned int size,unsigned int len);
extern int change(unsigned char *buffer,unsigned int bufend,int base);
extern void dispval(int x,int len,int base,int c);
extern int dump(unsigned char *buffer,unsigned int bfptr,unsigned int bufend,unsigned int len,int base);
extern void dumpf(register unsigned char *buffer,int size, int base);
extern void pause(void);
extern void viewfile(char *filename, int display);


/* macros to make displaying of numbers easier to implement */

#ifndef DISKED                /* Radix is a global variable */
#define Radix   10            /* DISKED uses a structure entry */
#endif                        /* This is here for non-DISKED usage */
                              /* define Radix for you own use */

#define getbyte(n)   getnum(255,n,Radix)
#define getint(n)    getnum(32767,n,Radix)
#define getuint(n)   getnum(65535,n,Radix)
#define getlong(n)   getnumber(2147483647L,n,Radix)
#define getnumb(m,n) getnum(m,n,Radix)
#define getlnumb(m,n) getnumber((unsigned long)(m),n,Radix)
#define len(n)       getlen(n,Radix)
#define length(n)    getlength((unsigned long)(n),Radix)

#define putbyte(n)   pn((int)(n),Radix)
#define puthex(n)    pnlz(n,4,16)
#define putint(n)    pn(n,Radix)
#define putuint(n)   pln((unsigned long)(n),Radix)
#define putlong(n)   pln((unsigned long)(n),Radix)
#define zputbyte(n)  pnlz((unsigned int)(n),3,Radix)
