/***
*init.h - disked initialization stuff
*
*Copyright (c) 1993-1995, Gregg Jennings.  All wrongs reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   See INIT.C.
*
*Notice:
*   This progam may be freely used and distributed.  Any distrubution
*   with modifications must retain the above copyright statement and
*   modifications noted.
*   No pulp-publication, in whole or in part, permitted without
*   permission (magazines or books).
*******************************************************************************/

#ifndef KEYWORDS_H

#define KEYWORDS_H

typedef struct Keys {         /* "keywords" */
   unsigned int key;
   int value;                 /* option value (boolean) */
   char *keyword;             /* keyword */
   int type;
} KEYWORDS;

enum IO_TYPE { STDIO, BDOS, BIOS };

extern KEYWORDS kw[];

/* Defines to make it easy to use */
#define SignonTxt    kw[16].keyword
#define OutputTxt    kw[17].keyword
#define RadixTxt     kw[15].keyword

#define TranslateTxt kw[13].keyword
#define LogicalTxt   kw[12].keyword
#define PartialTxt   kw[11].keyword
#define AsciiTxt     kw[10].keyword
#define DebugTxt     kw[9].keyword
#define FilesTxt     kw[8].keyword
#define ConvertTxt   kw[7].keyword
#define StripTxt     kw[6].keyword
#define WriteTxt     kw[5].keyword
#define VerifyTxt    kw[4].keyword
#define MaskTxt      kw[3].keyword
#define HomeTxt      kw[2].keyword
#define GetTxt       kw[1].keyword
#define DisplayTxt   kw[0].keyword

#define Filter    kw[19].value
#define Viewer    kw[18].value
#define Output    kw[17].value
#define Signon    kw[16].value
#define Radix     kw[15].value

#define Translate kw[13].value
#define Logical   kw[12].value
#define Partial   kw[11].value
#define Ascii     kw[10].value
#define Debug     kw[9].value
#define Files     kw[8].value
#define Convert   kw[7].value
#define Strip     kw[6].value
#define Write     kw[5].value
#define Verify    kw[4].value
#define Mask      kw[3].value
#define Home      kw[2].value
#define Get       kw[1].value
#define Display   kw[0].value

enum INIT_ARGS { INIT_RESTORE, INIT_VIEW };

extern int initialize(char *);
extern int setkeyword(unsigned int c, KEYWORDS *kw);
extern int init_save_array(void);
extern int saveinit(char *filename);
extern int getinit(char *filename, int arg);


#endif
