/***
*arrays.h - misc. array handling
*
*for Public Domain 1995, Gregg Jennings.  All wrongs reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   General purpose array handling.
*
*Notice:
*   This source file may be freely used and distributed without restriction.
*******************************************************************************/

/*
   Versions

   0.1   15-Dec-1994
*/


extern int arraymax(int __huge *array,size_t max,int n);
extern int arraymin(int __huge *array,size_t max,int n);
extern int arraycnt(int __huge *array,size_t max,int n);
extern size_t arrayfirst(int __huge *array,size_t max,int n);
extern size_t arraylast(int __huge *array,size_t max,int n);
extern size_t arrayfind(int __huge *array, size_t max, int n);
extern size_t arraytrav(int __huge *array,size_t max,size_t n,int dir);
extern size_t arraysub(int __huge *array, int *sub, size_t max, int n);
extern int arraymap(int __huge *array,size_t max,int n,int base);

extern void plist(long *array, size_t max, int base);
