
























                                       DISKED
                                   The DISK EDitor
                                  For IBM-PC/XT/AT
                                      Computers


                                 Software and Manual
                                Designed and Written
                                  by Gregg Jennings

                                Software Version 2.4
                              Documentation Version 2.1
                                  December 2, 1993

                           (c) 1989-1993 by Gregg Jennings
                                 ALL WRONGS RESERVED


















       DISKED                                                           page 2


                                   WHAT DISKED IS

       DISKED is a simple to use disk editor and data recovery program for
       IBM-PC/XT/AT and compatible computers.  It allows the editing of any
       sector and the saving of sectors to a file.  DISKED provides a way to
       recover data from disks with a damaged BOOT sector, damaged FATs, and
       damaged directory areas, allowing the saving of otherwise lost data.

       DISKED is meant to be very easy to learn and to use -- it is operated
       by entering easy to remember single letter commands.  Its simple
       interface enables the user to have full control over the program,
       letting it be run with full confidence and assurance.  DISKED was and
       still is being developed with ease of use as the number one feature.



                                 WHAT DISKED IS NOT

       Although DISKED can recover an erased file's data, DISKED cannot
       unerase a file.  DISKED also does not format nor change any parameters
       of the format of a disk -- does not fix bad sectors -- does no file
       copying, moving or deleting -- there are better utilities for that.

       All DISKED does is read, write, and store any available sector of a
       disk in a simple and easy, yet powerful and versatile way.

                         Ŀ
                                    BUT REMEMBER           
                         DISKED CAN RECOVER DATA FROM DISKS
                             WHEN DOS UTILITIES CANNOT     
                         



                                    REQUIREMENTS

       This version of DISKED requires an IBM compatible with 128KB of memory
       and DOS version 3.0 or higher.  DISKED supports all IBM PC/XT/AT drive
       formats.



       DISKED                                                           page 3


                                      TUTORIAL

       DISKED comes up at the disk's root directory sector and is in a
       combined command and edit mode.

       DISKED displays each sector as you move about the disk.  Movement is
       done by the direction keys similar to paging through a text document --
       you always know exactly where you are on the disk.

       There are two available areas for data; a sector buffer that holds
       selected sector's data and a file buffer that allows saving sector data
       for writing to a disk file.

       The sector buffer can be changed in a manner similar to a debugger and
       can be written back to the disk.  There is also a spare sector buffer
       to which a sector can be stored and retrieved for copying to another
       sector.

       Data is saved by appending single or multiple sectors into the file
       buffer.  The file buffer can then be observed and changed, written to a
       disk file, emptied, or more sectors appended or unappended.  Any number
       of absolute sectors can also be written to a file.

       These features produce a very versatile program.



       DISKED                                                           page 4


                                      Section 1
                                    Using DISKED


       1.1 Documentation Notes

       This document assumes that the user knows certain computer terms.
       Specific terms are: hexadecimal numbers; strings and bytes; tracks,
       sectors and clusters; control characters and ASCII.

       In this documentation, the word disk is used to mean either the hard
       disk drive or a floppy diskette -- the media that holds the data; the
       word drive use used as meaning the DOS drive as in 'A:' or 'C:', as
       well as any logical drives or ram drives when device drivers are used.

       The word sector is used in two different and distinct ways -- there are
       physical and logical sectors of a disk.  The physical sector references
       pertain to the disk drive hardware, the logical sectors pertain to DOS.
       Physical sectors come in to play, as far as DISKED is concerned, with
       the 's' (select physical position) command and parameter display only.
       All other references to sectors are logical, which run from 0 to the
       end of the disk.


       1.1.1 Command Input Conventions

       The commands, arguments, and keys designated in this manual use the
       following conventions:

       Convention   Description

       D            A valid drive letter.

       n            A decimal or hexadecimal number.

       x            A hexadecimal number.

       s            An ASCII string.

       c            An ASCII character.

       C            A letter.

       ^C           A control character.

       'c'          A DISKED command key.

       's'          A DISKED keyword.

       |            More than one key will perform the same command.



       DISKED                                                           page 5


       end          A cursor key.

       F1           Function key.

       TAB          Other special key.


       1.1.2 Keyboard Input

       Because some commands are instantaneous any command typed that needs an
       argument cannot be erased (i.e. a backspace or delete will not erase
       it), yet a return or an escape will usually cancel.  Commands that do
       not require an argument will be performed without a return.

       When a command argument is needed, during input, the backspace will
       delete characters, a ^C or ESC will cancel the command, a ^U will
       delete all input.  A return, a space, or a comma ends the input.  A
       return will be automatically entered if the maximum number of
       characters is input.

       When a number argument needs to be input, only numbers will be
       accepted.  Any number required will be of 1 to 5 places so, depending
       on the type of argument required, too large of a number cannot be
       entered.  Any argument that is out of bounds will just be ignored.

       When more than one number needs to be input, a return, a space, or a
       comma can be used to separate the numbers.

       Whenever DISKED asks for confirmation of a command, a capital or
       lowercase Y will confirm and any other key will cancel.



       DISKED                                                           page 6


                                      Section 2
                                      Commands

       Note: any command that deals with files that exist on the disk will be
       disabled if file indexing is off (cf. 3.1.0).


       2.1 Drives

       Command      Function

       lD           Log in drive D as the disk to use.  The file buffer is
                    left alone, allowing for data recovery to the same drive.

                    The first sector of the root directory area is selected
                    after the log in (cf. 3.1.0).

       ^L           Re-log current drive.  This should be done whenever the
                    file buffer is written to the current disk and filename
                    display is on (cf. 3.1.0).

                    When a floppy disk has been changed it does not have to be
                    logged in unless the new disk is of a different format or
                    filename displaying is wanted.


       2.2 Moving

       When moving, the disk is treated as circular.  Movement past either end
       results in "wrapping" around to the other end.  Each sector contents is
       displayed after every movement.  The sector data can be displayed in a
       variety of formats; 16 bytes per line hex/ASCII (only the first 128
       bytes are displayed, this is the default), 24 bytes per line hex/ASCII
       (the full sector contents), ASCII only, and a directory format.  The
       format is selectable (cf. 3.1.0).

       Command      Function

       sn,n,n       Select the track, sector, and head respectfully, separated
                    by commas or spaces.  A return will end the input.  Any
                    parameter may be omitted leaving it unchanged.

       sb           Select the BOOT sector.

       sf           Select the beginning of the first FAT area.

       Sn           Select the first sector of cluster n.

       ^Sn          Select the logical sector n.

       end          Select last sector.



       DISKED                                                           page 7


       home         Select the beginning of the root directory.

       n            Next sector.

       ^N|pgdn      Next track.

       N|right      Next cluster.

       b            Back sector.

       ^B|pgup      Back track.

       B|left       Back cluster.

       +n           Increment n sectors.

       -n           Decrement n sectors.

       r            Range forward by sectors.  If the key hit is a number the
                    pause between sectors is increased or decreased, 1 being
                    the fastest, 9 the slowest.  A space will pause, any other
                    key will cancel.

       ^R           Range backward.

       R            Range by clusters.

       1-9          Select the tagged sector.  See the 't' command.

       j|^right     Jump to the next cluster of the file that the current
                    cluster is allocated to.

       J|^left      Jump to the previous cluster of the file that the current
                    cluster is allocated to.

       ^home        Start cluster of file that the current cluster is
                    allocated to.

       ^end         End cluster of the file that the current cluster is
                    allocated to.

       Shft-right   Next free cluster.

       Shft-left    Back free cluster.


       2.3 Editing

       Command      Function



       DISKED                                                           page 8


       cn           Change sector contents starting at buffer location n. The
                    address of the sector offset is shown along with the data
                    in hex and ASCII.  A return or a space leaves the data
                    alone and advances to the next, a backspace advances to
                    the previous, always wrapping around at the extremes of
                    the buffer.

                    The the buffer position can be changed and new data can be
                    entered by typing a new value in a variety of ways.

                         Table 2.1: Change Formats

                         x         hex number
                         'c        ASCII character
                         ^C        control character
                         "s        string
                         CR/SP     next location
                         TAB       go to location 00
                         =x        go to location x
                         \x        go to number x
                         \'c       go to character c
                         \^C       go to control character C
                         -x1,x2    fill x1 places of x2
                         +x1,x2    replace all x1 with x2
                         ?|/       display command summary
                         .|ESC     exit change

                    Changes are not written to the disk.  See the 'w' command.

       C            Change file buffer contents.

       ^C           Change the sector buffer in a directory format.  The file
                    names, file attributes, and file times and dates can be
                    changed.  The file attributes are toggled by the spacebar;
                    the volume label or deleted files can not be changed.  The
                    DOS system files must not be changed.  There is no out-
                    of-bounds checking for the times and dates.  If the sector
                    is not a directory sector the change fields will still be
                    in the directory format.

                         Table 2.2: Directory Change

                         CR/SP     next entry
                         TAB       next field
                         SHFT-TAB  previous field
                         =n        go to entry n
                         ?|/       display command summary
                         .|ESC     exit change

                    Changes are not written to the disk.  See the 'w' command.



       DISKED                                                           page 9


       k            Kill any changes to the sector buffer.  After any changes
                    have been made to the sector buffer, a 'k' will restore it
                    to its original state.  The sector is not written to the
                    disk.  The file buffer cannot be unchanged.

       w            Write the sector buffer back to the disk, presumably after
                    changes have been made, or after a saved sector has been
                    retrieved by the '<' command.  A 'w' in the BOOT or FAT
                    area will cause a warning message to be displayed only and
                    will always ask for confirmation.

                    Care should be used when in the BOOT sector, any FAT
                    sector, or any directory area.

                    This command has to be enabled by an entry in the
                    DISKED.INI file (cf. 3.2.1) and turned on from within
                    DISKED (cf. 3.1.0).


       2.4 Copying

       The copy commands copy disk data into the file buffer.  All commands
       indicate when the file buffer is full.  The size of the file buffer is
       displayed by the BS command, the amount of the file buffer contents is
       displayed at the prompt.

       Command      Function

       a            Append the current sector into the file buffer.

       A            Append the current cluster.

       ^An1,n2      Append n2 bytes from offset n1 of the sector.

       u            Unappend a sector size amount of bytes out of the file
                    buffer.

       U            Unappend a cluster size amount of bytes.

       ^Un          Unappend n bytes.

       gn           Get n sectors.  Append the next n sectors, starting from
                    the current sector, into the file buffer, leaving the
                    current sector selected.  Any key hit while cancel the
                    getting.

       g0           Get the entire current track.

       g1           Get the rest of the track, starting from the current
                    sector.



       DISKED                                                          page 10


       ^Gn          Get n sectors and move n+1 sectors.

       e            Empty the file buffer.

       ^E           Empty the file buffer regardless of the 'verify' keyword
                    (cf. 3.1.0).


       2.5 Storing

       Any one sector can be stored in a special buffer for retrieval at any
       time.  This special buffer contents remains the same until another
       sector is stored.

       Command      Function

       >            Store sector.

       <            Retrieve sector.  If there is no sector stored nothing
                    happens, if there is, the sector buffer is overwritten by
                    the stored sector and displayed as by a normal sector
                    move.  The sector is not written to the disk.


       2.6 Files

       During any file input or output, the buffer will be translated
       according to the 'mask', 'strip' and 'convert' keywords except when
       noted (cf. 0).  During file reading or writing any key hit will cancel.

       Command      Function

       ps           Put the file buffer to file s.

       ^Ps          Put the file buffer to file s without any character
                    translations.  All bytes will be written, including any
                    EOF characters.

       Pn1,n2,s     Put n2 sectors, starting at n1 (or the current sector if
                    n2 is a left out) to file s without any translations.

       is           Insert the file s into the file buffer (as much as
                    possible).

       ^Is          Insert the file s without any character translations.

       Is           Insert the file that the current sector is allocated to.

       m            Map out the clusters of the file that the current cluster
                    is allocated to.



       DISKED                                                          page 11


       2.7 Displaying

       Command      Function

       /            List command summary.

       ?            Extra command summary.

       BS           Display drive parameters.

       SPACE        Display top 128 bytes of sector buffer.

       CR           Display the next 384 bytes.

       ^J           Display position.

       dn           Display the file buffer a page (256 bytes) at a time
                    starting from address n, in a hex/ASCII format.

       vn           View the file buffer contents with translation according
                    to the translation keywords.

       ^V           View the sector buffer.  The viewing will not pause until
                    the end of the sector is reached.

       Shft-F1      Display top 128 bytes of sector buffer.

       Shft-F2      Display full sector buffer.

       Shft-F3      View the sector buffer.

       Shft-F4      Directory display the file buffer.


       2.8 Searching

       Command      Function

       fs           Find string s; a null response will search for the
                    previously entered string.  Any key hit while in progress
                    will stop the search.  The following control characters
                    can be embedded in the string:



       DISKED                                                          page 12


                         Table 2.3: Find Control Charcters

                         \0        null
                         \a        bell
                         \f        form feed
                         \n        line feed
                         \r        return
                         \s        space
                         \t        tab
                         \xxx      hexadecimal value xx
                         \\        backslash

                    Extended characters (values greater than '~' or 7Eh)
                    can be entered by Alt-Keypad sequences.

       ^Fs          Find s on the disk searching backward.

       Fs           Find s in the file buffer.


       2.9 Exiting

       Command      Function

       q|.|ESC      Return to DOS.  The drive and directory that was current
                    when DISKED was loaded will be re-selected.

       ^Q           Return to DOS regardless of the 'verify' keyword.


       2.10 Miscellaneous

       Command      Function

       zs           Show and/or change keywords (cf 2).

       Z            Show keywords only.

       ,            Toggle input radix between decimal and hexadecimal.  All
                    numbers displayed or input will be either decimal or
                    hexadecimal.  The default is decimal.

       F1           Display the name of and the files in the currently
                    selected directory.  This will be the directory for all
                    default file I/O.

       F2           Display all files on the disk.  A space will pause the
                    displaying, an ESC will abort.

       F3           Display the number of files and directories on the disk.



       DISKED                                                          page 13


       F4s          Make the directory s the current directory for all default
                    file I/O.

       F5           Re-read current sector.

       F6           Append sector with 'strip'; ignores the 'strip' keyword.

       F7           Append sector with 'convert'; ignores the 'convert'
                    keyword.

       F8           Append sector with 'mask'; ignores the 'mask' keyword.

       F9           Append sector with translation as per the 'mask', 'strip'
                    and 'convert' keywords.'

       F10s         Set to the first cluster of the file or directory s.  The
                    full path name need not be given unless there are
                    duplicate files on the disk.

       tn           Tag the current sector.  Assigns n (1-9) to the current
                    sector, enabling the selection of that sector by typing
                    the corresponding number.

       x            View the DISKED.INI file.

       X            View the DISKED.SAV file.

       ^X           Save the current state of DISKED to a file named
                    DISKED.SAV.  The file will be written to the directory
                    named in the INIT environment variable or to the default
                    directory.  The drive, sector, tagged sector list, and
                    last search string will be saved.

       ^Z           Restore DISKED state by reading the DISKED.SAV file.



       DISKED                                                          page 14


                                      Section 3
                                DISKED Initialization


       3.1 DISKED Keywords

       Keywords are the names of certain parameters indicating how some
       commands will function.

       Keyword      Function

       ascii        Displays sector data to the screen as the '^V' command,
                    with translation according to the translation keywords.

       convert      Converts all non-printable bytes to its hexadecimal
                    equivalent between angle brackets during file I/O or when
                    the file buffer is viewed to the screen.

       display      Displays a description of and information about the
                    command before it is performed.

       files        All filenames on the disk will be read and indexed so that
                    the filename can be matched to each cluster and displayed.

       get          A move is made after sectors are appended using the 'g'
                    command.

       home         The first sector of the root directory area of a disk is
                    selected after it is logged in.

       mask         Masks off the high bit of all bytes during file I/O or
                    when the file buffer is viewed to the screen.

       logical      Displays disk information without references to the
                    physical properties of the disk.

       partial      Displays just the first 128 bytes of a sector when not in
                    Ascii mode.  Otherwise 512 bytes are displayed.

       strip        Strips out (ignores) all non-printable bytes during file
                    I/O or when the file buffer viewed to the screen.

       translate    Displays directory sectors in a directory format.

       verify       Asks for confirmation when performing any of the more
                    powerful commands.

       write        Enables the writing of sectors to the disk.



       DISKED                                                          page 15


       These parameters can be turned on and off (or enabled and disabled)
       from within DISKED or by an initialization file.  By default they are
       all on except for 'ascii', 'files' and 'write'.


       3.2 Changing DISKED Parameters


       3.2.1 Outside DISKED

       DISKED will look for a DISKED.INI file to set or change the DISKED
       keywords.  In the DISKED.INI file enter the keyword followed by either
       'on' or 'off'.  DISKED will first search the directory indicated by the
       "INIT" DOS environment variable, then the directory in which DISKED was
       executed from, and finally the default directory.


       3.2.2 Inside DISKED

       By the use of the 'z' command these parameters can be changed inside
       DISKED.  The 'z' is followed by a string containing the first letter of
       the keyword to be changed, toggling it on or off.  Only the keyword
       letters are valid, all other characters are ignored.  When the
       'display' parameter is on, all keywords and their values are shown
       before inputting.

       For added protection, the 'write' parameter must be in DISKED.INI and
       then turned on by the 'z' command for the 'w' command to work.

       A quicker way of changing the keywords is by using the Alt key and the
       first letter.  The parameter is changed and its new value is displayed.



       DISKED                                                          page 16


                                      Section 4
                                   Hints on Usage


       4.1 Bad Sectors


       4.1.1 Damage

       Damage is when a sector can not be read due to physical defects on the
       disk.  Damage will most likely be trapped by DOS with the standard
       message; if retrying does eventually result in the sector being read
       you are in luck.  DISKED does not do anything fancy when reading
                                  1
       sectors -- it relies on DOS .

       Damage in the data area results in DISKED not being able to read those
       sectors and if they lie in a file then only the readable parts of the
       file can be recovered.  Executable files cannot be recovered in this
       situation.

       Damage in the BOOT area can be circumvented by logging in a good disk
       of the same format then putting in the disk with the bad BOOT sector.
       DISKED can not log on to a hard drive if it has a damaged BOOT sector
       only if it is "known" by the operating system (if DOS does not issue
       the "Invalid drive specification" message).

       If damage is found in the FAT or in a directory area, DISKED will
       automatically turn off the 'files' keyword.

       DISKED makes no use the FAT bad cluster information.


       4.1.2 Corruption

       Corrupt data is invalid information on the disk; this results just as
       if the areas were damaged if the corruption lies in the BOOT, FAT, or
       directory areas, for normal DOS utilities and applications.

       Corrupt data can be a foreign type of media (not really corrupt but
       unable to be interpreted), a disk that was inadvertently written to by
       power failures or system crashes, or, on single floppy systems (like
       laptops), a disk was changed at the wrong time causing another disk's
       data written on it.


       _______________________________________________________________________

       1. Central Point Software Inc. has an excellent product call the Deluxe
          Option Board that can literally copy, completely, physically damaged
          diskettes (cf. Appendix D)



       DISKED                                                          page 17


       The BOOT sector can be fixed by reading the BOOT of a good disk of the
       same format, putting in the corrupted disk and writing the sector.  The
       DOS FORMAT command will of course fix a disk, but all data will be lost
       (although one could press ^Break after the first track is formatted).

       The FAT can be written in a similar manner.  Just remember to copy from
       a disk without files.  An empty FAT has a sequence of 3 bytes
       indicating the type of format and is then all zeros.  The number of
       sectors of the FATs is displayed in the drive statistics.

       An empty ROOT is filled with zeros.  The number of sectors of the ROOT
       is the logical sector number of the first cluster minus the logical
       sector number of the 'home' position.



       DISKED                                                          page 18


       4.2 Recovering Files


       4.2.1 Text Files

       Getting back text files is basically a hit and miss situation.  Knowing
       some of the text helps by searching for it.  If not, ranging, or paging
       over the disk is the only way.  Once a sector with data to be recovered
       is found, search back to the beginning of the data and then do a 'g1'
       to get the rest of the track.

       Display the file buffer to find out how many sectors should have been
       read in.  By the correct number of 'u's, or an 'e' followed by a 'gn'
       with the correct number of sectors, a good chunk of data can be
       retrieved.  If the data extends beyond a track, more data can be
       retrieved by a '^N' (or pgdn) followed by a 'g0'.

       If the data is very fragmented, range by the 'r' command, stopping and
       appending as needed.  Since DOS stores file data by clusters, it may be
       more efficient to move a cluster at a time.

       If large amounts of data are to be recovered, always put the file
       buffer to another disk to avoid overwriting recoverable data.

       Understanding the beginning byte sequence of formatted files and
       worksheet and database files will give something to search for.  A
       little investigation of files can provide this information.


       4.2.2 Executable Files

       Executable files can only be recovered if the size is known and the
       file is contiguous.  EXE format files provide the size information.
       COM files and overlays do not.  In an EXE file, the fourth and fifth
       bytes of the file contains the file size in 512 byte pages.  The number
       is in hexadecimal and stored least significant byte first.  For example
       17 00 shows that the file is 17 pages long not 1700.  Since a sector is
       512 bytes long this makes recovering the file by getting that many
              2
       sectors .

       Also, the first two bytes of all EXE files is 4d 5a (hex), which is MZ
       in ASCII.  This enables the finding of the beginning of the EXE file.

       If the recovered EXE file results in the DOS message "ERROR in EXE
       file" (or if it hangs the system) then the file was not contiguous or
       was corrupted.
       _______________________________________________________________________

       2. More sectors than are needed may be saved and the program will run
          correctly.



       DISKED                                                          page 19


       4.3 Other Uses

       Another well suited use for DISKED is the changing of messages that a
       program displays.  If many copies of a program are being distributed,
       each copy having a unique serial number or message, DISKED can be used
       to go to that particular sector holding the information, change data
       and then to write the sector.  This takes the place of multiple
       compilations or expensive serialization programs.

       This is further speeded up by making multiple floppies containing just
       that one program, and setting to the appropriate sector once, make the
       change, write the sector, put in the next disk, make the change, write
       the sector, and so on.

       DISKED is the only program that allows this kind of work to be done (at
       a reasonable price!).

       DISKED also lets you investigate and create small files containing
       codes outside ASCII values.

       DISKED also lets you edit a file without an editor.



       DISKED                                                          page 20


                                      Section 5
                                 An Example of Usage

       C:>disked a:

            Serial No: 1.NF3.011          DOS: 3.3
            buffer size: 16384            number of drives: 4
            current drive: A:             media: IBM 3.3
            volume label: ?               current directory: \
            drive size: 363520            cluster size: 1024
            sector size: 512              total sectors: 719
            sectors/fat: 2                sectors/cluster: 2
            sectors: 1-9                  tracks: 0-39
            clusters: 0-355               heads: 0-1

            '/' for help

       track 0, sector 6(5), head 0
       00000: 44 45 4d 4f 20 20 20 20 45 58 45 20 00 00 00 00 DEMO    EXE ....
       00016: 00 00 00 00 00 00 74 8a c9 14 02 00 04 00 00 00 ......t.........
                                     . . .
       00096: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................
       00112: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ................

       (00000)*s track b

       track 0, sector 1(0), head 0 BOOT
       00000: eb 34 90 49 42 4d 20 20 33 2e 33 00 02 02 01 00 .4.IBM 3.3......
       00016: 02 70 00 d0 02 fd 02 00 09 00 02 00 00 00 00 00 .p..............
                                     . . .
       00096: 1a 7c 88 16 2a 7c a3 39 7c c3 b4 02 8b 16 39 7c .|..*|.9|.....9|
       00112: b1 06 d2 e6 0a 36 3b 7c 8b ca 86 e9 8a 16 fd 7d .....6;|.......}

       (00000)*a append sector
       (00512)*^P file: boot.rec put file w/o options? Yes putting
       (00512)*. exit DISKED? Yes

       C:>

       The above example saved the BOOT record of the diskette in drive A: to
       the disk so it could be investigated by a debugger or disassembled.



       DISKED                                                          page 21


                                      Section 6
                                   Command Summary


       6.1 Movement

       n,N,^N    next sector, cluster, track
       b,B,^B    back sector, cluster, track
       st,s,h    set to track t, sector s, head h
       Sn        set to cluster n
       ^Sn       set to logical sector n
       sb        set to BOOT sector
       sf        set to FAT sector
       0-9       set to tagged sector 0-9
       home      set to root directory
       end       set to last sector
       r         range forward by sectors
       ^R        range backward by sectors
       R         range forward by clusters
       j         jump to next cluster of file
       J         jump to previous cluster of file
       ^right    set to the next un-allocated cluster
       ^left     set to the previous un-allocated cluster


       6.2 Get

       a         append sector
       A         append cluster
       ^An,n     append from n, n bytes
       g0|1|n    get sectors
       ^G0|1|n   get sectors with move


       6.3 Unget

       u         unappend sector
       U         unappend cluster
       ^Un       unappend n bytes
       e         empty


       6.4 Log

       lD        log disk D
       ^L        re-log disk


       6.5 Search

       fs        find string s on disk



       DISKED                                                          page 22


       ^Fs       find s searching backward
       Fs        find s in file buffer


       6.6 Display

       SPACE     dump sector buffer
       dn        dump file buffer from n
       vn        view file buffer from n
       ^V        view sector buffer
       BS        display disk parameters
       /         display command summary
       m         display cluster map of current file
       M         map un-allocated clusters of drive
       Shft-F1   top 128 bytes of sector buffer
       Shft-F2   full sector buffer
       Shft-F3   view sector buffer
       Shft-F4   directory display of sector buffer


       6.7 Change

       cn        change sector buffer from n
       Cn        change file buffer from n
       ^C        change directory
       k         kill changes


       6.8 Files

       ps        put file buffer to file s
       ^Ps       put with no translation to file s
       Pn,n,s    put from n, n sectors to file s
       is        insert file s
       ^Is       insert file s with no translation


       6.9 Miscellaneous

       zs        change parameters
       Z         display parameters
       ,         toggle input radix
       F1        display files in current directory
       F2        display all files on disk
       F3        display number of files and directories
       F4s       change to directory s
       F5        re-read sector
       F6        append sector with 'strip'
       F7        append sector with 'convert'
       F8        append sector with 'mask'
       F9        append sector per translation keywords



       DISKED                                                          page 23


       F10s      set to the first sector of file s
       tn        tag sector n
       T         display tagged sector list
       x         view DISKED.INI
       X         view DISKED.SAV
       ^X        save state
       ^Z        restore state



       DISKED                                                          page 24


                                      Section 7
                                   Error Messages

       Most errors will be harmless and can be considered warnings.  DOS
       errors will be common on damaged diskettes.  The file buffer and spare
       buffer contents are always maintained until explicit commands empty
       them.

       Messages

       Invalid Boot Sector D:  Cannot run.

            DISKED was able to read but not able to interpret the boot sector
            of the current drive.  Select another drive or disk and try
            running DISKED again.

       Invalid Boot Sector D:  Use current?

            DISKED was able to read but not able to interpret the boot sector
            of drive designated on the command line.  A Y will use the current
            drive, any other key will exit.

       Drive Not Ready D:  Use current? (or Retry)

            DISKED cannot access the drive designated on the command line,
            usually because the drive door is not closed or the disk is
            physically damaged.  A Y will use the current drive, an R will
            retry drive D:, any other key will exit.

       General Failure D:  Use current?

            DISKED cannot read the drive designated on the command line,
            usually because the disk is not formatted or a format that DOS
            cannot read (such as a 1.2/1.4M disk on XT machines).  A Y will
            use the current drive, any other key will exit.

       Insufficient Memory, n

            There was not enough memory available for storing the cluster
            numbers for the particular disk, where n is the number of
            clusters.  The 'files' keyword will be turned off.  There was not
            enough memory for holding the FAT sectors in memory, where n is
            the amount of memory needed.

       FAT Entry Invalid, n=x

            The offset n into the FAT area is not valid.  Indicates a corrupt
            FAT.

       "filename" Starting Cluster Number Invalid



       DISKED                                                          page 25


            The starting cluster number for the directory entry "filename" is
            not a valid cluster number.  Indicates a corrupt directory.

       Create File Error

            DISKED could not create the file for saving the file buffer.
            Could indicate to many files in the root directory.  Has no effect
            except no file is written.

       Write Error

            DISKED could not write data to the file saving writing the file
            buffer.  Most likely this will be due to not enough disk space.
            Has no effect other than a file that may not hold any or all data.

       Data Error (CRC)
       Seek Error
       Sector Not Found

            DISKED encountered a damaged sector.  The bad sector will still be
            selected although the sector buffer will contain the last read
            sector's data (or garbage).  Any command that was in progress will
            be stopped.



       DISKED                                                          page 26


                                     Appendix A
                                      Anomalies

       Anomalies are strange functionings that will require too complicated
       programming to adjust, or aspects of DOS that DISKED cannot overcome.
       The following is a list of such phenomena.

       fs           The string can contain null characters (a value of zero)
                    by a \0 embedded in the string.  If the first byte is a
                    \0, then the next call to 'f' cannot be repeated with just
                    a return.

                    The string to be searched for will not be found if it lies
                    across sector boundaries so keep search strings as small
                    as possible.  This may be changed if I see a need for it.

       sb|sf        In hex mode, an sb and an sf will still set to the BOOT
                    and the FAT.  Use a leading 0 to avoid this.

       Some non-DOS floppy disk formats will be able to be read if they are
       formatted for 512 byte sectors.  DISKED will read them properly but not
       be able to determine the correct number of sectors the disk has.  There
       are many shareware utilities to read and write non-DOS diskettes.  A
       future version of DISKED may provide a way to use non-DOS diskettes if
       the need arises.



       DISKED                                                          page 27


                                     Appendix B
                          Legal Stuff and License Agreement

       This text is a legal agreement between you, the licensee, and me, the
       program developer.  By using this program, you are agreeing to abide by
       the terms of this agreement.  If you do not agree with the terms of
       this agreement, promptly return the disk package (or erase it, or give
       it away, or do not use it).

       I grant to the licensee the non-exclusive right, without right to
       sublicense, to use this copy of DISKED software on any number of
       computers at any time, and to make as many copies of said software as
       seems fit, and to freely distribute said software so long as a fee is
       not taken for the program for any reason including but not limited to
                                   *
       media costs and copying time , with the exception of barter type goods
       including other shareware and public domain software.

       The software and accompanying documentation (magnetic or paper) are
       provided "As Is" without warranty of any kind, expressed or implied
       (although registered users will get free future versions and support).
       In no event shall the program developer be liable for any loss of
       profit or any other commercial damage, including but not limited to
       special, incidental, consequential or other damages.  In no event shall
       any other person offer a warranty of any kind, nor shall any other
       person offer support for the use software unless a fee, of any kind, is
       waivered.

       DISKED can be customized for anyone who requests it.  Please send bug
       reports, suggestions, criticisms, thoughts, to:

                                   Gregg Jennings
                                     PO BOX 200
                               Falmouth, MA 02541-0200
                                   (508) 540-9711











       _______________________________________________________________________

       *      If you are willing to share this program with others for the
              sole reason of being monetarily compensated, you have no right
              to be even using it, PERIOD.



       DISKED                                                          page 28


                                     Appendix C
                                  Programming Notes

       DISKED is NOT another utility CLONE.  It was first developed around
       1982; I have not tried to copy any other program; DISKED was for my own
       use exclusively.  I realize now that it may be useful to others.

       DISKED uses DOS for all disk reads and writes, for all drive parameter
       information, and for all console I/O.  DISKED does not perform any BIOS
       calls; only DOS interrupts are used with the purpose in mind that it
       should work under any standard DOS system (it has been tested on MS-
       DOS, PC-DOS, and Compaq-DOS).  Although this may not be the fastest or
       the neatest way for coding this kind of a program, it is the most
       reliable.

       The reason for displaying only the first 128 bytes of each sector is
       two fold.  First, the CP/M operating system had only 128 byte sectors
       and DISKED was developed on CP/M.  Secondly, the displaying of data 16
       bytes per line, in hex followed by ASCII is the display format that I
       first saw when I became involved in computers so long ago and the whole
       sector will not fit entirely on the screen in this format.  A DOS
       directory is also better displayed in this format for each file's entry
       is 32 bytes in length (which is not just a coincidence).

       If any user encounters anything that may be a bug, or any errors in the
       operation of DISKED, a written letter to the address found above will
       be appreciated.  If DISKED was found on a BBS, a message left there
       will be appreciated as well.

       DISKED was first conceived and developed on what is called an S-100 bus
       computer using the CP/M operating system as a very basic sector
       oriented diskette editor for used for getting back a file's data after
       it's directory entry had been somehow lost (something that happened
       fairly often in those early days), and the file could not be "un-
       erased" (and since DOS was modeled after CP/M, this still holds true).

       Special thanks must be given to someone by the name of Ward
       Christensen, whose CP/M program called DU, for Disk Utility, gave me
       the basics of low level diskette I/O to relate to.  DU was (and still
       is if anyone has a CP/M machine) a neat utility for reading, modifying
       and writing diskette sectors.  It lacked, however, a way of saving
       diskette sectors to a file.

       DISKED is growing almost daily; new features are being added on the fly
       for I am constantly finding more uses for it.  If you are seriously
       using this program, your thoughts and criticisms will be listened to at
       this time -- I will seriously consider additions and changes.



       DISKED                                                          page 29


                                     Appendix D
                                   Other Utilities

       List of recommended commercial utilities.  There are not many, but I
       will update the list as I gather more information.  If anyone has there
       own useful utilities a note sent to me will be appreciated.


       Copy II Pc (R) Deluxe Option Board by Central Point Software.

       This is an add-in board for PC-XT's which is meant for Apple, Amiga and
       Atari floppy conversions as well as copy protected backups.  It comes
       with a really cool floppy disk editor of an unprecedented level -- it
       lets one view and edit stuff like the Gap and Sync bytes, Sector IDs,
       and all of the "real" data on the disk.  It also explains what all that
       stuff is.  I have used it to successfully copy physically damaged
       diskettes.  I forget the price but it was worth it.


       Spinrite by Gibson Research

       Spinrite will actually repair bad sectors on a hard drive.  I do not
       know how they can do this I swear it works.  It can take a long time --
       5-10 hours -- but can be interrupted and started ^LPage 2 again later
       where it left off.






                                      Contents
               WHAT DISKED IS  . . . . . . . . . . . . . . . . . . . .  2
               WHAT DISKED IS NOT  . . . . . . . . . . . . . . . . . .  2
               REQUIREMENTS  . . . . . . . . . . . . . . . . . . . . .  2
               TUTORIAL  . . . . . . . . . . . . . . . . . . . . . . .  3
               1  Using DISKED . . . . . . . . . . . . . . . . . . . .  4
                   1.1  Documentation Notes  . . . . . . . . . . . . .  4
                   1.1.1  Command Input Conventions  . . . . . . . . .  4
                   1.1.2  Keyboard Input . . . . . . . . . . . . . . .  5
               2  Commands . . . . . . . . . . . . . . . . . . . . . .  6
                   2.1  Drives . . . . . . . . . . . . . . . . . . . .  6
                   2.2  Moving . . . . . . . . . . . . . . . . . . . .  6
                   2.3  Editing  . . . . . . . . . . . . . . . . . . .  7
                   2.4  Copying  . . . . . . . . . . . . . . . . . . .  9
                   2.5  Storing  . . . . . . . . . . . . . . . . . . . 10
                   2.6  Files  . . . . . . . . . . . . . . . . . . . . 10
                   2.7  Displaying . . . . . . . . . . . . . . . . . . 11
                   2.8  Searching  . . . . . . . . . . . . . . . . . . 11
                   2.9  Exiting  . . . . . . . . . . . . . . . . . . . 12
                   2.10  Miscellaneous . . . . . . . . . . . . . . . . 12
               3  DISKED Initialization  . . . . . . . . . . . . . . . 14
                   3.1  DISKED Keywords  . . . . . . . . . . . . . . . 14
                   3.2  Changing DISKED Parameters . . . . . . . . . . 15
                   3.2.1  Outside DISKED . . . . . . . . . . . . . . . 15
                   3.2.2  Inside DISKED  . . . . . . . . . . . . . . . 15
               4  Hints on Usage . . . . . . . . . . . . . . . . . . . 16
                   4.1  Bad Sectors  . . . . . . . . . . . . . . . . . 16
                   4.1.1  Damage . . . . . . . . . . . . . . . . . . . 16
                   4.1.2  Corruption . . . . . . . . . . . . . . . . . 16
                   4.2  Recovering Files . . . . . . . . . . . . . . . 18
                   4.2.1  Text Files . . . . . . . . . . . . . . . . . 18
                   4.2.2  Executable Files . . . . . . . . . . . . . . 18
                   4.3  Other Uses . . . . . . . . . . . . . . . . . . 19
               5  An Example of Usage  . . . . . . . . . . . . . . . . 20
               6  Command Summary  . . . . . . . . . . . . . . . . . . 21
                   6.1  Movement . . . . . . . . . . . . . . . . . . . 21
                   6.2  Get  . . . . . . . . . . . . . . . . . . . . . 21
                   6.3  Unget  . . . . . . . . . . . . . . . . . . . . 21
                   6.4  Log  . . . . . . . . . . . . . . . . . . . . . 21
                   6.5  Search . . . . . . . . . . . . . . . . . . . . 21
                   6.6  Display  . . . . . . . . . . . . . . . . . . . 22
                   6.7  Change . . . . . . . . . . . . . . . . . . . . 22
                   6.8  Files  . . . . . . . . . . . . . . . . . . . . 22
                   6.9  Miscellaneous  . . . . . . . . . . . . . . . . 22
               7  Error Messages . . . . . . . . . . . . . . . . . . . 24

            Appendix A  Anomalies                                      26

            Appendix B  Legal Stuff and License Agreement              27

            Appendix C  Programming Notes                              28

                                          i






            Appendix D  Other Utilities                                29



















































                                         ii






                                       Tables
            Table 2.1: Change Formats  . . . . . . . . . . . . . . . . .8
            Table 2.2: Directory Change  . . . . . . . . . . . . . . . .8
            Table 2.3: Find Control Charcters  . . . . . . . . . . . . 12
















































                                         iii

