/* program to produce side-by-side listings of programs and manuals, etc. *
 * on an HP DeskJet+, a la the PD utility laserlst.com, which appeared in *
 * PC Mag some time ago.                                                  *
 *                                                                        *
 * (c) Adam E. Saltman, 1989                                              *
 *                                                                        */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys\stat.h>

#define ESC        0x1b
#define LANDSCAPE "&l1O"
#define DRAFTMODE "(s1Q"
#define EIGHTLPI  "&l8D"
#define TWENTYCPI "(s20H"
#define RESET     'E'
#define FORMFEED   0x0c
#define RETURN     '\n'
#define LEFT       1
#define RIGHT      2
#define MIDDLE     100

char page[58][201];

void
blankpage(void)
{
  int i, j;

  for (i=0; i<57; i++)
  {
    for (j=0; j<200; j++)
      page[i][j] = ' ';
    page[i][j] = 0;
  }
}

void
printpage(void)
{
  int i;

  for (i=0; i<57; i++)
  {
    fputs(page[i], stdout);
    fputc(RETURN, stdout);
  }

  fputc(FORMFEED, stdout);

  blankpage();
}

void
main(int argc, char **argv)
{
  /* parse options here, eventually */

  int line,
      column,
      columnOffset,
      pageNumber,
      side,
      tabToSpaces = 4,
      endOfFile;

  long numChars;

  FILE *fp;

  struct stat statbuf;

  fp = fopen(argv[1], "rt");
  if (fp == NULL)
  {
    printf("Cannot open %s\n", argv[1]);
    exit(-1);
  }

  stat(argv[1], &statbuf);

  fputc(ESC, stdout);
  fputs(LANDSCAPE, stdout);

  fputc(ESC, stdout);
  fputs(EIGHTLPI, stdout);

  fputc(ESC, stdout);
  fputs(TWENTYCPI, stdout);

  fputc(ESC, stdout);
  fputs(DRAFTMODE, stdout);

  blankpage();

  line = 3;
  column = 0;
  columnOffset = 0;

  pageNumber = 1;
  side = LEFT;

  numChars = 0L;
  endOfFile = 0;

  for(;;)
  {
    int c;

    c = fgetc(fp);

    numChars++;

    if (numChars == statbuf.st_size)
      endOfFile = 1;

    if ((c == '\n') || (line >= 58) || endOfFile)
    {
      if ((line >= 58) || endOfFile)
      {
        char buf[4];

        itoa(pageNumber, buf, 10);

        if (side == LEFT)
        {
          int i;

          strncpy(&page[0][0], argv[1], strlen(argv[1]));
          strncpy(&page[0][MIDDLE - strlen(buf) - 9], "Page ", 5);
          strncpy(&page[0][MIDDLE - strlen(buf) - 4], buf, strlen(buf));

          for (i=0; i<58; i++)
            page[i][MIDDLE] = '|';

          side = RIGHT;
          columnOffset = MIDDLE + 5;

          if (endOfFile)
          {
            printpage();
            fclose(fp);
            fputc(ESC, stdout);
            fputc(RESET, stdout);
            exit(0);
          }
        }

        else
        {
          strncpy(&page[0][columnOffset], argv[1], strlen(argv[1]));
          strncpy(&page[0][columnOffset + 84], "Page ", 5);
          strncpy(&page[0][columnOffset + 89], buf, strlen(buf));

          printpage();

          if (endOfFile)
          {
            fclose(fp);
            fputc(ESC, stdout);
            fputc(RESET, stdout);
            exit(0);
          }

          side = LEFT;
          columnOffset = 0;
        }

        line = 3;
        column = 0;
        pageNumber++;

        if (isprint(c))
          page[line][column++] = c;
      }

      else
      {
        line++;
        column = 0;
      }

      continue;
    }

    if (c == '\t')
    {
      int i;

      for (i = 0; i < tabToSpaces; i++)
      {
        page[line][column + columnOffset + i] = ' ';
        if (column >= MIDDLE - 5)
          break;
        column++;
      }

      continue;
    }

    page[line][column + columnOffset] = (char)c;
    column++;

    if (column >= MIDDLE - 5)
    {
      column = 0;
      line++;
    }
  }
}
