/*
 * Program to find a "magic" number!
 *
 * Find a number which contains all digits from 1 to 9, occuring
 * only once each. The number may not contain any zeros.
 *
 * The leftmost 'n' digits of the number must always be evenly
 * divisible by 'n'. In other words:
 *   The first digit of this number will be divisible by 1.
 *   The first 2 digits must be evenly divisible by 2
 *   The first 3 digits must be evenly divisible by 3
 *   ...
 *   The first 8 digits must be evenly divisible by 8
 *   The entire number (9 digits) must be evenly divisible by 9
 *
 * There is only one number which meets these conditions.
 *
 * This program solves the problem, and proves that there is in fact
 * only one solution (all possibilities are tested). It is also quite
 * interesting in that it is a recursive "main" function.
 *
 * Dave Dunfield - May 22, 1994
 */
#include <stdio.h>

#define	LONG_SIZE	4						/* 32 bit longs */

char temp1[LONG_SIZE], temp2[LONG_SIZE];	/* Temporary long buffers */

extern char Longreg[LONG_SIZE];				/* Contains MOD after DIV */

main()
{
	int i;									/* Loop counter */
	char savenum[LONG_SIZE];				/* Save number during attempts */
	static int n = 0;						/* Digit counter */
	static char digits[10] = { 0 };			/* Records digits in use */
	static char num[LONG_SIZE] =  { 0 };	/* Number we are building */

	++n;
	if(n >= 10)								/* This number qualifies */
		print_long(num);
	else for(i=1; i < 10; ++i) {			/* Test digits 1-9 only */
		if(digits[i])						/* Digit in use */
			continue;
		longcpy(savenum, num);				/* Save original number */
		longset(temp1, 10);					/* Base 10 */
		longmul(num, temp1);				/* Make room for new digit */
		longset(temp1, i);					/* Get new digit */
		longadd(num, temp1);				/* Add in to number */
		longcpy(temp2, num);				/* Copy for test */
		longset(temp1, n);					/* Check against digit # */
		longdiv(temp2, temp1);				/* Perform test */
		if(!longtst(Longreg)) {				/* Divides - proceed */
			digits[i] = -1;					/* Mark digit as used */
			main();							/* Try sub-combinations */
			digits[i] = 0; }				/* Release digit */
		longcpy(num, savenum); }			/* Restore for next try */
	--n;
}

/*
 * Print LONG number
 */
print_long(unsigned char *n1)
{
	unsigned sp;
	unsigned char stack[(LONG_SIZE*25)/10+1];

	longcpy(temp2, n1);
	longset(temp1, 10);
	
	/* Stack up digits in reverse order */
	sp = 0;
	do {
		longdiv(temp2, temp1);
		stack[sp++] = *Longreg + '0'; }
	while(longtst(temp2));

	/* Unstack digits into output buffer */
	do
		putc(stack[--sp], stdout);
	while(sp);
	putc('\n', stdout);
}
