/*
 * This program displays any occurances of the first eight hardware
 * interrupts on the IBM PC, which signal various processor exceptions.
 *
 * When HEM detects a hardware exception, It will open a small window
 * in the center of the screen, displaying what type of exception
 * has occured, and waits for you to press a key. After you press a key,
 * HEM will close the text window, and attempt to terminate the
 * application "gracefully" by exiting to DOS.
 *
 * To install HEM, you must execute the program, and specify HOT-KEYS
 * on the command line as follows:
 *		L - Left SHIFT
 *		R - Right SHIFT
 *		A - ALT
 *		C - CONTROL
 *		S - SysRq (Caution: some systems may not like this one)
 *
 *		eg: HEM LR	(Install with LEFT+RIGHT SHIFT for hotkeys)
 *
 * Any time you 'POP-INTO' HEM with the HOT-KEYS, it will reclaim the
 * hardware interrupts. This allows you to bypass application programs
 * which take them over.
 *
 * Copyright 1990-1995 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc hem -fop
 */
#include <stdio.h>
#include <tsr.h>

extern int PSP;		/* COM files CODE segment */
char *msg;

divide()	{ showint("Divide by Zero"); }
step()		{ showint("Single-Step interrupt"); }
nmi()		{ showint("Non-Maskable interrupt"); }
brkpt()		{ showint("Breakpoint interrupt"); }
overflow()	{ showint("Overflow"); }
prtsc()		{ showint("Print-Screen/BOUND interrupt"); }
opcode()	{ showint("Illegal Opcode"); }
nofpu()		{ showint("Co-processor not present"); }

/*
 * Display the interrupt that has occured
 */
showint(ptr)
	char *ptr;
{
	asm {
		MOV		DX,CS
		MOV		DS,DX
	}
	msg = ptr;
	asm {
		MOV		SS,DX
		MOV		SP,0
	}
	message();
	exit(0);
}

/*
 * On POP-UP, reclaim interrupts & issue message
 */
popup()
{
	get_ints();
	msg = "Interrupt vectors reclaimed";
	message();
}

/*
 * Display a message in a window on the screen
 */
message()
{
	char *ptr;

	wopen(18, 10, 40, 3, 0xD070);
	ptr = "HEM: \7";
	while(*ptr)
		wputc(*ptr++);
	while(*msg)
		wputc(*msg++);
	wgetc();
	wclose();
}

/*
 * Grab the hardware interrupt vectors
 */
get_ints()
{
	set_int(0, &divide);
	set_int(1, &step);
	set_int(2, &nmi);
	set_int(3, &brkpt);
	set_int(4, &overflow);
	set_int(5, &prtsc);
	set_int(6, &opcode);
	set_int(7, &nofpu);
}

/*
 * Set an individual interrupt vector
 */
set_int(intr, addr)
	int intr, addr;
{
	pokew(0, intr*4, addr);
	pokew(0, intr*4+2, PSP);
}

/*
 * Main program, either TSR or display USE message
 */
main(argc, argv)
	int argc;
	int *argv[];
{
	int hot_keys;
	char *ptr;

	fputs("Hardware Exception Monitor\n\nCopyright 1990-1995 Dave Dunfield\nAll rights reserved.", stderr);
/* If RAM-resident, print startup message & TSR */
	if(argc > 1) {
		hot_keys = 0;
		ptr = argv[1];
		while(*ptr) switch(toupper(*ptr++)) {
			case 'A' : hot_keys |= ALT;		break;
			case 'C' : hot_keys |= CONTROL;	break;
			case 'L' : hot_keys |= L_SHIFT;	break;
			case 'R' : hot_keys |= R_SHIFT; break;
			case 'S' : hot_keys |= SYS_REQ;	break;
			default: abort("\n\nInvalid HOTKEY"); }
		get_ints();
		tsr(&popup, hot_keys, 1500); }

/* Not RAM-resident, display usage info */
	fputs("\n\nUse: hem <hotkeys>", stderr);
}
