
//
//  LousyPlayer for WATCOM using IRQ calling.
//


#include <stdlib.h>
#include <stdio.h>

#include "irq"
#include "music.h"

//

extern "C" int  GUSBasePort;
extern "C" int  GUSDramDMA;
extern "C" int  GUSAdcDMA;
extern "C" int  GUSGf1IRQ;
extern "C" int  GUSMidiIRQ;

extern "C" int  init_card();
extern "C" void play_musictick();
extern "C" void start_gusirq();
extern "C" void interrupt gus_interrupt();

//

static int       oldIrqState;
static void far* oldIrqHandler;
static char*     envstr;
static int       MusicInitFlag = 0;

//

int
try_GUS()
{
        envstr = getenv("ULTRASND");

        if (envstr != NULL)
        {
            if (sscanf(envstr,"%x,%d,%d,%d,%d",&GUSBasePort,
                                               &GUSDramDMA,
                                               &GUSAdcDMA,
                                               &GUSGf1IRQ,
                                               &GUSMidiIRQ) != 5) return 0;

            SoundCard = GUS;
            return 1;
        }

        return 0;
}

//

int
try_GUSIW()
{
        envstr = getenv("INTERWAVE");

        if (envstr != NULL)
        {
            if (try_GUS())
            {
                SoundCard = GUSIW;
                return 1;
            }
        }

        return 0;
}

//

cardid
init_music(int forcegf1)
{

        if (!MusicInitFlag)
        {
            SoundCard = NoSound;

            if (forcegf1)
            {
                if (!try_GUS())
                    return NoSound;
            }
            else
                if (!try_GUSIW())
                    if (!try_GUS())
                        return NoSound;

            if (init_card() != 0)
                return NoSound;

            oldIrqHandler = irq_gethandler(GUSGf1IRQ);
            oldIrqState   = irq_isenabled(GUSGf1IRQ);

            irq_cli();

            irq_sethandler(GUSGf1IRQ,gus_interrupt);
            irq_enable(GUSGf1IRQ);
            start_gusirq();

            irq_sti();

            MusicInitFlag = 1;
            atexit(&close_music);
        }

        return (cardid) SoundCard;
}

//

cardid
init_music()
{
        return init_music(0);
}

//

void
close_music()
{

        if (MusicInitFlag)
        {

            irq_cli();

            irq_sethandler(GUSGf1IRQ,oldIrqHandler);

            //if (oldIrqState == 0)
            //    irq_disable(GUSGf1IRQ);

            irq_sti();
        }
}

//





