UNIT Globals;
(* ----------------------------------------------------------------------
   Part of 4FF   - 4DOS File Finder

   (c) 1992, 1993 Copyright by David Frey,
                               Urdorferstrasse 30
                               8952 Schlieren ZH
                               Switzerland

   DISCLAIMER: This unit is freeware: you are allowed to use, copy
               and change it free of charge, but you may not sell or hire
               this part of 4DESC. The copyright remains in our hands.

               If you make any (considerable) changes to the source code,
               please let us know. (send a copy or a listing).
               We would like to see what you have done.

               We, David Frey and Tom Bowden, the authors, provide absolutely
               no warranty of any kind. The user of this software takes the
               entire risk of damages, failures, data losses or other
               incidents.


       Code created using Turbo Pascal 7.0 (c) Borland International 1992

   This unit provides the string handling and the date/time handling.

   ----------------------------------------------------------------------- *)

INTERFACE USES Objects, Dos, StringDateHandling;

CONST MaxFileSpecs      =   6;
      DescLen           = 200;

TYPE  DescStr           = STRING[DescLen];
      NameExtStr        = STRING[8+1+3];
      FileSpecArrayType = ARRAY[1..MaxFileSpecs] OF NameExtStr;

(* command line flags: *)

VAR   ExactAttr                : BOOLEAN;
      ScanLZHArchives          : BOOLEAN;
      ScanZIPArchives          : BOOLEAN;
      ScanARJArchives          : BOOLEAN;
      SubDirectories           : BOOLEAN;
      AllDrives, FixedDrives   : BOOLEAN;
      BareOutput               : BOOLEAN;
      DoPage                   : BOOLEAN;
      Drive                    : CHAR;
      searchdesc               : DescStr;

(* Global variables *)

VAR   Attr                     : BYTE;
      DirSize,   TotalSize     : LONGINT;
      FileCount, TotalFileCount: WORD;

VAR   FileName                 : NameExtStr;
      Search                   : SearchRec;
      Path                     : PathStr;
      Name                     : NameStr;
      Dir                      : DirStr;
      Ext                      : ExtStr;

VAR   f                        : FILE; (* the archive *)

VAR   InfoArray                : ARRAY[0..6] OF PString;
      AttrStr, FileStr, SizeStr: STRING;
      Date                     : DateStr;
      Time                     : TimeStr;
      DateRec                  : DateTime;

VAR   csize                    : LONGINT;    (* compressed size *)
      fstamp                   : DateTime;   (* last mod file date/time (turbo format) *)
      s                        : STRING;

(* Templates for FormatStr *)

VAR   DateTempl : STRING[4];
      TimeTempl : STRING[4];
      DescTempl : STRING[5];

VAR   MaxViewLength : BYTE;

(* Buffer related variables: *)

CONST MaxBufSize = 65500;

TYPE  PBuffer = ^TBuffer;
      TBuffer = ARRAY[0..MaxBufSize] OF BYTE;

VAR   BufPtr    : LONGINT;
      BytesRead : WORD;
      BufSize   : WORD;
      FilePtr   : LONGINT;

VAR   Buffer    : PBuffer;

VAR   Line      : BYTE;
      Redirected: BOOLEAN;

PROCEDURE TestForMoreMsg;

PROCEDURE InstallBuffer;
PROCEDURE FreeBuffer;
FUNCTION  ReadByte: BYTE;

IMPLEMENTATION USES Memory, Crt,
                    HandleINIFile, DescriptionHandling;

VAR   ScreenHeight : BYTE;
      HilightMore  : BOOLEAN;

FUNCTION TestIfRedirected: BOOLEAN;

TYPE TPSP = ARRAY[0..$FF] OF BYTE;

VAR  PSP  : ^TPSP;

BEGIN
 PSP := Ptr(PrefixSeg,0);
 TestIfRedirected := (PSP^[$19] <> 1);
END;

PROCEDURE TestForMoreMsg;

VAR ch: CHAR;

BEGIN
 INC(Line);
 IF KeyPressed OR (Line = ScreenHeight) THEN
  BEGIN
   IF KeyPressed THEN ch := ReadKey;
   IF HilightMore THEN HighVideo;
   Write('-- more --',#13);
   IF HilightMore THEN LowVideo;
   REPEAT UNTIL KeyPressed;
   ch := ReadKey;
   ClrEOL;
   IF Line = ScreenHeight THEN Line := 1;
  END;
END;

PROCEDURE InstallBuffer;

BEGIN
 IF MaxAvail < MaxBufSize THEN BufSize:= WORD(MaxAvail)
                          ELSE BufSize:= MaxBufSize;

 GetMem(Buffer,BufSize);
 IF Buffer = NIL THEN
  BEGIN
   WriteLn(Output);
   WriteLn(Output,'Fatal Error : Unable to allocate Buffer!');
   HALT(255);
  END;
END; (* InstallBuffer *)

PROCEDURE FreeBuffer;

BEGIN
 FreeMem(Buffer,BufSize);
END; (* FreeBuffer *)

FUNCTION ReadByte: BYTE;

BEGIN
 IF BufPtr >= BufSize THEN
  BEGIN
   BlockRead(f,Buffer^,BufSize, BytesRead);
   BufPtr := 0;
  END;

 ReadByte := Buffer^[BufPtr]; INC(BufPtr); INC(FilePtr);
END; (* ReadByte *)

BEGIN
 Str(Length(DateFormat),DateTempl); DateTempl := '%'+DateTempl+'s';
 Str(Length(TimeFormat),TimeTempl); TimeTempl := '%'+TimeTempl+'s';

 Assign(Output,''); Rewrite(Output);
 Redirected := TestIfRedirected; DirectVideo := NOT Redirected;

 IF Redirected THEN
  BEGIN
   MaxViewLength := 255; DescTempl := '%-s';
   Assign(Output,''); Rewrite(Output);

   DoPage := FALSE;
  END
 ELSE
  BEGIN
   AssignCrt(Output); Rewrite(Output);

   MaxViewLength := Lo(WindMax)-33-Length(DateFormat)-Length(TimeFormat);
   Str(MaxViewLength,DescTempl); DescTempl := '%-'+DescTempl+'s';
   ScreenHeight := Hi(WindMax);

   InitMemory;

   INIStrings := New(PINIStrings,Init); (* Read in the .INI file(s) *)
   StringDateHandling.EvaluateINIFileSettings;
   DescriptionHandling.EvaluateINIFileSettings;

   HilightMore := (ReadSettingsChar('4ff','hilightmore','y') = 'y');
   DoPage      := (ReadSettingsChar('4ff','dopage','n') = 'y');

   Dispose(INIStrings,Done); INIStrings := NIL;
  END;
END.
