/*

  GUS.H

  Michael Chen
  mchen@cs.psu.edu
  4/18/1993
  
  See the included .TXT file for terms and other information.

*/

#ifndef __GUS_H
#define __GUS_H

/* A few typedefs for convenience. */

typedef unsigned char byte;
typedef unsigned int word;
typedef unsigned long longword;

/* Define minimum and maximum number of voices. */

#define MINVOICES             14
#define MAXVOICES             32

/* Command (GUSCommand) defines */

#define G_SetVoiceMode        0x0
#define G_SetVoiceFreq        0x1
#define G_SetLoopStartLo      0x2
#define G_SetLoopStartHi      0x3
#define G_SetLoopEndLo        0x4
#define G_SetLoopEndHi        0x5
#define G_SetVolumeRampRate   0x6
#define G_SetVolumeRampStart  0x7
#define G_SetVolumeRampEnd    0x8
#define G_SetVolume           0x9
#define G_SetPositionLo       0xA
#define G_SetPositionHi       0xB
#define G_SetVoiceBalance     0xC
#define G_SetVolumeControl    0xD
#define G_SetMaxVoice         0xE
#define G_DMAControl          0x41
#define G_SetDRAMLo           0x43
#define G_SetDRAMHi           0x44
#define G_TimerControl        0x45
#define G_TimerSpeed          0x46
#define G_SampleControl       0x49
#define G_Initialize          0x4C
#define G_ReadVoiceMode       0x80
#define G_ReadVoiceFreq       0x81
#define G_ReadLoopStartLo     0x82
#define G_ReadLoopStartHi     0x83
#define G_ReadLoopEndLo       0x84
#define G_ReadLoopEndHi       0x85
#define G_ReadVolumeRampRate  0x86
#define G_ReadVolumeRampStart 0x87
#define G_ReadVolumeRampEnd   0x88
#define G_ReadVolume          0x89
#define G_ReadPositionLo      0x8A
#define G_ReadPositionHi      0x8B
#define G_ReadVoiceBalance    0x8C
#define G_ReadVolumeControl   0x8D
#define G_ReadMaxVoice        0x8E
#define G_IRQStatus           0x8F

/* Voice mask for use with G_Set/ReadMaxVoice. */

#define G_VoiceMask           0xC0

/* Mixer control (GUSMixer) defines */

#define M_LineInOn            0x0
#define M_LineInOff           0x1
#define M_OutputOn            0x0
#define M_OutputOff           0x2
#define M_MicInOn             0x4
#define M_MicInOff            0x0
#define M_IRQControl          0x40
#define M_DMAControl          0x0

/* Voice mode (G_Set/ReadVoiceMode) defines */

#define V_VoiceStopped        0x1
#define V_VoiceStarted        0x0
#define V_StopVoice           0x2
#define V_StartVoice          0x0
#define V_16Bit               0x4
#define V_8Bit                0x0
#define V_Loop                0x8
#define V_NoLoop              0x0
#define V_Bidirectional       0x10
#define V_Unidirectional      0x0
#define V_IRQLoop             0x20
#define V_NoIRQLoop           0x0
#define V_Forward             0x0
#define V_Backward            0x40

/* Volume control (G_Set/ReadVolumeControl) defines */

#define V_RampStopped         0x1
#define V_RampStarted         0x0
#define V_StartRamp           0x0
#define V_StopRamp            0x2
/* same V_Loop/NoLoop defines */
/* same V_Uni/Bidirectional   */
#define V_IRQRamp             0x20
#define V_NoIRQRamp           0x0
#define V_Increasing          0x0
#define V_Decreasing          0x40

/* Ramp scale defines */

#define R_Every1              0x0
#define R_Every8              0x1
#define R_Every64             0x2
#define R_Every512            0x3

/* Voice balance (pan) defines */

#define P_Center              0x7
#define P_Left                0x0
#define P_Right               0xF
 
/* Addresses of ports. */

extern int GUSBase;
extern int GUSMixer;              /* base         */
extern int GUSStatus;             /* base + 6     */
extern int GUSTimerControl;       /* base + 8     */
extern int GUSTimerData;          /* base + 9     */
extern int GUSIRQDMAControl;      /* base + 0xB   */
extern int GUSMIDIControl;        /* base + 0x100 */
extern int GUSMIDIData;           /* base + 0x101 */
extern int GUSVoice;              /* base + 0x102 */
extern int GUSCommand;            /* base + 0x103 */
extern int GUSDataLo;             /* base + 0x104 */
extern int GUSDataHi;             /* base + 0x105 */
extern int GUSDRAMIO;             /* base + 0x107 */

/* Internal variables, but can be seen externally. */

extern int GUSCurrentVoice;
extern int GUSVoices;

/* Declare frequency divisor table. */

extern byte GUSFreqDivisorTable[MAXVOICES+1];

/* Prototypes for extern routines. */

#ifdef __cplusplus
extern "C" {
#endif

extern void GUSDelay();
extern void GUSReset();
extern unsigned char GUSPeek(longword);
extern void GUSPoke(longword, byte);
extern unsigned char GUSPokePeek(longword, byte);
extern unsigned char GUS_Peek(byte, word);
extern void GUS_Poke(byte, word, byte);
extern unsigned char GUS_PokePeek(byte, word, byte);
extern int ProbeGUS();
extern int DetectGUS();

#ifdef __cplusplus
}
#endif


#define GUS_PeekSame()           (inportb(GUSDRAMIO))
#define GUS_PokeSame(x)          (outportb(GUSDRAMIO,x))

#ifdef __cplusplus
extern "C" {
#endif

extern void GUS_SelectVoice(byte);
extern void GUSSelectVoice(byte);
extern void GUSStopVoice(byte);
extern void GUSStartVoice(byte);
extern void GUSSetVoiceMode(byte voice, byte mode);
extern void GUSSetLoopStart(byte voice, longword addr);
extern void GUSSetLoopEnd(byte voice, longword addr);
extern void GUSSetPosition(byte voice, longword addr);
extern void GUSSetVoiceFreq(byte voice, word freq);
extern void GUSSetVoices(byte voices);
extern longword GUSReadLoopStart(byte voice);
extern longword GUSReadLoopEnd(byte voice);
extern longword GUSReadPosition(byte voice);
extern byte GUSReadVoiceMode(byte voice);
extern word GUSReadVoiceFreq(byte voice);
extern word GUSReadVolume(byte voice);
extern void GUSSetVolume(byte voice, word vol);
extern void GUSSetDRAM(longword addr, void* buf, longword len);
extern void GUSReadDRAM(longword addr, void* buf, longword len);
extern void GUSFillDRAM(longword addr, byte b, longword len);

#ifdef __cplusplus
}
#endif


#define GUS_SetMixer(b)          (outportb(GUSMixer,b))
#define GUS_ReadMixer()          (inportb(GUSMixer))
#define GUS_SetStatus(b)         (outportb(GUSStatus,b))
#define GUS_ReadStatus()         (inportb(GUSStatus))
#define GUS_SetTimerControl(b)   (outportb(GUSTimerControl,b))
#define GUS_ReadTimerControl()   (inportb(GUSTimerControl))
#define GUS_SetTimerData(b)      (outportb(GUSTimerData,b))
#define GUS_ReadTimerData()      (inportb(GUSTimerData))
#define GUS_SetIRQDMAControl(b)  (outport(GUSIRQDMAControl,b))
#define GUS_ReadIRQDMAControl()  (inportb(GUSIRQDMAControl))
#define GUS_SetMIDIControl(b)    (outportb(GUSMIDIControl,b))
#define GUS_ReadMIDIControl()    (inportb(GUSMIDIControl))
#define GUS_SetMIDIData(b)       (outportb(GUSMIDIData,b))
#define GUS_ReadMIDIData()       (inportb(GUSMIDIData))
#define GUS_SetVoice(b)          (outportb(GUSVoice,b))
#define GUS_ReadVoice()          (inportb(GUSVoice))
#define GUS_SetCommand(b)        (outportb(GUSCommand,b))
#define GUS_ReadCommand()        (inportb(GUSCommand))
#define GUS_SetDRAMIO(b)         (outportb(GUSDRAMIO,b))
#define GUS_ReadDRAMIO()         (inportb(GUSDRAMIO))

#ifdef __cplusplus
extern "C" {
#endif

extern void GUSSetVolumeRampRate(byte voice, byte incr, byte scale);
extern byte GUSReadVolumeRampRate(byte voice);
extern void GUSSetVolumeRampStart(byte voice, word vol);
extern void GUSSetVolumeRampEnd(byte voice, word vol);
extern word GUSReadVolumeRampStart(byte voice);
extern word GUSReadVolumeRampEnd(byte voice);
extern void GUSSetVolumeControl(byte voice, byte mode);
extern byte GUSReadVolumeControl(byte voice);
extern void GUSSetMixer(byte mode);
extern byte GUSReadMixer();
extern void GUSShutUp();
extern void GUSStartRamp(byte voice);
extern void GUSStopRamp(byte voice);
extern void GUSSetVoiceBalance(byte voice, byte pan);
extern byte GUSReadVoiceBalance(byte voice);

#ifdef __cplusplus
}
#endif

#endif
