/***************************************************************************
*	NAME:  INIT.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/
#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"
#include "extern.h"
#include "ultraerr.h"
#include "irq.h"
#include "dma.h"

extern IRQ_ENTRY _gf1_irq[];
extern DMA_ENTRY _gf1_dma[];
extern ULTRA_DATA _gf1_data;

int
UltraPing(unsigned int port)
{
unsigned char val;
unsigned char save_val0;
unsigned char save_val1;

/* save current values ... */
save_val0 = UltraPeekData(port,0L);
save_val1 = UltraPeekData(port,1L);

UltraPokeData(port,0L,0xAA);
UltraPokeData(port,1L,0x55);
val = UltraPeekData(port,0L);

/* restore data to old values ... */
UltraPokeData(port,0L,save_val0);
UltraPokeData(port,1L,save_val1);

if (val == (unsigned char)0xAA)
	return(ULTRA_OK);
else
	return(NO_ULTRA);
}

int
UltraProbe(unsigned int port)
{
int val;

_gf1_data.base_port = port;
_gf1_data.midi_data = port + GF1_MIDI_DATA;
_gf1_data.midi_control = port + GF1_MIDI_CTRL;
_gf1_data.voice_select = port + GF1_PAGE;
_gf1_data.reg_select = port + GF1_REG_SELECT;
_gf1_data.data_low = port + GF1_DATA_LOW;
_gf1_data.data_hi = port + GF1_DATA_HI;
_gf1_data.irq_status = port + GF1_IRQ_STAT;
_gf1_data.dram_data = port + GF1_DRAM;
_gf1_data.mix_control = port + GF1_MIX_CTRL;
_gf1_data.timer_control = port + GF1_TIMER_CTRL;
_gf1_data.timer_data = port+ GF1_TIMER_DATA;

_gf1_data.irq_control = port + GF1_IRQ_CTRL;

/* Pull a reset on the GF1 */
outp(_gf1_data.reg_select,MASTER_RESET);
outp(_gf1_data.data_hi,0x00);

/* Wait a little while ... */
gf1_delay();
gf1_delay();

/* Release Reset */
outp(_gf1_data.reg_select,MASTER_RESET);
outp(_gf1_data.data_hi,GF1_MASTER_RESET);

gf1_delay();
gf1_delay();


val = UltraPing(port);
return(val);
}

void
UltraSetInterface(int dram,int adc,int gf1,int midi)
// int dram;	/* dram dma chan */
// int adc;		/* adc dma chan */
// int gf1;		/* gf1 irq # */
// int midi;	/* midi irq # */
{
unsigned char	gf1_irq, midi_irq, dram_dma=0, adc_dma=0;
unsigned char	irq_control, dma_control;
unsigned char	mix_image;

	ENTER_CRITICAL;

	/* Don't need to check for 0 irq #. Its latch entry = 0 */
	gf1_irq = _gf1_irq[gf1].latch;

	midi_irq = _gf1_irq[midi].latch;

	midi_irq <<= 3;

	/* Set latch to 0 if dma channel is 0 */
	/* This takes this channel off line ... */
	if (dram != 0)	
		dram_dma = _gf1_dma[dram-1].latch;

	if (adc != 0)
		adc_dma = _gf1_dma[adc-1].latch;

	adc_dma <<= 3;

	irq_control = dma_control = 0x0;

	mix_image = _gf1_data.mix_image;/* init image to everything disabled */
	
	irq_control |= gf1_irq;
	if((gf1 == midi) && (gf1 != 0))
		{
		irq_control |= 0x40;
		}
	else
		{
		irq_control |= midi_irq;
		}
		
	dma_control |= dram_dma;
	if((dram == adc) && (dram != 0))
		{
		dma_control |= 0x40;
		}
	else
		{
		dma_control |= adc_dma;
		}

/* Set up for Digital ASIC */
	outp(_gf1_data.base_port+0x0f,0x5);
	outp(_gf1_data.mix_control,mix_image);
	outp(_gf1_data.irq_control,0x0);
	outp(_gf1_data.base_port+0x0f,0x0);

/* First do DMA control register */
	outp( _gf1_data.mix_control, mix_image );             
	outp( _gf1_data.irq_control, dma_control|0x80 );

/* IRQ CONTROL REG */
	outp( _gf1_data.mix_control, mix_image|0x40 );             
	outp( _gf1_data.irq_control, irq_control );
	
/* First do DMA control register */
	outp( _gf1_data.mix_control, mix_image );             
	outp( _gf1_data.irq_control, dma_control );

/* IRQ CONTROL REG */
	outp( _gf1_data.mix_control, mix_image|0x40 );             
	outp( _gf1_data.irq_control, irq_control );
	
/* IRQ CONTROL, ENABLE IRQ */
/* just to Lock out writes to irq\dma register ... */
	outp( _gf1_data.voice_select, 0 );

/* enable output & irq, disable line & mic input */
	mix_image |= 0x09;
	outp( _gf1_data.mix_control, mix_image );             

/* just to Lock out writes to irq\dma register ... */
	outp( _gf1_data.voice_select, 0x0 );

	/* put image back .... */
	_gf1_data.mix_image = mix_image;

	LEAVE_CRITICAL;
}

