kline           db      " xxxk/xxxk",0
kline2		db	"xxxk",0
repstr		db	" ~  ",0

OrigMemory      dw      0
CursorType      dw      0
Screen		dw	0B800h
ScreenFix	dw	0
OldMode 	db	0
CurMode 	db	0

proc            HowMuchMemory near
		mov	ah,48h
		mov	bx,0FFFFh
		int	21h
		shr	bx,6
		mov	[cs:OrigMemory],bx
		ret
endp		HowMuchMemory

proc		RestoreMode
		xor	ah,ah
		mov	al,[cs:OldMode]
		int	10h
		ret
endp		RestoreMode

proc            SetMode near
		xor	ah,ah
		mov	al,[cs:CurMode]
		int	10h
		ret
endp		SetMode

proc            DetermineDisplay near
		mov	ax,0f00h
		int	10h
		mov	[cs:OldMode],al
		cmp	al,7			; Are we in monochrome mode?
		jz	@@Monochrome
		mov	[Word cs:Screen],0B800h
		mov	[Word cs:CursorType],0607h
		mov	[Byte cs:CurMode],3
		ret
@@Monochrome:	mov	[Word cs:Screen],0B000h
                mov     [Word cs:CursorType],0B0Ch
		mov	[Byte cs:CurMode],7
		ret
endp		DetermineDisplay

; CX - Scan Lines
proc            SetCursor near
		mov	[cs:CursorType],cx
		mov	ax,0100h
		int	10h
		ret
endp		SetCursor

; bx - X
; dx -Y
; cx:si - Loc
; ax - Len
; di - Attr
proc            WriteChars near
		push	ds si bx cx dx di
		mov	es,[cs:Screen]
		push	ax
		mov	ax,160
		mul	dx
		add	ax,bx
		add	ax,bx
		mov	di,ax
                mov     ds,cx
		pop	cx
                push    di
		mov	ax,0
		rep	stosw
		pop	di
		pop	ax
		jmp	ActualWritePart
endp            WriteChars

; bx - X
; dx - Y
; cx:si - offset of string in DS
proc            Write near
		push	ds si bx cx dx
		mov	es,[cs:Screen]
		mov	ax,160
		mul	dx
		add	ax,bx
		add	ax,bx
		mov	di,ax
		mov	ds,cx
		lodsb
ActualWritePart:
		mov	ah,al
		xor	cx,cx
		xor	dx,dx
@@MainLoop:	lodsb
		cmp	al,0
		jz	@@Done
		cmp	al,'`'
		jnz	@@CheckRepeat
		lodsb
		mov	ah,al
		jmp	@@MainLoop
@@CheckRepeat:	cmp	al,'~'
		jnz	@@JustStore
		lodsb
		mov	cl,al
		lodsb
		rep	stosw
		add	dx,cx
		jmp	@@MainLoop
@@JustStore:	inc	dx
		stosw
		jmp	@@MainLoop
@@Done: 	pop	dx cx bx si ds
		ret
endp		Write

; ax - NumK
; dx - NumDigits
; cx:di - String
proc            ConvertKToStr near
		push	es
		mov	es,cx
		mov	cx,dx
		dec	cx
		add	di,cx
		inc	cx
@@NumLoop:	mov	bl,10
		div	bl
		add	ah,'0'
		mov	[es:di],ah
		dec	di
		xor	ah,ah
		loop	@@NumLoop
		pop	es
		ret
endp		ConvertKToStr

proc            WriteMemLeft near
		mov	ah,48h
		mov	bx,0FFFFh
		int	21h
		shr	bx,6
		push	bx
		mov	ax,[cs:OrigMemory]
		mov	dx,3
		mov	cx,seg kline
		mov	di,offset kline+8
		call	ConvertKToStr
		pop	ax
		mov	dx,3
		mov	cx,seg kline
		mov	di,offset kline+3
		call	ConvertKToStr
                mov     bx,freek_Col
                mov     dx,freek_Line
		mov	cx,seg kline
		mov	si,offset kline
		call	Write
		ret
endp		WriteMemLeft

proc            MakeDec near
		push	di
		dec	cx
		add	di,cx
		inc	cx
		xor	ah,ah
@@NumLoop:	mov	bl,10
		div	bl
		add	ah,'0'
		mov	[es:di],ah
		dec	di
		xor	ah,ah
		loop	@@NumLoop
@@Done: 	pop	di
		ret
endp		MakeDec

HexStuff        db      '0123456789ABCDEF'
proc            MakeHex near
                push    di
                push    ax
                and     al,0F0h
                shr     al,4
                mov     bl,al
                mov     bh,0
                mov     ah,[cs:bx+HexStuff]
                mov     [es:di],ah
                inc     di
                pop     ax
                and     al,0Fh
                mov     bl,al
                mov     bh,0
                mov     ah,[cs:bx+HexStuff]
                mov     [es:di],ah
                pop     di
                ret
endp            MakeHex

proc            DirectWrite1 near
		push	es
		mov	es,[cs:Screen]
@@1:		lodsb
		inc	di
		stosb
		loop	@@1
		pop	es
		ret
endp		DirectWrite1

proc		DirectWrite2 near
		push	es
		mov	es,[cs:Screen]
@@1:		inc	di
		stosb
		loop	@@1
		pop	es
		ret
endp		DirectWrite2


