
@echo off
echo ͻ
echo  This batch file is used to :                                     
echo  1. Remove NCR 53C810 SCSI BIOS from mainboard BIOS.              
echo     The following are the details :                               
echo     (a) Save mainboard BIOS to a newly created file 'OLDBIOS'.    
echo     (b) Duplicate 'OLDBIOS' to another file 'NEWBIOS'.            
echo     (c) Remove NCR SCSI BIOS from 'NEWBIOS'.                      
echo     (d) Re-program the mainboard BIOS flash ROM with 'NEWBIOS'.   
echo     (e) Reboot the system.                                        
echo     1.1 For EPROM mainboard BIOS :                                
echo       (f) User needs to program a new EPROM with 'NEWBIOS'.       
echo       (g) Replace mainboard BIOS with this new EPROM.             
echo                                                                   
echo  2. Restore original system 'OLDBIOS' :                           
echo     2.1 For flash ROM mainboard BIOS :                            
echo       (a) Re-program the mainboard BIOS flash ROM with 'OLDBIOS'. 
echo     2.2 For EPROM mainboard BIOS :                                
echo       (a) Replace mainboard BIOS EPROM with the old one.          
echo                                                                   
echo  Command syntax ( Case sensitive ) :                              
echo    PROG REMOVE_NCR      : To remove system NCR SCSI V3.0 BIOS     
echo    PROG RESTORE_BIOS    : To restore original system BIOS         
echo ͼ
pause
if not exist awdflash.exe goto file
if not exist cbrom.exe goto file
if "%1" == "REMOVE_NCR" goto remove
if "%1" == "RESTORE_BIOS" goto restore
goto end

:remove
awdflash /pn oldbios /sy
echo Mainboard BIOS has been retrieved.
pause
copy oldbios newbios > nul
if not exist newbios goto end
cbrom newbios /ncr release
echo !!!
echo Ready to program mainboard flash ROM with 'NEWBIOS'
pause
awdflash newbios /py /sn
goto end

:restore
if not exist oldbios goto nobios
echo Ready to program mainboard flash ROM with original 'OLDBIOS'
pause
awdflash oldbios /py /sn
goto end

:nobios
echo Original mainboard BIOS "OLDBIOS" not found !!!
goto end

:file
echo To run this batch file, the following program is needed:
echo AWDFLASH.EXE is needed to retrieve and program mainboard BIOS
echo CBROM.EXE is needed to remove NCR SCSI BIOS from mainboard BIOS
:end

