/* setbus : set AT bus data width for tseng based svga cards to 
either 8 or 16 operation.  Most useful for Windows developers using 
two monitors for CodeView debugging. By default, if there is a monochrome 
(or other second monitor on the AT bus, the svga card operates at only 
8 bits doubling video time.

This program allows the user to tell the svga card to use 16-bit data paths
which doubles video perforamce.  This improvement is nearly complete, as 
verified by the PC Labs Windows Graphics benchmark test.

Some programs, such as pcANYWHERE IV and Microsoft's CV and CVW, will
only operate when the bus is in 8-bit mode.  
Changing the mode within a DOS virtual session under Windows is not 
sufficient to allow these programs to operate properly.  SETBUS must
be executed before Windwos for these programs to function.

The source for this code was downloaded from the STB section of the
GRAHICSVENDOR forum on Compuserv.  The original author is unknown.
This is offered as-is. No claims attached. 
It has been tested with an Orchid Pro Designer II card, probably works with 
STB's Tseng based cards, and may work with other Tseng cards.

Uploaded by Pat Farrell, aka pfarrell@gmuvax2.gmu.edu on the Internet.
*/


#include <stdio.h>

main(argc, argv)
   int argc;
   char *argv[];
   {
   int crtc, val;

   if (inp(0x3CC) & 0x01)
      crtc = 0x3D4;
   else
      crtc = 0x3B4;

   outp(0x3BF, 0x03);
   outp(crtc+4, 0xA0);
   outp(crtc, 0x36);
   val = inp(crtc+1);

   if (argc == 2) {
      if (strcmp(argv[1], "16") == 0)
         outp(crtc+1, val | 0x40);
      else if (strcmp(argv[1], "8") == 0)
         outp(crtc+1, val & 0xBF);
      else
         goto usage;
      }
   else
      goto usage;
   exit(0);

usage:
   fprintf(stderr, "Usage: SETBUS 16\n");
   fprintf(stderr, "   or  SETBUS 8\n");
   exit(1);
   }
