#include<iostream.h>
#include<stdlib.h>
#include<stdio.h>
#include<dos.h>

#include"pci.h"

extern int _argc;
extern char **_argv;

bios_info_type *
pci_bios_type::installation_check( void )
{
	return bios_info;     	// Returns TABLE if PCI_BIOS detected
}


uchar
pci_bios_type::find_device( pci_device_handle_type *pci_device )
{
	// Attempts to locate device specified in *pci_device
	// Returns TRUE if successful, FALSE otherwise
     union REGS reg;
     uchar status=FALSE;

     reg.x.ax=0xB102;	// FIND_PCI_DEVICE
     reg.x.cx= pci_device->device;
     reg.x.dx= pci_device->vendor;
     reg.x.si= pci_device->index;

     int86( PCI_INT, &reg, &reg );
     if ( reg.h.ah == 0 )
	{
		status=TRUE;
          pci_device->bus = reg.h.bh;
          pci_device->f.byte = reg.h.bl;	// Function/device byte
     }

     return status;
}

uchar
pci_bios_type::read_cbyte( const pci_device_handle_type pci_device,
	const uint index, uchar *value )
{
     union REGS reg;
     uchar status=FALSE;

     reg.x.ax=0xB108;	// READ_CONFIGURATION_BYTE (real-mode)
     reg.h.bh= pci_device.bus;
     reg.h.bl= pci_device.f.byte;
     reg.x.di= index;

     int86( PCI_INT, &reg, &reg );
     if ( reg.h.ah == 0 )
     {
		status=TRUE;
          *value = reg.h.cl;
     }

     return status;	// Returns BIOS code
	// Returns BIOS code
}

uchar
pci_bios_type::write_cbyte( const pci_device_handle_type pci_device,
	const uint index, const uchar value )
{
     union REGS reg;
     uchar status=FALSE;

     reg.x.ax=0xB10B;	// WRITE_CONFIGURATION_BYTE (real-mode)
     reg.h.bh= pci_device.bus;
     reg.h.bl= pci_device.f.byte;
     reg.x.di= index;
     reg.h.cl= value;

     int86( PCI_INT, &reg, &reg );
     if ( reg.h.ah == 0 )
		status=TRUE;

     return status;	// Returns BIOS code
}


// Constructor initially calls BIOS for presence of PCI,
// sets "installed" to TRUE or FALSE accordingly.  And loads
// bios_info with pci_information returned by the BIOS call
pci_bios_type::pci_bios_type( void )
{
     union REGS reg;
     installed = FALSE;
     bios_info = NULL;	// In case PCI_BIOS does not exist

     reg.x.ax= 0xB101;
     int86( PCI_INT, &reg, &reg );
//     cout << endl << "PCI bios NOT detected.";

     if ( reg.h.ah == 0 )
     {
     	installed=TRUE;
          bios_info = new bios_info_type;
//          cout << endl << "PCI BIOS detected!" ;
          bios_info->major_version = reg.h.bh;
          bios_info->minor_version = reg.h.bl;
          bios_info->last_bus = reg.h.cl;
          bios_info->hardware_characteristics = reg.h.al;
//          printf("\nVersion =  %02X.%02X", bios_info->major_version,
//			bios_info->minor_version );
//          printf("\nLast_bus=0x%02X ", bios_info->last_bus );
//         printf("\nHardware=0x%02X ", bios_info->hardware_characteristics );
	}

}


// Destructor frees up memory used to store bios_info table
pci_bios_type::~pci_bios_type()
{
	if ( bios_info != NULL )
     	delete bios_info;
}


