/*******************************************************************************
*
*	WOLVES.h
*
*	This file contains data structures, function prototypes and constants
*	for using the WOLVES interface within any application
*
*-------------------------------------------------------------------------------
*
*	Copyright Matrox Electronic Systems Ltd.  1990.
*  All rights reserved.
*
*******************************************************************************/


/*******************************************************************************
*
*	Typedefs 
*
*******************************************************************************/


/*
 *---	handle to Video Windows
 */

typedef  WORD   HVIDWND;


/*
 *---	live video window definition structure
 */

typedef  struct
   {
   HVIDWND  hVidWnd;    /* Video window handle              */
   WORD     XDst;       /* Destination rectangle left       */
   WORD     YDst;       /* Destination rectangle top        */
   WORD     DstWidth;   /* Destination rectangle width      */
   WORD     DstHeight;  /* Destination rectangle height     */
   WORD     XSrc;       /* Source rectangle left            */
   WORD     YSrc;       /* Source rectangle top             */
   WORD     SrcWidth;   /* Source rectangle width           */
   WORD     SrcHeight;  /* Source rectangle height          */
   WORD     FullMotion; /* 0=single grab, other=continuous  */
   WORD     Priority;   /* Priority                         */
   } VIDEOGRAB;


/*
 *---	video parameter definition structure
 */

typedef  struct
   {
   HVIDWND  hVidWnd;    /* Video window handle              */
   WORD     Name;       /* Name of the parameter beeing accessed  */
   DWORD    Value;      /* Value of parameter               */
   } VIDEOPARM;



/*******************************************************************************
*
*	CONSTANTS
*
*******************************************************************************/


/*
 *---	wolves support return value
 */

#define WS_INTERRUPTCONNECT	0x0001
#define WS_WOLVESPRESENT		0x0002
#define WS_PALBOARD				0x0080


/*
 *--- Motion Values ( used for VIDEOGRAB FullMotion field )
 */

#define	FM_SINGLE			0
#define	FM_CONTINUOUS		1


/*
 *---	video parameter identification ( used for VIDEOPARM Name field )
 */

#define  VP_HUE            1
#define  VP_SATURATION     2
#define  VP_CONTRAST       3
#define  VP_OFFSET_VAL     4
#define  VP_GAIN           5
#define  VP_SOURCE         6
#define  VP_INPUTMASK      7
#define  VP_COMPMASK       8
#define  VP_COMPDATA       9
#define  VP_KEYMODE        10
#define  VP_OUTMODE        11
#define  VP_FADE           12
#define  VP_LIVEWINSTATE   13
#define  VP_GENLOCK        14

/*
 *--- OUTMODE masks
 */

#define	OM_INTERLACE		0
#define	OM_NONINTREPT		2
#define	OM_NONINTPROG		3

/*
 *---	board state return value
*/

#define	LWS_FREESTATE     0
#define	LWS_USEDSTATE     1
#define	LWS_LIVESTATE     2
#define	LWS_SGLESTATE     3

/*
 *--- genlock states
 */

#define   GEN_OFF          0
#define   GEN_ON           1


/*******************************************************************************
*
*	function prototypes
*
*******************************************************************************/


WORD		FAR PASCAL MTXWolvesSupport( );
HVIDWND	FAR PASCAL MTXCreateVideoWindow( );
WORD		FAR PASCAL MTXDeleteVideoWindow( HVIDWND );
WORD		FAR PASCAL MTXStartVideoGrab( VIDEOGRAB FAR * );
WORD		FAR PASCAL MTXStopVideoGrab( HVIDWND );
WORD		FAR PASCAL MTXQueryVideoParm( WORD, DWORD FAR * );
WORD		FAR PASCAL MTXVideoParm( VIDEOPARM FAR *, VIDEOPARM FAR * );
WORD		FAR PASCAL MTXStartVideoRegion();
WORD		FAR PASCAL MTXStopVideoRegion();


/******************************************************************************/

