;				Hercbios.asm
;		Int 10h bios routines for Hercules monochrome graphics,
;	featuring 43 row, 90 column display and very fast line drawing functions.
;	format: Hercbios [ #of_rows_for_getchar_buffer ]
;	defaults: no get_char buffer at all
;----------------------------------------------------------------------------

;Hercbios is Copywrite 1987, 1988 by Douglas McDaniels
;HERCBIOS is shareware, you may make all the copies that you want, and are
;encouraged to give them to your freinds, and place HBIOSARC.EXE on bulletin
;boards when appropriate. Programers may distribute the Hercbios system with
;their programs that make use of it without paying a royalty.
;If you like HERCBIOS  and make use of it, then you must send a $5.00 licence
;fee to:
;
	       ;Douglas McDaniels
	       ;2627 Arlington Dr #101
	       ;Alexandria VA 22306

TITLE	HERCBIOS

;----------------------------------------------------------------------------
;This is to be converted to a com program,
;Be sure to exe2bin if necessary
;
;----------------------------------------------------------------------------

BIOSSEG	SEGMENT AT 0H
	ORG	7CH
GRAF0		DW	?;To contain dword ptr to 8x8 bit graphics char pixel maps
GRAF1		DW	?;Set by graftabl.com if available
	ORG	110H
ASCII0	DW	?;To contain dword ptr to 8x8 bit ascii pixel maps
ASCII1	DW	?;Set by ascitabl.com. for ibm computers and true compatables
;These pixel maps are always located at 0f000:0fa6e (the PC Jr has already set
;This interrupt)
	ORG	449H
CRTMODE	DB	?;Bios data --- is supposed contain current crt mode
	ORG	44AH
COLDIS	DB	?;Bios data --- number of character columns
	ORG	44CH
BYPERPAG	DW	?;Bios data --- length of video buffer
	ORG	44EH
OFSTAPAG	DW	?;Bios data --- offset of active video page into video buffer
	ORG	450H
BCURS0	DW	?;Bios data --- cursor location, page 0
	ORG	452H
BCURS1	DW	?;Bios data --- cursor location, page 1
	ORG	462H
ACTPAG	DB	?;Bios data --- active display page
	ORG	484H
ROWSONSCRN	DB	?;Bios data --- number of character rows -1, if nonzero
BIOSSEG	ENDS

CSEG	SEGMENT
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	ORG	0100H
DUMPROC	PROC	NEAR

;----------------------------------------------------------------------------
;Note that,by convention, int 10h need only preserve
;bx,cx,dx and the segment registers, but we play it safe 
;and preserve all registers
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
START:	JMP	LAST_BYTE;Jump to installation code
;----------------------------------------------------------------------------

OLD10H	DW	0;Dword ptr to old location of int 10h vector
OLD10H2	DW	0
ILOC	DW	IBM;Iloc initially points to code to handle the interrupt when in an
;IBM mode, but is changed to point to a handler for the Hercules mode when that
;mode is selected
	DW	SPECIAL;This is the start of a dispatch table of routines to change
;To a non-IBM mode, with special(mode -1) reserved for mode mapping use
	DW	SETMHERC ;(mode -2) currently just the one (Hercules) is available

TRANSLAT	DW	0100H;	IBM mode translation table
	DW	0302H;Initially set for no mode translation
	DW	0504H
	DW	0706H,0908H,0B0AH,0D0CH,0F0EH
	DW	1110H,1312H,1514H,1716H,1918H
	DW	1B1AH,1D1CH,1F1EH;Translation space is provided for the first 32
;Video modes


;----------------------------------------------------------------------------
NEW10HI:
	JMP	WORD PTR CS:ILOC;Initially iloc contains IBM, but is changed to
;point to Hercules mode handler when mode -2 (254) is selected

;	request to set mode, code when in IBM mode
IBM:	CMP	AH,0
	JZ	SET			;Allow for 32 IBM video modes
	JMP	DWORD PTR	CS:OLD10H;Far jump to old int 10

;	allow for 32 IBM video modes
SET:	CMP	AL,20H
	JNB	SET2			;Request to set to a non IBM video mode?
	PUSH	BX
	PUSH	DS
	PUSH	CS
	POP	DS
	MOV	BX,OFFSET TRANSLAT	;IBM mode translation table
	XLAT
	POP	DS
	POP	BX
;	request to set to a non IBM video mode?
SET2:	CMP	AL,0
	JL	NON_IBM_MODE
	JMP	DWORD PTR	CS:OLD10H


;	lowest currently available mode (note that 0feh = -2)
NON_IBM_MODE:	CMP	AL,0FEH
	JGE	HOP1
	JMP	DWORD PTR	CS:OLD10H

HOP1:	PUSH	AX
	PUSH	DS
	PUSH	ES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP;Pushgroup b
	NEG	AL
	ADD	AL,AL
	MOV	SI,OFFSET ILOC
	ADD	SI,AX
	JMP	WORD PTR CS:[SI];si has been set to code to change to requested mode
	
	
;----------------------------------------------------------------------------	
SPECIAL:;Requesting mode -1 (255) sets IBM mode translation table
;IBM mode held in ch, now is translated to a request for mode in cl
;----------------------------------------------------------------------------
	PUSH	CS
	POP	DS
	MOV	BX,OFFSET TRANSLAT	;IBM mode translation table
	MOV	DL,CH
	XOR	DH,DH
	ADD	BX,DX
	MOV	[BX],CL
	CMP	CL,0FEH
	JNZ	HOP100			;Jump to popgroup b and iret
	MOV	HMODE,CH;If Hercmode is to substitute for an IBM mode,
;Then get_mode function will now return the emulated video mode number
;	jump to popgroup b and iret
HOP100:	JMP	HNULL

;----------------------------------------------------------------------------
INDEXX EQU 03B4H ;Address of 6845 chip index port (data port is at 03b5h)
CONTROL EQU 03B8H ;Address of 6845 chip control port

GTABLE	DB	35H,2DH,2EH,7;Table of values to output to 6845 data port
	DB	5BH,2,2 DUP(57H); in order to reprogram chip for Hercules
	DB	2,3,2 DUP(0);Graphics mode
;----------------------------------------------------------------------------
	
	
;----------------------------------------------------------------------------
;	change mode to Hercules routine. if bh = 0, suppress page 1, to
;Allow simultaneous use of both Herc card and cga card
;If bh = 1, enable both video pages (0 and 1)
;----------------------------------------------------------------------------
SETMHERC:
	MOV	AX,CS
	MOV	DS,AX;Define ds (ds is undefined on entry to interrupt)
;Before attempting to change mode, we must output 1 or 3 to port 03bfh,
;3 alows both mode changing and page changing
	MOV	DX,03BFH
	MOV	AL,BH
	ADD	AL,AL
	INC	AL;al = 1+2*bh
	OUT	DX,AL
;change the mode, but with the screen blanked to suppress 'bounce'
	MOV	DX,CONTROL
	MOV	AL,2;Instruction to change mode to graphics and blank screen
	OUT	DX,AL
	MOV	SI,OFFSET GTABLE	;Control equ address of 6845 control port
;Point ds:si to gtable for upcoming lods
	CLD
	MOV	DX,INDEXX
	MOV	CX,0CH;Intitialize loop to output gtable to 6845
	XOR	AH,AH
LOOPTOP:
	MOV	AL,AH
	OUT	DX,AL
	INC	DX
	LODSB
	OUT	DX,AL
	INC	AH
	DEC	DX
	LOOP	LOOPTOP;This loop outputs gtable to 6845
	
	MOV	CX,4000H;Erase the screen, first page only
	CMP	BH,1
	JNZ	HOP2
	MOV	CX,8000H;Both pages instead
HOP2:	MOV	AX,0B000H
	MOV	ES,AX
	XOR	DI,DI;es:di now points to start of video buffer
	XOR	AX,AX;Clear all pixels
	REPZ	STOSW
	PUSH	CS
	POP	ES
	MOV	DI,OFFSET LAST_BYTE;di points to start of get_char buffer
	MOV	CX,WORD PTR SEEN_BYTES	;Total bytes covered by get_char buffer
	SHR	CX,1
	XOR	AX,AX
	REPZ	STOSW
	MOV	DX,CONTROL;Now turn the screen back on and use page 0
	MOV	AL,0AH
	OUT	DX,AL
	
	MOV	BYTE PTR HPAGE,0;Set initial page to 0
	MOV	WORD PTR HCURS_TYPE,0607H;Set initial cursor type
	MOV	WORD PTR HCURS_ROW0,0	;Cursor row for page 0 
	MOV	WORD PTR HCURS_COLMN0,0	;Cursor column for page 0 
	MOV	WORD PTR ILOC,OFFSET NEW10HH
	MOV	AX,0920H;Put space over initial spurious cursor
	MOV	BX,7
	MOV	CX,1
	INT	10H
	
	XOR	AX,AX;(ax=0)now update rom bios video data areas
	MOV	DS,AX
	
	ASSUME DS:BIOSSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	MOV	BYTE PTR CRTMODE,0FEH
	MOV	BYTE PTR COLDIS,5AH
	MOV	WORD PTR BYPERPAG,8000H
	MOV	WORD PTR OFSTAPAG,0	;Number of lines to move
	MOV	WORD PTR BCURS0,0
	MOV	WORD PTR BCURS1,0
	MOV	BYTE PTR ACTPAG,0
	MOV	AL,BYTE PTR CS:TOTAL_ROWS
	DEC	AL
	MOV	ROWSONSCRN,AL
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	
	JMP	HNULL	;Jump to popgroup b and iret

;----------------------------------------------------------------------------
;Herc_dispatch is a transfer table, containing the addresses of the code for the
;various int 10h functions. (see the accompanying descriptions of the int 10h
;functions) offset of function 00h handler
HERC_DISPATCH	DW	HERC_CMODE	;ah=0h request to change mode
	DW	HSET_CURSOR		;ah=01h cx is cursor style to select
	DW	HPUT_CURSOR	;ah=2h
	DW	HGET_CURSOR;ah=3h
	DW	HNULL		;Light pen not supported	
	DW	HSET_PAGE	;5h
	DW	HSCROLL_UP	
	;ah=06h, al = # of lines to scroll up ( window blanked if al = 0 )
	DW	HSCROLL_DOWN
	;ah=07h, al= # of lines to scroll down ( window blanked if al = 0 )
	DW	HGET_ATTR		;ah=08h gets character at cursor
	DW	HPUT_CHAR ;Same as ah=09h
	;ah=09h/ah=0ah al=character to write, bh=page, bl=attribute,cx=rep factor
	DW	HPUT_CHAR
	;ah=0ah al=character to write, bh=page, bl=attribute,cx=rep factor
	DW	HNULL	; ah=0bh set small palette not implemented
	DW	HPUT_DOT;ah=0ch
	;ah=0ch cx=column number(0 to 719) dx=row number(0 to 347),al=color(0,1)
	DW	HGET_DOT
	;ah=0dh cx=column(0 to 719) dx=row(0 to 347) returns al=pixel(0 or 1)
	DW	HWRITE_CHAR;ah=0eh teletype mode
	DW	HGET_MODE;ah=0fh
	DW	HNULL			;ah=10h set large palette not implemented
	DW	HGET_ROWS	;ah=11h (see ah=20h)
	DW	HNULL		;ah=12h
	DW	HNULL ;ah=13h write string (at only) not yet implemented
	DW	HNULL			
	DW	HNULL			
	DW	HNULL			
	DW	HNULL			
	DW	HNULL			
	DW	HGET_SIZE;ah=19h	(see ah=21h)
	DW	SET_ROWS ;ah=1ah	(see ah=22h)
	DW	HNULL;ah=1bh
	DW	HNULL ;ah=1ch
	DW	HNULL ;ah=1dh
	DW	HNULL ;ah=1eh
	DW	HNULL ;ah=1fh
	DW	HGET_ROWS;ah=20h gets # of rows
;This also returns scan lines/character
	DW	HGET_SIZE ;ah=21h returns size of screen in pixels
;Returns # of pixel rows on screen in dx, pixel columns in cx
	DW	SET_ROWS ;ah=22h sets number of rows on screen, max is 43
	DW	HLMOVE ;ah=23h move to start of a line 
	DW	HLDRAW ;ah=24h draw a line on screen 
	DW	HNULL ;ah=25h draw a rectangle (proposed)
	DW	HNULL	;ah=26h move rectangle (proposed)
;----------------------------------------------------------------------------	
	
;----------------------------------------------------------------------------	
;Note to editor, these last two proposed functions, though not yet 
;implimented, would be very useful to graphics based programs, and I strongly
;recomend that you request that I impliment them.
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
NEW10HH:	;Location of handler for int 10h mode -2 functions
;Iloc points here when in mode -2 (254)
	PUSH	AX
	PUSH	DS
	PUSH	ES
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP;Pushgroup b
	PUSH	CS
	POP	DS
	PUSH	AX
	PUSH	ES
	XOR	AX,AX
	MOV	ES,AX
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:BIOSSEG
	MOV	AX,WORD PTR ES:BCURS0
	MOV	BYTE PTR HCURS_ROW0,AH
	MOV	BYTE PTR HCURS_COLMN0,AL
	MOV	AX,WORD PTR ES:BCURS1
	MOV	BYTE PTR HCURS_ROW1,AH
	MOV	BYTE PTR HCURS_COLMN1,AL
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	POP	ES
	POP	AX
	
	
	XCHG	AL,AH
	MOV	SI,AX
	XCHG	AL,AH
	AND	SI,0FFH
	CMP	SI,26H
	JBE	HOP5			;si = 2 * funct
	JMP	HNULL		
;	si = 2 * funct
HOP5:	ADD	SI,SI
	JMP	WORD PTR [SI+HERC_DISPATCH]	;Offset of function 00h handler

HNULL:	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	ES
	POP	DS
	POP	AX;Popgroup b
	IRET
;----------------------------------------------------------------------------
	

;----------------------------------------------------------------------------
;Code to to change mode 
HERC_CMODE:
	CMP	AL,0FEH
	JNZ	HOP3
	JMP	SETMHERC		
;change mode to Hercules routine. (note that setmHerc also used pushgroup b
;On the alternate entry to this code so that pushes will match pops)

HOP3:	MOV	WORD PTR ILOC,OFFSET IBM	;Point iloc to code for IBM modes
	MOV	AX,7
	INT	10H;change to IBM mode 7.
	POP	BP ;The rombios will set the mode for monocrome text and reprogram
	POP	DI ;The 6845 chip for text mode
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	ES
	POP	DS
	POP	AX;Popgroup b
	JMP	NEW10HI;Now while in IBM mode 7, go to previous change mode handler
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;Variables used by subroutine xor_hcurs
HPAGE	DB	0;Current active page (0 or 1)
	DB	0
HCURS_TYPE	DW	0607H
HCURS_ROW0	DB	0;	cursor row for page 0 
HCURS_ROW1	DB	0; cursor row for page 1
HCURS_COLMN0	DB	0; cursor column for page 0 
HCURS_COLMN1	DB	0; cursor column for page 1
HCURS_FLAG0	DB	0;	flag is 1 if cursor is not present (page 0)
HCURS_FLAG1	DB	1;	flag for page 1
;----------------------------------------------------------------------------
	
;----------------------------------------------------------------------------	
XOR_HCURS: ;	uses hcurs_type to xor cursor shape
;This routine is called with video page segment in es, and bx set
;To value of active page (0 or 1). uses ax,dx and si
;----------------------------------------------------------------------------
	MOV	AX,HCURS_TYPE
	CMP	AH,AL
	JG	HOP25			
	MOV	DL,[BX+HCURS_ROW0]	;Cursor row for page bx 
	INC	DL
	XOR	DH,DH
	MOV	AX,WORD PTR ROW_F1		;90*row_f2/4
	MUL	DX
	MOV	DL,[BX+HCURS_COLMN0]	;Cursor column for page bx 
	XOR	DH,DH
	ADD	AX,DX
	MOV	SI,AX
	MOV	AX,HCURS_TYPE
	MOV	DL,BYTE PTR ROW_F2		;Number of scan lines/character
LOOP27:	CMP	DL,AH
	JL	HOP25			
	CMP	DL,AL
	JG	HOP26
	XOR	BYTE PTR ES:[SI],0FFH
HOP26:	SUB	SI,2000H
	CMP	SI,0
	JG	OUTBBB
	ADD	SI,8000H
	SUB	SI,5AH
OUTBBB:	DEC	DL
	JG	LOOP27;This loop xors the cursor onto the screen 
HOP25:	RET
;----------------------------------------------------------------------------



;----------------------------------------------------------------------------
HSET_CURSOR:;	ah=01h cx is cursor style to select
	CMP	WORD PTR HCURS_TYPE,CX
	JNZ	HOP50
	JMP	HNULL;No change is needed so quit

HOP50:	CMP	BYTE PTR HCURS_FLAG0,1
;Flag is 1 if cursor is not present (page 0)
	JZ	HOP29
	MOV	AX,0B000H;If cursor is present, xor out old cursor
	MOV	ES,AX; and xor in new cursor, first for page 0
	XOR	BX,BX
	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
	XCHG	CX,HCURS_TYPE

	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
	XCHG	CX,HCURS_TYPE

HOP29:	CMP	BYTE PTR HCURS_FLAG1,1	;Flag for page 1
	JZ	HOP30
	MOV	AX,0B800H;Now do the same for page 1
	MOV	ES,AX
	MOV	BX,1
	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
	MOV	HCURS_TYPE,CX

	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
HOP30:	MOV	HCURS_TYPE,CX;Finally, save value of new cursor style
	JMP	HNULL			
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
HPUT_CURSOR:;ah=02h  sets the text cursor position of video page in bh
;dh=row, dl=column (0 to 89)
	XOR	BL,BL
	XCHG	BH,BL;Let bx=bh
	MOV	BP,0B000H
	CMP	BL,1
	JNZ	HOP23			;Set es to video page for xor_hcurs
	MOV	BP,0B800H
HOP23:	MOV	ES,BP;	set es to video page for xor_hcurs
	CMP	BYTE PTR [BX+HCURS_FLAG0],0
;Flag is 1 if cursor is not present 
	JNZ	HOP28
	PUSH	DX;If old cursor is still on screen,then remove it
	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
	POP	DX
HOP28:	MOV	CX,DX
	MOV	[BX+HCURS_ROW0],DH	;Cursor row for page bx 
	MOV	[BX+HCURS_COLMN0],DL	;Cursor column for page bx 
	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
	MOV	BYTE PTR [BX+HCURS_FLAG0],0;Flag is 1 if cursor is not present
	XOR	AX,AX
	MOV	DS,AX
	ADD	BX,BX
	MOV	[BX+450H],CX;Update rombios data cursor position area
	JMP	HNULL			
;----------------------------------------------------------------------------



;----------------------------------------------------------------------------
HGET_CURSOR:	MOV	BP,SP;ah=03h returns the cursor type in cl.
;Returns the row and column of cursor for page bh in dh and dl
	XOR	BL,BL
	XCHG	BH,BL
	MOV	DH,[BX+HCURS_ROW0]	;Cursor row for page bx 
	MOV	DL,[BX+HCURS_COLMN0]	;Cursor column for page bx 
	MOV	CX,HCURS_TYPE
	MOV	[BP+6],DX
	MOV	[BP+8],CX
	JMP	HNULL			
;----------------------------------------------------------------------------



;----------------------------------------------------------------------------
HSET_PAGE:;ah=05h,al=page, selects displayed video page
;User should be certain page is mapped into memory (see change mode instruction)
	MOV	HPAGE,AL;Update internal active page variable
	PUSH	AX
	ROR	AL,1
	OR	AL,0AH;Page # is bit 7,graphics on is bit 1,screen on is bit 3
	MOV	DX,CONTROL
	OUT	DX,AL;change hardware page instruction
	XOR	AX,AX
	MOV	DS,AX
	
	ASSUME DS:BIOSSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	POP	AX
	MOV	ACTPAG,AL;Update rombios active page variable
	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	
	JMP	HNULL
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;Here are the variables used by the scroll up and scroll down routines
LINES	DW	0;	al saved here 
STARTROW	DW	0;	ch saved here
STARTCOL	DW	0;	cl saved here
ENDROW	DW	0;	dh saved here
ENDCOL	DW	0;	dl saved here
SROW_OFF	DW	0;To hold relative offset into video buffer for starting row
EROW_OFF	DW	0;To hold relative offset into video buffer for ending row
DELROW_OFF	DW	0
LISH	DW	0;This is to hold the number of scan lines to scroll
ATTRIB	DB	0;	0 or 255 for blank or solid fill pattern
GSOFF		DW	0;	to be start of window top row in get_char buffer
GEOFF		DW	0;	to be start of window end row in get_char buffer
REP_COUNT	DW	0;Rep count for block moves
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;Called by both scroll up and scroll down routines to save above variables
SCROLLINIT:;Computes lish,erow_off,srow_off,gsoff,geoff
	CLD
	MOV	BYTE PTR LINES,AL
	MOV	BYTE PTR ATTRIB,0	;0 or 255 for blank or solid fill pattern
	MOV	AL,7
	AND	AL,BH
	JNZ	HOP46
	MOV	AL,70H
	AND	AL,BH
	JZ	HOP46
	MOV	BYTE PTR ATTRIB,0FFH	;Code for solid fill pattern
	
HOP46:	MOV	BYTE PTR STARTROW,CH	;ch saved here
	MOV	BYTE PTR STARTCOL,CL		;Cl saved here
	MOV	BYTE PTR ENDCOL,DL		;dl saved here	
	MOV	BYTE PTR ENDROW,DH		;dh saved here	
	CMP	HPAGE,0
	JNE	HOP122
	MOV	AL,90
	MUL	CH
	XOR	BH,BH
	MOV	BL,CL
	ADD	AX,BX
	CMP	AX,SEEN_BYTES
	JB	HOP120
	MOV	AX,SEEN_BYTES
	SUB	AX,90
	ADD	AX,BX
HOP120:	ADD	AX,OFFSET LAST_BYTE
	MOV	GSOFF,AX;	to be start of window top row in get_char buffer
	MOV	AL,90
	MUL	DH
	ADD	AX,BX;bx still contains relative offset into row
	CMP	AX,SEEN_BYTES
	JB	HOP121
	MOV	AX,SEEN_BYTES
	SUB	AX,90
	ADD	AX,BX
HOP121:	ADD	AX,OFFSET LAST_BYTE
	MOV	GEOFF,AX;	to be start of window end row in get_char buffer
HOP122:	MOV	CX,ENDCOL
	SUB	CX,STARTCOL
	INC	CX;Prepare rep count for block move
	MOV	REP_COUNT,CX
	
	MOV	AX,WORD PTR ROW_F1		;90*row_f2/4
	MUL	WORD PTR STARTROW
	MOV	SROW_OFF,AX;Relative offset into video buffer for starting row

	MOV	AX,WORD PTR ROW_F1		;90*row_f2/4
	MUL	WORD PTR ENDROW	;dh saved here
	MOV	EROW_OFF,AX;Relative offset into video buffer for ending row

	MOV	AX,ENDROW
	SUB	AX,STARTROW
	SUB	AX,LINES
	JB	HOP133;Is entire window to be scrolled away?
	
	CMP	BYTE PTR LINES,0	;al saved here
	JNZ	HOP7
HOP133:	MOV	AX,ENDROW		;dh saved here
	SUB	AX,STARTROW		;ch saved here
	INC	AX
	MOV	LINES,AX		;al saved here,if al was zero,make lines to scroll
;Just larger than window size
HOP7:	MOV	AX,ENDROW		;dh saved here
	SUB	AX,STARTROW		;ch saved here
	SUB	AX,LINES		;al saved here
	INC	AX
	MUL	WORD PTR ROW_F2		;Number of scan lines/character
	MOV	LISH,AX;	number of scan lines to move
	MOV   BX,WORD PTR HPAGE

	CMP	BYTE PTR [BX+HCURS_FLAG0],1	
;Flag is 1 if cursor is not present (page 0)
	JZ	HOP31
	CALL	SETESVID		;Uses cx, sets es to active video page
	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
	MOV	BYTE PTR [BX+HCURS_FLAG0],1;Remove cursor before scrolling
HOP31:	RET
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;This short routine is used by hscroll_up during update of get_char buffer
CLEGW:	ADD	DI,5AH;Clears remaining area of window, requires di,cx set
	PUSH	DS
	POP	ES;Set es for upcoming block move
	CMP	DI,GEOFF
	JA	HOP138
	MOV	AX,20H;' '
	PUSH	DI
	PUSH	CX
	REPZ	STOSB
	POP	CX
	POP	DI
	JMP	SHORT CLEGW
HOP138:	RET
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;	ah=06h, al = # of lines to scroll up ( window blanked if al = 0 )
;ch = starting text row ,dh = ending text row
;Cl = starting text column, dl = ending text column
;If bh has bits 0,1,and 2 clear and bits 4,5, or 6 set, then an
;Inverse video (solid) space is used for new blank lines
;----------------------------------------------------------------------------
HSCROLL_UP:
	CALL	SCROLLINIT		;Computes lish,erow_off,srow_off
	MOV	BX,STARTROW		;ch saved here
	ADD	BX,LINES		;bx is now at first row to scroll up
	MOV	AX,WORD PTR ROW_F1		;90*row_f2/4
	MUL	BX
	MOV	DELROW_OFF,AX

	CMP	EROW_OFF,AX

	JGE	HOP8
	MOV	DI,GSOFF
	SUB	DI,5AH;90
	MOV	CX,REP_COUNT
	CALL	CLEGW;Scroll away window in get_char buffer
	MOV	AX,SROW_OFF;Prepare to scroll away entire screen
	ADD	AX,STARTCOL		;Cl saved here
	MOV	DI,AX;Offset into page of destination byte of move
	CALL	SETESDSVID		;Uses cx, sets es and ds to active video page
	MOV	CX,CS:REP_COUNT
	JMP	ATIP

HOP8:	
	CMP	HPAGE,0
	PUSH	DS
	POP	ES;Set es for upcoming block move
	JNE	HOP108
	MOV	CH,BYTE PTR STARTROW
	ADD	CH,BYTE PTR LINES
	MOV	AL,90
	MUL	CH
	MOV	BX,STARTCOL
	ADD	AX,BX
	CMP	AX,SEEN_BYTES
	JB	HOP126
	MOV	AX,SEEN_BYTES
	SUB	AX,90
	ADD	AX,BX
HOP126:	ADD	AX,OFFSET LAST_BYTE
	MOV	SI,AX;si is at start of row to first move in get_char buffer
	MOV	DI,GSOFF
	MOV	CX,REP_COUNT
HOP129:	PUSH	SI
	PUSH	DI
	PUSH	CX
	REPZ	MOVSB
	POP	CX
	POP	DI
	POP	SI
	CMP	SI,GEOFF
	JAE	HOP128
	ADD	SI,5AH;90
	ADD	DI,5AH;90
	JMP	SHORT HOP129
HOP128:	CALL	CLEGW;Clears remaining area of window, requires di,cx set
HOP108:
	MOV	AX,DELROW_OFF
	ADD	AX,STARTCOL		;Cl saved here
	MOV	SI,AX;Offset into page of source byte to move
	MOV	AX,SROW_OFF
	ADD	AX,STARTCOL		;Cl saved here
	MOV	DI,AX
	CALL	SETESDSVID		;Uses cx, sets es and ds to active video page
	MOV	CX,CS:REP_COUNT
	MOV	DX,CS:LISH
TIP:	PUSH	SI
	PUSH	DI
	PUSH	CX
	REPZ	MOVSB
	POP	CX
	POP	DI
	POP	SI
	ADD	SI,2000H
	CMP	SI,8000H
	JB	OUTBA
	SUB	SI,7FA6H;Increase si and di to point to next pair of scan lines
;For transfer
OUTBA:	ADD	DI,2000H
	CMP	DI,8000H
	JB	OUTBC
	SUB	DI,7FA6H;This number comes from the formula for the Hercules
OUTBC:	DEC	DX;Bit map
	JNZ	TIP
ATIP:	MOV	AX,CS:LINES		;al saved here
	MOV	BX,WORD PTR CS:ROW_F2		;Number of scan lines/character
	MUL	BX
	MOV	DX,AX
TIIP:	PUSH	DI
	PUSH	CX
	MOV	AL,CS:ATTRIB		;0 or 255 for blank or solid fill pattern
	REPZ	STOSB;This is the code to fill in newly created blank lines
	POP	CX
	POP	DI
	ADD	DI,2000H
	CMP	DI,8000H
	JB	OUTBE
	SUB	DI,7FA6H
OUTBE:	DEC	DX
	JNZ	TIIP
	JMP	HNULL			
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
SETESDSVID:;	uses cx, sets es and ds to active video page
	MOV	CX,0B000H
	CMP	BYTE PTR HPAGE,1
	JNZ	HOP48
	MOV	CX,0B800H
HOP48:	MOV	ES,CX
	MOV	DS,CX
	RET
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
SETESVID:;	uses cx, sets es to active video page
	MOV	CX,0B000H
	CMP	BYTE PTR HPAGE,1
	JNZ	HOP16
	MOV	CX,0B800H
HOP16:	MOV	ES,CX
	RET
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;This short routine is used by hscroll_down during update of get_char buffer
CLEDGW:	SUB	DI,5AH;Clears remaining area of window, requires di,cx set
	PUSH	DS
	POP	ES;Set es for upcoming block move
	CMP	DI,GSOFF
	JB	HOP178
	CMP	DI,08000H
	JAE	HOP178
	MOV	AX,20H;' '
	PUSH	DI
	PUSH	CX
	REPZ	STOSB
	POP	CX
	POP	DI
	JMP	SHORT CLEDGW
HOP178:	RET
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;	ah=07h, al= # of lines to scroll down ( window blanked if al = 0 )
;ch = starting text row,dh = ending text row
;Cl = starting text column.dl = ending text column
;The code here is analagous to the code to scroll up
;----------------------------------------------------------------------------
HSCROLL_DOWN:
	CALL	SCROLLINIT		;Sets lish,erow_off,srow_off
	MOV	BX,ENDROW		;dh saved here
	SUB	BX,LINES		;al saved here
	INC	BX
	MOV	AX,WORD PTR ROW_F1		;90*row_f2/4
	MUL	BX;ax now holds offset of scan line just below first line to scroll
	ADD	AX,6000H;Its scan line # is divisible by 4
	SUB	AX,5AH;90
	MOV	DELROW_OFF,AX;Thus delrow_off becomes the offset of the first
;Scan line to move

	MOV	AX,ENDROW
	SUB	AX,STARTROW
	SUB	AX,LINES
	JAE	HOP33;Is entire window to be scrolled away?
	MOV	DI,GEOFF
	ADD	DI,5AH;90
	MOV	CX,REP_COUNT
	CALL	CLEDGW;Scroll away window in get_char buffer
	MOV	AX,EROW_OFF;Then blank the whole window
	ADD	AX,6000H
	SUB	AX,5AH
	ADD	AX,WORD PTR ROW_F1
	ADD	AX,STARTCOL		;Cl saved here
	MOV	DI,AX;di for nullline
	CALL	SETESDSVID		;Uses cx, sets es and ds to active video page
	MOV	CX,CS:REP_COUNT
	JMP	ATIP2

HOP33:
	CMP	HPAGE,0
	PUSH	DS
	POP	ES;Set es for upcoming block move
	JNE	HOP148
	MOV	CH,BYTE PTR ENDROW
	SUB	CH,BYTE PTR LINES
	MOV	AL,90
	MUL	CH
	MOV	BX,STARTCOL
	ADD	AX,BX
	CMP	AX,SEEN_BYTES
	JB	HOP166
	MOV	AX,SEEN_BYTES
	SUB	AX,90
	ADD	AX,BX
HOP166:	ADD	AX,OFFSET LAST_BYTE
	MOV	SI,AX;si is at start of row to first move in get_char buffer
	MOV	DI,GEOFF
	MOV	CX,REP_COUNT
HOP169:	PUSH	SI
	PUSH	DI
	PUSH	CX
	REPZ	MOVSB
	POP	CX
	POP	DI
	POP	SI
	CMP	SI,GSOFF
	JBE	HOP168
	SUB	SI,5AH;90
	SUB	DI,5AH;90
	JMP	SHORT HOP169
HOP168:	CALL	CLEDGW;Clears remaining area of window, requires di,cx set

HOP148:	MOV	AX,DELROW_OFF
	ADD	AX,STARTCOL		;Cl saved here
	MOV	SI,AX;si is offset of start of sting of bytes to move
	MOV	AX,EROW_OFF
	ADD	AX,6000H
	SUB	AX,5AH
	ADD	AX,WORD PTR ROW_F1
	ADD	AX,STARTCOL		;Cl saved here
	MOV	DI,AX;di now points to destination of first string to move
	CALL	SETESDSVID		;Uses cx, sets es and ds to active video page
	MOV	CX,CS:REP_COUNT
	MOV	DX,CS:LISH;Scan lines to move
TIP2:	PUSH	SI
	PUSH	DI
	PUSH	CX
	REPZ	MOVSB
	POP	CX
	POP	DI
	POP	SI
	SUB	SI,2000H
	CMP	SI,0
	JGE	OUTBF
	ADD	SI,8000H
	SUB	SI,5AH
OUTBF:	SUB	DI,2000H
	CMP	DI,0
	JGE	OUTBG
	ADD	DI,7FA6H
OUTBG:	DEC	DX
	JNZ	TIP2
	
ATIP2:	MOV	AX,CS:LINES		;al saved here
	MUL	WORD PTR CS:ROW_F2		;Number of scan lines/character
	MOV	DX,AX;Lines to null
TIIP2:	PUSH	DI
	PUSH	CX
	MOV	AL,CS:ATTRIB		;0 or 255 for blank or solid fill pattern
	REPZ	STOSB
	POP	CX
	POP	DI
	SUB	DI,2000H
	CMP	DI,0
	
	JGE	OUTBH
	ADD	DI,7FA6H
OUTBH:	DEC	DX
	JNZ	TIIP2
	JMP	HNULL
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;	ah=08h returns attribute in ah, character return in al
;No space has been reserved to save 
;an attribute, uses an algorithm to get the attribute by examining the pixels
;on the screen.
;----------------------------------------------------------------------------
HGET_ATTR:
	CMP	BH,0
	JZ	HOP346
	JMP	SPACE
HOP346:	MOV	AL,5AH;90
	MUL	BYTE PTR HCURS_ROW0	;Cursor row for page 0 ,ax=90*row
	MOV	BL,HCURS_COLMN0		;Cursor column for page 0 
	ADD	AX,BX;ax=offset into get character buffer of desired character
	CMP	AX,WORD PTR SEEN_BYTES	;Total bytes covered by get_char buffer
	JNB	SPACE;If beyond allotted buffer space, return space character
	;start of algorithm to get atribute from pixels on the screen
	ADD	AX,OFFSET LAST_BYTE
	MOV	BP,SP
	MOV	BX,AX
	MOV	AL,[BX]
	MOV	[BP+10H],AL
	
	MOV	CX,0B000H
	MOV	ES,CX
	MOV	CL,HCURS_ROW0	;Cursor row
	INC	CL
	XOR	CH,CH
	MOV	AX,WORD PTR ROW_F1		;90*row_f2/4
	MUL	CX
	MOV	CL,HCURS_COLMN0	;Cursor column
	XOR	CH,CH
	ADD	AX,CX
	MOV	BX,AX
	;Byte ptr row_f2 is number of scan lines/character
	ADD	BX,6000H;
	SUB	BX,5AH;90  bx holds offset of byte below cursor(top of lower char)
	MOV	BH,ES:[BX];Save
	MOV	CL,HCURS_ROW0	;Cursor row
	XOR	CH,CH
	MOV	AX,WORD PTR ROW_F1		;90*row_f2/4
	MUL	CX;Destroys dx
	MOV	DH,BH
	MOV	CL,HCURS_COLMN0	;Cursor column
	XOR	CH,CH
	ADD	AX,CX
	MOV	BX,AX;bx hold offset of byte at cursor (top of character)
	MOV	DL,ES:[BX];Save, dx contains word for algorithm
	MOV	CX,16
	XOR	AX,AX;Accumulator
	AND	DX,0C701H
HOP326:
	SHR	DX,1
	JNC	HOP327
	INC	AX
HOP327:
	LOOP	HOP326
	CMP	AX,3
	JG	HOP328
	
	MOV	BYTE PTR [BP+11H],7
	JMP	HNULL
HOP328:
	MOV	BYTE PTR [BP+11H],70H;
	JMP	HNULL

SPACE:	MOV	BP,SP
	MOV	WORD PTR [BP+10H],0720H
	JMP	HNULL
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;These are the variables used by hput_char
INDEX	DW	0;Contains page in use (0 or 1)
CHAR	DB	0;Contains character to write
	DB	0;always zero
ATTR	DB	0;Contains a coded version of the attribute to use
	DB	0
REPF	DW	0;cx is saved here (repartition factor)
BEEL	DB	0;bl is saved here
ZERO	DW	0;Contains the constant zero
SUBLIST	DW	ACK1,ACK3,ACK2,ACK4,ACK5,ACK6,ACK2,ACK4
;A transfer list of routines to place bytes
;On screen with possible pixel inversion and xoring
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;	ah=09h/ah=0ah al=character to write, bh=page, bl=attribute,cx=rep factor
HPUT_CHAR:
	CALL	HPUTCHAR
	JMP	HNULL
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
HPUTCHAR:
	PUSH	WORD PTR HPAGE;Save page (and cursor type indicator)
	MOV	HPAGE,BH;Temporarily use bh as page indicator
	MOV	CHAR,AL;Save char to write
	MOV	REPF,CX;Save rep factor
	CMP	BEEL,BL
	JZ	HOP49;If previous attribute is still in use, attr is not updated
	MOV	BEEL,BL
	MOV	BYTE PTR ATTR,0
	MOV	AL,7
	AND	AL,BL
	JNZ	HOP47
	MOV	AL,70H
	AND	AL,BL
	JZ	HOP47
	OR	BYTE PTR ATTR,2;Code for inverse video
HOP47:	TEST	BL,80H
	JZ	HOP49
	OR	BYTE PTR ATTR,4;Code for xoring
HOP49:	TEST BL,8;Bold/or attribute
	JZ	HOP345
	OR	BYTE PTR ATTR,8;Code for oring
HOP345:	XOR	BL,BL
	XCHG	BL,BH;bx=bh
	MOV	INDEX,BX;Save page indicator
	CMP	BYTE PTR HPAGE,0
	JNZ	HOP99			
	TEST	BYTE PTR ATTR,4
	JNZ	HOP99		;If not page 0 don't upadte get_char buffer
	MOV	AL,HCURS_ROW0;Cursor row for page 0
	CMP	AL,BYTE PTR SEEN_ROWS
;Rows covered by space allocated to get_char buffer
	JGE	HOP99;Don't update beyond allocated get_char buffer (very important)
	MOV	AL,5AH;90, prepare to update get_char buffer
	MUL	BYTE PTR HCURS_ROW0	;Cursor row for page 0
	XOR	CH,CH
	MOV	CL,HCURS_COLMN0;Cursor column for page 0 
	ADD	CX,AX
	MOV	DI,OFFSET LAST_BYTE
	ADD	DI,CX
	MOV	AL,CHAR
	MOV	CX,REPF
	PUSH	CS
	POP	ES
	CLD
	REPZ	STOSB;Updates get_char buffer
HOP99:	CALL	SETESVID		;Uses cx, sets es to active video page
	CMP	BYTE PTR [BX+HCURS_FLAG0],1	
;Flag is 1 if cursor is not present (page 0)
	JZ	LOOP3;----putting a character on screen removes the cursor----
	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
	MOV	BYTE PTR [BX+HCURS_FLAG0],1	
;Flag is 1 if cursor is not present (page 0)
LOOP3:	MOV	SI,INDEX
	MOV	BL,[SI+HCURS_ROW0]	;Cursor row for page si 
	XOR	BH,BH
	CMP	WORD PTR REPF,0
	JNZ	HOP44;When rep factor has been decrimented to 0, quit
	JMP	OUT3

HOP44:	DEC	WORD PTR REPF
	MOV	AX,WORD PTR ROW_F1		;90*row_f2/4
	MUL	BX
	MOV	BL,[SI+HCURS_COLMN0]	;Cursor column for page si 
	XOR	BH,BH
	ADD	BX,REPF
	ADD	BX,AX
	MOV	CL,[SI+HCURS_COLMN0]	;Cursor column for page si 
	MOV	DI,WORD PTR ATTR
	ADD	DI,OFFSET SUBLIST
	MOV	SI,WORD PTR CHAR

	MOV	CL,3
	SHL	SI,CL
	MOV	CX,0
	PUSH	DS
	MOV	DS,CX
	
	ASSUME DS:BIOSSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	CMP	SI,400H
	JB	HOP62		
	SUB	SI,400H
	ADD	SI,GRAF0;Graphics char 8x8 pixel map address
	MOV	CX,GRAF1
	JMP	SHORT	HOP63
HOP62:	ADD	SI,ASCII0	;Ascii char 8x8 pixel map address
	MOV	CX,ASCII1
HOP63:	MOV	DS,CX
	CMP	BYTE PTR CS:TOTAL_ROWS,1DH;29
	JG	HOP67
	CMP	BYTE PTR CS:CHAR,0B0H
	JB	HOP67
	CMP	BYTE PTR CS:CHAR,0DFH
	JA	HOP67
	CALL	WORD PTR CS:[DI];Extend graphics pixel map into a 12x8 pixel map
	ADD	BX,2000H;si points to offset of byte containing pixels to update
	CMP	BX,8000H
	JB	HOP71
	SUB	BX,8000H
	ADD	BX,5AH
	
HOP71:	INC	SI
	CALL	WORD PTR CS:[DI]
	ADD	BX,2000H
	CMP	BX,8000H
	JB	HOP77
	SUB	BX,8000H
	ADD	BX,5AH
	
HOP77:	DEC	SI

HOP67:	MOV	CX,8
BACK0:	CALL	WORD PTR CS:[DI]
	ADD	BX,2000H
	CMP	BX,8000H
	JB	HOP11
	SUB	BX,8000H
	ADD	BX,5AH
	
HOP11:	INC	SI
	LOOP	BACK0;This loop draws the main portion of the character on screen
	CMP	BYTE PTR CS:TOTAL_ROWS,1DH
	JG	HOP69
	CMP	BYTE PTR CS:CHAR,0B0H
	JB	HOP200
	CMP	BYTE PTR CS:CHAR,0DFH
	JA	HOP200
	DEC	SI
	DEC	SI
	CALL	WORD PTR CS:[DI]
	ADD	BX,2000H
	CMP	BX,8000H
	JB	HOP73
	SUB	BX,8000H
	ADD	BX,5AH

HOP73:	INC	SI
	CALL	WORD PTR CS:[DI]
	ADD	BX,2000H
	CMP	BX,8000H
	JB	HOP69
	SUB	BX,8000H
	ADD	BX,5AH
	JMP	SHORT HOP69
HOP200:PUSH	DS
	PUSH	CS
	POP	DS
	MOV	SI,OFFSET ZERO
	MOV	CX,4
BACK1:	CALL	WORD PTR CS:[DI]
	ADD	BX,2000H
	CMP	BX,8000H
	JB	HOP311
	SUB	BX,8000H
	ADD	BX,5AH
HOP311:
	LOOP	BACK1;This loop draws the bottom portion of the character on screen
	POP	DS
HOP69:	POP	DS

	ASSUME DS:CSEG, SS:CSEG ,CS:CSEG ,ES:CSEG
	JMP	LOOP3

OUT3:	POP	WORD PTR HPAGE

	RET
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;Subroutines called from above:
;	regular placement
ACK1:	MOV	AH,[SI]
	MOV	ES:[BX],AH
	RET

;	xor placement
ACK2:	MOV	AH,[SI]
	XOR	ES:[BX],AH
	RET

;	inverse video
ACK3:	MOV	AH,[SI]
	NOT	AH
	MOV	ES:[BX],AH
	RET

;	xor inverse video
ACK4:	MOV	AH,[SI]
	NOT	AH
	XOR	ES:[BX],AH
	RET

;	or
ACK5:	MOV	AH,[SI]
	OR	ES:[BX],AH
	RET
	
;	or inverse
ACK6:	MOV	AH,[SI]
	NOT	AH
	OR	ES:[BX],AH
	RET
;----------------------------------------------------------------------------
	
	
;----------------------------------------------------------------------------
;Variables used by put dot routines
COLOR	DB	0;Contains color of dot to put on screen (0 or 1)
XORFL	DB	0
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
DOTCORE:;A short routine used to compute the offset and mask of pixel coords
	PUSH	CX;Save x coord
	PUSH	DX;Save y coord
	MOV	CL,2;Video interleave factor
	SHR	DX,CL
	MOV	AX,5AH;90 bytes per line
	MUL	DX;ax contains product
	POP	DX;Get y coord
	AND	DX,3;dx=dx mod 2^(interleave factor)
	MOV	CL,3
	ROR	DX,CL;dx=dx*02000h
	ADD	AX,DX
	POP	BX;Get x coord
	PUSH	BX;Save x coord
	SHR	BX,CL;Int(x/8)
	ADD	BX,AX;bx now contains offset into buffer of byte containing dot
	POP	CX;Get x coord
	AND	CX,7;X mod pixels/byte
	RET
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;	ah=0ch cx=column number(0 to 719) dx=row number(0 to 347),al=color(0,1)
HPUT_DOT:
	MOV	XORFL,AL;Bit 7 set if pixel to be xor'ed
	AND	AL,7FH
	ROR	AL,1
	MOV	COLOR,AL
	AND	BYTE PTR XORFL,80H
	
	CALL DOTCORE
	
	MOV	AL,COLOR
	MOV	AH,7FH
	ROR	AL,CL
	ROR	AH,CL
	CALL	SETESVID		;Uses cx, sets es to active video page
	CMP	BYTE PTR XORFL,80H
	JZ	HOP90
	AND	ES:[BX],AH
	OR	ES:[BX],AL
	JMP	HNULL			

HOP90:	XOR	ES:[BX],AL
	JMP	HNULL			
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;	ah=0dh cx=column(0 to 719) dx=row(0 to 347) returns al=pixel(0 or 1)
HGET_DOT:;Code analogous to put_dot
	
	CALL DOTCORE
	
	MOV	AL,80H
	ROR	AL,CL
	PUSH	CX
	CALL	SETESVID		;Uses cx, sets es to active video page
	POP	CX
	AND	AL,ES:[BX]
	INC	CL
	ROL	AL,CL
	MOV	BP,SP
	MOV	[BP+10H],AL
	JMP	HNULL			
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
INDEX2	DW	0;Used to save referenced page (0 or 1)
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;a short subroutine called from just below in function ah=0eh
INESCU:	MOV	BX,INDEX2;	sets index2 ,es, and removes cursor
	MOV	AX,0B000H
	CMP	BL,1
	JNZ	HOP38			;Set es to video page
	MOV	AX,0B800H
;	set es to video page
HOP38:	MOV	ES,AX
	CMP	BYTE PTR [BX+HCURS_FLAG0],1	
;Flag is 1 if cursor is not present (page 0)
	JZ	HOP37
	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
	MOV	BYTE PTR [BX+HCURS_FLAG0],1	
;Flag is 1 if cursor is not present (page 0)
HOP37:	RET
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
HWRITE_CHAR:;ah=0eh, al=char to write, bh = page, bl = atribute
;Writes character in teletype mode
	PUSH	BX
	XOR	BL,BL
	XCHG	BH,BL
	MOV	INDEX2,BX
	POP	BX
	CMP	AL,7
	JNZ	HOP84	
	MOV	DX,28H
	IN	AL,61H
	AND	AL,0FEH
NCC:	OR	AL,2;	turn on speaker
	OUT	61H,AL
	MOV	CX,01F4H
CYC:	LOOP	CYC			;Small delay
	AND	AL,0FDH
	OUT	61H,AL
	MOV	CX,05DCH
YCY:	LOOP	YCY
	DEC	DX
	JNZ	NCC			;Turn on speaker
	JMP	HNULL			

HOP84:	CMP	AL,0AH;	linefeed
	JNZ	HOP19			;Delelte/backspace
	CALL	INESCU			;Sets index2 , es and removes cursor
	JMP	SHORT	HOP6		;Linefeed handler

HOP19:	CMP	AL,8;	delelte/backspace
	JNZ	HOP35			;Carriage return
	CALL	INESCU			;Sets index2 , es and removes cursor
	CMP	BYTE PTR [BX+HCURS_COLMN0],0	;Cursor column for page bx 
	JZ	OUT4
	DEC	BYTE PTR [BX+HCURS_COLMN0]	;Cursor column for page bx 
	JMP	SHORT	OUT4

HOP35:	CMP	AL,0DH;	carriage return
	JNZ	HOP18
	CALL	INESCU			;Sets index2 , es and removes cursor
	MOV	BYTE PTR [BX+HCURS_COLMN0],0	;Cursor column for page bx 
	JMP	SHORT	OUT4

HOP18:	MOV	CX,1
	CALL	HPUTCHAR
	PUSH	CS
	POP	DS
	MOV	BX,INDEX2
	INC	BYTE PTR [BX+HCURS_COLMN0]	;Cursor column for page bx
	CMP	BYTE PTR [BX+HCURS_COLMN0],5AH		;Cursor column for page bx
	JNB	HOP15
	JMP	SHORT	OUT4
HOP15:	MOV	BYTE PTR [BX+HCURS_COLMN0],0	;Cursor column for page bx
;	linefeed handler
HOP6:	INC	BYTE PTR [BX+HCURS_ROW0]	;Cursor row for page bx
	MOV	CL,BYTE PTR TOTAL_ROWS
	CMP	[BX+HCURS_ROW0],CL	;Cursor row for page bx
	JNB	HOP17
	JMP	SHORT	OUT4

HOP17:
	PUSH	BX
	MOV	CH,[BX+HCURS_ROW0]	;Cursor row for page bx 
	MOV	CL,[BX+HCURS_COLMN0]	;Cursor column for page bx 
	XOR	AX,AX
	MOV	DS,AX
	ADD	BX,BX
	MOV	[BX+450H],CX
	MOV	AX,0601H
	MOV	BH,1
	XOR	CX,CX
	MOV	DH,BYTE PTR CS:TOTAL_ROWS
	DEC	DH
	MOV	DL,59H
	INT	10H
	POP	BX
	DEC	BYTE PTR CS:[BX+HCURS_ROW0]	;Cursor row for page bx 
OUT4:	PUSH	CS
	POP	DS
	MOV	CH,[BX+HCURS_ROW0]	;Cursor row for page bx 
	MOV	CL,[BX+HCURS_COLMN0]	;Cursor column for page bx 
	CALL	XOR_HCURS		;Uses hcurs_type to xor cursor shape
	MOV	BYTE PTR [BX+HCURS_FLAG0],0
;Flag is 1 if cursor is not present (page 0)
	XOR	AX,AX
	MOV	DS,AX
	ADD	BX,BX
	MOV	[BX+450H],CX
	JMP	HNULL			
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
HMODE	DB	0FEH;	-2
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
HGET_MODE:;ah=0fh
	MOV	BH,CS:HPAGE
	MOV	BP,SP
	MOV	BYTE PTR [BP+11H],5AH	
	MOV	AL,HMODE		;-2
	MOV	[BP+10H],AL;Default is -2, mode number returned in al
	MOV	[BP+0BH],BH;Active page returned in bh
	JMP	HNULL			
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
HGET_ROWS:;ah=11h returns #rows on screen in dl, #scanlines/char in cx
	MOV	DL,BYTE PTR TOTAL_ROWS
	MOV	CX,WORD PTR ROW_F2		;Number of scan lines/character
	MOV	BP,SP
	MOV	[BP+10H],AL
	MOV	[BP+8],CX
	JMP	HNULL			
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;	ah=19h returns # of pixel rows on screen in dx, pixel columns in cx
HGET_SIZE:
	MOV	BP,SP
	MOV	WORD PTR [BP+8],OFFSET HPAGE
	MOV	WORD PTR [BP+6],OFFSET HOP1
	JMP	HNULL
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
SEEN_ROWS	DW	0H;	rows covered by space allocated to get_char buffer
SEEN_BYTES	DW 0H;	total bytes covered by get_char buffer
TOTAL_ROWS	DB	1DH;29
ROW_F1	DW 010EH;270;	90*row_f2/4
ROW_F2	DB 0CH;	number of scan lines/character
	DB	0
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
SET_ROWS:;ah=1a sets number of rows on screen to al,default is 29
	MOV	TOTAL_ROWS,AL

	XOR	BX,BX
	MOV	ES,BX
	MOV	BL,AL
	DEC	BL
	MOV	ES:[484H],BL
	CMP	AL,1DH
	JG	HOP94			;43 line mode
	MOV	WORD PTR ROW_F1,010EH	;90*row_f2/4
	MOV	BYTE PTR ROW_F2,0CH	;Number of scan lines/character
	JMP	HNULL			

;	43 line mode
HOP94:	MOV	WORD PTR ROW_F1,0B4H	;90*row_f2/4
	MOV	BYTE PTR ROW_F2,8	;Number of scan lines/character
	JMP	HNULL			
;----------------------------------------------------------------------------
	
	
;----------------------------------------------------------------------------
;Variables used bu line drawing routines
LCOLOR	DB	0;Contains color of line (0 or 1,funny effects if larger)
LXORFL	DB	0;Set to 1 if xoring chosen
ROWOFF	DW	0;Offset of row containing pixel in video buffer
COLBYTE	DW	0;Offset into row of byte containing pixel
MASK1		DB	0;Bit masks for bit in byte containing pixel
MASK2		DB	0
LASTX		DW	0;Contains x coord of start of line for next draw
LASTY		DW	0;Contains y coord of start of line for next draw
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;	ah=23h cx=column number(0 to 719) dx=row number(0 to 347),al=color(0,1)
HLMOVE:	;	sets location,color and xorflag for line draw
	MOV	LXORFL,AL;Bit 7 set in al if pixel to be xor'ed
	AND	AL,7FH
	ROR	AL,1
	MOV	LCOLOR,AL;Bit 7 in lcolor is set if color is green, cleared if black
	AND	BYTE PTR LXORFL,80H
	
	MOV	LASTX,CX
	MOV	LASTY,DX
	MOV	CL,2;Video interleave factor
	SHR	DX,CL
	MOV	AX,5AH;90 bytes per line
	MUL	DX;ax contains product
	MOV	DX,LASTY
	AND	DX,3;dx=dx mod 2^(interleave factor)
	MOV	CL,3
	ROR	DX,CL;dx=dx*02000h
	ADD	AX,DX
	MOV	ROWOFF,AX;Offset to start of row

	MOV	BX,LASTX
	SHR	BX,CL;Int(x/8)
	MOV	COLBYTE,BX;Offset into row

	MOV	CX,LASTX
	AND	CX,7;X mod pixels/byte
	MOV	AH,LCOLOR;Dot mask
	MOV	AL,07FH;Anti dot mask
	ROR	AL,CL
	ROR	AH,CL
	MOV	WORD PTR MASK1,AX;Save masks to alter just selected bit in byte
	JMP	HNULL
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
HLDRAW:	;ah=24h implements line draw to specified pixel from last stopping
;	pixel, or from pixel set by move function.
;	cx=column number(0 to 719) dx=row number(0 to 347)
;	starting location,color and xorflag set with move function
	MOV	SI,CX;Save column coordinate in si
	MOV	DI,DX;Save row coordinate in di
	SUB	DX,LASTY
	LAHF	
	MOV	AL,AH; save flag outcome for y in al
	JGE	HOP325
	NEG	DX; dx=y
HOP325:	SUB	CX,LASTX
	LAHF	;Save flag outcome for x in ah
	JGE	HOP336
	NEG	CX;cx=x
HOP336:	MOV	LASTX,SI
	MOV	LASTY,DI;Udate lastx and lasty
	MOV	SI,1
	CMP	CX,DX
	JA	HOP337
	XCHG	CX,DX;cx is now larger than or equal to dx
	XOR	SI,SI;If si=1 then  x>y, if si=0 then  x<=y
HOP337:	MOV	BP,DX;cx=max(x,y),bp=min(x,y)
	MOV	DI,CX
	SUB	DI,DX;di=x-y  
	MOV	BX,ROWOFF;   bx,bp,cx and di are now set (ax holds flag states)
	CMP	LXORFL,80H;If xoring is not desired jump to nonxoring code
	JZ	HOP501
	JMP	HOP376
	
	
	
HOP501:	CMP	SI,0
	JNE	XLONG;If  x<=y then jump to code for this case
	JMP	YLONG
XLONG:	SAHF;Put true sign of x (sub cx,lastx) into flags
	JL	HOP378
	MOV	BYTE PTR XINCDEC1,0CEH;(incx)
	MOV	BYTE PTR XADCSBB1,0D6H;(incx)
	MOV	BYTE PTR XINCDEC2,0CEH
	MOV	BYTE PTR XADCSBB2,0D6H
	JMP	SHORT HOP380
HOP378:	MOV	BYTE PTR XINCDEC1,0C6H;(decx)
	MOV	BYTE PTR XADCSBB1,0DEH;(decx)
	MOV	BYTE PTR XINCDEC2,0C6H
	MOV	BYTE PTR XADCSBB2,0DEH
HOP380:	MOV	AH,AL
	SAHF;Put true sign of y (sub dx,lasty) into flags
	JL	HOP379
	MOV	BYTE PTR XADDSUB,0C3H;(incy)
	MOV	BYTE PTR XSUBADD,0EBH
	JMP	SHORT HOP381
HOP379:	MOV	BYTE PTR XADDSUB,0EBH;(decy)
	MOV	BYTE PTR XSUBADD,0C3H
	
HOP381:;	use ax, set es to active video page
	MOV	AX,0B000H
	CMP	BYTE PTR HPAGE,1
	JNZ	HOP416
	MOV	AX,0B800H
HOP416:	MOV	ES,AX
	MOV	AX,CX
	SHR	AX,1
	CMP	AX,BP
	PUSHF
	XOR	AX,AX
	MOV	SI,COLBYTE
	MOV	DX,WORD PTR MASK1;sp,ss,cs,ds,es,ax,bx,cx,dx,si,di & bp are now set.
	POPF
	JG	STRAIGHTA;When the longer axis is more than twice as long as
	;The shorter,go straight along the longer axis first
	
DIAGA:	;Xordraw diagonaly
		DB	0D0H
XINCDEC1	DB	0CEH;Ror dh,1 / rol dh,1
		DB	083H
XADCSBB1	DB	0D6H
		DB	0; adc si,0 / sbb si,0
		DB	081H
XADDSUB	DB	0C3H	;Add/sub	bx,02000h
		DW	02000H
	TEST	BX,08000H
	JZ	HOP401
		DB	081H
XSUBADD	DB	0EBH;Sub/add	bx,07fa6h;08000h-90
		DW	07FA6H
HOP401:	XOR	ES:[BX+SI],DH
	LOOP	HOP402
	JMP	OUT7
HOP402:	SUB	AX,DI;di=x-y
	JGE	DIAGA
STRAIGHTA:	;Xordraw straight
		DB	0D0H
XINCDEC2	DB	0CEH;Ror dh,1 / rol dh,1
		DB	083H
XADCSBB2	DB	0D6H
		DB	0; adc si,0 / sbb si,0
	XOR	ES:[BX+SI],DH
	LOOP	HOP403
	JMP	OUT7
HOP403:	ADD	AX,BP;bp=min(x,y)
	JG	DIAGA	
	JMP	SHORT STRAIGHTA


YLONG:	SAHF;Put true sign of x (sub cx,lastx) into flags
	JL	HOP478
	MOV	BYTE PTR YINCDEC,0CEH;(incx)
	MOV	BYTE PTR YADCSBB,0D6H;(incx)
	JMP	SHORT HOP480
HOP478:	MOV	BYTE PTR YINCDEC,0C6H;(decx)
	MOV	BYTE PTR YADCSBB,0DEH;(decx)
HOP480:	MOV	AH,AL
	SAHF;Put true sign of y (sub dx,lasty) into flags
	JL	HOP479
	MOV	BYTE PTR YADDSUB1,0C3H;(incy)
	MOV	BYTE PTR YSUBADD1,0EBH
	MOV	BYTE PTR YADDSUB2,0C3H
	MOV	BYTE PTR YSUBADD2,0EBH
	JMP	SHORT HOP481
HOP479:	MOV	BYTE PTR YADDSUB1,0EBH;(decy)
	MOV	BYTE PTR YSUBADD1,0C3H
	MOV	BYTE PTR YADDSUB2,0EBH
	MOV	BYTE PTR YSUBADD2,0C3H
HOP481:;	use ax, set es to active video page
	MOV	AX,0B000H
	CMP	BYTE PTR HPAGE,1
	JNZ	HOP417
	MOV	AX,0B800H
HOP417:	MOV	ES,AX
	MOV	AX,CX
	SHR	AX,1
	CMP	AX,BP
	PUSHF
	XOR	AX,AX
	MOV	SI,COLBYTE
	MOV	DX,WORD PTR MASK1;sp,ss,cs,ds,es,ax,bx,cx,dx,si,di & bp are now set.
	POPF
	JG	SHORT STRAIGHTB
	
DIAGB:	;Xordraw diagonaly
		DB	0D0H
YINCDEC	DB	0CEH;Ror dh,1 / rol dh,1
		DB	083H
YADCSBB	DB	0D6H
		DB	0; adc si,0 / sbb si,0
		DB	081H
YADDSUB1	DB	0C3H	;Add/sub	bx,02000h
		DW	02000H
	TEST	BX,08000H
	JZ	HOP405
		DB	081H
YSUBADD1	DB	0EBH;Sub/add	bx,07fa6h;08000h-90
		DW	07FA6H
HOP405:	XOR	ES:[BX+SI],DH
	LOOP	HOP404
	JMP	OUT7
HOP404:	SUB	AX,DI;di=x-y
	JG	DIAGB
STRAIGHTB:	;Xordraw straight
		DB	081H
YADDSUB2	DB	0C3H	;Add/sub	bx,02000h
		DW	02000H
	TEST	BX,08000H
	JZ	HOP409
		DB	081H
YSUBADD2	DB	0EBH;Sub/add	bx,07fa6h;08000h-90
		DW	07FA6H
HOP409:	XOR	ES:[BX+SI],DH
	LOOP	HOP408
	JMP	OUT7
HOP408:	ADD	AX,BP;bp=min(x,y)
	JG	DIAGB
	JMP	STRAIGHTB

HOP376:
	
HOP701:	CMP	SI,0
	JNE	XXLONG;If  x<=y then jump to code for this case
	JMP	YYLONG
XXLONG:	SAHF;Put true sign of x (sub cx,lastx) into flags
	JL	HOP578
	MOV	BYTE PTR XXINCDEC1,0CEH;(incx)
	MOV	BYTE PTR XLINCDEC1,0CAH
	MOV	BYTE PTR XXADCSBB1,0D6H;(incx)
	MOV	BYTE PTR XXINCDEC2,0CEH
	MOV	BYTE PTR XLINCDEC2,0CAH
	MOV	BYTE PTR XXADCSBB2,0D6H
	JMP	SHORT HOP580
HOP578:	MOV	BYTE PTR XXINCDEC1,0C6H;(decx)
	MOV	BYTE PTR XLINCDEC1,0C2H
	MOV	BYTE PTR XXADCSBB1,0DEH;(decx)
	MOV	BYTE PTR XXINCDEC2,0C6H
	MOV	BYTE PTR XLINCDEC2,0C2H
	MOV	BYTE PTR XXADCSBB2,0DEH
HOP580:	MOV	AH,AL
	SAHF;Put true sign of y (sub dx,lasty) into flags
	JL	HOP579
	MOV	BYTE PTR XXADDSUB,0C3H;(incy)
	MOV	BYTE PTR XXSUBADD,0EBH
	JMP	SHORT HOP581
HOP579:	MOV	BYTE PTR XXADDSUB,0EBH;(decy)
	MOV	BYTE PTR XXSUBADD,0C3H
	
HOP581:;	use ax, set es to active video page
	MOV	AX,0B000H
	CMP	BYTE PTR HPAGE,1
	JNZ	HOP616
	MOV	AX,0B800H
HOP616:	MOV	ES,AX
	MOV	AX,CX
	SHR	AX,1
	CMP	AX,BP
	PUSHF
	XOR	AX,AX
	MOV	SI,COLBYTE
	MOV	DX,WORD PTR MASK1;sp,ss,cs,ds,es,ax,bx,cx,dx,si,di & bp are now set.
	POPF
	JG	STRAIGHTC;When the longer axis is more than twice as long as
	;The shorter,go straight along the longer axis first
	
DIAGC:	;Draw diagonaly

		DB	0D0H
XXINCDEC1	DB	0CEH;Ror dh,1 / rol dh,1
		DB	0D0H
XLINCDEC1	DB	0CAH;Ror dl,1 / rol dl,1
	CMC
		DB	083H
XXADCSBB1	DB	0D6H
		DB	0; adc si,0 / sbb si,0
		DB	081H
XXADDSUB	DB	0C3H	;Add/sub	bx,02000h
		DW	02000H
	TEST	BX,08000H
	JZ	HOP601
		DB	081H
XXSUBADD	DB	0EBH;Sub/add	bx,07fa6h;08000h-90
		DW	07FA6H
HOP601:	AND	ES:[BX+SI],DL
		OR	ES:[BX+SI],DH
	LOOP	HOP602
	JMP	OUT7
HOP602:	SUB	AX,DI;di=x-y
	JGE	DIAGC
STRAIGHTC:	;Draw straight

		DB	0D0H
XXINCDEC2	DB	0CEH;Ror dh,1 / rol dh,1
		DB	0D0H
XLINCDEC2	DB	0CAH;
	CMC
		DB	083H
XXADCSBB2	DB	0D6H
		DB	0; adc si,0 / sbb si,0
	AND	ES:[BX+SI],DL
	OR	ES:[BX+SI],DH
	LOOP	HOP603
	JMP	OUT7
HOP603:	ADD	AX,BP;bp=min(x,y)
	JG	DIAGC	
	JMP	SHORT STRAIGHTC

YYLONG:	SAHF;Put true sign of x (sub cx,lastx) into flags
	JL	HOP678
	MOV	BYTE PTR YYINCDEC,0CEH;(incx)
	MOV	BYTE PTR YLINCDEC,0CAH
	MOV	BYTE PTR YYADCSBB,0D6H;(incx)
	JMP	SHORT HOP680
HOP678:	MOV	BYTE PTR YYINCDEC,0C6H;(decx)
	MOV	BYTE PTR YLINCDEC,0C2H
	MOV	BYTE PTR YYADCSBB,0DEH;(decx)
HOP680:	MOV	AH,AL
	SAHF;Put true sign of y (sub dx,lasty) into flags
	JL	HOP679
	MOV	BYTE PTR YYADDSUB1,0C3H;(incy)
	MOV	BYTE PTR YYSUBADD1,0EBH
	MOV	BYTE PTR YYADDSUB2,0C3H
	MOV	BYTE PTR YYSUBADD2,0EBH
	JMP	SHORT HOP681
HOP679:	MOV	BYTE PTR YYADDSUB1,0EBH;(decy)
	MOV	BYTE PTR YYSUBADD1,0C3H
	MOV	BYTE PTR YYADDSUB2,0EBH
	MOV	BYTE PTR YYSUBADD2,0C3H
HOP681:;	use ax, set es to active video page
	MOV	AX,0B000H
	CMP	BYTE PTR HPAGE,1
	JNZ	HOP617
	MOV	AX,0B800H
HOP617:	MOV	ES,AX
	MOV	AX,CX
	SHR	AX,1
	CMP	AX,BP
	PUSHF
	XOR	AX,AX
	MOV	SI,COLBYTE
	MOV	DX,WORD PTR MASK1;sp,ss,cs,ds,es,ax,bx,cx,dx,si,di & bp are now set.
	POPF
	JG	SHORT STRAIGHTD
	
DIAGD:	;Draw diagonaly

		DB	0D0H
YYINCDEC	DB	0CEH;Ror dh,1 / rol dh,1
		DB	0D0H
YLINCDEC	DB	0CAH;Ror dl,1 /rol dl,1
	CMC
		DB	083H
YYADCSBB	DB	0D6H
		DB	0; adc si,0 / sbb si,0
		DB	081H
YYADDSUB1	DB	0C3H	;Add/sub	bx,02000h
		DW	02000H
	TEST	BX,08000H
	JZ	HOP605
		DB	081H
YYSUBADD1	DB	0EBH;Sub/add	bx,07fa6h;08000h-90
		DW	07FA6H
HOP605:	AND	ES:[BX+SI],DL
		OR	ES:[BX+SI],DH
	LOOP	HOP604
	JMP	OUT7
HOP604:	SUB	AX,DI;di=x-y
	JG	DIAGD
STRAIGHTD:	;Draw straight
		DB	081H
YYADDSUB2	DB	0C3H	;Add/sub	bx,02000h
		DW	02000H
	TEST	BX,08000H
	JZ	HOP609
		DB	081H
YYSUBADD2	DB	0EBH;Sub/add	bx,07fa6h;08000h-90
		DW	07FA6H
HOP609:	AND	ES:[BX+SI],DL
		OR	ES:[BX+SI],DH
	LOOP	HOP608
	JMP	OUT7
HOP608:	ADD	AX,BP;Bp=min(x,y)
	JG	DIAGD
	JMP	STRAIGHTD
	

OUT7:	MOV	COLBYTE,SI
	MOV	ROWOFF,BX
	MOV	WORD PTR MASK1,DX
	JMP	HNULL
;----------------------------------------------------------------------------



;----------------------------------------------------------------------------
LAST_BYTE:;Also start of get_char buffer, and start of install code
	PUSH	ES
	PUSH	DS
	MOV	SI,81H
	CALL	GET_PARAM
	MOV	SEEN_ROWS,AX
;Rows covered by space allocated to get_char buffer
	MOV	BX,5AH	
	MUL	BX
	MOV	WORD PTR SEEN_BYTES,AX
		;Total bytes covered by get_char buffer
	MOV	AX,3510H
	INT	21H
	MOV	OLD10H,BX
	MOV	OLD10H2,ES
	MOV	AX,2510H
	MOV	DX,OFFSET NEW10HI	
	INT	21H
	MOV	DX,OFFSET LAST_BYTE
	ADD	DX,WORD PTR SEEN_BYTES	;Total bytes covered by get_char buffer
	MOV	CL,4
	SHR	DX,CL
	ADD	DX,0BH
	MOV	AH,31H
	POP	DS
	POP	ES
	INT	21H
;----------------------------------------------------------------------------



;----------------------------
GET_PARAM:
	XOR	AX,AX
;	bl=read character from command line
GET_DIGIT:
	MOV	BL,[SI]
	CMP	BL,1FH
	JLE	HOP96
	INC	SI
	SUB	BL,30H	;'0'
	JB	GET_DIGIT		;bl=read character from command line
	CMP	BL,9
	JA	GET_DIGIT		;bl=read character from command line
	MOV	BH,0AH
	MUL	BH
	ADD	AL,BL
	JMP	SHORT	GET_DIGIT	;bl=read character from command line
HOP96:	RET
;-----------------------------


DUMPROC	ENDP
	CSEG	ENDS
END START
