/*
** Copyright (C) 1991, 1992 by
** Digital Equipment Corporation, Maynard, Mass.
**
** This software is furnished under a license and may be used and copied
** only  in  accordance  with  the  terms  of such  license and with the
** inclusion of the above copyright notice. This software or  any  other
** copies thereof may not be provided or otherwise made available to any
** other person. No title to and ownership of  the  software  is  hereby
** transferred.
**
** The information in this software is subject to change without  notice
** and  should  not be  construed  as  a commitment by Digital Equipment
** Corporation.
**
** Digital assumes no responsibility for the use or  reliability  of its
** software on equipment which is not supplied by Digital.
**
*/

#include "sys/types.h"                          
#include "config.h"
#include "sys/dce_space.h"

/*
** Enable/disable diagnostic messages. Allowed values are:
**    XXX_TRUE  - enable debug message
**    XXX_FALSE - disable debug message
*/
#define XXX_DEBUG      XXX_FALSE

/*
** For PCI machines - how to access the HW :
**   XXX_USE_PCI_BIOS        - Use the 32-bit protected mode PCI BIOS calls
**   XXX_USE_PCI_MECHANISM1  - Direct access to the HW, using PCI mechanism 1
**   XXX_USE_PCI_MECHANISM2  - Direct access to the HW, using PCI mechanism 2
**
**   NOTE : The default is to use the PCI BIOS calls (in 32-bit protected
**          mode). Some systems may not support these calls, in which case
**          there will be problems at boot time. If using a system that
**          does not support 32-bit protected mode PCI BIOS calls, direct
**          hardware accesses must be used.
**          XXX_USE_PCI_MECHANISM1 or XXX_USE_PCI_MECHANISM2 should be
**          selected depending on what the specific machine supports.
*/
#define XXX_HW_ACCESSES  XXX_USE_PCI_BIOS


/* 
** Highest vector number supported. Needed to allocate large enough array 
** Should NOT be modified
*/
#define XXX_MAX_VECTOR_NUMS            16

/* 
** Number of buffers pre-allocated on the receive list
*/
#define XXX_RX_BUFS_TO_POST            4

/* 
** EISA Slot ID value for DC21040 adapter 
*/
#define XXX_PLX_DC21040_EISA_ID_VAL    0x5042A310    

/* 
** EISA Slot ID value for DC21140 adapter 
*/
#define XXX_PLX_DC21140_EISA_ID_VAL     0x0430A310    

/* 
** # of packets queued to read queues before rx processing is disabled
** (used as a high-water mark to disable driver rx processing of
** packets from the adapter)
*/
#define XXX_RX_PKTS_QUEUED_THRESH_HI   16

/* 
** When less than this # of packets are queued to read queue then
** driver receive processing will be re-enabled if it was previously
** disabled.         
*/
#define XXX_RX_PKTS_QUEUED_THRESH_LO   8


/* 
** Maximum number of streams connected (opened) to each adapter .
** Revision 1 adapters are limited to 16. If the number defined here is
** greater than the limit supported by the adapter's revision, or greater
** than the maximum supported by the driver, the driver will use the minimum
** of all the limitations
*/
#define XXX_MAX_USRS                   16

/* 
** When enabled, frames sent by a user will be looped back to the user
** if the frame meets the perfect filter criteria for that user.
** Default is enable.
*/
#define XXX_UNIFORM_CARD_MODEL         XXX_TRUE

/* 
** SIA mode for DC21040 and DC21041 boards only! . Can have one of the 
** following values:
**     XXX_TP                          - twisted pair connection
**     XXX_BNC                         - BNC connection 
**     XXX_AUI                         - AUI connection 
**     XXX_TP_FULL_DUPLEX              - point to point full duplex twisted 
**                                       pair connection
**     XXX_TP_LINK_DISABLE             - Twisted pair connection with linkfail
**                                       test ignore & set polarity plus
**     XXX_AUTOSENSE                   - Automatic detection between TP BNC 
**                                       and AUI
**     XXX_DC2104X_DEF_SERIAL_MODE     - choose the value that was read from
**                                       the SROM if read, else choose the 
**                                       AUTOSENSE mode
** 
** Important Note!
** This definition is a global definition for all installed boards. 
** If you want to set a different mode for each board, please modify 
** the 'DC2104x_sia_mode' field in the appropriate part of the XXX_info
** structure below (the values to use are those listed above).
**
** It is NOT recommended to select XXX_AUTOSENSE (for DC2104x) to the 
** first station in the net that will boot.
*/
#define XXX_DC2104X_SIA_MODE          XXX_DC2104X_DEF_SERIAL_MODE

/* 
** Serial mode for DC21140 boards only! . Can have one of the following values:
**     XXX_TP                          - 10 MB/sec TP connection
**     XXX_BNC                         - 10 MB/sec BNC connection 
**     XXX_AUI                         - 10 MB/sec AUI connection 
**     XXX_TP_FULL_DUPLEX              - point to point full duplex, 10 MB/sec
**                                       TP connection
**     XXX_SYM_SCR                     - 100 MB/sec mode
**     XXX_SYM_SCR_FULL_DUPLEX         - point to point full duplex, 100 MB/sec
**                                       mode
**     XXX_AUTOSENSE                   - Automatic detection between all 
**                                       supported media (except FULL DUPLEX).
**     XXX_DC21140_DEF_SERIAL_MODE     - choose the value that was read from
**                                       the SROM if read, else choose the 
**                                       AUTOSENSE mode
** 
** Important Note!
** This definition is a global definition for all installed boards. 
** If you want to set a different mode for each board, please modify 
** the 'DC21140_serial_mode' field in the appropriate part of the XXX_info
** structure below (the values to use are those listed above).
*/
#define XXX_DC21140_SERIAL_MODE          XXX_DC21140_DEF_SERIAL_MODE 

/*
** Selects internal bus arbitration between the receive and transmit
** processing. Allowed values:
**    XXX_TRUE  - round robin arbitration, equal sharing
**    XXX_FALSE - receive process has priority over the transmit process
**                (default)
*/
#define XXX_BUS_ARBITRATION   XXX_FALSE

/*
** Maximum number of longwords transferred in a DMA transaction.
** Allowed values are: 
**     XXX_PBL_0 (0), 
**     XXX_PBL_1 (1), 
**     XXX_PBL_2 (2), 
**     XXX_PBL_4 (4), 
**     XXX_PBL_8 (8), 
**     XXX_PBL_16 (16), 
**     XXX_PBL_32 (32 - default).
** Burst length of XXX_PBL_0 means the only limit is the amount of data stored.
** Burst length of XXX_PBL_32 is not supported in 21040 Revision 1 boards.
**
** NOTE : In case the driver work on PCI machine with CDC chip (rev 3) or 
**        with CDC chip (rev 2) he initialize DC21040 burst length to 
**        XXX_PBL_8 and ignore the value that was given by the user in space.c .
** NOTE : The driver DOESN'T inform the user that he ignored his value because
**        there is standard format to the init message in SCO-UNIX, to all 
**        drivers and the driver can't change this format by adding warning 
**        messages to the user. 
*/
#define XXX_BURST_LENGTH      XXX_PBL_32

/*
** Address boundary for data burst stop. Allowed values are:
**    XXX_CACHE_8
**    XXX_CACHE_16 
**    XXX_CACHE_32 (default)
*/
#define XXX_CACHE_ALIGNMENT   XXX_CACHE_32

/*
** Enable/disable passing of bad frames (runt frames, truncated frames,
** collided frames) from the adapter to the driver.
**    XXX_TRUE  - enables passing of bad frames
**    XXX_FALSE - disable passingof bad frames (default)
*/
#define XXX_PASS_BAD_FRAMES   XXX_FALSE 

/*
** Backoff counter algorithm.
**    XXX_TRUE  - stop counter when any carrier activity is detected
**    XXX_FALSE - backoff counter is not affected by the carrier activity
**                (default)
*/
#define XXX_BACKOFF_CNTR      XXX_FALSE

/*
** Transmit FIFO threshold for starting packet transmission to line (for
** 10MB mode).
** Allowed values are:
**    XXX_10MB_THRESHOLD_72
**    XXX_10MB_THRESHOLD_96 (default)
**    XXX_10MB_THRESHOLD_128
**    XXX_10MB_THRESHOLD_160 
*/
#define XXX_10MB_THRESHOLD         XXX_10MB_THRESHOLD_96

/*
** Transmit FIFO threshold for starting packet transmission to line (for
** 100MB mode).
** Allowed values are:
**    XXX_100MB_THRESHOLD_128
**    XXX_100MB_THRESHOLD_256 
**    XXX_100MB_THRESHOLD_512
**    XXX_100MB_THRESHOLD_1024
**    XXX_100MB_THRESHOLD_FULL (default) - full packet
*/
#define XXX_100MB_THRESHOLD         XXX_100MB_THRESHOLD_FULL

/*
** Enable/disable parity checking on PCI bus
**    XXX_TRUE  - enable parity checking
**    XXX_FALSE - disable parity checking (default)
*/
#define XXX_PARITY_ERROR_RESPONSE XXX_FALSE

/*
** DC21040/DC21140/DC21041 PCI Latency Timer, in units of PCI bus clocks. 
** Default is 50h
**
** Note : If the user choose a value for the PCI Latency Timer that is < 50h
**        the driver change this value to 50h, since the driver works with
**        the minimum value - 50h.
*/
#define XXX_LATENCY_TIMER     0x50

/*
** Enable/Disable SW's CRC calculation (in transmit packets)
**    XXX_SW_CRC_ALWAYS - CRC will be calculated by the software for every 
**                        transmit packet longer than the thershold, for
**                        transmit packets shorter than the threshold the HW
**                        will calculate the CRC
**    XXX_SW_CRC_NEVER  - CRC will be calculated by the hardware for every 
**                        transmit packet 
*/
#define XXX_CRC_CALC          XXX_SW_CRC_ALWAYS

/* 
** The control and data values to be written to the general purpose DC21140
** register.
**    XXX_GPR_DEFAULT - the value that will be found in the SROM. If no value
**                      was found in the SROM the driver has its default
**                      values.
**    The user can set his values by setting XXX_DC21140_CTRL/DATA his/her
**    value.
*/
#define XXX_DC21140_GPR_CTRL  XXX_GPR_DEFAULT
#define XXX_DC21140_GPR_DATA  XXX_GPR_DEFAULT


/*
** This constant use to enable/disable PCI priority over EISA.
**
** XXX_TRUE  - PCI has priority over EISA
** XXX_FALSE - EISA has priority over PCI
**
*/

#define XXX_TURBO             XXX_TRUE


/*
** Enable/disable snooze mode.
**    XXX_TRUE  - enable snooze mode (default)
**    XXX_FALSE - disable snooze mode
*/
#define XXX_SNOOZE_MODE       XXX_TRUE


#ifdef XXX3_0
#define XXX_MAX_BOARDS        4
#else
#ifdef XXX2_0
#define XXX_MAX_BOARDS        3
#else
#ifdef XXX1_0
#define XXX_MAX_BOARDS        2
#else
#ifdef XXX_0
#define XXX_MAX_BOARDS        1
#endif
#endif
#endif
#endif




XXX_board_config_t XXX_info[XXX_MAX_BOARDS] =
{
#ifdef XXX_0
   {
   0,                            /* board_num */
   "dce0",                       /* board_id */
   XXX_0_VECT,                   /* vector */
   XXX_0_SIOA,                   /* iobase */
   XXX_0_EIOA,                   /* ioend */
   XXX_0_SIOA,                   /* placeholder for cfgbase */
   XXX_PLX_DC21040_EISA_ID_VAL,  /* DC21040_probe_val*/            
   XXX_PLX_DC21140_EISA_ID_VAL,  /* DC21140_probe_val*/            
#ifdef XXX_CMAJOR_0
   XXX_CMAJOR_0,                 /* major_num */
#else
   -1,
#endif
   XXX_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   XXX_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   XXX_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   XXX_UNIFORM_CARD_MODEL,       /* uniform_card_model */
   XXX_DC2104X_SIA_MODE,         /* DC2104x_sia_mode */
   XXX_DC21140_SERIAL_MODE,      /* DC21140_serial_mode */
   XXX_BUS_ARBITRATION,          /* bus_arbitration */
   XXX_BURST_LENGTH,             /* burst_length */
   XXX_CACHE_ALIGNMENT,          /* cache_alignment */
   XXX_PASS_BAD_FRAMES,          /* pass_bad_frames */
   XXX_BACKOFF_CNTR,             /* backoff_cntr */
   XXX_10MB_THRESHOLD,           /* threshold */
   XXX_100MB_THRESHOLD,          /* threshold_100 */
   XXX_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   XXX_LATENCY_TIMER,            /* latency_timer */
   XXX_NULL_PCI_HANDLER,         /* pci handler place-holder */
   XXX_CRC_CALC,                 /* SW/HW CRC calculation */
   XXX_DC21140_GPR_CTRL,         /* DC21140's general purpose register control
                                    value */
   XXX_DC21140_GPR_DATA,         /* DC21140's general purpose register data
                                    value */
   XXX_TURBO,                    /* Enable/disable PCI priority over EISA */
   XXX_SNOOZE_MODE               /* snooze_mode */
   }
#endif



#ifdef XXX1_0
   ,{
   1,                            /* board_num */
   "dce1",                       /* board_id */
   XXX1_0_VECT,                  /* vector */
   XXX1_0_SIOA,                  /* iobase */
   XXX1_0_EIOA,                  /* ioend */
   XXX1_0_SIOA,                  /* placeholder for cfgbase */
   XXX_PLX_DC21040_EISA_ID_VAL,  /* DC21040_probe_val*/            
   XXX_PLX_DC21140_EISA_ID_VAL,  /* DC21140_probe_val*/            
#ifdef XXX_CMAJOR_1
   XXX_CMAJOR_1,                 /* major_num */
#else
   -1,
#endif
   XXX_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   XXX_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   XXX_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   XXX_UNIFORM_CARD_MODEL,       /* uniform_card_model */
   XXX_DC2104X_SIA_MODE,         /* DC2104x_sia_mode */
   XXX_DC21140_SERIAL_MODE,      /* DC21140_serial_mode */
   XXX_BUS_ARBITRATION,          /* bus_arbitration */
   XXX_BURST_LENGTH,             /* burst_length */
   XXX_CACHE_ALIGNMENT,          /* cache_alignment */
   XXX_PASS_BAD_FRAMES,          /* pass_bad_frames */
   XXX_BACKOFF_CNTR,             /* backoff_cntr */
   XXX_10MB_THRESHOLD,           /* threshold */
   XXX_100MB_THRESHOLD,          /* threshold_100 */
   XXX_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   XXX_LATENCY_TIMER,            /* latency_timer */
   XXX_NULL_PCI_HANDLER,         /* pci handler place-holder */
   XXX_CRC_CALC,                 /* SW/HW CRC calculation */
   XXX_DC21140_GPR_CTRL,         /* DC21140's general purpose register control
                                    value */
   XXX_DC21140_GPR_DATA,         /* DC21140's general purpose register data
                                    value */
   XXX_TURBO,                    /* Enable/disable PCI priority over EISA */
   XXX_SNOOZE_MODE               /* snooze_mode */
   }
#endif



#ifdef XXX2_0
   ,{
   2,                            /* board_num */
   "dce2",                       /* board_id */
   XXX2_0_VECT,                  /* vector */
   XXX2_0_SIOA,                  /* iobase */
   XXX2_0_EIOA,                  /* ioend */
   XXX2_0_SIOA,                  /* placeholder for cfgbase */
   XXX_PLX_DC21040_EISA_ID_VAL,  /* DC21040_probe_val*/            
   XXX_PLX_DC21140_EISA_ID_VAL,  /* DC21140_probe_val*/            
#ifdef XXX_CMAJOR_2
   XXX_CMAJOR_2,                 /* major_num */
#else
   -1,
#endif
   XXX_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   XXX_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   XXX_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   XXX_UNIFORM_CARD_MODEL,       /* uniform_card_model */
   XXX_DC2104X_SIA_MODE,         /* DC2104x_sia_mode */
   XXX_DC21140_SERIAL_MODE,      /* DC21140_serial_mode */
   XXX_BUS_ARBITRATION,          /* bus_arbitration */
   XXX_BURST_LENGTH,             /* burst_length */
   XXX_CACHE_ALIGNMENT,          /* cache_alignment */
   XXX_PASS_BAD_FRAMES,          /* pass_bad_frames */
   XXX_BACKOFF_CNTR,             /* backoff_cntr */
   XXX_10MB_THRESHOLD,           /* threshold */
   XXX_100MB_THRESHOLD,          /* threshold_100 */
   XXX_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   XXX_LATENCY_TIMER,            /* latency_timer */
   XXX_NULL_PCI_HANDLER,         /* pci handler place-holder */
   XXX_CRC_CALC,                 /* SW/HW CRC calculation */
   XXX_DC21140_GPR_CTRL,         /* DC21140's general purpose register control
                                    value */
   XXX_DC21140_GPR_DATA,         /* DC21140's general purpose register data
                                    value */
   XXX_TURBO,                     /* Enable/disable PCI priority over EISA */
   XXX_SNOOZE_MODE               /* snooze_mode */
   }
#endif




#ifdef XXX3_0
   ,{
   3,                            /* board_num */
   "dce3",                       /* board_id */
   XXX3_0_VECT,                  /* vector */
   XXX3_0_SIOA,                  /* iobase */
   XXX3_0_EIOA,                  /* ioend */
   XXX3_0_SIOA,                  /* placeholder for cfgbase */
   XXX_PLX_DC21040_EISA_ID_VAL,  /* DC21040_probe_val*/            
   XXX_PLX_DC21140_EISA_ID_VAL,  /* DC21140_probe_val*/            
#ifdef XXX_CMAJOR_3
   XXX_CMAJOR_3,                 /* major_num */
#else
   -1,
#endif
   XXX_RX_BUFS_TO_POST,          /* rx_bufs_to_post */
   XXX_RX_PKTS_QUEUED_THRESH_HI, /* rx_pkts_queued_thresh_hi */
   XXX_RX_PKTS_QUEUED_THRESH_LO, /* rx_pkts_queued_thresh_lo */
   XXX_UNIFORM_CARD_MODEL,       /* uniform_card_model */
   XXX_DC2104X_SIA_MODE,         /* DC2104x_sia_mode */
   XXX_DC21140_SERIAL_MODE,      /* DC21140_serial_mode */
   XXX_BUS_ARBITRATION,          /* bus_arbitration */
   XXX_BURST_LENGTH,             /* burst_length */
   XXX_CACHE_ALIGNMENT,          /* cache_alignment */
   XXX_PASS_BAD_FRAMES,          /* pass_bad_frames */
   XXX_BACKOFF_CNTR,             /* backoff_cntr */
   XXX_10MB_THRESHOLD,           /* threshold */
   XXX_100MB_THRESHOLD,          /* threshold_100 */
   XXX_PARITY_ERROR_RESPONSE,    /* parity_error_response */
   XXX_LATENCY_TIMER,            /* latency_timer */
   XXX_NULL_PCI_HANDLER,         /* pci handler place-holder */
   XXX_CRC_CALC,                 /* SW/HW CRC calculation */
   XXX_DC21140_GPR_CTRL,         /* DC21140's general purpose register control
                                    value */
   XXX_DC21140_GPR_DATA,         /* DC21140's general purpose register data
                                    value */
   XXX_TURBO,                    /* Enable/disable PCI priority over EISA */
   XXX_SNOOZE_MODE               /* snooze_mode */
   }
#endif

};


#ifndef TCP_0
   void *ifstats = (void *)0;
#endif


char            *XXX_vector_to_board[XXX_MAX_VECTOR_NUMS];
uint            XXX_hw_accesses = XXX_HW_ACCESSES;
unchar          XXX_debug      = XXX_DEBUG;
uint            XXX_max_boards = XXX_MAX_BOARDS;
uint            XXX_max_usrs   = XXX_MAX_USRS;
void            *XXX_Boards_table[XXX_MAX_BOARDS];
