{
  MibBrow.Pas

  MIBB32.EXE main form.
  Copyright 1995-1997 by MG-SOFT d.o.o.
  All rights reserved.
    E-mail: info@mg-soft.si
    Web URL: http://www.mg-soft.si/


  This source file is for demonstrational purpose only.
  Check LICENSE.TXT for licensing information.
}
unit MibBrow;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, StdCtrls, ExtCtrls, About, Semaph, WinSnmp, WSnmpMib, Buttons,
  Grids, Registry, icmp, WinSock {, MgWSnmp};

const
  RegInitKey = 'SOFTWARE\MG-SOFT\Mib Browser Demo\1.0';
  WM_SNMP_MSG = WM_USER + 1;
  WM_SNMP_INFO_MSG = WM_USER + 2;
  MAX_INFO_FORMS = 60; // Do not increase this value above 60!
  CharSet: set of Char = [Char(9)..Char(13),' '..'~'];

type
  TMibBrowState = (MBS_NOT_INITIALIZED,
                   MBS_NOT_CONTACTED,
                   MBS_CONTACTING,
                   MBS_CONTACTED,
                   MBS_ERROR_CONTACT,
                   MBS_BROWSING,
                   MBS_FINISH_BROWSING,
                   MBS_ABORT_BROWSING
                   );
  SnmpEntity = record
    { General WinSnmp data }
    nMajorVersion: smiUINT32;
    nMinorVersion: smiUINT32;
    nLevel: smiUINT32;
    nTranslateMode: smiUINT32;
    nRetransmitMode: smiUINT32;
    { Notification data }
    snmpHandle : HWND;
    snmpMessage : UINT;
    { Initialize depended data}
    bInitialized: Bool;
    bWinSnmpStarted: Bool;
    { Session depended data}
    psIPManager: string;
    psIPAgent: string;
    sIPManager: array[0..80] of Char;
    sIPAgent: array[0..80] of Char;
    sCommunity: array[0..80] of Char;
    smiCommunity: smiOCTETS;
    { Session values }
    stopCondition : Boolean;
    stopOid : smiOID;
    stopOidVal : array[0..MAXOBJIDSIZE] of smiUINT32;
    oid: smiOID;
    oidVal : array[0..MAXOBJIDSIZE] of smiUINT32;
    value: smiVALUE;
    thresholdId : Integer;
    requestId : Integer;
    { Session handles }
    hSnmpSession: HSNMP_SESSION;
    hAgentEntity: HSNMP_ENTITY;
    hManagerEntity: HSNMP_ENTITY;
    hViewContext: HSNMP_CONTEXT;
    hVbl: HSNMP_VBL;
    hPdu: HSNMP_PDU;
    { result values }
    resultNames : TStringList;
    resultValues : TStringList;
  end;
  // Main application class
  TFormMB32 = class(TForm)
    PageControl1: TPageControl;
    StatusBar1: TStatusBar;
    MainMenu1: TMainMenu;
    Action1: TMenuItem;
    MenuContact: TMenuItem;
    MenuBrowse: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    GroupBox1: TGroupBox;
    ComboBoxRSnmpAgent: TComboBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    MemoBResult: TMemo;
    File1: TMenuItem;
    Exit1: TMenuItem;
    PanelToolbar: TPanel;
    SpeedButtonContact: TSpeedButton;
    SpeedButtonQuery: TSpeedButton;
    SpeedButtonAbort: TSpeedButton;
    SpeedButtonClear: TSpeedButton;
    SpeedButtonCopyClipboard: TSpeedButton;
    Edit1: TMenuItem;
    MenuCopyResults: TMenuItem;
    MenuClearResults: TMenuItem;
    TabSheet4: TTabSheet;
    SpeedButtonInfo: TSpeedButton;
    MenuAbort: TMenuItem;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    GroupBox6: TGroupBox;
    EditRetransmit: TEdit;
    EditTimeout: TEdit;
    EditCommunity: TEdit;
    GroupBox7: TGroupBox;
    EditManager: TEdit;
    ButtonApplyOptions: TButton;
    Bevel3: TBevel;
    MibTreeView: TTreeView;
    GroupBox8: TGroupBox;
    EditPingHost: TEdit;
    PingResultsMemo: TMemo;
    StartPing: TButton;
    GroupBox9: TGroupBox;
    MemoPingResults: TMemo;
    GroupBox10: TGroupBox;
    EditPingBytes: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    EditPingRequests: TEdit;
    CheckBoxPingDontFragment: TCheckBox;
    LabelPingTimeout: TLabel;
    EditPingTimeout: TEdit;
    Helptopics1: TMenuItem;
    N1: TMenuItem;
    CheckBoxBrowseAll: TCheckBox;
    RadioGroup1: TRadioGroup;
    RadioButtonPollNo: TRadioButton;
    RadioButtonPollYes: TRadioButton;
    GroupBox11: TGroupBox;
    CheckBoxExitConfirmation: TCheckBox;
    N2: TMenuItem;
    New1: TMenuItem;
    Closeall1: TMenuItem;
    Window1: TMenuItem;
    Newwindow1: TMenuItem;
    N3: TMenuItem;
    Cascade1: TMenuItem;
    Cascade2: TMenuItem;
    CloseAll2: TMenuItem;
    Polling1: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    MinimizeAll1: TMenuItem;
    MaximizaAll1: TMenuItem;
    MainToFront1: TMenuItem;
    N6: TMenuItem;
    InfoWindows: TMenuItem;
    MinimizedToFront1: TMenuItem;
    NormalToFront1: TMenuItem;
    SpeedButtonDiscover: TSpeedButton;
    Discover1: TMenuItem;
    N7: TMenuItem;
    Discover2: TMenuItem;
    SpeedButtonHelp: TSpeedButton;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure StatusBar1DrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure About1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButtonContactClick(Sender: TObject);
    procedure SpeedButtonClearClick(Sender: TObject);
    procedure SpeedButtonAbortClick(Sender: TObject);
    procedure SpeedButtonQueryClick(Sender: TObject);
    procedure MemoBResultChange(Sender: TObject);
    procedure SpeedButtonCopyClipboardClick(Sender: TObject);
    procedure MenuContactClick(Sender: TObject);
    procedure MenuBrowseClick(Sender: TObject);
    procedure MenuCopyResultsClick(Sender: TObject);
    procedure MenuClearResultsClick(Sender: TObject);
    procedure MenuAbortClick(Sender: TObject);
    procedure ButtonApplyOptionsClick(Sender: TObject);
    procedure ComboBoxRSnmpAgentKeyPress(Sender: TObject; var Key: Char);
    procedure PingWriteLn(s : string);
    procedure StartPingClick(Sender: TObject);
    procedure Helptopics1Click(Sender: TObject);
    procedure SpeedButtonInfoClick(Sender: TObject);
    procedure ComboBoxRSnmpAgentClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure RadioButtonPollNoClick(Sender: TObject);
    procedure RadioButtonPollYesClick(Sender: TObject);
    procedure Closeall1Click(Sender: TObject);
    procedure Polling1Click(Sender: TObject);
    procedure Cascade1Click(Sender: TObject);
    procedure Cascade2Click(Sender: TObject);
    procedure MinimizeAll1Click(Sender: TObject);
    procedure MaximizaAll1Click(Sender: TObject);
    procedure MainToFront1Click(Sender: TObject);
    procedure MinimizedToFront1Click(Sender: TObject);
    procedure NormalToFront1Click(Sender: TObject);
    procedure SpeedButtonDiscoverClick(Sender: TObject);
  private
    { Private declarations }
    hIcmp : THandle;
  public
    { Public declarations }
    RegIni: TRegIniFile;
    MBSem : TSemaphore;
    se: SnmpEntity;
    localHostIp : TInAddr;
    StatusPanelSemStyle: TStatusPanelStyle;
    MibBrowState : TMibBrowState;
    BrowseCount : Integer;
    CurrentRSnmpAgentComboBoxEntry : String;
    procedure ReadRegIni;
    procedure WriteRegIni;
    procedure MyWriteLn(s : string);
    procedure MyWrite(s : string);
    procedure SetMibBrowState(state : TMibBrowState);
    function WinSnmpInit(se : SnmpEntity) : Boolean;
    procedure SnmpInitConnection(var se: SnmpEntity);
    procedure SnmpCloseConnection(var se: SnmpEntity);
    procedure SnmpContactCreateQuery(var se: SnmpEntity);
    procedure SnmpBrowse(var se: SnmpEntity;  updateStatus : Boolean);
    procedure OnSnmpEvent(var Msg: TMessage); message WM_SNMP_MSG;
    procedure SnmpOutputValue(name : smiOID; value : smiVALUE);
    procedure InitializeMibTreeView(firstNode: string);
    procedure CascadeWindows(oneToMax : Boolean);


  end;

var
  FormMB32: TFormMB32;

implementation

uses Info, Discover;

{$R *.DFM}
{$R MIBB32_1.RES}
{$R PROJVER.RES}

procedure TFormMB32.FormCreate(Sender: TObject);
  var
    wVersionRequested : WORD;
    wsaData : TWSAData;
    err : Integer;
    localIP : TInAddr;
    he : PHostEnt;
    heLocalIP : ^PInAddr;
    heLocalHostName : array[0..255] of Char;
    i : Integer;
begin
  {
    IMPORTANT NOTE!
    Borland should document this one in Delphi manuals.
    Don't forget to True this one in every Delphi program
    you are developping.
    All Delphi allocations/deallocations will be
    protected from concurrent access.
  }
  IsMultithread := True;
  // Initialize InfoForms counter
  infoFormsCount := 0;
  for i := 0 to MAX_INFO_FORMS do
    InfoForm[i] := nil;
  // Initialize page
  PageControl1.ActivePage := TabSheet1;
  // Initialize visual semaphore on status bar
  MBSem := TSemaphore.Create(Self);
  MBSem.SemaphoreState := SEM_IDLE;
  // Initialize status bar
  StatusBar1.Panels.Items[2].Style := psOwnerDraw;
  StatusBar1.Panels.Items[0].Text := 'Initializing...';
  // Read startup values from the registry
  ReadRegIni;
  // Initialize WinSnmp
  SetMibBrowState(MBS_NOT_INITIALIZED);
  se.bWinSnmpStarted := False;
  Randomize;
  {
    IMPORTANT NOTE!!!
    It is very important to increase request ID. It is the only reference
    for WinSnmp to discover the packet source. It can mess up the internal
    timeout/retransmit queues!!! Request ID has to be increased InterThread globally!

    Use InterlockedIncrement for global request ID increase.
  }
  se.requestId := Random(MAXINT);
  // Get local IP
  wVersionRequested := MAKEWORD(1, 1);
  err := WSAStartup(wVersionRequested, wsaData);
  if err = 0 then begin
    if (LOBYTE(wsaData.wVersion) <> 1) OR
       (HIBYTE(wsaData.wVersion) <> 1) then begin
      WSACleanup();
    end
    else begin
      // Retreive local host IP address
      if 0 = gethostname(@heLocalHostName[0], 255) then begin
        he := gethostbyname(@heLocalHostName[0]);
        if he <> nil then begin
          heLocalIP := Pointer(he.h_addr_list);
          while Pointer(heLocalIP^) <> nil do begin
            localHostIp.S_addr := heLocalIP^^.S_addr;
            EditManager.Text := inet_ntoa(localHostIp);
            MyWriteLn('Local host IP address: ' + inet_ntoa(localHostIp));
            Inc(heLocalIP, 4);
            Break;
          end;
        end;
      end;
    end;
  end;
  // Initialize MIB-walk panel WinSnmp entity
  if (WinSnmpInit(se) = False) then begin
    MessageDlg('Could not initialize MIB-walk WinSnmp! Terminating...', mtError, [mbOk], 0);
    Application.Terminate;
  end;

  {
    This is for WinMib32 usage. WinMib is not finished yet.
    The code supporting the MIB tree is removed.
  }
  InitializeMibTreeView('ccitt');


  // Icmp initialization
  hIcmp := IcmpCreateFile();

  // Initialization OK.
  SetMibBrowState(MBS_NOT_CONTACTED);
end;

{
  FormDestroy
  Before exiting free all resources
}
procedure TFormMB32.FormDestroy(Sender: TObject);
  var
    i : Integer;
begin
  // Destroy InfoForms
  for i := 0 to MAX_INFO_FORMS do begin
    if InfoForm[i] <> nil then begin
      InfoForm[i].Destroy;
      InfoForm[i] := nil;
    end;
  end;
  // close mib-walk panel snmp entity
  if (se.bInitialized = True) then begin
    SnmpCloseConnection(se);
  end;
  SnmpCleanup();
  // Icmp cleanup
  if (IcmpCloseHandle(hIcmp) = False) then begin
  end;

  // Write startup values to registry
  WriteRegIni;
  // Cleanup winsock
  WSACleanup();
end;

{
  Helptopics1Click
  Help activation
}
procedure TFormMB32.Helptopics1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

{
  StatusBar1DrawPanel
  Status bar update.
}
procedure TFormMB32.StatusBar1DrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
  var
    leftx1, leftx2, leftx3, topx, midx : Integer;
    pos : TRect;
begin
  MBSem.ClientHandle := StatusBar.Handle;
  // Set position for red light
  Pos.Top := Rect.Top + ((Abs(Rect.Top - Rect.Bottom) - MBSem.LightHeight) div 2);
  Pos.Left := Rect.Left + ((Abs((Rect.Right - Rect.Left) div 3) - MBSem.LightWidth) div 2) + 1;
  MBSem.RedPos := Pos;
  // Set position for yellow light
  midx := Abs(Pos.Left - Rect.left);
  Pos.Left := Pos.Left + MBSem.LightWidth + midx;
  MBSem.YellowPos := Pos;
  // Sep position for green light
  Pos.Left := Pos.Left + MBSem.LightWidth + midx;
  MBSem.GreenPos := Pos;
  // update semaphore
  MBSem.Update;
end;

{
  MyWriteLn
  TMemo output.
}
procedure TFormMB32.MyWriteLn(s : string);
  var
    currentMemoLine : Integer;
    i : Integer;
begin
  while True do begin
    currentMemoLine := MemoBResult.Lines.Count;
    // Add a line
    MemoBResult.Lines.Add(s);
    if (currentMemoLine = MemoBResult.Lines.Count) then begin
      MemoBResult.Lines.BeginUpdate;
      for i := 0 to 10 do
        MemoBResult.Lines.Delete(0);
      MemoBResult.Lines.EndUpdate;
    end;
    Break;
  end;
end;

procedure TFormMB32.MyWrite(s : string);
begin
  MyWriteLn(s);
end;

procedure TFormMB32.About1Click(Sender: TObject);
begin
  AboutBox.Show;
end;

procedure TFormMB32.Exit1Click(Sender: TObject);
begin
  Close;
end;

{
  WinSnmpInit
  Init the WinSnmp and set its' globals
}
function TFormMB32.WinSnmpInit(se : SnmpEntity) : Boolean;

  label
    terminate;
  var
    error: Bool;
    s: SNMPAPI_STATUS;
    ts : String;

begin
  Result := True;
  se.bInitialized := False;
  MyWriteLn('Initializing MG-WinSNMP module');
  { Start WinSnmp.dll }
  s := SnmpStartup(@se.nMajorVersion, @se.nMinorVersion, @se.nLevel, @se.nTranslateMode,
                   @se.nRetransmitMode);
  if s = SNMPAPI_FAILURE then begin
    s := SnmpGetLastError(se.hSnmpSession);
    MessageDlg('SnmpStartup error : ' + IntToStr(s), mtInformation, [mbOk], 0);
    Result := False;
    Exit;
  end;
  MyWriteLn('nMajorVersion: ' + IntToStr(se.nMajorVersion));
  MyWriteLn('nMinorVersion: ' + IntToStr(se.nMinorVersion));
  case se.nLevel of
    SNMPAPI_NO_SUPPORT:  ts := 'Level 0';
    SNMPAPI_V1_SUPPORT:  ts := 'Level 1';
    SNMPAPI_V2_SUPPORT:  ts := 'Level 2';
    SNMPAPI_M2M_SUPPORT: ts := 'Level 3';
  end;
  MyWrite('nLevel: ' + ts);
  case se.nTranslateMode of
    SNMPAPI_TRANSLATED:  ts := 'Translated';
    SNMPAPI_UNTRANSLATED_V1: ts := 'UnTranslated V1';
    SNMPAPI_UNTRANSLATED_V2: ts := 'UnTranslated V2';
  end;
  MyWrite('nTranslateMode: ' + ts);
  case se.nRetransmitMode of
    SNMPAPI_OFF: ts := 'Not executing the retransmission policy';
    SNMPAPI_ON:  ts := 'Executing the retransmission policy';
  end;
  MyWrite('nRetransmitMode: ' + ts);

  if (se.nTranslateMode <> SNMPAPI_UNTRANSLATED_V1) then begin
    s := SnmpSetTranslateMode(SNMPAPI_UNTRANSLATED_V1);
    if s = SNMPAPI_FAILURE then begin
      s := SnmpGetLastError(se.hSnmpSession);
      MessageDlg('SnmpSetTranslateMode error : ' + IntToStr(s), mtInformation, [mbOk], 0);
      Result := False;
      Exit;
    end;
    MyWriteLn('SnmpSetTranslateMode OK');
  end;
  se.bWinSnmpStarted := True;
end;

{
  SpeedButtonContactClick
  Tries to contact the remote SNMP agent
  It uses sysUpTime for this.
  Hopefully agent supports sysUpTime :-)
}
procedure TFormMB32.SpeedButtonContactClick(Sender: TObject);
  var
    ts : array[0..40] of Char;

begin
  SetMibBrowState(MBS_CONTACTING);

  // Check first if entity is initialized. If so close last entity
  if (se.bInitialized = True) then begin
    SnmpCloseConnection(se);
    MyWriteLn('Closing connection!');
    if (se.bInitialized = True) then begin
      // Close SNMP connection error
      MessageDlg('Can not close connection. Check WinSnmp.dll', mtError, [mbOk], 0);
      Exit;
    end;
  end;

  MyWriteLn('');
  // Get Manager IP string from EditManager
  StrCopy(se.sIPManager, PChar(EditManager.Text));
  MyWriteLn('Local IP: ' + se.sIPManager);
  // Get Agent IP string from ComboBoxRSnmpAgent
  StrCopy(se.sIPAgent, PChar(CurrentRSnmpAgentComboBoxEntry));
  MyWriteLn('Remote IP: ' + se.sIPAgent);
  // Get Community name
  // StrCopy(se.sCommunity, PChar('public'));
  se.smiCommunity.len := StrLen(PChar(EditCommunity.Text));   { WinSnmp needs community in smiOctets format}
  se.smiCommunity.ptr := PByte(EditCommunity.Text);

  // Initialize new connection
  se.snmpHandle := Handle;
  se.snmpMessage := WM_SNMP_MSG;
  SnmpInitConnection(se);

  // Initialize Query information
  ts := '1.3.6.1.2.1.1.3';    { sysUpTime }
  if se.oid.ptr <> nil then
    SnmpFreeDescriptor(SNMP_SYNTAX_OID, @se.oid);
  SnmpStrToOid(ts, @se.oid);
  // no stop oid condition
  se.stopOid.len := 0;
  se.stopOid.ptr := @se.stopOidVal[0];
  // Create a query and send message
  SnmpContactCreateQuery(se);
end;

{
  SnmpInitConnection
  Opens new session and initialize Entities, Context, Timeouts and Retries
}
procedure TFormMB32.SnmpInitConnection(var se: SnmpEntity);
  var
    s : SNMPAPI_STATUS;
begin
  if (se.hSnmpSession = 0) then begin
    se.hSnmpSession := SnmpOpen(se.snmpHandle, se.snmpMessage);
  end;
  if (se.hSnmpSession = SNMPAPI_FAILURE) then
    Exit;
  // Register traps for this session - no filtering
  SnmpRegister(se.hSnmpSession, 0, 0, 0, nil, SNMPAPI_ON);
  se.hAgentEntity := SnmpStrToEntity(se.hSnmpSession, @se.sIPAgent[0]);
  se.hManagerEntity := SnmpStrToEntity(se.hSnmpSession, @se.sIPManager[0]);
  se.hViewContext := SnmpStrToContext(se.hSnmpSession, @se.smiCommunity);
  s := SnmpSetRetry(se.hManagerEntity, StrToInt(EditRetransmit.Text));
  s := SnmpSetTimeout(se.hManagerEntity, StrToInt(EditTimeout.Text));
  s := SnmpSetRetry(se.hAgentEntity, StrToInt(EditRetransmit.Text));
  s := SnmpSetTimeout(se.hAgentEntity, StrToInt(EditTimeout.Text));
  s := SnmpSetRetransmitMode(SNMPAPI_ON);
  se.bInitialized := True;
  se.stopCondition := False;
end;

{
  SnmpCloseConnection
  Close the SNMP session
}
procedure TFormMB32.SnmpCloseConnection(var se: SnmpEntity);
  var
    s: SNMPAPI_STATUS;
begin
  { Free SNMP Entity context }
  s := SnmpFreeContext(se.hViewContext);
  se.hViewContext := 0;
  s := SnmpFreeEntity(se.hManagerEntity);
  se.hManagerEntity := 0;
  s := SnmpFreeEntity(se.hAgentEntity);
  se.hAgentEntity := 0;
  s := SnmpClose(se.hSnmpSession);
  se.hSnmpSession := 0;
  se.bInitialized := False;
end;


{
  SnmpContactCreateQuery
  Create and send contact query
}
procedure TFormMB32.SnmpContactCreateQuery(var se: SnmpEntity);
  var
    s: SNMPAPI_STATUS;
begin
  se.hVbl := SnmpCreateVbl(se.hSnmpSession, @se.oid, nil);
  {
    you can find more information on requestId in FormCreate!
  }
  se.requestId := se.requestId + 1;
  se.hPdu := SnmpCreatePdu(se.hSnmpSession, SNMP_PDU_GETNEXT, se.requestId, 0, 0, se.hVbl);
  s := SnmpSendMsg(se.hSnmpSession, se.hManagerEntity, se.hAgentEntity, se.hViewContext, se.hPdu);
  s := SnmpFreeVbl(se.hVbl);
  s := SnmpFreePdu(se.hPdu);
end;

{
  OnSnmpEvent
  Handles the WinSnmp messages
}
procedure TFormMB32.OnSnmpEvent(var Msg: TMessage);
  var
    s: SNMPAPI_STATUS;
    hRcvAgentEntity: HSNMP_ENTITY;
    hRcvManagerEntity: HSNMP_ENTITY;
    hRcvViewContext: HSNMP_CONTEXT;
    hRcvVbl: HSNMP_VBL;
    hRcvPdu: HSNMP_PDU;

    oContext: smiOCTETS;
    requestId: smiINT32;
    pduType, errorStatus, errorIndex : smiINT;
    oid : smiOID;
    value : smiVALUE;

    oidc : Integer;
    i : Integer;
    oidCompareResult : smiINT;
    ts : array[0..40] of char;
begin
  // MyWriteLn('OnSnmpEvent');
  // Check what's going on
  s := SnmpRecvMsg(se.hSnmpSession, @hRcvAgentEntity, @hRcvManagerEntity,
                              @hRcvViewContext, @hRcvPdu);
  if (s = SNMPAPI_FAILURE) then begin
    s := SNmpGetLastError(se.hSnmpSession);
    if (s = SNMPAPI_TL_TIMEOUT) then begin
      {
        When TIMEOUT?
        Timeout is received after original message +
        n retries (SnmpSetRetry).
        Every retry is SnmpSetTimeout long.
        Request timeout is removed from timeout que
        if received packets' request_id matches one in
        timeout que.

        This is the only error that program must
        release resources returned by SnmpRecvMsg
        If WinSNMP can not locate the original handle that has
        been passed to the SnmpSendMsg it returns NULL for the
        parameter.
        e.g: if hPdu is freed after SnmpSendMsg, SnmpRecvMsg will
        return NULL for hRcvPdu.
      }
      if (hRcvPdu <> 0) then SnmpFreePdu(hRcvPdu);
      if (hRcvAgentEntity  <> 0) then SnmpFreeEntity(hRcvAgentEntity);
      if (hRcvManagerEntity  <> 0) then SnmpFreeEntity(hRcvManagerEntity);
      if (hRcvViewContext  <> 0) then SnmpFreeContext(hRcvViewContext);
      MyWriteLn('TIMEOUT');
      SetMibBrowState(MBS_ERROR_CONTACT);
      Exit;
    end;
    if (s = SNMPAPI_NOOP) then begin
      {
        Why NOOP?
        MG-WinSnmp sometimes sends more than one message
        to the main app. If app is busy it can happened that
        two or more messages are sent. This causes that second++ message
        returns NOOP when SnmpRecvMsg is called.

        We still did not figured out what Microsoft is working internally with messages.
        But sometimes happens that message is lost!?
      }
      // MyWriteLn('NOOP');
      Exit;
    end;
    // MyWriteLn('ERROR');
    Exit;
  end;

  {
    you can find more information on requestId in FormCreate!
  }
  s := SnmpGetPduData(hRcvPdu, @pduType, @requestId, @errorStatus, @errorIndex, @hRcvVbl);

  // Did we reach the end of agents' MIB tree?
  if (errorStatus = SNMP_ERROR_NOSUCHNAME) then begin
    SetMibBrowState(MBS_FINISH_BROWSING);
    SnmpFreeVbl(hRcvVbl);
    SnmpFreePdu(hRcvPdu);
    SnmpFreeEntity(hRcvAgentEntity);
    SnmpFreeEntity(hRcvManagerEntity);
    SnmpFreeContext(hRcvViewContext);
    Exit;
  end;

  if ((MibBrowState <> MBS_CONTACTING) AND
      (MibBrowState <> MBS_BROWSING) AND
      (MibBrowState <> MBS_FINISH_BROWSING) AND
      (MibBrowState <> MBS_CONTACTED)) then begin
    SnmpFreeVbl(hRcvVbl);
    SnmpFreePdu(hRcvPdu);
    SnmpFreeEntity(hRcvAgentEntity);
    SnmpFreeEntity(hRcvManagerEntity);
    SnmpFreeContext(hRcvViewContext);
    Exit;
  end;

  {
    for TRAPS
    SNMP_PDU_V1TRAP is obsolete but anyway...
    MG-WinSnmp always use SNMP_PDU_TRAP

    In WinSnmp specification traps are converted
    from V1 to V2 trap type.

    V1->V2 converted trap PDU description:
    1: sysUpTime.0    (1.3.6.1.2.1.1.3.0)
        VAL:  time field from V1 trap
    2: snmpTrapOID.0  (1.3.6.1.6.3.1.1.4.1.0)
        case generic trap
          VAL:  notification type from snmpTraps subtree e.g.: coldStart
                Be carefull: trap values from V1 specification (coldStart = 0)
                             are shifted by one in V2 specification (coldStart = 1)!
        case enterprise specific trap
          VAL:  snmpTrapEnterprise.0.0.specificTrapVal
              specificTrapVal = specific field from V1 traps
    3..n-1:  OID-VALUE from V1 trap PDU
             (may be skipped - sometimes traps have blank PDUs)
    n: snmpTrapEnterprise.0   (1.3.6.1.6.3.1.1.4.3.0)
        VAL:  enterprise OID field from V1 traps

    In V1->V2 converted traps
      request_id,
      error_status,
      error_index
    are all 0.
  }
  if ((pduType = SNMP_PDU_TRAP) OR
      (pduType = SNMP_PDU_V1TRAP)) then begin
    MyWriteLn('** TRAP START **');
    ts[0] := Char(0);
    SnmpEntityToStr(hRcvAgentEntity, 40, @ts[0]);
    MyWriteLn('Trap received from: ' + ts);
  end;

  {
    Check the VB count first.
    Handle all VB's after
  }
  oidc := SnmpCountVbl(hRcvVbl);
  for i := 1 to oidc do begin
    s := SnmpGetVb(hRcvVbl, i, @oid, @value);
    { remember first SNMP binding value for the next query }
    if i = 1 then begin
      if se.oid.ptr <> nil then begin
        SnmpFreeDescriptor(SNMP_SYNTAX_OID, @se.oid);
      end;
      SnmpOidCopy(@oid, @se.oid);
      se.value.syntax := SNMP_SYNTAX_NULL;
    end;
    { stop condition set ? }
    if se.stopOid.len > 0 then begin
      { check if stop condition matches current oid }
      if SNMPAPI_SUCCESS = SnmpOidCompare(@se.stopOid, @oid, 0, @oidCompareResult) then begin
        if oidCompareResult = -1 then begin
          SetMibBrowState(MBS_FINISH_BROWSING)
        end
        else
          SnmpOutputValue(oid, value);
      end;
    end
    else
      SnmpOutputValue(oid, value);
    {
      Free descriptors
    }
    s := SnmpFreeDescriptor(SNMP_SYNTAX_OID, @oid);
    case value.syntax of
      SNMP_SYNTAX_OCTETS:
        s := SnmpFreeDescriptor(value.syntax, @value.pString);
      SNMP_SYNTAX_OID:
        s := SnmpFreeDescriptor(value.syntax, @value.oid);
      SNMP_SYNTAX_IPADDR:
        s := SnmpFreeDescriptor(value.syntax, @value.pString);
    end;
  end;
  {
    for TRAPS
  }
  if ((pduType = SNMP_PDU_TRAP) OR
      (pduType = SNMP_PDU_V1TRAP)) then begin
    MyWriteLn('** TRAP END **');
    s := SnmpFreeVbl(hRcvVbl);
    s := SnmpFreePdu(hRcvPdu);
    s := SnmpFreeEntity(hRcvAgentEntity);
    s := SnmpFreeEntity(hRcvManagerEntity);
    s := SnmpFreeContext(hRcvViewContext);
    Exit;
  end;

  if (MibBrowState = MBS_CONTACTING) then begin
    SetMibBrowState(MBS_CONTACTED);
    SnmpFreeVbl(hRcvVbl);
    SnmpFreePdu(hRcvPdu);
    SnmpFreeEntity(hRcvAgentEntity);
    SnmpFreeEntity(hRcvManagerEntity);
    SnmpFreeContext(hRcvViewContext);
  end;
  if (MibBrowState = MBS_BROWSING) then begin
    {
      Yet another query
    }
    SnmpBrowse(se, True);
    SnmpFreeVbl(hRcvVbl);
    SnmpFreePdu(hRcvPdu);
    SnmpFreeEntity(hRcvAgentEntity);
    SnmpFreeEntity(hRcvManagerEntity);
    SnmpFreeContext(hRcvViewContext);
  end;
end;


{
  SnmpOutputValue
  Output the SNMP OID-VALUE to TMemo
  IMPORTANT! Do not forget to free descriptors of
             OID and VALUE after exit!
             Forgetting causes the memory leaking.
}
procedure TFormMB32.SnmpOutputValue(name : smiOID; value : smiVALUE);
  var
    ts : array[0..2048] of char;
    ts1 : array[0..2048] of char;
    oidp : smiLPUINT32;
    charp : smiLPBYTE;
    i, j : Integer;
    d,h,m,s,th : Integer;
    mibNode : HWSM_NODE;
    initialNameLen : Integer;
    printHex : Boolean;
begin
  { Print OID }
  ts := '';
  initialNameLen := name.len;
  { find a string alias for the OID }
  for j := name.len downto 0 do begin
    name.len := j;
    mibNode := WsmMapOidToNode(@name);
    if (mibNode <> 0) then begin
      i := 500;
      WsmGetNodeString(mibNode, WSM_INFO_NAME, @i, @ts1[0]);
      StrCat(ts, ts1);
      break;
    end;
  end;
  name.len := initialNameLen;
  { append OID reminder to the string }
  oidp := name.ptr;
  inc(oidp, j);
  for i := j + 1 to name.len do begin
    if i <> 1 then
      StrCat(ts, '.');
    StrCat(ts, PChar(IntToStr(oidp^)));
    inc(oidp);
  end;
  { append separator }
  StrCat(ts, ' **** ');
  { append type }
  case value.syntax of
    SNMP_SYNTAX_INT:            StrCat(ts, '(int, int32)');
    SNMP_SYNTAX_UINT32:         StrCat(ts, '(uint32)');
    SNMP_SYNTAX_CNTR32:         StrCat(ts, '(cntr32)');
    SNMP_SYNTAX_GAUGE32:        StrCat(ts, '(gauge32)');
    SNMP_SYNTAX_TIMETICKS:      StrCat(ts, '(timeticks)');
    SNMP_SYNTAX_OCTETS:         StrCat(ts, '(octets)');
    SNMP_SYNTAX_CNTR64:         StrCat(ts, '(cntr64)');
    SNMP_SYNTAX_IPADDR:         StrCat(ts, '(ipaddr)');
    SNMP_SYNTAX_BITS:           StrCat(ts, '(bits)');
    SNMP_SYNTAX_OPAQUE:         StrCat(ts, '(opaque)');
    SNMP_SYNTAX_NSAPADDR:       StrCat(ts, '(nsapaddr)');
    SNMP_SYNTAX_OID:            StrCat(ts, '(oid)');
    SNMP_SYNTAX_NULL:           StrCat(ts, '(null)');
    SNMP_SYNTAX_NOSUCHOBJECT:   StrCat(ts, '(nosuchobject)');
    SNMP_SYNTAX_NOSUCHINSTANCE: StrCat(ts, '(nosuchinstance)');
    SNMP_SYNTAX_ENDOFMIBVIEW:   StrCat(ts, '(endofmibview)');
  end;
  StrCat(ts, ' ');
  { append value }
  case value.syntax of
    //SNMP_SYNTAX_INT32:,
    SNMP_SYNTAX_INT: begin
      StrCat(ts, PChar(IntToStr(value.sNumber)));
    end;
    SNMP_SYNTAX_UINT32,
    SNMP_SYNTAX_CNTR32,
    SNMP_SYNTAX_GAUGE32: begin
      StrCat(ts, PChar(IntToStr(value.uNumber)));
    end;
    SNMP_SYNTAX_TIMETICKS: begin
      d := value.uNumber;
      th := d mod 100; d := d div 100;
      s := d mod 60;   d := d div 60;
      m := d mod 60;   d := d div 60;
      h := d mod 24;
      d := d div 24;
      StrCat(ts, PChar(Format('%d days %02.02dh:%02.02dm:%02.02ds.%02.02dth', [d,h,m,s,th])));
    end;
    SNMP_SYNTAX_CNTR64 : begin
      StrCat(ts, PChar(IntToHex(value.hNumber.hipart, 8)));
      StrCat(ts, '.');
      StrCat(ts, PChar(IntToHex(value.hNumber.lopart, 8)));
      StrCat(ts, ' (hex)');
    end;
    SNMP_SYNTAX_OCTETS: begin
      if value.pString.len < 1 then begin
        StrCat(ts, ' (zero-length)');
      end;
      printHex := False;
      charp := value.pString.ptr;
      ts1 := '';
      for i := 1 to value.pString.len do begin
        if ((NOT (Char(charp^) IN CharSet)) OR
            ((Char(charp^) = Char(0)) AND
             (i <> value.pString.len))) then begin
          // to print string only last char can be '\0'
          printHex := True;
        end;
        if i <> 1 then
          StrCat(ts1, '.');
        StrCat(ts1, PChar(IntToHex(charp^, 2)));
        inc(charp);
      end;
      if printHex then begin
        StrCat(ts, ts1);
        StrCat(ts, ' (hex)');
      end
      else begin
        Move(value.pString.ptr^, ts1, value.pString.len);
        ts1[value.pString.len] := Char(0);
        StrCat(ts, ts1);
      end;
    end;
    SNMP_SYNTAX_IPADDR : begin
      charp := value.pString.ptr;
      for i := 1 to value.pString.len do begin
        if i <> 1 then
          StrCat(ts, '.');
        StrCat(ts, PChar(IntToStr(charp^)));
        inc(charp);
      end;
    end;
    SNMP_SYNTAX_BITS : begin
      charp := value.pString.ptr;
      for i := 1 to value.pString.len do begin
        if i <> 1 then
          StrCat(ts, '.');
        StrCat(ts, PChar(IntToHex(charp^, 2)));
        inc(charp);
      end;
      StrCat(ts, ' (hex)');
    end;
    SNMP_SYNTAX_OPAQUE : begin
      charp := value.pString.ptr;
      for i := 1 to value.pString.len do begin
        if i <> 1 then
          StrCat(ts, '.');
        StrCat(ts, PChar(IntToHex(charp^, 2)));
        inc(charp);
      end;
      StrCat(ts, ' (hex)');
    end;
    SNMP_SYNTAX_NSAPADDR: begin
      charp := value.pString.ptr;
      for i := 1 to value.pString.len do begin
        if i <> 1 then
          StrCat(ts, '.');
        StrCat(ts, PChar(IntToHex(charp^, 2)));
        inc(charp);
      end;
      StrCat(ts, ' (hex)');
    end;
    //
    SNMP_SYNTAX_OID : begin
      { check if OID is NULL-OID 0.0 }
      if value.oid.len = 2 then begin
        oidp := value.oid.ptr;
        if oidp^ = 0 then begin
          inc(oidp);
          if oidp^ = 0 then begin
            StrCat(ts, '(null-oid) ');
          end;
        end;
      end;
      { find a string alias for the OID }
      initialNameLen := value.oid.len;
      for j := value.oid.len downto 0 do begin
        value.oid.len := j;
        mibNode := WsmMapOidToNode(@value.oid);
        if (mibNode <> 0) then begin
          i := 500;
          WsmGetNodeString(mibNode, WSM_INFO_NAME, @i, @ts1[0]);
          StrCat(ts, ts1);
          break;
        end;
      end;
      value.oid.len := initialNameLen;
      { append OID reminder to the string }
      oidp := value.oid.ptr;
      inc(oidp, j);
      for i := j + 1 to value.oid.len do begin
        if i <> 1 then
          StrCat(ts, '.');
        StrCat(ts, PChar(IntToStr(oidp^)));
        inc(oidp);
      end;
    end;
    //
    SNMP_SYNTAX_NULL : begin
      StrCat(ts, 'NULL');
    end;
    SNMP_SYNTAX_NOSUCHOBJECT : begin
      StrCat(ts, 'NOSUCHOBJECT');
    end;
    SNMP_SYNTAX_NOSUCHINSTANCE : begin
      StrCat(ts, 'NOSUCHINSTANCE');
    end;
    SNMP_SYNTAX_ENDOFMIBVIEW : begin
      StrCat(ts, 'NOSUCHINSTANCE');
    end;
  end;
  { Write everything to MemoBResult }
  MyWriteLn(ts);
end;

{
  SetMibBrowState
  MIBB32.EXE state machine
}
procedure TFormMB32.SetMibBrowState(state : TMibBrowState);
begin
  case (state) of
    MBS_NOT_INITIALIZED: begin
      MBSem.SemaphoreState := SEM_ERROR;
      SpeedButtonContact.Enabled := False;
      SpeedButtonQuery.Enabled := False;
      SpeedButtonAbort.Enabled := False;
      SpeedButtonClear.Enabled := False;
      SpeedButtonCopyClipboard.Enabled := False;
      MenuContact.Enabled := False;
      MenuBrowse.Enabled := False;
      MenuAbort.Enabled := False;
      MenuCopyResults.Enabled := False;
      MenuClearResults.Enabled := False;
      ComboBoxRSnmpAgent.Enabled := False;
      StatusBar1.Panels.Items[0].Text := 'Initializing...';
      BrowseCount := 0;
    end;
    MBS_NOT_CONTACTED: begin
      MBSem.SemaphoreState := SEM_IDLE;
      StatusBar1.Panels.Items[0].Text := 'Remote SNMP agent not contacted.';
      SpeedButtonContact.Enabled := True;
      SpeedButtonQuery.Enabled := False;
      SpeedButtonAbort.Enabled := False;
      SpeedButtonClear.Enabled := True;
      MenuContact.Enabled := True;
      MenuBrowse.Enabled := False;
      MenuAbort.Enabled := False;
      ComboBoxRSnmpAgent.Enabled := True;
      MenuClearResults.Enabled := True;
    end;
    MBS_ERROR_CONTACT: begin
      MBSem.SemaphoreState := SEM_ERROR;
      StatusBar1.Panels.Items[0].Text := 'Remote SNMP agent ' + ComboBoxRSnmpAgent.Text + ' not responding!';
      SpeedButtonContact.Enabled := True;
      SpeedButtonQuery.Enabled := False;
      SpeedButtonAbort.Enabled := False;
      SpeedButtonClear.Enabled := True;
      MenuContact.Enabled := True;
      MenuBrowse.Enabled := False;
      MenuAbort.Enabled := False;
      MenuClearResults.Enabled := True;
      ComboBoxRSnmpAgent.Enabled := True;
    end;
    MBS_CONTACTING: begin
      MBSem.SemaphoreState := SEM_WORKING;
      StatusBar1.Panels.Items[0].Text := 'Contacting ' + ComboBoxRSnmpAgent.Text + '...';
      SpeedButtonContact.Enabled := False;
      SpeedButtonQuery.Enabled := False;
      SpeedButtonAbort.Enabled := True;
      SpeedButtonClear.Enabled := True;
      MenuContact.Enabled := False;
      MenuBrowse.Enabled := False;
      MenuAbort.Enabled := True;
      MenuClearResults.Enabled := True;
      ComboBoxRSnmpAgent.Enabled := False;
    end;
    MBS_CONTACTED: begin
      MBSem.SemaphoreState := SEM_GO;
      StatusBar1.Panels.Items[0].Text := 'Remote SNMP agent ' + ComboBoxRSnmpAgent.Text + ' contacted.';
      SpeedButtonContact.Enabled := True;
      SpeedButtonQuery.Enabled := True;
      SpeedButtonAbort.Enabled := False;
      SpeedButtonClear.Enabled := True;
      MenuContact.Enabled := True;
      MenuBrowse.Enabled := True;
      MenuAbort.Enabled := False;
      MenuClearResults.Enabled := True;
      ComboBoxRSnmpAgent.Enabled := True;
    end;
    MBS_BROWSING: begin
      MBSem.SemaphoreState := SEM_WORKING;
      StatusBar1.Panels.Items[0].Text := 'Browsing ' + ComboBoxRSnmpAgent.Text + '...';
      MyWrite('');
      MyWrite('***** SNMP BROWSE START *****');
      SpeedButtonContact.Enabled := False;
      SpeedButtonQuery.Enabled := False;
      SpeedButtonAbort.Enabled := True;
      SpeedButtonClear.Enabled := True;
      MenuContact.Enabled := False;
      MenuBrowse.Enabled := False;
      MenuAbort.Enabled := True;
      MenuClearResults.Enabled := True;
      ComboBoxRSnmpAgent.Enabled := False;
    end;
    MBS_FINISH_BROWSING: begin
      MBSem.SemaphoreState := SEM_GO;
      StatusBar1.Panels.Items[0].Text := 'Browse agent ' + ComboBoxRSnmpAgent.Text + ' finished.';
      MyWrite('***** SNMP BROWSE END *****');
      SpeedButtonContact.Enabled := True;
      SpeedButtonQuery.Enabled := True;
      SpeedButtonAbort.Enabled := False;
      SpeedButtonClear.Enabled := True;
      MenuContact.Enabled := True;
      MenuBrowse.Enabled := True;
      MenuAbort.Enabled := False;
      MenuClearResults.Enabled := True;
      ComboBoxRSnmpAgent.Enabled := True;
    end;
    MBS_ABORT_BROWSING: begin
      MBSem.SemaphoreState := SEM_GO;
      StatusBar1.Panels.Items[0].Text := 'Browse agent ' + ComboBoxRSnmpAgent.Text + ' aborted.';
      MyWrite('***** SNMP BROWSE ABORT *****');
      SpeedButtonContact.Enabled := True;
      SpeedButtonQuery.Enabled := True;
      SpeedButtonAbort.Enabled := False;
      SpeedButtonClear.Enabled := True;
      MenuContact.Enabled := True;
      MenuBrowse.Enabled := True;
      MenuAbort.Enabled := False;
      MenuClearResults.Enabled := True;
      ComboBoxRSnmpAgent.Enabled := True;
    end;
    else
      Exit;
  end;
  PanelToolbar.Update;
  StatusBar1.Update;
  ComboBoxRSnmpAgent.Update;
  MibBrowState := state;
end;

{
  Clear the result TMemo
}
procedure TFormMB32.SpeedButtonClearClick(Sender: TObject);
begin
  MemoBResult.Clear;
  StatusBar1.Panels.Items[1].Text := '';
  BrowseCount := 0;
  SpeedButtonCopyClipboard.Enabled := False;
  MenuCopyResults.Enabled := False;
  PanelToolbar.Update;
  MemoBResult.Update;
  StatusBar1.Update;
end;

{
  Abort browse
}
procedure TFormMB32.SpeedButtonAbortClick(Sender: TObject);
begin
  if (MibBrowState = MBS_CONTACTING) then begin
    SetMibBrowState(MBS_NOT_CONTACTED);
    {
      There might be some pending timeouts in the que.
      Reinitializing the agent entity will empty
      the timer que.
    }
    SnmpFreeEntity(se.hAgentEntity);
    se.hAgentEntity := SnmpStrToEntity(se.hSnmpSession, @se.sIPAgent[0]);
  end;
  if (MibBrowState = MBS_BROWSING) then begin
    SetMibBrowState(MBS_ABORT_BROWSING);
    {
      There might be some pending timeouts in the que.
      Reinitializing the agent entity will empty
      the timer que.
    }
    SnmpFreeEntity(se.hAgentEntity);
    se.hAgentEntity := SnmpStrToEntity(se.hSnmpSession, @se.sIPAgent[0]);
  end;
end;

{
  ComboBoxRSnmpAgentChange
  Callback for SNMP Agent change
}
{
  SpeedButtonQueryClick
  Start browsing the remote SNMP agent
}
procedure TFormMB32.SpeedButtonQueryClick(Sender: TObject);
  var
    ts : array[0..255] of Char;
    l, l1 : HWSM_NODE;
    s: SNMPAPI_STATUS;
    toidVal : array[0..MAXOBJIDSIZE] of smiUINT32;
    tOid : smiOID;
begin
  SetMibBrowState(MBS_BROWSING);

  {
    IP address, community and manager address are
    already stored in the 'se' structure.
    Initialize Query information
    Start with selected from MibTreeView
    or with sysDescriptor if nothing is selected
  }
  if se.oid.ptr <> nil then
    SnmpFreeDescriptor(SNMP_SYNTAX_OID, @se.oid);
  se.oid.len := 0;
  //
  se.stopOid.len := 0;
  se.stopOid.ptr := @se.stopOidVal[0];
  { If MibTreeView.Selected = nil this will
    be the first query oid }
  ts := '1.3.6.1.2.1.1.1'; { sysDescr }
  SnmpStrToOid(ts, @se.oid);
  if MibTreeView.Selected <> nil then begin
    { startOid - if an OID is selected in MibTreeView }
    l := WsmMapStrToNode(PChar(MibTreeView.Selected.Text));
    if l <> 0 then begin
      toid.len := 0;
      toid.ptr := @toidVal[0];
      // WsmGetNodeOid requiers pre-allocated ptr field
      s := WsmGetNodeOid(l, WSM_INFO_OID, @toid);
      if (se.oid.ptr <> nil) then begin
        s := SnmpFreeDescriptor(SNMP_SYNTAX_OID, @se.oid);
      end;
      s := SnmpOidCopy(@toid, @se.oid);
      { stopOid - if browse all is not checked }
      if NOT CheckBoxBrowseAll.Checked then begin
        repeat
          l1 := l;
          l := WsmFindNodeNextSibling(l1);
          if l <> 0 then begin
            { stopOid found }
            // se.stopOid already has allocated ptr
            // WsmGetNodeOid requires pre-allocated ptr field
            s := WsmGetNodeOid(l, WSM_INFO_OID, @se.stopOid);
            Break;
          end
            else begin
              l := WsmFindNodeParent(l1);
            end;
        until l = 0;
      end;
    end;
  end;
  // Send first query
  SnmpBrowse(se, True);
end;

{
  SnmpBrowse
  Browse a query
}
procedure TFormMB32.SnmpBrowse(var se: SnmpEntity; updateStatus : Boolean);
  var
    s : SNMPAPI_STATUS;
    ts : array[0..200] of Char;

begin
  se.hVbl := SnmpCreateVbl(se.hSnmpSession, @se.oid, nil);
  {
    you can find more information on requestId in FormCreate!
  }
  Inc(se.requestId);
  se.hPdu := SnmpCreatePdu(se.hSnmpSession, SNMP_PDU_GETNEXT, se.requestId, 0, 0, se.hVbl);

  inc(BrowseCount);

  if (updateStatus) then begin
    s := SnmpOidToStr(@se.oid, 199, @ts[0]);
    if s = SNMPAPI_FAILURE then begin
      StrCopy(@ts[0], '*** TOO LARGE ***');
    end;
  end;


  s := SnmpSendMsg(se.hSnmpSession, se.hManagerEntity, se.hAgentEntity, se.hViewContext, se.hPdu);

  if (updateStatus) then begin
    StatusBar1.Panels.Items[0].Text := 'Query ' + ts + ' ...';
    StatusBar1.Panels.Items[1].Text := IntToStr(BrowseCount);
    StatusBar1.Update;
  end;

  s := SnmpFreeVbl(se.hVbl);
  s := SnmpFreePdu(se.hPdu);

end;

{
  MemoBResultChange
  Enable copy results to clipboard buttons
}
procedure TFormMB32.MemoBResultChange(Sender: TObject);
begin
  SpeedButtonCopyClipboard.Enabled := True;
  MenuCopyResults.Enabled := True;
end;

{
  SpeedButtonCopyClipboardClick
  Copy results to clipboard
}
procedure TFormMB32.SpeedButtonCopyClipboardClick(Sender: TObject);
  var
    SelAll : Boolean;
begin
  if (MemoBResult.SelLength = 0) then begin
    MemoBResult.SelectAll;    // Nothing selected - select all
    SelAll := True;
  end
  else
    SelAll := False;
  MemoBResult.CopyToClipboard;   // Copy data to clipboard
  // Deselect all if nothing selected on start
  If SelAll then
    MemoBResult.SelLength := 0;
end;

{
  InitializeMibTreeView
  This one is used to initialize the MIB tree.
  MIB tree is accessed using the WINMIB32.DLL.
  WINMIB32 is not finished yet.
  Therefore the code is commented out.
}
procedure TFormMB32.InitializeMibTreeView(firstNode: string);
  const
    MIB_TREE_DEPTH = 255;

  label
    Child, Sibling, lError;

  var
    l, l1: HWSM_NODE;
    a, b: LongInt;
    s: SNMPAPI_STATUS;
    j: smiLPINT;
    pc: array[0..255] of Char;
    offset, lastOffset, i: Byte;
    p: PChar;
    oid: smiOID;
    oida: array[0..MAXOBJIDSIZE] of smiUINT32;
    LastParentIndex: Integer;
    cParentIndex: array[0..MIB_TREE_DEPTH] of TTreeNode;

begin
  MibTreeView.Selected := nil;
  MibTreeView.Items.Clear;
  MibTreeView.ShowRoot := True;
  MibTreeView.ShowLines := True;


  oid.ptr := @oida[0];
  for i := 0 to MIB_TREE_DEPTH do
    cParentIndex[i] := nil;   { rememberes last index in depth }
  lastOffset := 0;     { Must be 0, points to the last offset depth! }
  offset := 1;         { Must be 1, points to the new offset depth! }
  p := @pc[0];         { Buffer for PChar string }
  StrPCopy(p, firstNode); { Convert PAS string to PChar string }

  l := WsmMapStrToNode(p);
  if l = SNMPAPI_FAILURE then begin
    MessageDlg('MibTreeView WsmMapStrToNode error', mtInformation, [mbOk], 0);
    goto lError;
  end;

   Child:
    repeat
      a := 100;
      j := @a;
      s := WsmGetNodeString(l, WSM_INFO_NAME, j, @pc[0]);
      if (lastOffset < offset) then
        cParentIndex[offset] := MibTreeView.Items.AddChildObject(cParentIndex[offset - 1], StrPas(@pc[0]), nil)
      else
        cParentIndex[offset] := MibTreeView.Items.AddObject(cParentIndex[offset], StrPas(@pc[0]), nil);

      s := WsmGetNodeOid(l, WSM_INFO_OID, @oid);
      {find a child}
      l1 := l;
      l := WsmFindNodeChild(l);
      lastOffset := offset;
      offset := offset + 1;
    until l = 0;
   Sibling:
    l := WsmFindNodeNextSibling(l1);
    if l <> 0 then begin
      lastOffset := offset;
      offset := offset - 1;
      l1 := l;
      goto Child;
    end
    else begin
      l := WsmFindNodeParent(l1);
      if l <> 0 then begin
        lastOffset := offset;
        offset := offset - 1;
        l1 := l;
        goto Sibling;
      end;
    end;
 lError:
end;

{
  MenuContactClick
}
procedure TFormMB32.MenuContactClick(Sender: TObject);
begin
  SpeedButtonContactClick(Sender);
end;

{
  MenuBrowseClick
}
procedure TFormMB32.MenuBrowseClick(Sender: TObject);
begin
  SpeedButtonQueryClick(Sender);
end;

{
  MenuCopyResultsClick
}
procedure TFormMB32.MenuCopyResultsClick(Sender: TObject);
begin
  SpeedButtonCopyClipboardClick(Sender);
end;

{
  MenuClearResultsClick
}
procedure TFormMB32.MenuClearResultsClick(Sender: TObject);
begin
  SpeedButtonClearClick(Sender);
end;

{
  MenuAbortClick
}
procedure TFormMB32.MenuAbortClick(Sender: TObject);
begin
  SpeedButtonAbortClick(Sender);
end;

{
  ReadRegIni
  Read startup defaults from the registry
}
procedure TFormMB32.ReadRegIni;
  var
    Section: String;
    Value: String;
    i, j : Integer;
    isMember : Boolean;
begin
  RegIni := TRegIniFile.Create(RegInitKey);
  with RegIni do
  begin
    // Window position
    Section := 'Startup';
    Top := ReadInteger(Section, 'Top', 20);
    Left := ReadInteger(Section, 'Left', 20);
    // SNMP
    EditRetransmit.Text := ReadString(Section, 'Retransmits', '4');
    EditTimeout.Text := ReadString(Section, 'Timeout', '500');
    EditCommunity.Text := ReadString(Section, 'Community', 'public');
    //
    CheckBoxBrowseAll.Checked := Boolean(ReadInteger(Section, 'Browse all', Longint(False)));
    CheckBoxExitConfirmation.Checked := Boolean(ReadInteger(Section, 'Exit confirmation', Longint(True)));
    //
    RadioButtonPollNo.Checked := Boolean(ReadInteger(Section, 'Info forms polling no', Longint(False)));
    RadioButtonPollYes.Checked := Boolean(ReadInteger(Section, 'Info forms polling yes', Longint(True)));
    Polling1.Checked := RadioButtonPollYes.Checked;
    // Ping
    EditPingHost.Text := ReadString(Section, 'Ping host', '0.0.0.0');
    // Mibb32 Favorites
    Section := 'Favorites';
    ComboBoxRSnmpAgent.Text := ReadString(Section, '0', '0.0.0.0');
    CurrentRSnmpAgentComboBoxEntry := ComboBoxRSnmpAgent.Text;
    for i := 0 to 7 do begin
      Value := ReadString(Section, IntToStr(i + 1), '');
      if Value <> '' then begin
        isMember := False;
        for j := 0 to ComboBoxRSnmpAgent.Items.Count do begin
          if ComboBoxRSnmpAgent.Items[j] = Value then begin
            isMember := True;
            Break;
          end;
        end;
        if NOT isMember then begin
          ComboBoxRSnmpAgent.Items.Add(Value);
        end;
      end;
    end;
  end;
  RegIni.Destroy;
end;

{
  WriteRegIni
  Write startup defaults to the registry
}
procedure TFormMB32.WriteRegIni;
  var
    Section: String;
    Value: String;
    i : Integer;
begin
  RegIni := TRegIniFile.Create(RegInitKey);
  with RegIni do
  begin
    // Window position
    Section := 'Startup';
    WriteInteger(Section, 'Top', Top);
    WriteInteger(Section, 'Left', Left);
    // SNMP
    WriteString(Section, 'SNMP Manager', EditManager.Text);
    WriteString(Section, 'Retransmits', EditRetransmit.Text);
    WriteString(Section, 'Timeout', EditTimeout.Text);
    WriteString(Section, 'Community', EditCommunity.Text);
    //
    WriteInteger(Section, 'Browse all', LongInt(CheckBoxBrowseAll.Checked));
    WriteInteger(Section, 'Exit confirmation', LongInt(CheckBoxExitConfirmation.Checked));
    //
    WriteInteger(Section, 'Info forms polling no', LongInt(RadioButtonPollNo.Checked));
    WriteInteger(Section, 'Info forms polling yes', LongInt(RadioButtonPollYes.Checked));
    // Ping
    WriteString(Section, 'Ping host', EditPingHost.Text);
    // Mibb32 favorites
    Section := 'Favorites';
    WriteString(Section, IntToStr(0), ComboBoxRSnmpAgent.Text);
    for i := 0 to ComboBoxRSnmpAgent.Items.Count - 1 do begin
      WriteString(Section, IntToStr(i + 1), ComboBoxRSnmpAgent.Items[i]);
    end;
  end;
  RegIni.Destroy;
end;

{
  ButtonApplyOptionsClick
}
procedure TFormMB32.ButtonApplyOptionsClick(Sender: TObject);
begin
  StrCopy(se.sIPAgent, PChar(ComboBoxRSnmpAgent.Text));
  MyWriteLn('Remote IP: ' + se.sIPAgent);
  // Get Manager IP string from ComboBoxLSnmpManager
  StrCopy(se.sIPManager, PChar(EditManager.Text));
  MyWriteLn('Local IP: ' + se.sIPManager);
  // Get Community name
  se.smiCommunity.len := StrLen(PChar(EditCommunity.Text));   { WinSnmp needs community in smiOctets format}
  se.smiCommunity.ptr := PByte(EditCommunity.Text);
  // Set timeouts/retries
  SnmpSetRetry(se.hManagerEntity, StrToInt(EditRetransmit.Text));
  SnmpSetTimeout(se.hManagerEntity, StrToInt(EditTimeout.Text));
  SnmpSetRetry(se.hAgentEntity, StrToInt(EditRetransmit.Text));
  SnmpSetTimeout(se.hAgentEntity, StrToInt(EditTimeout.Text));
  SnmpSetRetransmitMode(SNMPAPI_ON);
end;

{
  ComboBoxRSnmpAgentKeyPress
}
procedure TFormMB32.ComboBoxRSnmpAgentKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key = Char(13) then begin
    ComboBoxRSnmpAgentClick(Sender);
    Key := Char(0);
  end;
end;



{
  PingWriteLn
  Memo ping results output.
}
procedure TFormMB32.PingWriteLn(s : string);
begin
  {
    Still haven't figured out how much
    chars can be maximum in TMemo. Let's say
    29000 is reasonable ammount.
  }
  MemoPingResults.Lines.BeginUpdate;
  while MemoPingResults.GetTextLen >= 29000 do begin
    MemoPingResults.Lines.Delete(0);
  end;
  while MemoPingResults.Lines.Count > 500 do begin
    MemoPingResults.Lines.Delete(0);
  end;
  MemoPingResults.Lines.EndUpdate;
  // Add a line
  MemoPingResults.Lines.Add(s);
end;


{
  StartPingClick
  Microsoft Win95/NT icmp.dll usage demo
}
procedure TFormMB32.StartPingClick(Sender: TObject);

  var
    requestDataLen : Integer;
    requestBytes : Integer;
    requestTimeout : Integer;
    requestData : array[0..1600] of Byte;
    replyData : array[0..1600] of Byte;
    rv : DWORD;
    ipoi : TIpOptionInformation;
    ier : ^TIcmpEchoReply;
    pc : PChar;
    replyAddress : ^SunB;
    timeString : String;
    remoteNodeAddress : LongInt;
    i, j : Integer;
    lastRequestTimedOut : Boolean;



begin
  // icmp initialized?
  if hIcmp = 0 then begin
    PingWriteLn('ERROR: Could not initialize icmp.');
    Exit;
  end;

  requestBytes := StrToInt(EditPingBytes.Text);
  if (requestBytes < 1) OR (requestBytes > 1400) then begin
    requestBytes := 32;
    EditPingBytes.Text := '32';
  end;

  requestTimeout := StrToInt(EditPingTimeout.Text);
  if requestTimeout < 1 then begin
    requestTimeout := 1000;
    EditPingTimeout.Text := '1000';
  end;

  ipoi.Ttl := 32;
  ipoi.Tos := 0;
  if CheckBoxPingDontFragment.Checked = True then
    ipoi.Flags := IP_FLAG_DF
  else
    ipoi.Flags := 0;
  ipoi.OptionsSize := 0;
  ipoi.OptionsData := nil;

  remoteNodeAddress := inet_addr(PChar(EditPingHost.Text));
  if remoteNodeAddress = INADDR_NONE then begin
    PingWriteLn('Bad IP address ' + EditPingHost.Text);
    Exit;
  end;

  PingWriteLn('Pinging ' + EditPingHost.Text
              + ' with ' + IntToStr(requestBytes)
              + ' bytes of data:');
  PingWriteLn('');

  StrCopy(@requestData[0], PChar('MG-SOFT'));

  j := 0;
  j := StrToInt(EditPingRequests.Text);
  if j < 1 then
    j := 4;
  lastRequestTimedOut := False;
  for i := 1 to j do begin
    if (i <> 1) AND (NOT lastRequestTimedOut) then begin
      Sleep(1000);
    end;

    // Send ICMP request
    rv := IcmpSendEcho(hIcmp,
                       remoteNodeAddress,// htonl($c009c862),
                       @requestData[0],
                       requestBytes,
                       @ipoi,
                       @replyData[0],
                       1500,
                       requestTimeout
                       );
    if rv = 0 then begin
      rv := GetLastError();
      case rv of
        IP_REQ_TIMED_OUT: begin
          PingWriteLn('Request timed out.');
          lastRequestTimedOut := True;
        end;
        IP_PACKET_TOO_BIG: begin
          PingWriteLn('Packet needs to be fragmented but DF set.');
        end;
        else
          PingWriteLn('Error: ' + IntToStr(rv));
      end;
      Continue;
    end;
    lastRequestTimedOut := False;

    ier := @replyData[0];

    if ier.RoundTripTime < 1 then begin
      timeString := '<10';
    end
    else begin
      timeString := '=' + IntToStr(ier.RoundTripTime);
    end;

    replyAddress := @ier.Address;
    PingWriteLn('Reply from '
      + IntToStr(Integer(replyAddress.s_b1))
      + '.' + IntToStr(Integer(replyAddress.s_b2))
      + '.' + IntToStr(Integer(replyAddress.s_b3))
      + '.' + IntToStr(Integer(replyAddress.s_b4))
      + ': bytes=' + IntToStr(ier.DataSize)
      + ', time' + timeString + 'ms'
      + ', TTL=' + IntToStr(ier.Options.Ttl)

    );
  end; // for
  PingWriteLn('');
  PingWriteLn('OK.');
  PingWriteLn('');
end;

procedure TFormMB32.SpeedButtonInfoClick(Sender: TObject);
  var
    i : Integer;
    foundFreeDescriptor : Boolean;
begin
  if infoFormsCount < MAX_INFO_FORMS then begin
    foundFreeDescriptor := False;
    for i := 0 to MAX_INFO_FORMS do begin
      if InfoForm[i] = nil then begin
        foundFreeDescriptor := True;
        Break;
      end;
    end;
    if NOT foundFreeDescriptor then
      Exit;
    Application.CreateForm(TInfoForm, InfoForm[i]);
    InfoForm[i].SelfIndex := i;
    InfoForm[i].SetCaption('Info ' + IntToStr(i + 1));
    InfoForm[i].Show;
    InfoForm[i].MenuItem := TMenuItem.Create(Self);
    InfoForm[i].MenuItem.OnClick := InfoForm[i].WindowsSubMenuClick;
    if NOT FormDiscover.DiscoverFormStartInfoFormPending then
      InfoForm[i].GetMyFavoriteAddress
    else begin
      InfoForm[i].SetMyFavoriteAddress(FormDiscover.DiscoverListView.Selected.SubItems[0]);
    end;
    if RadioButtonPollYes.Checked then
      InfoForm[i].EnablePolling
    else
      InfoForm[i].DisablePolling;
    InfoForm[i].MenuItem.Caption := InfoForm[i].Caption + '  ' + InfoForm[i].ComboBoxRSnmpAgent.Text;
    if infoFormsCount = 0 then
      InfoWindows.Add(InfoForm[i].MenuItem)
    else
      InfoWindows.Insert(i, InfoForm[i].MenuItem);
    if infoFormsCount >= MAX_INFO_FORMS then
      FormMB32.SpeedButtonInfo.Enabled := False;
    InfoForm[i].ComboBoxRSnmpAgentClick(InfoForm[i]);
  end;
end;

procedure TFormMB32.ComboBoxRSnmpAgentClick(Sender: TObject);
  var
    i : Integer;
    isMember : Boolean;
begin
  SetMibBrowState(MBS_NOT_CONTACTED);
  StrCopy(se.sIPAgent, PChar(ComboBoxRSnmpAgent.Text));
  isMember := False;
  for i := 0 to ComboBoxRSnmpAgent.Items.Count do begin
    if ComboBoxRSnmpAgent.Items[i] = CurrentRSnmpAgentComboBoxEntry then begin
      isMember := True;
      Break;
    end;
  end;
  if NOT isMember then begin
    ComboBoxRSnmpAgent.Items.Insert(0, CurrentRSnmpAgentComboBoxEntry);
    if ComboBoxRSnmpAgent.Items.Count >= 8 then
      ComboBoxRSnmpAgent.Items.Delete(8);
  end;
  CurrentRSnmpAgentComboBoxEntry := ComboBoxRSnmpAgent.Text;
  SpeedButtonContactClick(Sender);
end;

{
  FormCloseQuery

  Close confirmation message box
}
procedure TFormMB32.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if CheckBoxExitConfirmation.Checked then
    if MessageDlg('Close Mib Browser?', mtConfirmation,
      [mbOk, mbCancel], 0) = mrCancel then
        CanClose := False;
end;

{
  RadioButtonPollNoClick

  Disable InfoForm polling for all forms
}
procedure TFormMB32.RadioButtonPollNoClick(Sender: TObject);
  var
    i : Integer;
begin
  Polling1.Checked := NOT RadioButtonPollNo.Checked;
  for i := 0 to MAX_INFO_FORMS do begin
    if InfoForm[i] <> nil then begin
      InfoForm[i].DisablePolling;
    end;
  end;
end;

{
  RadioButtonPollNoClick

  Enable InfoForm polling for all forms
}
procedure TFormMB32.RadioButtonPollYesClick(Sender: TObject);
  var
    i : Integer;
begin
  Polling1.Checked := RadioButtonPollYes.Checked;
  for i := 0 to MAX_INFO_FORMS do begin
    if InfoForm[i] <> nil then begin
      InfoForm[i].EnablePolling;
    end;
  end;
end;


procedure TFormMB32.Closeall1Click(Sender: TObject);
  var
    i : Integer;
begin
  { Destroy InfoForms }
  for i := 0 to MAX_INFO_FORMS do begin
    if InfoForm[i] <> nil then begin
      InfoForm[i].Destroy;
      InfoForm[i] := nil;
    end;
  end;
end;

procedure TFormMB32.Polling1Click(Sender: TObject);
begin
  Polling1.Checked := NOT Polling1.Checked;
  RadioButtonPollYes.Checked := Polling1.Checked;
  RadioButtonPollNo.Checked := NOT Polling1.Checked;
end;

procedure TFormMB32.Cascade1Click(Sender: TObject);
begin
  CascadeWindows(True);
  BringToFront;
end;

procedure TFormMB32.Cascade2Click(Sender: TObject);
begin
  CascadeWindows(False);
  BringToFront;
end;

procedure TFormMB32.CascadeWindows(oneToMax : Boolean);
  var
    i : Integer;
    topStep, leftStep : Integer;
    currentBottom, currentLeft : Integer;
    currentTop, currentRight : Integer;
    cascadeColumnStep, cascadeColumnCounter : Integer;
    max, min : Integer;

  procedure position;
  begin
    if InfoForm[i] <> nil then begin
      if InfoForm[i].WindowState <> wsMinimized then begin
        // Check if right screen margin is reached
        currentRight := currentLeft + InfoForm[i].Width;
        // Check if top screen margin is reached
        currentTop := currentBottom - InfoForm[i].Height;
        if currentTop < 0 then begin
          Inc(cascadeColumnCounter);
          // Row step for X axis (after IP status panel)
          cascadeColumnStep := InfoForm[i].StatusBar1.Panels[0].Width +
                               InfoForm[i].StatusBar1.Panels[1].Width +
                               InfoForm[i].StatusBar1.Panels[2].Width + 3;
          if ((currentLeft + cascadeColumnStep) > Screen.Width) then begin
            cascadeColumnCounter := 0;
          end;
          currentLeft := cascadeColumnCounter * cascadeColumnStep;
          currentBottom := Screen.Height; // - cascadeColumnCounter * topStep;
        end;
        InfoForm[i].Left := currentLeft;
        InfoForm[i].Top := currentBottom - InfoForm[i].height;
        currentBottom := currentBottom - topStep;
        currentLeft := currentLeft + leftStep;
        // Bring form to front
        InfoForm[i].BringToFront;
      end;
    end;
  end;

begin
  topStep := StatusBar1.Height;   // Step for Y axis
//  leftStep := 15;               // Step for X axis
  leftStep := 0;                  // Step for X axis
  currentBottom := Screen.Height; // Current bottom pos
  currentLeft := 0;               // Current left pos
  cascadeColumnStep := 60;        // Row step for X axis
  cascadeColumnCounter := 0;      // Row counter
  if oneToMax then begin
    for i := 0 to MAX_INFO_FORMS do begin
      position;
    end;
  end
  else begin
    for i := MAX_INFO_FORMS downto 0 do begin
      position;
    end;
  end;
end;

procedure TFormMB32.MinimizeAll1Click(Sender: TObject);
  var
    i : Integer;
begin
  for i := 0 to MAX_INFO_FORMS do begin
    if InfoForm[i] <> nil then begin
      InfoForm[i].WindowState := wsMinimized;
    end;
  end;
end;

procedure TFormMB32.MaximizaAll1Click(Sender: TObject);
  var
    i : Integer;
begin
  for i := 0 to MAX_INFO_FORMS do begin
    if InfoForm[i] <> nil then begin
      InfoForm[i].WindowState := wsNormal;
    end;
  end;
end;

procedure TFormMB32.MainToFront1Click(Sender: TObject);
begin
  BringToFront;
end;

procedure TFormMB32.MinimizedToFront1Click(Sender: TObject);
  var
    i : Integer;
begin
  for i := 0 to MAX_INFO_FORMS do begin
    if InfoForm[i] <> nil then begin
      if InfoForm[i].WindowState = wsMinimized then begin
        InfoForm[i].BringToFront;
      end;
    end;
  end;
end;

procedure TFormMB32.NormalToFront1Click(Sender: TObject);
  var
    i : Integer;
begin
  for i := 0 to MAX_INFO_FORMS do begin
    if InfoForm[i] <> nil then begin
      if InfoForm[i].WindowState = wsNormal then begin
        InfoForm[i].BringToFront;
      end;
    end;
  end;
end;

procedure TFormMB32.SpeedButtonDiscoverClick(Sender: TObject);
begin
  FormDiscover.Show;
end;

end.
