/****************************************************************************
 * FILE:		    wsnmpmib.h
 * DESCRIPTION: This file contains the defines, data structures, typedefs
 *                         and function prototypes necessary to implement the
 *                         winSNMP/MIB API
 * MODIFICATION: (10/18/93) Created
 ****************************************************************************/

#ifndef _INC_WSNMPMIB
#define _INC_WSNMPMIB

#ifndef _INC_WINDOWS
#include <windows.h>
#define _INC_WINDOWS
#endif

#ifndef _INC_WINSNMP
#include "winsnmp.h"               /* includes winsnmp.h for compatibility */
#endif

/* windows related types */
typedef HANDLE HWSM_NODE, 		FAR *LPHWSM_NODE;
typedef HANDLE HWSM_LISTELEMENT,   	FAR *LPHWSM_LISTELEMENT;

/* status values */
#define WSM_STATUS_MANDATORY			1
#define WSM_STATUS_OPTIONAL			2
#define WSM_STATUS_OBSOLETE			3
#define WSM_STATUS_DEPRECATED		        4
#define WSM_STATUS_CURRENT			5

/* access values */
#define WSM_ACCESS_READONLY			1
#define WSM_ACCESS_READWRITE			2
#define WSM_ACCESS_WRITEONLY			3
#define WSM_ACCESS_NOTACCESSIBLE		4
#define WSM_ACCESS_READCREATE		        5

/* flag values */
#define WSM_YES_FLAG				1
#define WSM_NO_FLAG				2

/* error codes returned by WsmGetLastError(), so as not to    */
/* conflict with the error codes from winSNMP                 */
#define WSM_NODE_UNKNOWN                   	200
#define WSM_NODE_AMBIGUOUS                 	201
#define WSM_NODE_NONE                      	202
#define WSM_NODE_NOINFO                    	203
#define WSM_NODE_TRUNCATED                	204
#define WSM_LISTELEMENT_UNKNOWN            	205
#define WSM_LISTELEMENT_AMBIGUOUS          	206
#define WSM_LISTELEMENT_NONE               	207
#define WSM_LISTELEMENT_NOINFO             	208
#define WSM_LISTELEMENT_TRUNCATED          	209
#define WSM_MODULE_NOTLOADED               	210
#define WSM_MODULE_NOTUNLOADED             	211
//
#define WSM_ALLOC_ERROR						297
#define WSM_MODULE_NOT_REGISTERED			294
#define WSM_MODULE_UNLINK_ERROR				295
#define WSM_MODULE_LINK_ERROR				296
#define WSM_MODULE_DATABASE_ERROR			297
//
#define WSM_TLS_FAILURE						298
#define WSM_NOT_INITIALIZED					299


/* information identifiers */
#define WSM_INFO_TYPE                      	1
#define WSM_INFO_NAME                      	2
#define WSM_INFO_OID                       	3
#define WSM_INFO_LAST_UPDATED              	4
#define WSM_INFO_ORGANIZATION              	5
#define WSM_INFO_CONTACT                   	6
#define WSM_INFO_DESCRIPTION               	7
#define WSM_INFO_REVISIONS                 	8
#define WSM_INFO_STATUS                    	9
#define WSM_INFO_REFERENCE                 	10
#define WSM_INFO_SYNTAX                    	11
#define WSM_INFO_SYNTAXSIZES               	12
#define WSM_INFO_SYNTAXVALS                	13
#define WSM_INFO_TEXTCONV_NAME             	14
#define WSM_INFO_TEXTCONV_DISPHINT         	15
#define WSM_INFO_TEXTCONV_STATUS           	16
#define WSM_INFO_TEXTCONV_DESCR            	17
#define WSM_INFO_TEXTCONV_REFER            	18
#define WSM_INFO_UNITS                     	19
#define WSM_INFO_MAXACCESS                 	20
#define WSM_INFO_INDEXES                   	21
#define WSM_INFO_AUGMENTS                  	22
#define WSM_INFO_DEFVAL                    	23
#define WSM_INFO_OBJECTS                   	24
#define WSM_INFO_ENTERPRISE                	25
#define WSM_INFO_INTVALUE                  	26
// #define WSM_INFO_OBJECTS                   	27
#define WSM_INFO_MCMODULES                 	28
#define WSM_INFO_PRODUCTREL                	29
#define WSM_INFO_ACMODULES                 	30
#define WSM_INFO_REVISION                  	31
#define WSM_INFO_IMPLIED                   	32
#define WSM_INFO_MINSIZE                   	33
#define WSM_INFO_MAXSIZE                   	34
#define WSM_INFO_VALUEINT                  	35
#define WSM_INFO_VALUELABEL                	36
#define WSM_INFO_MANDGROUPS                	37
#define WSM_INFO_MCOMPS                    	38
#define WSM_INFO_GROUPTYPE                 	39
#define WSM_INFO_OBJECTTYPE                	40
#define WSM_INFO_WRITESYNTAX               	41
#define WSM_INFO_WSYNTAXSIZES              	42
#define WSM_INFO_WSYNTAXVALS               	43
#define WSM_INFO_MINACCESS                 	44
#define WSM_INFO_SUPPORT                   	45
#define WSM_INFO_INCLUDES                  	46
#define WSM_INFO_VARIABLES                 	47
#define WSM_INFO_ACCESS                    	48
#define WSM_INFO_CREATIONS                 	49
#define WSM_INFO_MODULE                  	50

/* Node types */
#define WSM_MODULE_IDENTITY                	1
#define WSM_OBJECT_IDENTITY                	2
#define WSM_OBJECT_TYPE                    	3
#define WSM_NOTIFICATION_TYPE              	4
#define WSM_OBJECT_GROUP                   	5
#define WSM_MODULE_COMPLIANCE              	6
#define WSM_AGENT_CAPABILITIES             	7

/* ListElement types */
#define WSM_REV_LIST                       	20
#define WSM_INDEX_LIST                     	21
#define WSM_SIZE_LIST                      	22
#define WSM_VALUE_LIST                     	23
#define WSM_OBJECT_LIST                    	24
#define WSM_MCMOD_LIST                     	25
#define WSM_MCCOMP_LIST                    	26
#define WSM_ACMOD_LIST                     	27
#define WSM_ACVAR_LIST                     	28

/* function prototypes: IN and OUT are for information purposes only */
#define WSM_CALL         WINAPI          /* for PASCAL calling conventions */


#ifdef __cplusplus
extern "C" {
#endif
__declspec(dllexport)
HWSM_NODE WSM_CALL WsmMapStrToNode
								  (IN  LPSTR   			nodeString);
__declspec(dllexport)
HWSM_NODE WSM_CALL WsmMapOidToNode
								  (IN  smiLPOID 		oid);
__declspec(dllexport)
HWSM_NODE WSM_CALL WsmFindNodeChild
								  (IN  HWSM_NODE 		hNode);
__declspec(dllexport)
HWSM_NODE WSM_CALL WsmFindNodeParent
								  (IN  HWSM_NODE 		hNode);
__declspec(dllexport)
HWSM_NODE WSM_CALL WsmFindNodeNextSibling
								  (IN  HWSM_NODE 		hNode);
__declspec(dllexport)
HWSM_NODE WSM_CALL WsmFindNodePrevSibling
								  (IN  HWSM_NODE 		hNode);
__declspec(dllexport)
HWSM_LISTELEMENT WSM_CALL WsmFindNextListElement
								  (IN  HWSM_LISTELEMENT 	hListElement);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmGetNodeOid
								  (IN  HWSM_NODE 		hNode,
									IN  smiINT    		infoID,
									OUT smiLPOID  		oid);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmGetNodeInt
                          (IN  HWSM_NODE 		hNode,
                           IN  smiINT   		infoID,
                           OUT smiLPINT  		lpInt);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmGetNodeString
                          (IN  HWSM_NODE    		hNode,
                           IN  smiINT       		infoID,
                           IN OUT smiLPINT  		lpStrlen,
                           OUT LPSTR        		string);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmGetNodeList
                          (IN  HWSM_NODE    		hNode,
                           IN  smiINT       		infoID,
                           OUT LPHWSM_LISTELEMENT       lphListElement);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmGetListElementOid
                          (IN  HWSM_LISTELEMENT 	hListElement,
                           IN  smiINT    		infoID,
                           OUT smiLPOID  		oid);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmGetListElementInt
								  (IN  HWSM_LISTELEMENT 	hListElement,
                           IN  smiINT    		infoID,
                           OUT smiLPINT  		lpInt);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmGetListElementString
								  (IN  HWSM_LISTELEMENT 	hListElement,
									IN  smiINT    		infoID,
									IN OUT smiLPINT  		lpStrlen,
									OUT LPSTR        		string);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmGetListElementList
								  (IN  HWSM_LISTELEMENT 	hListElement,
									IN  smiINT    		infoID,
									OUT LPHWSM_LISTELEMENT       lphListElement);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmGetLastError
								  (void);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmFreeList
								  (HWSM_LISTELEMENT 	        hListElement);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmLoadModule
								  (LPSTR 			module);
__declspec(dllexport)
SNMPAPI_STATUS WSM_CALL WsmUnloadModule
								  (LPSTR 			module);

#ifdef __cplusplus
}
#endif

#endif   /* _INC_WSNMPMIB  */
