{
  WinSnmp.Pas

  WinSnmp Delphi header file.
  Converted by MG-SOFT d.o.o. 
    E-mail: info@mg-soft.si
    Web URL: http://www.mg-soft.si/

  Source for conversion:
    Windows SNMP API Specification V1.1
    12 June 1994
    WinSnmp.H
}
unit WinSnmp;

interface

uses WinTypes, WinProcs;

{ ASN/BER Base Types }
{ used in forming SYNTAXes and certain SNMP types/values }
const
  ASN_UNIVERSAL       =  ($00);
  ASN_APPLICATION     =  ($40);
  ASN_CONTEXT         =  ($80);
  ASN_PRIVATE         =  ($C0);
  ASN_PRIMITIVE       =  ($00);
  ASN_CONSTRUCTOR     =  ($20);

  { SNMP ObjectSyntax Values }
  SNMP_SYNTAX_SEQUENCE  = (ASN_CONTEXT or ASN_CONSTRUCTOR or $10);
  { These values are used in the "syntax" member of the smiVALUE structure which follows }
  SNMP_SYNTAX_INT       = (ASN_UNIVERSAL or ASN_PRIMITIVE or $02);
  SNMP_SYNTAX_BITS      = (ASN_UNIVERSAL or ASN_PRIMITIVE or $03);
  SNMP_SYNTAX_OCTETS    = (ASN_UNIVERSAL or ASN_PRIMITIVE or $04);
  SNMP_SYNTAX_NULL      = (ASN_UNIVERSAL or ASN_PRIMITIVE or $05);
  SNMP_SYNTAX_OID       = (ASN_UNIVERSAL or ASN_PRIMITIVE or $06);
  SNMP_SYNTAX_INT32     = (ASN_UNIVERSAL or ASN_PRIMITIVE or $02);   { SNMP_SYNTAX_INT; }
  SNMP_SYNTAX_IPADDR    = (ASN_APPLICATION or ASN_PRIMITIVE or $00);
  SNMP_SYNTAX_CNTR32    = (ASN_APPLICATION or ASN_PRIMITIVE or $01);
  SNMP_SYNTAX_GAUGE32   = (ASN_APPLICATION or ASN_PRIMITIVE or $02);
  SNMP_SYNTAX_TIMETICKS = (ASN_APPLICATION or ASN_PRIMITIVE or $03);
  SNMP_SYNTAX_OPAQUE    = (ASN_APPLICATION or ASN_PRIMITIVE or $04);
  SNMP_SYNTAX_NSAPADDR  = (ASN_APPLICATION or ASN_PRIMITIVE or $05);
  SNMP_SYNTAX_CNTR64    = (ASN_APPLICATION or ASN_PRIMITIVE or $06);
  SNMP_SYNTAX_UINT32    = (ASN_APPLICATION or ASN_PRIMITIVE or $07);
  { Exception conditions in response PDUs for SNMPv2 }
  SNMP_SYNTAX_NOSUCHOBJECT   = (ASN_CONTEXT or ASN_PRIMITIVE or $00);
  SNMP_SYNTAX_NOSUCHINSTANCE = (ASN_CONTEXT or ASN_PRIMITIVE or $01);
  SNMP_SYNTAX_ENDOFMIBVIEW   = (ASN_CONTEXT or ASN_PRIMITIVE or $02);


type
  { Temporary types }
  UINT = LongInt;
  LPCSTR = PChar;
  LPSTR = PChar;

  { WinSNMP API Type Definitions  }
  HSNMP_SESSION = THandle;      LPHSNMP_SESSION = PHandle;
  HSNMP_ENTITY = THandle;       LPHSNMP_ENTITY = PHandle;
  HSNMP_CONTEXT = THandle;      LPHSNMP_CONTEXT = PHandle;
  HSNMP_PDU = THandle;          LPHSNMP_PDU = PHandle;
  HSNMP_VBL = THandle;          LPHSNMP_VBL = PHandle;

  smiBYTE = Byte;              smiLPBYTE = PByte;
  { SNMP-related types from RFC1442 (SMI) }
  smiINT = LongInt;            smiLPINT = PLongInt;
  smiINT32 = LongInt;          smiLPINT32 = PLongInt;
  { LongInt is signed! Differes from C, C++ }
  { There is no unsigned LongInt in Delphi }
  smiUINT32 = LongInt;
  smiLPUINT32 = PLongInt;
  smiOCTETS = record
    len : smiUINT32;
    ptr : smiLPBYTE;
  end;                         smiLPOCTETS = ^smiOCTETS;

  smiLPCOCTETS = ^smiOCTETS;
  smiBITS = smiOCTETS;         smiLPBITS = ^smiOCTETS;

  smiOID = record
    len : smiUINT32;
    ptr : smiLPUINT32;
  end;                         smiLPOID = ^smiOID;
  smiLPCOID = ^smiOID;

  smiIPADDR = smiOCTETS;       smiLPIPADDR = ^smiOCTETS;
  smiCNTR32 = smiUINT32;       smiLPCNTR32 = ^smiUINT32;
  smiGAUGE32 = smiUINT32;      smiLPGAUGE32 = ^smiUINT32;
  smiTIMETICKS = smiUINT32;    smiLPTIMETICKS = ^smiUINT32;
  smiOPAQUE = smiOCTETS;       smiLPOPAQUE = ^smiOCTETS;
  smiNSAPADDR = smiOCTETS;     smiLPNSAPADDR = ^smiOCTETS;

  smiCNTR64 = record
    hipart : smiUINT32;
    lopart : smiUINT32;
  end;                         smiLOCNTR64 = ^smiCNTR64;

type
  smiVALUE = record                 { smiVALUE portion of VarBind }
    case syntax : smiUINT32 of      { Insert SNMP_SYNTAX_<type> }
       {SNMP_SYNTAX_INT,}
       SNMP_SYNTAX_INT32 :          (sNumber : smiINT);
       SNMP_SYNTAX_UINT32,
       SNMP_SYNTAX_CNTR32,
       SNMP_SYNTAX_GAUGE32,
       SNMP_SYNTAX_TIMETICKS :      (uNumber : smiUINT32);
       SNMP_SYNTAX_CNTR64 :         (hNumber : smiCNTR64);
       SNMP_SYNTAX_OCTETS,
       SNMP_SYNTAX_BITS,
       SNMP_SYNTAX_OPAQUE,
       SNMP_SYNTAX_IPADDR,
       SNMP_SYNTAX_NSAPADDR :       (pString : smiOCTETS);
       SNMP_SYNTAX_OID :            (oid : smiOID);
       SNMP_SYNTAX_NULL,
       SNMP_SYNTAX_NOSUCHOBJECT,
       SNMP_SYNTAX_NOSUCHINSTANCE,
       SNMP_SYNTAX_ENDOFMIBVIEW :   (empty : smiBYTE);
  end;
  smiLPVALUE = ^smiVALUE;
  smiLPCVALUE = ^smiVALUE;

const
  { SNMP Limits   }
  MAXOBJIDSIZE     = 128;  { Max number of components in an OID }
  MAXOBJIDSTRSIZE  = 1408; { Max len of decoded MAXOBJIDSIZE OID }

  { PDU Type Values }
  SNMP_PDU_GET          = (ASN_CONTEXT or ASN_CONSTRUCTOR or $0);
  SNMP_PDU_GETNEXT      = (ASN_CONTEXT or ASN_CONSTRUCTOR or $1);
  SNMP_PDU_RESPONSE     = (ASN_CONTEXT or ASN_CONSTRUCTOR or $2);
  SNMP_PDU_SET          = (ASN_CONTEXT or ASN_CONSTRUCTOR or $3);
  { SNMP_PDU_V1TRAP is obsolete in SNMPv2 }
  SNMP_PDU_V1TRAP       = (ASN_CONTEXT or ASN_CONSTRUCTOR or $4);
  SNMP_PDU_GETBULK      = (ASN_CONTEXT or ASN_CONSTRUCTOR or $5);
  SNMP_PDU_INFORM       = (ASN_CONTEXT or ASN_CONSTRUCTOR or $6);
  SNMP_PDU_TRAP         = (ASN_CONTEXT or ASN_CONSTRUCTOR or $7);

  { SNMPv1 Trap Values }
  { (These values might be superfluous with WinSNMP applications) }
  SNMP_TRAP_COLDSTART             = 0;
  SNMP_TRAP_WARMSTART             = 1;
  SNMP_TRAP_LINKDOWN              = 2;
  SNMP_TRAP_LINKUP                = 3;
  SNMP_TRAP_AUTHFAIL              = 4;
  SNMP_TRAP_EGPNEIGHBORLOSS       = 5;
  SNMP_TRAP_ENTERPRISESPECIFIC    = 6;

  { SNMP Error Codes Returned in Error_status Field of PDU }
  { (these are NOT WinSNMP API Error Codes }
  { Error Codes Common to SNMPv1 and SNMPv2 }
  SNMP_ERROR_NOERROR              = 0;
  SNMP_ERROR_TOOBIG               = 1;
  SNMP_ERROR_NOSUCHNAME           = 2;
  SNMP_ERROR_BADVALUE             = 3;
  SNMP_ERROR_READONLY             = 4;
  SNMP_ERROR_GENERR               = 5;
  { Error Codes Added for SNMPv2 }
  SNMP_ERROR_NOACCESS             = 6;
  SNMP_ERROR_WRONGTYPE            = 7;
  SNMP_ERROR_WRONGLENGTH          = 8;
  SNMP_ERROR_WRONGENCODING        = 9;
  SNMP_ERROR_WRONGVALUE           = 10;
  SNMP_ERROR_NOCREATION           = 11;
  SNMP_ERROR_INCONSISTENTVALUE    = 12;
  SNMP_ERROR_RESOURCEUNAVAILABLE  = 13;
  SNMP_ERROR_COMMITFAILED         = 14;
  SNMP_ERROR_UNDOFAILED           = 15;
  SNMP_ERROR_AUTHORIZATIONERROR   = 16;
  SNMP_ERROR_NOTWRITABLE          = 17;
  SNMP_ERROR_INCONSISTENTNAME     = 18;

  { WinSNMP API Values }
  { Values used to indicate entity/context translation modes }
  SNMPAPI_TRANSLATED              = 0;
  SNMPAPI_UNTRANSLATED_V1         = 1;
  SNMPAPI_UNTRANSLATED_V2         = 2;

  { Values used to indicate "SNMP level" supported by the implementation }
  SNMPAPI_NO_SUPPORT              = 0;
  SNMPAPI_V1_SUPPORT              = 1;
  SNMPAPI_V2_SUPPORT              = 2;
  SNMPAPI_M2M_SUPPORT             = 3;

  { Values used to indicate retransmit mode in the implementation }
  SNMPAPI_OFF                     = 0;    { Refuse support }
  SNMPAPI_ON                      = 1;    { Request support }

type
  { WinSNMP API Function Return Codes }
  SNMPAPI_STATUS = smiUINT32;             { Used for function ret values }

const
  SNMPAPI_FAILURE            = 0;    { Generic error code }
  SNMPAPI_SUCCESS            = 1;    { Generic success code }
  { WinSNMP API Error Codes (for SnmpGetLastError) }
  { (NOT SNMP Response-PDU error_status codes) }
  SNMPAPI_ALLOC_ERROR        = 2;    { Error allocating memory }
  SNMPAPI_CONTEXT_INVALID    = 3;    { Invalid context parameter }
  SNMPAPI_CONTEXT_UNKNOWN    = 4;    { Unknown context parameter }
  SNMPAPI_ENTITY_INVALID     = 5;    { Invalid entity parameter }
  SNMPAPI_ENTITY_UNKNOWN     = 6;    { Unknown entity parameter }
  SNMPAPI_INDEX_INVALID      = 7;    { Invalid VBL index parameter }
  SNMPAPI_NOOP               = 8;    { No operation performed }
  SNMPAPI_OID_INVALID        = 9;    { Invalid OID parameter }
  SNMPAPI_OPERATION_INVALID  = 10;   { Invalid/unsupported operation }
  SNMPAPI_OUTPUT_TRUNCATED   = 11;   { Insufficient output buf len }
  SNMPAPI_PDU_INVALID        = 12;   { Invalid PDU parameter }
  SNMPAPI_SESSION_INVALID    = 13;   { Invalid session parameter }
  SNMPAPI_SYNTAX_INVALID     = 14;   { Invalid syntax in smiVALUE }
  SNMPAPI_VBL_INVALID        = 15;   { Invalid VBL parameter }
  SNMPAPI_MODE_INVALID       = 16;   { Invalid mode parameter }
  SNMPAPI_SIZE_INVALID       = 17;   { Invalid size/length parameter }
  SNMPAPI_NOT_INITIALIZED    = 18;   { SnmpStartup failed/not called }
  SNMPAPI_MESSAGE_INVALID    = 19;   { Invalid SNMP message format }
  SNMPAPI_HWND_INVALID       = 20;   { Invalid Window handle }
  SNMPAPI_OTHER_ERROR        = 99;   { For internal/undefined errors }
  { Generic Transport Layer (TL) Errors }
  SNMPAPI_TL_NOT_INITIALIZED = 100;  { TL not initialized }
  SNMPAPI_TL_NOT_SUPPORTED   = 101;  { TL does not support protocol }
  SNMPAPI_TL_NOT_AVAILABLE   = 102;  { Network subsystem has failed }
  SNMPAPI_TL_RESOURCE_ERROR  = 103;  { TL resource error }
  SNMPAPI_TL_UNDELIVERABLE   = 104;  { Destination unreachable }
  SNMPAPI_TL_SRC_INVALID     = 105;  { Source endpoint invalid }
  SNMPAPI_TL_INVALID_PARAM   = 106;  { Input parameter invalid }
  SNMPAPI_TL_IN_USE          = 107;  { Source endpoint in use }
  SNMPAPI_TL_TIMEOUT         = 108;  { No response before timeout }
  SNMPAPI_TL_PDU_TOO_BIG     = 109;  { PDU too big for send/receive }
  SNMPAPI_TL_OTHER           = 199;  { Undefined TL error }

  { WinSNMP API Function Prototypes }
{  INP                        =  {}   { Documentation only }
{  OUT                        =  {}   { Documentation only }
{  SNMPAPI_CALL               = FAR PASCAL;  { FAR PASCAL calling conventions }


{ Local Database Functions }
function SnmpGetTranslateMode({OUT} nTranslateMode : smiLPUINT32): SNMPAPI_STATUS; stdcall;
function SnmpSetTranslateMode({IN} nTranslateMode : smiUINT32) : SNMPAPI_STATUS; stdcall;
function SnmpGetRetransmitMode({OUT} nRetransmitMode : smiLPUINT32) : SNMPAPI_STATUS; stdcall;
function SnmpSetRetransmitMode({IN} nRetransmitMode : smiUINT32) : SNMPAPI_STATUS; stdcall;
function SnmpGetTimeout({IN} hEntity : HSNMP_ENTITY;
                        {OUT} nPolicyTimeout : smiLPTIMETICKS;
                        {OUT} nActualTimeout : smiLPTIMETICKS) : SNMPAPI_STATUS; stdcall;
function SnmpSetTimeout({IN} hEntity : HSNMP_ENTITY;
                        {IN} nPolicyTimeout : smiTIMETICKS) : SNMPAPI_STATUS; stdcall;
function SnmpGetRetry({IN} hEntity : HSNMP_ENTITY;
                      {OUT} nPolicyRetry : smiLPUINT32;
                      {OUT} nActualRetry : smiLPUINT32) : SNMPAPI_STATUS; stdcall;
function SnmpSetRetry({IN} hEntity : HSNMP_ENTITY;
                      {IN} nPolicyRetry : smiUINT32) : SNMPAPI_STATUS; stdcall;
{ Communications Functions }
function SnmpStartup({OUT} nMajorVersion : smiLPUINT32;
                     {OUT} nMinorVersion : smiLPUINT32;
                     {OUT} nLevel : smiLPUINT32;
                     {OUT} nTranslateMode : smiLPUINT32;
                     {OUT} nRetransmitMode : smiLPUINT32) : SNMPAPI_STATUS; stdcall;
function SnmpCleanup : SNMPAPI_STATUS; stdcall;
function SnmpOpen({IN} hWindow : THandle;
                  {IN} wMessage : UINT) : HSNMP_SESSION; stdcall;
function SnmpClose({IN} session : HSNMP_SESSION) : SNMPAPI_STATUS; stdcall;
function SnmpSendMsg({IN} session : HSNMP_SESSION;
                     {IN} srcEntity : HSNMP_ENTITY;
                     {IN} dstEntity : HSNMP_ENTITY;
                     {IN} context : HSNMP_CONTEXT;
                     {IN} PDU : HSNMP_PDU) : SNMPAPI_STATUS; stdcall;
function SnmpRecvMsg({IN} session : HSNMP_SESSION;
                     {OUT} srcEntity : LPHSNMP_ENTITY;
                     {OUT} dstEntity : LPHSNMP_ENTITY;
                     {OUT} context : LPHSNMP_CONTEXT;
                     {OUT} PDU : LPHSNMP_PDU) : SNMPAPI_STATUS; stdcall;
function SnmpRegister({IN} session : HSNMP_SESSION;
                      {IN} srcEntity : HSNMP_ENTITY;
                      {IN} dstEntity : HSNMP_ENTITY;
                      {IN} context : HSNMP_CONTEXT;
                      {IN} notification : smiLPCOID;
                      {IN} state : smiUINT32) : SNMPAPI_STATUS; stdcall;
{ Entity/Context Functions }
function SnmpStrToEntity({IN} session : HSNMP_SESSION;
                         {IN} pString : LPCSTR) : HSNMP_ENTITY; stdcall;
function SnmpEntityToStr({IN} entity : HSNMP_ENTITY;
                         {IN} size : smiUINT32;
                         {OUT} pString : LPSTR) : SNMPAPI_STATUS; stdcall;
function SnmpFreeEntity({IN} entity : HSNMP_ENTITY) : SNMPAPI_STATUS; stdcall;
function SnmpStrToContext({IN} session : HSNMP_SESSION;
                          {IN} pString : smiLPCOCTETS) : HSNMP_CONTEXT; stdcall;
function SnmpContextToStr({IN} context : HSNMP_CONTEXT;
                          {OUT} pString : smiLPOCTETS) : SNMPAPI_STATUS; stdcall;
function SnmpFreeContext({IN} context : HSNMP_CONTEXT) : SNMPAPI_STATUS ; stdcall;
{ PDU Functions }
function SnmpCreatePdu({IN} session : HSNMP_SESSION;
                       {IN} PDU_type : smiINT;
                       {IN} request_id : smiINT32;
                       {IN} error_status : smiINT;
                       {IN} error_index : smiINT;
                       {IN} varbindlist : HSNMP_VBL) : HSNMP_PDU; stdcall;
function SnmpGetPduData({IN} PDU : HSNMP_PDU;
                        {OUT} PDU_type : smiLPINT;
                        {OUT} request_id : smiLPINT32;
                        {OUT} error_status : smiLPINT;
                        {OUT} error_index : smiLPINT;
                        {OUT} varbindlist : LPHSNMP_VBL) : SNMPAPI_STATUS; stdcall;
function SnmpSetPduData({IN} PDU : HSNMP_PDU;
                        {IN} PDU_type : smiLPINT;
                        {IN} request_id : smiLPINT32;
                        {IN} non_repeaters : smiLPINT;
                        {IN} max_repetitions : smiLPINT;
                        {IN} varbindlist : LPHSNMP_VBL) : SNMPAPI_STATUS; stdcall;
function SnmpDuplicatePdu({IN} session : HSNMP_SESSION;
                          {IN} PDU : HSNMP_PDU) : HSNMP_PDU; stdcall;
function SnmpFreePdu({IN} PDU : HSNMP_PDU) : SNMPAPI_STATUS; stdcall;
{ Variable-Binding Functions }
function SnmpCreateVbl({IN} session : HSNMP_SESSION;
                       {IN} name : smiLPCOID;
                       {IN} value : smiLPCVALUE) : HSNMP_VBL; stdcall;
function SnmpDuplicateVbl({IN} session : HSNMP_SESSION;
                          {IN} vbl : HSNMP_VBL) : HSNMP_VBL; stdcall;
function SnmpFreeVbl({IN} vbl : HSNMP_VBL) : SNMPAPI_STATUS; stdcall;
function SnmpCountVbl({IN} vbl : HSNMP_VBL) : SNMPAPI_STATUS; stdcall;
function SnmpGetVb({IN} vbl : HSNMP_VBL;
                   {IN} index : smiUINT32;
                   {OUT} name : smiLPOID;
                   {OUT} value : smiLPVALUE) : SNMPAPI_STATUS; stdcall;
function SnmpSetVb({IN} vbl : HSNMP_VBL;
                   {IN} index : smiUINT32;
                   {IN} name : smiLPCOID;
                   {IN} value : smiLPCVALUE) : SNMPAPI_STATUS; stdcall;
function SnmpDeleteVb({IN} vbl : HSNMP_VBL;
                      {IN} index : smiUINT32) : SNMPAPI_STATUS; stdcall;
{ Utility Functions }
function SnmpGetLastError({IN} session : HSNMP_SESSION) : SNMPAPI_STATUS; stdcall;
function SnmpStrToOid({IN} pString : LPCSTR;
                      {OUT} dstOID : smiLPOID) : SNMPAPI_STATUS; stdcall;
function SnmpOidToStr({IN} srcOID : smiLPCOID;
                      {IN} size : smiUINT32;
                      {OUT} pString : LPSTR) : SNMPAPI_STATUS; stdcall;
function SnmpOidCopy({IN} srcOID : smiLPCOID;
                     {OUT} dstOID : smiLPOID) : SNMPAPI_STATUS; stdcall;
function SnmpOidCompare({IN} xOID : smiLPCOID;
                        {IN} yOID : smiLPCOID;
                        {IN} maxlen : smiUINT32;
                        {OUT} result : smiLPINT) : SNMPAPI_STATUS; stdcall;
function SnmpEncodeMsg({IN} session : HSNMP_SESSION;
                       {IN} srcEntity : HSNMP_ENTITY;
                       {IN} dstEntity : HSNMP_ENTITY;
                       {IN} context : HSNMP_CONTEXT;
                       {IN} pdu : HSNMP_PDU;
                       {OUT} msgBufDesc : smiLPOCTETS) : SNMPAPI_STATUS; stdcall;
function SnmpDecodeMsg({IN} session : HSNMP_SESSION;
                       {OUT} srcEntity : LPHSNMP_ENTITY;
                       {OUT} dstEntity : LPHSNMP_ENTITY;
                       {OUT} context : LPHSNMP_CONTEXT;
                       {OUT} pdu : LPHSNMP_PDU;
                       {IN} msgBufDesc : smiLPCOCTETS) : SNMPAPI_STATUS ; stdcall;
function SnmpFreeDescriptor({IN} syntax : smiUINT32;
                            {IN} descriptor : smiLPOPAQUE) : SNMPAPI_STATUS; stdcall;


implementation

  const
    winsnmp_dll = 'wsnmp32.dll';

  { Local Database Functions }
  function SnmpGetTranslateMode;  external winsnmp_dll name 'SnmpGetTranslateMode';
  function SnmpSetTranslateMode;  external winsnmp_dll name 'SnmpSetTranslateMode';
  function SnmpGetRetransmitMode; external winsnmp_dll name 'SnmpGetRetransmitMode';
  function SnmpSetRetransmitMode; external winsnmp_dll name 'SnmpSetRetransmitMode';
  function SnmpGetTimeout;        external winsnmp_dll name 'SnmpGetTimeout';
  function SnmpSetTimeout;        external winsnmp_dll name 'SnmpSetTimeout';
  function SnmpGetRetry;          external winsnmp_dll name 'SnmpGetRetry';
  function SnmpSetRetry;          external winsnmp_dll name 'SnmpSetRetry';
  { Communications Functions }
  function SnmpStartup;           external winsnmp_dll name 'SnmpStartup';
  function SnmpCleanup;           external winsnmp_dll name 'SnmpCleanup';
  function SnmpOpen;              external winsnmp_dll name 'SnmpOpen';
  function SnmpClose;             external winsnmp_dll name 'SnmpClose';
  function SnmpSendMsg;           external winsnmp_dll name 'SnmpSendMsg';
  function SnmpRecvMsg;           external winsnmp_dll name 'SnmpRecvMsg';
  function SnmpRegister;          external winsnmp_dll name 'SnmpRegister';
  { Entity/Context Functions }
  function SnmpStrToEntity;       external winsnmp_dll name 'SnmpStrToEntity';
  function SnmpEntityToStr;       external winsnmp_dll name 'SnmpEntityToStr';
  function SnmpFreeEntity;        external winsnmp_dll name 'SnmpFreeEntity';
  function SnmpStrToContext;      external winsnmp_dll name 'SnmpStrToContext';
  function SnmpContextToStr;      external winsnmp_dll name 'SnmpContextToStr';
  function SnmpFreeContext;       external winsnmp_dll name 'SnmpFreeContext';
  { PDU Functions }
  function SnmpCreatePdu;         external winsnmp_dll name 'SnmpCreatePdu';
  function SnmpGetPduData;        external winsnmp_dll name 'SnmpGetPduData';
  function SnmpSetPduData;        external winsnmp_dll name 'SnmpSetPduData';
  function SnmpDuplicatePdu;      external winsnmp_dll name 'SnmpDuplicatePdu';
  function SnmpFreePdu;           external winsnmp_dll name 'SnmpFreePdu';
  { Variable-Binding Functions }
  function SnmpCreateVbl;         external winsnmp_dll name 'SnmpCreateVbl';
  function SnmpDuplicateVbl;      external winsnmp_dll name 'SnmpDuplicateVbl';
  function SnmpFreeVbl;           external winsnmp_dll name 'SnmpFreeVbl';
  function SnmpCountVbl;          external winsnmp_dll name 'SnmpCountVbl';
  function SnmpGetVb;             external winsnmp_dll name 'SnmpGetVb';
  function SnmpSetVb;             external winsnmp_dll name 'SnmpSetVb';
  function SnmpDeleteVb;          external winsnmp_dll name 'SnmpDeleteVb';
  { Utility Functions }
  function SnmpGetLastError;      external winsnmp_dll name 'SnmpGetLastError';
  function SnmpStrToOid;          external winsnmp_dll name 'SnmpStrToOid';
  function SnmpOidToStr;          external winsnmp_dll name 'SnmpOidToStr';
  function SnmpOidCopy;           external winsnmp_dll name 'SnmpOidCopy';
  function SnmpOidCompare;        external winsnmp_dll name 'SnmpOidCompare';
  function SnmpEncodeMsg;         external winsnmp_dll name 'SnmpEncodeMsg';
  function SnmpDecodeMsg;         external winsnmp_dll name 'SnmpDecodeMsg';
  function SnmpFreeDescriptor;    external winsnmp_dll name 'SnmpFreeDescriptor';
end.
