{
  MgWSnmp.Pas

  MG-SOFT WinSNMP specification extensions header file.
  Copyright 1995-1997 by MG-SOFT d.o.o.
  All rights reserved.
    E-mail: info@mg-soft.si
    Web URL: http://www.mg-soft.si/

  Check LICENSE.TXT for licensing information.
}
{$ifndef _INC_MG_WINSNMP}
{$define _INC_MG_WINSNMP}

unit mgwsnmp;

interface

uses
  Windows, WinSnmp;

const
    // Session notification types
    SNMP_SESSION_TYPE_MESSAGE         = $01;
    SNMP_SESSION_TYPE_THREAD_MESSAGE  = $02;
    SNMP_SESSION_TYPE_CALLBACK        = $04; // Not yet implemented
    // Mask for session notification type bits
    SNMP_SESSION_TYPE_MASK            = $07;

    // MG-WinSNMP Extended API Error Codes (for SnmpGetLastError)
    MGWSNMP_E_OFFSET = 1000;
    SNMPAPI_SESSION_TYPE_INVALID = (MGWSNMP_E_OFFSET + 1);  // If invalid session type specified in SnmpOpenEx
    // Internal MG-WinSNMP error's
    SNMPAPI_BAD_SESSION_SIGNATURE = (MGWSNMP_E_OFFSET + 10);
    SNMPAPI_BAD_ENTITY_SIGNATURE  = (MGWSNMP_E_OFFSET + 11);
    SNMPAPI_BAD_CONTEXT_SIGNATURE = (MGWSNMP_E_OFFSET + 12);
    SNMPAPI_BAD_VB_SIGNATURE = (MGWSNMP_E_OFFSET + 13);
    SNMPAPI_BAD_VBL_SIGNATURE = (MGWSNMP_E_OFFSET + 14);
    //
    SNMPAPI_EXCEPTION_ERROR = (MGWSNMP_E_OFFSET + 99);  // If exception occures when working with input parameters

function SnmpOpenEx({IN} nSessionType : DWORD;
                    {IN} hWindow : THandle;
                    {IN} wMessage : UINT) : HSNMP_SESSION; stdcall;

function SnmpSetV1TrapPduData(
		{IN} hPDU : HSNMP_PDU;
		{IN} enterpriseOid : smiLPOID;
		{IN} agentIpAddr : smiLPIPADDR;
		{IN} genericTrapType : smiLPINT;
		{IN} specificTrapType : smiLPINT;
		{IN} timeStamp : smiLPTIMETICKS) : SNMPAPI_STATUS; stdcall;

function SnmpSetPort({IN} entity : HSNMP_ENTITY;
		     {IN} port : WORD) : SNMPAPI_STATUS; stdcall;


implementation

  const
    mgwinsnmp_dll = 'wsnmp32.dll';

  function SnmpOpenEx;  external mgwinsnmp_dll name 'SnmpOpenEx';
  function SnmpSetV1TrapPduData;  external mgwinsnmp_dll name 'SnmpSetV1TrapPduData';
  function SnmpSetPort;  external mgwinsnmp_dll name 'SnmpSetPort';

end.

{$endif}  // _INC_MG_WINSNMP

