/*
  MgWSnmp.h --- MG-WinSNMP specification extensions header file.
  
	Copyright 1995, 1996 by MG-SOFT d.o.o.
  All rights reserved.
    E-mail: info@mg-soft.si
    Web URL: http://www.mg-soft.si/

	Check LICENSE.TXT for licensing information.
*/


#ifndef _INC_MG_WINSNMP     
#define  _INC_MG_WINSNMP    

// Windows header required
#ifndef _INC_WINDOWS     
#include <windows.h>
#define _INC_WINDOWS     
#endif       

// WinSNMP standard header required
#ifndef _INC_WINSNMP
#include <winsnmp.h>
#endif       


/*
  Session notification types
*/
#define SNMP_SESSION_TYPE_MESSAGE         0x01
#define SNMP_SESSION_TYPE_THREAD_MESSAGE  0x02
#define SNMP_SESSION_TYPE_CALLBACK        0x04 // Not yet implemented
#define SNMP_SESSION_TYPE_MS_AGENT_EXTENSION  0x08 // Not yet implemented
// Mask for session notification type bits
#define SNMP_SESSION_MANAGER_TYPE_MASK    0x07
#define SNMP_SESSION_AGENT_TYPE_MASK      0x08
#define SNMP_SESSION_TYPE_MASK            0x0f
#define SNMP_SESSION_NETWORK_TYPE_MASK    0x07



/* MG-WinSNMP Extended API Error Codes (for SnmpGetLastError) */
#define MGWSNMP_E_OFFSET 1000
#define SNMPAPI_SESSION_TYPE_INVALID      (MGWSNMP_E_OFFSET + 1)  /* If invalid session type specified in SnmpOpenEx */
// Internal MG-WinSNMP error's
#define SNMPAPI_BAD_SESSION_SIGNATURE		  (MGWSNMP_E_OFFSET + 10)
#define SNMPAPI_BAD_ENTITY_SIGNATURE			(MGWSNMP_E_OFFSET + 11)
#define SNMPAPI_BAD_CONTEXT_SIGNATURE			(MGWSNMP_E_OFFSET + 12)
#define SNMPAPI_BAD_VB_SIGNATURE					(MGWSNMP_E_OFFSET + 13)
#define SNMPAPI_BAD_VBL_SIGNATURE					(MGWSNMP_E_OFFSET + 14)
// Conversion errors
#define SNMPAPI_RFC1157VBL_INVALID				(MGWSNMP_E_OFFSET + 20)
#define SNMPAPI_RFC1157VB_INVALID					(MGWSNMP_E_OFFSET + 21)
#define SNMPAPI_MS_SNMPAPI_NOT_INITIALIZED (MGWSNMP_E_OFFSET + 22)
#define SNMPAPI_MS_MGMTAPI_NOT_INITIALIZED (MGWSNMP_E_OFFSET + 23)
//
#define SNMPAPI_EXCEPTION_ERROR           MGWSNMP_E_OFFSET + 99  /* If exception occures when working with input parameters */


/*
	Integrated debugging facility
	--
	All debug messages are logged to the debug window
	Debug capabilities are installed only in Debug version of the MG-WinSNMP
*/
// Debug levels
#define DEBUG_L_OFF			0	// Turn off debugger
#define DEBUG_L_DUMP_ALL	3	// MgSnmpDebugOutputHandles() dumps 
								// all handles allocated by	application.
#define DEBUG_L_TIMEOUTS	3	// Timeouts and forced deletes of the internal reference 
								// queue are logged to the
								// debugger's output window. 
#define DEBUG_L_DELETE_ALL	4	// SnmpCleanup() reports all handles that has not been 
								// freed by application
#define DEBUG_L_API_CALLS	5	// All API calls are dumped to debugger's output window. 


#ifdef __cplusplus
extern "C" {
#endif

__declspec(dllexport)
HSNMP_SESSION  SNMPAPI_CALL   SnmpOpenEx
                              (IN DWORD nSessionType,
                               IN HWND hWnd,  
                               IN UINT wMsg);

__declspec(dllexport)
SNMPAPI_STATUS SNMPAPI_CALL  SnmpSetV1TrapPduData(
			IN HSNMP_PDU hPDU, 
			IN smiOID FAR *enterpriseOid,
			IN smiIPADDR FAR *agentIpAddr,
			IN smiINT FAR *genericTrapType,
			IN smiINT FAR *specificTrapType,
			IN smiTIMETICKS FAR *timeStamp);

__declspec(dllexport)
SNMPAPI_STATUS SNMPAPI_CALL SnmpSetPort
			(IN HSNMP_ENTITY entity,
			 IN WORD port);

__declspec(dllexport)
HSNMP_VBL SNMPAPI_CALL 
MgSnmpConvertMsRfc1157VblToWinSnmpVbl(
							IN HSNMP_SESSION session,
							IN /* RFC1157VarBindList */ void *variableBindings);

__declspec(dllexport)
SNMPAPI_STATUS SNMPAPI_CALL 
MgSnmpConvertWinSnmpVblToMsRfc1157Vbl(
							IN HSNMP_SESSION session,
	            IN HSNMP_VBL vbl,
							OUT /* RFC1157VarBindList */ void *variableBindings,
              OUT smiINT *errorStatus,
              OUT smiINT *errorIndex);


/*
  Debugging dupport
*/
__declspec(dllexport)
SNMPAPI_STATUS SNMPAPI_CALL 
MgSnmpDebugOutputHandles(void);

__declspec(dllexport)
SNMPAPI_STATUS SNMPAPI_CALL 
MgSnmpDebugSetLevel(smiUINT32 level);


#ifdef __cplusplus
}
#endif

#endif         /* _INC_MG_WINSNMP */
