/*
  MGTYPES.h --- Type definition file for MG-SOFT C and CPP programs.
  Copyright by MG-SOFT corporation C-1995.
  All rights reserved
*/
// Align structs to 4 bytes boundary / for Delphi {$ALIGN ON} compatibility
#if defined(__BORLANDC__)
#pragma -a4
#endif


typedef char Bool;
typedef unsigned char  uchar;
typedef unsigned int   uint;
typedef unsigned short ushort;
typedef unsigned long  ulong;
typedef void * POINTER;

// Note for 32bit
typedef short int           INT16;
typedef unsigned short int  UINT16;
typedef int                 INT32;
typedef unsigned int        UINT32;

// typedef unsigned int  ULONG;
typedef char          CHAR;
typedef unsigned char UCHAR;
typedef unsigned char BYTE;
//typedef DWORD WINAPI THREAD;
//typedef DWORD WINAPI PROCESS;
#define THREAD DWORD WINAPI
#define PROCESS DWORD WINAPI

typedef HANDLE HHEAP, FAR *LPHHEAP;

/* MG API Function Prototypes */
typedef INT32  WINAPI_STATUS;
#define IN                              /* Documentation only */
#define OUT                             /* Documentation only */
#define WINAPI_SUCCESS  1
#define WINAPI_FAILURE  0
#define WINAPI_CALL     WINAPI __DLL   /* FAR PASCAL calling conventions */


#ifndef TRUE
  #define TRUE   1
#endif
#ifndef FALSE
  #define FALSE  0
#endif

#define strlennull(x) strlen(x) + 1

#define USE_SEPARATE_HEAP_FOR_EACH_CLASS_TYPE
#if defined(USE_SEPARATE_HEAP_FOR_EACH_CLASS_TYPE)
/*
  Common class new/delete interface macros
*/
// Static class variables definition (put inside the class)
#define COMMON_CLASS_VARIABLES_DEFINITION                 \
  private:                                                \
    static HHEAP            gc_hHeap;                     \
    static UINT             gc_uNumAllocsInHeap;          \
    static CRITICAL_SECTION gc_AllocCs;                   \
    static BOOL             gc_CriticalSectionInitialized;
// END COMMON_CLASS_VARIABLES_DEFINITION

// Static class variables declaration
#define COMMON_CLASS_VARIABLES_DECLARATION(className)     \
  HHEAP className::gc_hHeap = NULL;                       \
  UINT  className::gc_uNumAllocsInHeap = 0;               \
  CRITICAL_SECTION className::gc_AllocCs;                 \
  BOOL className::gc_CriticalSectionInitialized = FALSE;
// END COMMON_CLASS_VARIABLES_DECLARATION

// goes inside overloaded new
#define COMMON_CLASS_CREATE(size)             \
  void *p;                                    \
  if (!gc_CriticalSectionInitialized) {       \
    InitializeCriticalSection(&gc_AllocCs);   \
    gc_CriticalSectionInitialized = TRUE;     \
  }                                           \
  EnterCriticalSection(&gc_AllocCs);          \
  if (gc_hHeap == NULL) {                     \
    gc_hHeap = HeapCreate(0, 0, 0);           \
    if (gc_hHeap == NULL) {                   \
      LeaveCriticalSection(&gc_AllocCs);      \
      return NULL;                            \
    }                                         \
  }                                           \
  while ((p = (void *) HeapAlloc(gc_hHeap, 0 ,size)) == NULL) { \
    break;                                                      \
  }                                                             \
  if (p != NULL) {                                              \
    gc_uNumAllocsInHeap++;                                      \
  }                                                             \
  LeaveCriticalSection(&gc_AllocCs);                            \
  return p;
// END COMMON_CLASS_CREATE

// goes inside overloaded delete
#define COMMON_CLASS_DESTROY(p)            \
  EnterCriticalSection(&gc_AllocCs);       \
  if (HeapFree(gc_hHeap, 0 , p)) {         \
    gc_uNumAllocsInHeap--;                 \
  }                                        \
  LeaveCriticalSection(&gc_AllocCs);
  
// END COMMON_CLASS_DESTROY
// pride za     gc_uNumAllocsInHeap--;        //\//
//    if (gc_uNumAllocsInHeap == 0) {        //\//
//      if (HeapDestroy(gc_hHeap)) {         //\//
//        gc_hHeap = NULL;                   //\//
//      }                                    //\//
//    }                                      //\//
 
#define COMMON_CLASS_REMOVE_HEAP           \
  try {                                    \
    EnterCriticalSection(&gc_AllocCs);     \
    if (gc_hHeap) {                        \
      if (HeapDestroy(gc_hHeap)) {         \
        gc_uNumAllocsInHeap = 0;           \
        gc_hHeap = NULL;                   \
      }                                    \
    }                                      \
    LeaveCriticalSection(&gc_AllocCs);     \
  }                                        \
  catch (...) {                            \
    gc_uNumAllocsInHeap = 0;               \
    gc_hHeap = NULL;                       \
    return;                                \
  }

                             
// END COMMON_CLASS_REMOVE_HEAP
#else

#define COMMON_CLASS_VARIABLES_DEFINITION
#define COMMON_CLASS_VARIABLES_DECLARATION(className)
#define COMMON_CLASS_CREATE(size)  mgw_malloc(size);
#define COMMON_CLASS_DESTROY(p)   mgw_free(p);
#define COMMON_CLASS_REMOVE_HEAP

#endif


